/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.ADSCImageLoader;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFLoader;
import uk.ac.diamond.scisoft.analysis.io.CrysalisLoader;
import uk.ac.diamond.scisoft.analysis.io.DatLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.JPEGLoader;
import uk.ac.diamond.scisoft.analysis.io.MARLoader;
import uk.ac.diamond.scisoft.analysis.io.NexusLoader;
import uk.ac.diamond.scisoft.analysis.io.PNGLoader;
import uk.ac.diamond.scisoft.analysis.io.PgmLoader;
import uk.ac.diamond.scisoft.analysis.io.PilatusEdfLoader;
import uk.ac.diamond.scisoft.analysis.io.PilatusTiffLoader;
import uk.ac.diamond.scisoft.analysis.io.RawBinaryLoader;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;
import uk.ac.diamond.scisoft.analysis.io.XMapLoader;
import uk.ac.diamond.scisoft.analysis.utils.ClassLoaderUtils;
import uk.ac.gda.monitor.IMonitor;
import uk.ac.gda.util.io.FileUtils;

public class LoaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(LoaderFactory.class);
    private static final Map<String, Set<Class<? extends AbstractFileLoader>>> LOADERS = new HashMap<String, Set<Class<? extends AbstractFileLoader>>>(17);

    static {
        try {
            LoaderFactory.registerLoader("img", ADSCImageLoader.class);
            LoaderFactory.registerLoader("cbf", CBFLoader.class);
            LoaderFactory.registerLoader("img", CrysalisLoader.class);
            LoaderFactory.registerLoader("jpeg", JPEGLoader.class);
            LoaderFactory.registerLoader("jpg", JPEGLoader.class);
            LoaderFactory.registerLoader("mccd", MARLoader.class);
            LoaderFactory.registerLoader("nxs", NexusLoader.class);
            LoaderFactory.registerLoader("tif", PilatusTiffLoader.class);
            LoaderFactory.registerLoader("png", PNGLoader.class);
            LoaderFactory.registerLoader("raw", RawBinaryLoader.class);
            LoaderFactory.registerLoader("srs", SRSLoader.class);
            LoaderFactory.registerLoader("dat", SRSLoader.class);
            LoaderFactory.registerLoader("dat", DatLoader.class);
            LoaderFactory.registerLoader("tif", TIFFImageLoader.class);
            LoaderFactory.registerLoader("tiff", TIFFImageLoader.class);
            LoaderFactory.registerLoader("zip", XMapLoader.class);
            LoaderFactory.registerLoader("edf", PilatusEdfLoader.class);
            LoaderFactory.registerLoader("pgm", PgmLoader.class);
        }
        catch (Exception exception) {
            logger.error("Cannot register loader - ALL loader registration aborted!", (Throwable)exception);
        }
    }

    public static DataHolder getData(String string, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            try {
                DataHolder dataHolder = abstractFileLoader.loadFile(iMonitor);
                return dataHolder;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static IMetaData getMetaData(String string, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            if (!IMetaLoader.class.isInstance(abstractFileLoader)) continue;
            try {
                ((IMetaLoader)((Object)abstractFileLoader)).loadMetaData(iMonitor);
                IMetaData iMetaData = ((IMetaLoader)((Object)abstractFileLoader)).getMetaData();
                return iMetaData;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static IDataset getDataSet(String string, String string2, IMonitor iMonitor) throws Exception {
        Iterator<Class<? extends AbstractFileLoader>> iterator = LoaderFactory.getIterator(string);
        while (iterator.hasNext()) {
            Class<? extends AbstractFileLoader> clazz = iterator.next();
            AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz, string);
            try {
                IDataset iDataset = ((IDataSetLoader)((Object)abstractFileLoader)).loadSet(string, string2, iMonitor);
                return iDataset;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public boolean isMetaLoader(String string) throws Exception {
        return this.isInstanceSupported(string, IMetaLoader.class);
    }

    public boolean isDataSetLoader(String string) throws Exception {
        return this.isInstanceSupported(string, IDataSetLoader.class);
    }

    private boolean isInstanceSupported(String string, Class<?> clazz) throws Exception {
        String string2 = FileUtils.getFileExtension((String)string).toLowerCase();
        if (LOADERS.containsKey(string2)) {
            Collection collection = LOADERS.get(string2);
            for (Class clazz2 : collection) {
                AbstractFileLoader abstractFileLoader = LoaderFactory.getLoader(clazz2, string);
                if (!clazz.isInstance(abstractFileLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public static AbstractFileLoader getLoader(Class<? extends AbstractFileLoader> clazz, String string) throws Exception {
        AbstractFileLoader abstractFileLoader;
        Constructor<?> constructor = ClassLoaderUtils.getSingleStringConstructor(clazz);
        if (constructor == null) {
            abstractFileLoader = clazz.newInstance();
            Method method = abstractFileLoader.getClass().getMethod("setFile", String.class);
            method.invoke((Object)abstractFileLoader, string);
        } else {
            abstractFileLoader = (AbstractFileLoader)constructor.newInstance(string);
        }
        return abstractFileLoader;
    }

    private static Iterator<Class<? extends AbstractFileLoader>> getIterator(String string) {
        String string2 = FileUtils.getFileExtension((String)string).toLowerCase();
        Iterator<Class<AbstractFileLoader>> iterator = null;
        if (LOADERS.containsKey(string2)) {
            iterator = LOADERS.get(string2).iterator();
        } else {
            HashSet hashSet = new HashSet();
            for (String string3 : LOADERS.keySet()) {
                hashSet.addAll(LOADERS.get(string3));
            }
            iterator = hashSet.iterator();
        }
        return iterator;
    }

    public static void registerLoader(String string, Class<? extends AbstractFileLoader> clazz) throws Exception {
        Set<Class<? extends AbstractFileLoader>> set;
        Constructor<?> constructor = ClassLoaderUtils.getSingleStringConstructor(clazz);
        if (constructor == null) {
            if (clazz.getMethod("setFile", String.class) == null) {
                throw new Exception("Loaders must have method setFile(String path)");
            }
            if (clazz.getConstructor(new Class[0]) == null) {
                throw new Exception("Loaders must have a no argument constructor!");
            }
        }
        if ((set = LOADERS.get(string)) == null) {
            set = new HashSet<Class<? extends AbstractFileLoader>>();
            LOADERS.put(string, set);
        }
        set.add(clazz);
    }
}

