/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AWTImageUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class JavaImageLoader
extends AbstractFileLoader {
    protected static final transient Logger logger = LoggerFactory.getLogger(JavaImageLoader.class);
    protected String fileName = "";
    private String fileType = "";
    private boolean asGrey;
    private boolean keepBitWidth = false;
    static final double Wr = 0.299;
    static final double Wg = 0.587;
    static final double Wb = 0.114;

    public void setFile(String string) {
        this.fileName = string;
    }

    public boolean isKeepBitWidth() {
        return this.keepBitWidth;
    }

    public void setKeepBitWidth(boolean bl) {
        this.keepBitWidth = bl;
    }

    public JavaImageLoader(String string, String string2) {
        this(string, string2, false);
    }

    public JavaImageLoader(String string, String string2, boolean bl) {
        this(string, string2, bl, false);
    }

    public JavaImageLoader(String string, String string2, boolean bl, boolean bl2) {
        this.fileName = string;
        this.fileType = string2;
        this.asGrey = bl;
        this.keepBitWidth = bl2;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        Object object;
        int n;
        AbstractDataset[] abstractDatasetArray;
        Object object2;
        AbstractDataset abstractDataset = null;
        File file = null;
        BufferedImage bufferedImage = null;
        file = new File(this.fileName);
        if (!file.exists()) {
            logger.warn("File, {}, did not exist. Now trying to replace suffix", (Object)this.fileName);
            object2 = ImageIO.getReaderFileSuffixes();
            String string = this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
            if (!string.equals(this.fileName)) {
                abstractDatasetArray = object2;
                n = abstractDatasetArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = abstractDatasetArray[n2];
                    if (!string.equalsIgnoreCase((String)object)) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            } else if ((file = new File((String)(object = String.valueOf(this.fileName) + "." + this.fileType))).exists()) {
                this.fileName = object;
            } else {
                Object object3 = object2;
                int n3 = ((Object)object3).length;
                n = 0;
                while (n < n3) {
                    Object object4 = object3[n];
                    object = String.valueOf(this.fileName) + "." + (String)object4;
                    file = new File((String)object);
                    if (file.exists()) {
                        this.fileName = object;
                        break;
                    }
                    ++n;
                }
            }
            if (!file.exists()) {
                throw new ScanFileHolderException("Does not exist", new FileNotFoundException(this.fileName));
            }
        }
        try {
            file = new File(this.fileName);
            bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                throw new ScanFileHolderException("File format in " + this.fileName + " cannot be read");
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("Error loading file " + this.fileName, iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScanFileHolderException("Error interpreting file " + this.fileName, illegalArgumentException);
        }
        try {
            object2 = bufferedImage.getData();
            int n4 = ((Raster)object2).getNumBands();
            object = ((Raster)object2).getSampleModel();
            int n5 = ((SampleModel)object).getDataType();
            n = ((SampleModel)object).getSampleSize(0);
            if (n5 == 3) {
                if (n <= 8) {
                    n5 = 0;
                } else if (n <= 16) {
                    n5 = 2;
                }
            }
            if (n5 == 1) {
                if (n <= 8) {
                    n5 = 0;
                } else if (n <= 16) {
                    n5 = 2;
                }
            }
            if (n5 == 2 && n <= 8) {
                n5 = 0;
            }
            abstractDatasetArray = AWTImageUtils.makeDatasets(bufferedImage, this.keepBitWidth);
            if (n4 == 1) {
                abstractDataset = abstractDatasetArray[0];
            } else {
                if (bufferedImage.getColorModel().getColorSpace().getType() != 5) {
                    throw new ScanFileHolderException("File does not contain RGB data");
                }
                if (n4 < 3) {
                    throw new ScanFileHolderException("Number of colour channels is less than three so cannot load and convert");
                }
                abstractDataset = new RGBDataset(abstractDatasetArray[0], abstractDatasetArray[1], abstractDatasetArray[2]);
                if (this.asGrey) {
                    abstractDataset = ((RGBDataset)abstractDataset).createGreyDataset(abstractDatasetArray[0].getDtype());
                }
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("There was a problem loading the image", exception);
        }
        object2 = new DataHolder();
        ((DataHolder)object2).addDataset(this.fileName, abstractDataset);
        return object2;
    }
}

