/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import java.util.Collection;
import java.util.Map;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.DatLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class DatLoaderTest {
    @Test
    public void testFeKedge_1_15() throws Exception {
        DataHolder dataHolder = new DatLoader("testfiles/gda/analysis/io/DatLoaderTest/FeKedge_1_15.dat").loadFile();
        if (dataHolder.getNames().length != 73) {
            throw new Exception("There should be 73 columns!");
        }
        if (dataHolder.getDataset("Energy").getDouble(0) != 6912.0) {
            throw new Exception("The first value of energy should be 6912.0000!");
        }
        if (dataHolder.getDataset("Energy").getDouble(488) != 7962.0) {
            throw new Exception("The 488 value of energy should be 7962.0000!");
        }
        if (dataHolder.getDataset("Element 1").getDouble(0) != -39259.72) {
            throw new Exception("The first value of Element 1 should be -39259.72!");
        }
        if (dataHolder.getDataset("Element 1").getDouble(488) != 327272.07) {
            throw new Exception("The 488 value of energy should be 327272.07!");
        }
    }

    @Test
    public void testMoFoil() throws Exception {
        DataHolder dataHolder = new DatLoader("testfiles/gda/analysis/io/DatLoaderTest/MoFoil.dat").loadFile();
        if (dataHolder.getNames().length != 13) {
            throw new Exception("There should be 13 columns!");
        }
        if (dataHolder.getDataset("Unknown").getDouble(0) != 3556.0) {
            throw new Exception("The first value of Unknown should be 3556!");
        }
        if (dataHolder.getDataset("Unknown").getDouble(898) != 1067.0) {
            throw new Exception("The 898 value of Unknown should be 1067!");
        }
    }

    @Test
    public void testMoFoilLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/DatLoaderTest/MoFoil.dat", null);
        if (dataHolder.getNames().length != 13) {
            throw new Exception("There should be 13 columns!");
        }
        if (dataHolder.getDataset("Unknown").getDouble(0) != 3556.0) {
            throw new Exception("The first value of Unknown should be 3556!");
        }
        if (dataHolder.getDataset("Unknown").getDouble(898) != 1067.0) {
            throw new Exception("The 898 value of Unknown should be 1067!");
        }
    }

    @Test
    public void testMoFoilLoaderFactoryMeta() throws Exception {
        IMetaData iMetaData = LoaderFactory.getMetaData("testfiles/gda/analysis/io/DatLoaderTest/MoFoil.dat", null);
        if (iMetaData.getDataNames().size() != 13) {
            throw new Exception("There should be 13 columns!");
        }
        if (!iMetaData.getDataNames().contains("(13 fluo channels)")) {
            throw new Exception("There should be a (13 fluo channels) column!");
        }
        if (iMetaData.getDataNames().contains("")) {
            throw new Exception("There should be no empty string column!");
        }
    }

    @Test
    public void testHorribleId143DatFile() throws Exception {
        IMetaData iMetaData = LoaderFactory.getMetaData("testfiles/gda/analysis/io/DatLoaderTest/bsa_013_01.dat", null);
        Collection<String> collection = iMetaData.getDataNames();
        if (!collection.contains("Unknown1")) {
            throw new Exception("No Unknown1 in meta data!");
        }
        if (!collection.contains("Unknown2")) {
            throw new Exception("No Unknown2 in meta data!");
        }
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/DatLoaderTest/bsa_013_01.dat", null);
        Map<String, IDataset> map = dataHolder.getMap();
        for (String string : map.keySet()) {
            if (map.get(string).getName().equals(string)) continue;
            throw new Exception("DatLoader did not set dataset name correctly!");
        }
    }
}

