/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import org.iucr.cbflib.CBF_NODETYPE;
import org.iucr.cbflib.SWIGTYPE_p_FILE;
import org.iucr.cbflib.SWIGTYPE_p_double;
import org.iucr.cbflib.SWIGTYPE_p_int;
import org.iucr.cbflib.SWIGTYPE_p_p_char;
import org.iucr.cbflib.SWIGTYPE_p_size_t;
import org.iucr.cbflib.SWIGTYPE_p_unsigned_int;
import org.iucr.cbflib.SWIGTYPE_p_void;
import org.iucr.cbflib.cbf;
import org.iucr.cbflib.cbfConstants;
import org.iucr.cbflib.cbf_handle_struct;
import org.iucr.cbflib.doubleArray;
import org.iucr.cbflib.intArray;
import org.iucr.cbflib.intP;
import org.iucr.cbflib.sizetP;
import org.iucr.cbflib.uintP;
import uk.ac.diamond.CBFlib.CBFlib;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.CBFError;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class CBFLoader
extends AbstractFileLoader {
    private String fileName = null;
    private HashMap<String, String> metadata = new HashMap();
    public HashMap<String, Object> GDAMetadata = new HashMap();
    static String[] miniCBFheaderNames;

    static {
        CBFlib.loadLibrary();
        miniCBFheaderNames = new String[]{"# Pixel_size", "# Silicon sensor, thickness", "# Exposure_time", "# Exposure_period", "# Tau =", "# Count_cutoff", "# Threshold_setting,", "# N_excluded_pixels =", "# Excluded_pixels:", "# Flat_field:", "# Trim_directory:", "# Wavelength", "# Energy_range", "# Detector_distance", "# Detector_Voffset", "# Beam_xy", "# Flux", "# Filter_transmission", "# Start_angle", "# Angle_increment", "# Detector_2theta", "# Polarization", "# Alpha", "# Kappa", "# Phi", "# Chi", "# Oscillation_axis", "# N_oscillations"};
    }

    public CBFLoader() {
    }

    public CBFLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        AbstractDataset abstractDataset = null;
        ImageOrientation imageOrientation = null;
        SWIGTYPE_p_FILE sWIGTYPE_p_FILE = cbf.fopen((String)this.fileName, (String)"rb");
        if (sWIGTYPE_p_FILE == null) {
            throw new ScanFileHolderException("File doesn't exist: " + this.fileName);
        }
        cbf_handle_struct cbf_handle_struct2 = new cbf_handle_struct();
        CBFError.errorChecker(cbf.cbf_read_widefile((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_FILE)sWIGTYPE_p_FILE, (int)cbfConstants.MSG_DIGEST));
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        imageOrientation = CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"diffrn_frame_data")) || CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"diffrn_data_frame")) ? this.readCBFHeaderData(cbf_handle_struct2) : this.readMiniCBFHeader(cbf_handle_struct2);
        abstractDataset = this.readCBFBinaryData(cbf_handle_struct2, imageOrientation);
        abstractDataset.setMetadataMap(this.GDAMetadata);
        dataHolder.addDataset(this.fileName, abstractDataset, this.GDAMetadata);
        return dataHolder;
    }

    private ImageOrientation readMiniCBFHeader(cbf_handle_struct cbf_handle_struct2) throws ScanFileHolderException {
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_data"));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"header_contents"));
        CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        String string = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        boolean bl = false;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n2 = 0;
                while (n2 < miniCBFheaderNames.length) {
                    bl = false;
                    if (string2.contains(miniCBFheaderNames[n2])) {
                        this.metadata.put(miniCBFheaderNames[n2], string2.substring(string2.indexOf(miniCBFheaderNames[n2]) + miniCBFheaderNames[n2].length(), string2.length()).trim());
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) continue;
                this.metadata.put("Unknown " + n, string2);
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("Error parsing miniCBF header ", iOException);
        }
        CBFError.errorChecker(cbf.cbf_find_tag((cbf_handle_struct)cbf_handle_struct2, (String)"_array_data.data"));
        CBFError.errorChecker(cbf.cbf_rewind_row((cbf_handle_struct)cbf_handle_struct2));
        uintP uintP2 = new uintP();
        intP intP2 = new intP();
        intP intP3 = new intP();
        intP intP4 = new intP();
        intP intP5 = new intP();
        intP intP6 = new intP();
        intP intP7 = new intP();
        sizetP sizetP2 = new sizetP();
        sizetP sizetP3 = new sizetP();
        sizetP sizetP4 = new sizetP();
        sizetP sizetP5 = new sizetP();
        sizetP sizetP6 = new sizetP();
        sizetP sizetP7 = new sizetP();
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char2 = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_get_arrayparameters_wdims((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast(), (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_size_t)sizetP2.cast(), (SWIGTYPE_p_int)intP3.cast(), (SWIGTYPE_p_int)intP4.cast(), (SWIGTYPE_p_size_t)sizetP3.cast(), (SWIGTYPE_p_int)intP5.cast(), (SWIGTYPE_p_int)intP6.cast(), (SWIGTYPE_p_int)intP7.cast(), (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2, (SWIGTYPE_p_size_t)sizetP4.cast(), (SWIGTYPE_p_size_t)sizetP5.cast(), (SWIGTYPE_p_size_t)sizetP6.cast(), (SWIGTYPE_p_size_t)sizetP7.cast()));
        int n3 = (int)sizetP4.value();
        int n4 = (int)sizetP5.value();
        this.metadata.put("numPixels_x", Integer.toString(n3));
        this.metadata.put("numPixels_y", Integer.toString(n4));
        this.createGDAMetadata();
        return new ImageOrientation(n3, n4);
    }

    private void createGDAMetadata() throws ScanFileHolderException {
        try {
            String string = this.getMetadataValue("# Pixel_size");
            String[] stringArray = string.split("m x");
            double d = Double.parseDouble(stringArray[0]) * 1000.0;
            double d2 = Double.parseDouble(stringArray[1].split("m")[0]) * 1000.0;
            String string2 = this.getMetadataValue("# Beam_xy");
            String[] stringArray2 = string2.split(",");
            double d3 = Double.parseDouble(stringArray2[0].split("\\(")[1]);
            double d4 = Double.parseDouble(stringArray2[1].split("\\)")[0]);
            double[] dArray = new double[]{(Double.parseDouble(this.getMetadataValue("numPixels_x")) - d3) * d, (Double.parseDouble(this.getMetadataValue("numPixels_y")) - d4) * d2, Double.parseDouble(this.getMetadataValue("# Detector_distance").split("m")[0]) * 1000.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", "milli*metre");
            double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", dArray2);
            double[] dArray3 = new double[]{Double.parseDouble(this.getMetadataValue("numPixels_x")) * d, Double.parseDouble(this.getMetadataValue("numPixels_y")) * d2, 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", dArray3);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXunits", "milli*metre");
            this.GDAMetadata.put("NXdetector:x_pixel_size", d);
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", "milli*metre");
            this.GDAMetadata.put("NXdetector:y_pixel_size", d2);
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", "milli*metre");
            this.GDAMetadata.put("NXmonochromator:wavelength", Double.parseDouble(this.getMetadataValue("# Wavelength").split("A")[0]));
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", "Angstrom");
            this.GDAMetadata.put("NXSample:rotation_start", Double.parseDouble(this.getMetadataValue("# Start_angle").split("deg.")[0]));
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:rotation_range", Double.parseDouble(this.getMetadataValue("# Angle_increment").split("deg.")[0]));
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:exposure_time", Double.parseDouble(this.getMetadataValue("# Exposure_time").split("s")[0]));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", "seconds");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string ", numberFormatException);
        }
    }

    private ImageOrientation readCBFHeaderData(cbf_handle_struct cbf_handle_struct2) throws ScanFileHolderException {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        intP intP2 = new intP();
        CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        String string = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char);
        this.metadata.put("diffrn_data_frame.array_id", string);
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_structure_list"));
        CBFError.errorChecker(cbf.cbf_rewind_row((cbf_handle_struct)cbf_handle_struct2));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        int n4 = 0;
        int n5 = 0;
        while ((n = cbf.cbf_find_nextrow((cbf_handle_struct)cbf_handle_struct2, (String)string)) == 0) {
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"index"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            n4 = intP2.value();
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"dimension"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            this.metadata.put("SIZE " + String.valueOf(n4), String.valueOf(intP2.value()));
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"precedence"));
            CBFError.errorChecker(cbf.cbf_get_integervalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast()));
            n5 = intP2.value();
            this.metadata.put("precedence " + n4, String.valueOf(n5));
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"direction"));
            CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            String string2 = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char);
            this.metadata.put("direction " + n4, string2);
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"axis_set_id"));
            CBFError.errorChecker(cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            String string3 = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char);
            this.metadata.put("axis_set_id " + n4, string3);
            CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        }
        if (n != cbfConstants.CBF_NOTFOUND) {
            CBFError.errorChecker(n);
        }
        CBFError.errorChecker(cbf.cbf_find_category((cbf_handle_struct)cbf_handle_struct2, (String)"array_data"));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"array_id"));
        CBFError.errorChecker(cbf.cbf_find_row((cbf_handle_struct)cbf_handle_struct2, (String)this.metadata.get("diffrn_data_frame.array_id")));
        CBFError.errorChecker(cbf.cbf_find_column((cbf_handle_struct)cbf_handle_struct2, (String)"data"));
        if (this.metadata.get("axis_set_id 1").equalsIgnoreCase("ELEMENT_X")) {
            bl3 = Integer.valueOf(this.metadata.get("precedence 1")) == 1;
            n2 = Integer.valueOf(this.metadata.get("SIZE 1"));
            n3 = Integer.valueOf(this.metadata.get("SIZE 2"));
            bl = this.metadata.get("direction 1").equalsIgnoreCase("increasing");
            bl2 = this.metadata.get("direction 2").equalsIgnoreCase("increasing");
        } else {
            bl3 = Integer.valueOf(this.metadata.get("precedence 2")) == 1;
            n2 = Integer.valueOf(this.metadata.get("SIZE 2"));
            n3 = Integer.valueOf(this.metadata.get("SIZE 1"));
            bl = this.metadata.get("direction 2").equalsIgnoreCase("increasing");
            bl2 = this.metadata.get("direction 1").equalsIgnoreCase("increasing");
        }
        return new ImageOrientation(n2, n3, bl, bl2, bl3);
    }

    private AbstractDataset readCBFBinaryData(cbf_handle_struct cbf_handle_struct2, ImageOrientation imageOrientation) throws ScanFileHolderException {
        AbstractDataset abstractDataset = null;
        int n = imageOrientation.getxLength();
        int n2 = imageOrientation.getyLength();
        boolean bl = imageOrientation.isxIncreasing();
        boolean bl2 = imageOrientation.isyIncreasing();
        boolean bl3 = imageOrientation.isRowsX();
        uintP uintP2 = new uintP();
        intP intP2 = new intP();
        intP intP3 = new intP();
        intP intP4 = new intP();
        intP intP5 = new intP();
        intP intP6 = new intP();
        intP intP7 = new intP();
        sizetP sizetP2 = new sizetP();
        sizetP sizetP3 = new sizetP();
        sizetP sizetP4 = new sizetP();
        sizetP sizetP5 = new sizetP();
        sizetP sizetP6 = new sizetP();
        sizetP sizetP7 = new sizetP();
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_get_arrayparameters_wdims((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast(), (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_size_t)sizetP2.cast(), (SWIGTYPE_p_int)intP3.cast(), (SWIGTYPE_p_int)intP4.cast(), (SWIGTYPE_p_size_t)sizetP3.cast(), (SWIGTYPE_p_int)intP5.cast(), (SWIGTYPE_p_int)intP6.cast(), (SWIGTYPE_p_int)intP7.cast(), (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char, (SWIGTYPE_p_size_t)sizetP4.cast(), (SWIGTYPE_p_size_t)sizetP5.cast(), (SWIGTYPE_p_size_t)sizetP6.cast(), (SWIGTYPE_p_size_t)sizetP7.cast()));
        boolean bl4 = intP7.value() == 1;
        int n3 = n * n2;
        if ((long)n3 != sizetP3.value()) {
            throw new ScanFileHolderException("Mismatch of CBF binary data size");
        }
        sizetP sizetP8 = new sizetP();
        int n4 = 0;
        int n5 = 0;
        System.out.println("Loading " + this.fileName + ", " + n3);
        if (bl4) {
            doubleArray doubleArray2 = new doubleArray(n3);
            if (doubleArray2.cast() == null) {
                System.gc();
                doubleArray2 = new doubleArray(n3);
                if (doubleArray2.cast() == null) {
                    System.out.println("Out of memory for " + this.fileName);
                    throw new ScanFileHolderException("Out of memory?");
                }
            }
            CBFError.errorChecker(cbf.cbf_get_realarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_void)cbf.double_void((SWIGTYPE_p_double)doubleArray2.cast()), (long)8L, (long)n3, (SWIGTYPE_p_size_t)sizetP8.cast()));
            if ((long)n3 != sizetP8.value()) {
                throw new ScanFileHolderException("Mismatch of CBF binary data size");
            }
            abstractDataset = new DoubleDataset(n2, n);
            double[] dArray = abstractDataset.getData();
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n) {
                    n4 = bl3 ? (bl ? (!bl2 ? n5 : (n2 - 1 - n6) * n + n7) : (!bl2 ? n6 * n + (n - 1 - n7) : n3 - n5 - 1)) : (bl ? (!bl2 ? n7 * n2 + n6 : (n - 1 - n7) * n2 + n7) : (!bl2 ? n7 * n2 + (n2 - 1 - n6) : n3 - n5 - 1));
                    dArray[n4] = doubleArray2.getitem(n5);
                    ++n5;
                    ++n7;
                }
                ++n6;
            }
            doubleArray2.delete();
        } else {
            intArray intArray2 = new intArray(n3);
            if (intArray2.cast() == null) {
                System.gc();
                intArray2 = new intArray(n3);
                if (intArray2.cast() == null) {
                    System.out.println("Out of memory for " + this.fileName);
                    throw new ScanFileHolderException("Out of memory?");
                }
            }
            intP intP8 = new intP();
            CBFError.errorChecker(cbf.cbf_get_integerarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)intP8.cast(), (SWIGTYPE_p_void)cbf.int_void((SWIGTYPE_p_int)intArray2.cast()), (long)4L, (int)intP3.value(), (long)n3, (SWIGTYPE_p_size_t)sizetP8.cast()));
            if ((long)n3 != sizetP8.value()) {
                throw new ScanFileHolderException("Mismatch of CBF binary data size");
            }
            abstractDataset = new IntegerDataset(n2, n);
            int[] nArray = ((IntegerDataset)abstractDataset).getData();
            int n8 = 0;
            while (n8 < n2) {
                int n9 = 0;
                while (n9 < n) {
                    n4 = bl3 ? (bl ? (!bl2 ? n5 : (n2 - 1 - n8) * n + n9) : (!bl2 ? n8 * n + (n - 1 - n9) : n3 - 1 - n5)) : (bl ? (!bl2 ? n9 * n2 + n8 : (n - 1 - n9) * n2 + n8) : (!bl2 ? n9 * n2 + (n2 - 1 - n8) : (n - 1 - n9) * n2 + (n2 - 1 - n8)));
                    nArray[n4] = intArray2.getitem(n5);
                    ++n5;
                    ++n9;
                }
                ++n8;
            }
            intArray2.delete();
        }
        return abstractDataset;
    }

    private INexusTree CBFMetaDataLoader(cbf_handle_struct cbf_handle_struct2, String string) throws ScanFileHolderException {
        CBFError.errorChecker(cbf.cbf_rewind_datablock((cbf_handle_struct)cbf_handle_struct2));
        NexusTreeNode nexusTreeNode = new NexusTreeNode(string, "NXroot", null);
        uintP uintP2 = new uintP();
        CBFError.errorChecker(cbf.cbf_count_datablocks((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast()));
        int n = 0;
        while ((long)n < uintP2.value()) {
            SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
            CBFError.errorChecker(cbf.cbf_select_datablock((cbf_handle_struct)cbf_handle_struct2, (long)n));
            CBFError.errorChecker(cbf.cbf_datablock_name((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
            NexusTreeNode nexusTreeNode2 = new NexusTreeNode("NXcif_" + cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char), "NXentry", null);
            nexusTreeNode.addChildNode((INexusTree)nexusTreeNode2);
            int[] nArray = new int[1];
            if (CBFError.errorChecker(cbf.cbf_rewind_blockitem((cbf_handle_struct)cbf_handle_struct2, (int[])nArray))) {
                uintP uintP3 = new uintP();
                CBFError.errorChecker(cbf.cbf_count_blockitems((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP3.cast()));
                int n2 = 0;
                while ((long)n2 < uintP3.value()) {
                    CBFError.errorChecker(cbf.cbf_select_blockitem((cbf_handle_struct)cbf_handle_struct2, (long)n2, (int[])nArray));
                    if (nArray[0] == CBF_NODETYPE.CBF_CATEGORY.swigValue()) {
                        this.process_category(cbf_handle_struct2, (INexusTree)nexusTreeNode2);
                    } else {
                        SWIGTYPE_p_p_char sWIGTYPE_p_p_char2 = cbf.new_charPP();
                        CBFError.errorChecker(cbf.cbf_saveframe_name((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2));
                        NexusTreeNode nexusTreeNode3 = new NexusTreeNode(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2), "saveframe", null);
                        if (CBFError.errorChecker(cbf.cbf_rewind_category((cbf_handle_struct)cbf_handle_struct2))) {
                            uintP uintP4 = new uintP();
                            CBFError.errorChecker(cbf.cbf_count_categories((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP4.cast()));
                            int n3 = 0;
                            while ((long)n3 < uintP4.value()) {
                                CBFError.errorChecker(cbf.cbf_select_category((cbf_handle_struct)cbf_handle_struct2, (long)n3));
                                this.process_category(cbf_handle_struct2, (INexusTree)nexusTreeNode3);
                                ++n3;
                            }
                        }
                        nexusTreeNode2.addChildNode((INexusTree)nexusTreeNode3);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return nexusTreeNode;
    }

    private void process_category(cbf_handle_struct cbf_handle_struct2, INexusTree iNexusTree) throws ScanFileHolderException {
        SWIGTYPE_p_p_char sWIGTYPE_p_p_char = cbf.new_charPP();
        CBFError.errorChecker(cbf.cbf_category_name((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char));
        NexusTreeNode nexusTreeNode = new NexusTreeNode(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char), "category", null);
        uintP uintP2 = new uintP();
        CBFError.errorChecker(cbf.cbf_count_rows((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP2.cast()));
        if (uintP2.value() != 0L) {
            uintP uintP3 = new uintP();
            CBFError.errorChecker(cbf.cbf_count_columns((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)uintP3.cast()));
            if (uintP3.value() != 0L && CBFError.errorChecker(cbf.cbf_rewind_column((cbf_handle_struct)cbf_handle_struct2))) {
                SWIGTYPE_p_p_char sWIGTYPE_p_p_char2 = cbf.new_charPP();
                do {
                    Object object;
                    Object object2;
                    CBFError.errorChecker(cbf.cbf_column_name((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2));
                    boolean bl = false;
                    CBFError.errorChecker(cbf.cbf_rewind_row((cbf_handle_struct)cbf_handle_struct2));
                    String[] stringArray = new String[(int)uintP2.value()];
                    String[] stringArray2 = new String[(int)uintP2.value()];
                    SWIGTYPE_p_p_char sWIGTYPE_p_p_char3 = cbf.new_charPP();
                    int n = 0;
                    while ((long)n < uintP2.value()) {
                        Object object3;
                        CBFError.errorChecker(cbf.cbf_select_row((cbf_handle_struct)cbf_handle_struct2, (long)n));
                        int n2 = cbf.cbf_get_value((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char3);
                        if (n2 == 0) {
                            stringArray2[n] = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char3);
                            CBFError.errorChecker(cbf.cbf_get_typeofvalue((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char3));
                            stringArray[n] = cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char3);
                            if (stringArray2[n] == null) {
                                stringArray2[n] = ".";
                                stringArray[n] = "null";
                            }
                            if (stringArray[n] == null) {
                                stringArray[n] = "undefined";
                            }
                            if (bl) {
                                object2 = this.formatdata(stringArray2[n], stringArray[n]);
                                object = new int[]{((String)object2).length()};
                                object3 = new NexusGroupData((int[])object, 4, (Serializable)object2);
                                nexusTreeNode.addChildNode((INexusTree)new NexusTreeNode("row", "data", (INexusTree)nexusTreeNode, (NexusGroupData)object3));
                            }
                        } else if (n2 == cbfConstants.CBF_BINARY) {
                            int n3;
                            Object[] objectArray;
                            Object object4;
                            intP intP2;
                            Object object5;
                            if (!bl) {
                                object2 = new NexusTreeNode(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2), "column", (INexusTree)nexusTreeNode);
                                int n4 = 0;
                                while (n4 < n) {
                                    object3 = this.formatdata(stringArray2[n4], stringArray[n4]);
                                    object5 = new int[]{((String)object3).length()};
                                    intP2 = new NexusGroupData((int[])object5, 4, (Serializable)object3);
                                    object2.addChildNode((INexusTree)new NexusTreeNode("row" + n4, "data", (INexusTree)nexusTreeNode, (NexusGroupData)intP2));
                                    ++n4;
                                }
                                bl = true;
                                nexusTreeNode.addChildNode((INexusTree)object2);
                            }
                            object2 = new uintP();
                            object = new intP();
                            object3 = new intP();
                            object5 = new intP();
                            intP2 = new intP();
                            intP intP3 = new intP();
                            intP intP4 = new intP();
                            sizetP sizetP2 = new sizetP();
                            sizetP sizetP3 = new sizetP();
                            sizetP sizetP4 = new sizetP();
                            sizetP sizetP5 = new sizetP();
                            sizetP sizetP6 = new sizetP();
                            sizetP sizetP7 = new sizetP();
                            SWIGTYPE_p_p_char sWIGTYPE_p_p_char4 = cbf.new_charPP();
                            CBFError.errorChecker(cbf.cbf_get_arrayparameters_wdims((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_unsigned_int)object2.cast(), (SWIGTYPE_p_int)object.cast(), (SWIGTYPE_p_size_t)sizetP2.cast(), (SWIGTYPE_p_int)object3.cast(), (SWIGTYPE_p_int)object5.cast(), (SWIGTYPE_p_size_t)sizetP3.cast(), (SWIGTYPE_p_int)intP2.cast(), (SWIGTYPE_p_int)intP3.cast(), (SWIGTYPE_p_int)intP4.cast(), (SWIGTYPE_p_p_char)sWIGTYPE_p_p_char4, (SWIGTYPE_p_size_t)sizetP4.cast(), (SWIGTYPE_p_size_t)sizetP5.cast(), (SWIGTYPE_p_size_t)sizetP6.cast(), (SWIGTYPE_p_size_t)sizetP7.cast()));
                            boolean bl2 = intP4.value() == 1;
                            sizetP sizetP8 = new sizetP();
                            Object[] objectArray2 = null;
                            int n5 = 21;
                            if (bl2) {
                                object4 = new doubleArray((int)sizetP3.value());
                                CBFError.errorChecker(cbf.cbf_get_realarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)object.cast(), (SWIGTYPE_p_void)cbf.double_void((SWIGTYPE_p_double)object4.cast()), (long)8L, (long)sizetP3.value(), (SWIGTYPE_p_size_t)sizetP8.cast()));
                                switch ((int)sizetP2.value()) {
                                    case 4: {
                                        n5 = 5;
                                        break;
                                    }
                                    case 8: {
                                        n5 = 6;
                                    }
                                }
                                objectArray = new double[(int)sizetP3.value()];
                                n3 = 0;
                                while ((long)n3 < sizetP3.value()) {
                                    objectArray[n3] = object4.getitem(n3);
                                    ++n3;
                                }
                                objectArray2 = objectArray;
                            } else {
                                object4 = new intArray((int)sizetP3.value());
                                CBFError.errorChecker(cbf.cbf_get_integerarray((cbf_handle_struct)cbf_handle_struct2, (SWIGTYPE_p_int)object.cast(), (SWIGTYPE_p_void)cbf.int_void((SWIGTYPE_p_int)object4.cast()), (long)4L, (int)object3.value(), (long)sizetP3.value(), (SWIGTYPE_p_size_t)sizetP8.cast()));
                                if (object5.value() != 0) {
                                    switch ((int)sizetP2.value()) {
                                        case 1: {
                                            n5 = 21;
                                            break;
                                        }
                                        case 2: {
                                            n5 = 23;
                                            break;
                                        }
                                        case 4: {
                                            n5 = 25;
                                        }
                                    }
                                } else {
                                    switch ((int)sizetP2.value()) {
                                        case 1: {
                                            n5 = 20;
                                            break;
                                        }
                                        case 2: {
                                            n5 = 22;
                                            break;
                                        }
                                        case 4: {
                                            n5 = 24;
                                        }
                                    }
                                }
                                objectArray = new int[(int)sizetP3.value()];
                                n3 = 0;
                                while ((long)n3 < sizetP3.value()) {
                                    objectArray[n3] = object4.getitem(n3);
                                    ++n3;
                                }
                                objectArray2 = objectArray;
                            }
                            object4 = new int[]{(int)sizetP4.value(), (int)sizetP5.value(), (int)sizetP6.value()};
                            int n6 = 1;
                            n3 = 0;
                            while (n3 < ((doubleArray)object4).length) {
                                if (object4[n3] == false) {
                                    object4[n3] = (doubleArray)true;
                                } else if (object4[n3] > true) {
                                    n6 = n3 + 1;
                                }
                                ++n3;
                            }
                            if (n6 == 1 && (long)object4[0] != sizetP3.value()) {
                                object4[0] = (doubleArray)((int)sizetP3.value());
                            }
                            int[] nArray = new int[n6];
                            int n7 = 0;
                            while (n7 < n6) {
                                nArray[n7] = (int)object4[n7];
                                ++n7;
                            }
                            nexusTreeNode.addChildNode((INexusTree)new NexusTreeNode("row", "data", (INexusTree)nexusTreeNode, new NexusGroupData(nArray, n5, (Serializable)objectArray2)));
                        }
                        ++n;
                    }
                    if (bl) continue;
                    n = 0;
                    String string = "";
                    if (uintP2.value() >= 1L) {
                        string = String.valueOf(string) + this.formatdata(stringArray2[0], stringArray[0]);
                        n = string.length();
                        int n8 = 1;
                        while ((long)n8 < uintP2.value()) {
                            object = "\n" + this.formatdata(stringArray2[n8], stringArray[n8]);
                            string = String.valueOf(string) + (String)object;
                            n += ((String)object).length();
                            ++n8;
                        }
                    }
                    if (n != string.length()) {
                        throw new ScanFileHolderException("Mismatch of CBF character data size");
                    }
                    object2 = new int[]{string.length()};
                    object = new NexusGroupData((int[])object2, 4, (Serializable)((Object)string));
                    nexusTreeNode.addChildNode((INexusTree)new NexusTreeNode(cbf.charPP_value((SWIGTYPE_p_p_char)sWIGTYPE_p_p_char2), "column", (INexusTree)nexusTreeNode, (NexusGroupData)object));
                } while (CBFError.errorChecker(cbf.cbf_next_column((cbf_handle_struct)cbf_handle_struct2)));
            }
        }
        iNexusTree.addChildNode((INexusTree)nexusTreeNode);
    }

    private String formatdata(String string, String string2) {
        if (string2.compareToIgnoreCase("sqlq") == 0) {
            return "'" + string + "'";
        }
        if (string2.compareToIgnoreCase("dblq") == 0) {
            return "\"" + string + "\"";
        }
        if (string2.compareToIgnoreCase("text") == 0) {
            return ";" + string + "\n;";
        }
        if (string2.length() == 0) {
            return ".";
        }
        return string;
    }

    private String getMetadataValue(String string) throws ScanFileHolderException {
        try {
            String string2 = this.metadata.get(string);
            return string2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the ADSC Header", exception);
        }
    }

    private class ImageOrientation {
        int x_Length;
        int y_Length;
        boolean x_Increasing;
        boolean y_Increasing;
        boolean is_RowsX;

        private ImageOrientation(int n, int n2) {
            this.x_Length = n;
            this.y_Length = n2;
            this.x_Increasing = true;
            this.y_Increasing = true;
            this.is_RowsX = true;
        }

        private ImageOrientation(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            this.x_Length = n;
            this.y_Length = n2;
            this.x_Increasing = bl;
            this.y_Increasing = bl2;
            this.is_RowsX = bl3;
        }

        public int getxLength() {
            return this.x_Length;
        }

        public int getyLength() {
            return this.y_Length;
        }

        public boolean isxIncreasing() {
            return this.x_Increasing;
        }

        public boolean isyIncreasing() {
            return this.y_Increasing;
        }

        public boolean isRowsX() {
            return this.is_RowsX;
        }
    }
}

