/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.DoubleBuffer;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class ASCIIDataHolderSaver
implements IFileSaver {
    final String fileName;
    private Writer out = null;

    public ASCIIDataHolderSaver(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Filename is null or empty");
        }
        this.fileName = string;
    }

    private void wl(String string) throws IOException {
        this.w(String.valueOf(string) + "\n");
    }

    private void w(String string) throws IOException {
        this.out.write(string);
    }

    private void writeData(int[] nArray, DoubleBuffer doubleBuffer) throws IOException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("shape.length == 0");
        }
        if (nArray.length == 1) {
            this.w(Double.toString(doubleBuffer.get()));
            int n = 1;
            while (n < nArray[0]) {
                this.w("," + Double.toString(doubleBuffer.get()));
                ++n;
            }
            this.wl("");
            return;
        }
        int n = 0;
        while (n < nArray[nArray.length - 1]) {
            int[] nArray2 = new int[nArray.length - 1];
            int n2 = 1;
            int n3 = 0;
            while (n3 < nArray2.length) {
                nArray2[n3] = nArray[n3];
                n2 *= nArray2[n3];
                ++n3;
            }
            this.writeData(nArray2, doubleBuffer);
            ++n;
        }
    }

    private void writeDataset(String string, AbstractDataset abstractDataset) throws IOException {
        int[] nArray;
        this.wl("Dataset," + string + "," + abstractDataset.getName());
        int[] nArray2 = nArray = abstractDataset.getShape();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            this.wl(Integer.toString(n3));
            ++n2;
        }
        int[] nArray3 = new int[nArray.length];
        n2 = 0;
        while (n2 < nArray3.length) {
            nArray3[n2] = nArray[nArray3.length - 1 - n2];
            ++n2;
        }
        double[] dArray = ((DoubleDataset)DatasetUtils.cast(abstractDataset, 6)).getData();
        DoubleBuffer doubleBuffer = DoubleBuffer.wrap(dArray, 0, dArray.length);
        this.writeData(nArray3, doubleBuffer);
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        try {
            this.out = new BufferedWriter(new FileWriter(this.fileName));
            if (dataHolder.getNexusTree() != null) {
                this.wl(dataHolder.getNexusTree().toXML(true, false));
                this.wl(dataHolder.getNexusTree().toXML(true, true));
                this.wl(dataHolder.getNexusTree().toXML(false, false));
                this.wl(dataHolder.getNexusTree().toXML(false, true));
            }
            String[] stringArray = dataHolder.getNames();
            this.wl("NumberOfDatasets," + stringArray.length);
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.writeDataset(string, dataHolder.getDataset(string));
                ++n2;
            }
            this.out.close();
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Error in AsciiScanFileHolderSaver.saveFile for " + this.fileName, exception);
        }
    }
}

