/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;
import uk.ac.gda.util.number.DoubleUtils;

public class QSpaceTest {
    static double wavelength = 1.4;
    static int[] ishape = new int[]{800, 400};
    static double[] pxdim = new double[]{0.2, 0.3};
    static double[] origin = new double[]{80.0, 60.0, 234.0};
    private static DetectorProperties detprops;
    private static DiffractionCrystalEnvironment diffexp;
    private static QSpace qspace;

    @BeforeClass
    public static void setUp() {
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setIdentity();
        detprops = new DetectorProperties(new Vector3d(origin), ishape[1], ishape[0], pxdim[1], pxdim[0], matrix3d);
        diffexp = new DiffractionCrystalEnvironment(wavelength);
        qspace = new QSpace(detprops, diffexp);
    }

    @Test
    public void testQShape() {
        Vector3d vector3d = qspace.getInitialWavevector();
        Assert.assertTrue((String)("q " + vector3d.length() + " not equal " + Math.PI * 2 / wavelength), (boolean)DoubleUtils.equalsWithinTolerance((Number)vector3d.length(), (Number)(Math.PI * 2 / wavelength), (Number)1.0E-4));
        int[] nArray = detprops.pixelCoords(detprops.getBeamPosition());
        double d = Math.tan(Math.toRadians(60.0)) * origin[2];
        vector3d = qspace.qFromPixelPosition((double)nArray[0] + d / pxdim[0], (double)nArray[1]);
        Assert.assertTrue((String)("q " + vector3d.length() + " not equal " + Math.PI * 2 / wavelength), (boolean)DoubleUtils.equalsWithinTolerance((Number)vector3d.length(), (Number)(Math.PI * 2 / wavelength), (Number)1.0E-4));
        vector3d = qspace.qFromPixelPosition((double)nArray[0], (double)nArray[1] + d / pxdim[1]);
        Assert.assertTrue((String)("q " + vector3d.length() + " not equal " + Math.PI * 2 / wavelength), (boolean)DoubleUtils.equalsWithinTolerance((Number)vector3d.length(), (Number)(Math.PI * 2 / wavelength), (Number)1.0E-4));
    }

    @Test
    public void testPixelPositions() {
        double d = Math.toRadians(11.5);
        double d2 = origin[2] * Math.tan(d);
        double d3 = 45.0;
        double d4 = 0.0;
        while (d4 < 360.0) {
            int n = (int)Math.floor((origin[0] + d2 * Math.cos(Math.toRadians(d4))) / pxdim[0]);
            int n2 = (int)Math.floor((origin[1] + d2 * Math.sin(Math.toRadians(d4))) / pxdim[1]);
            Vector3d vector3d = qspace.qFromPixelPosition(n, n2);
            Vector3d vector3d2 = new Vector3d();
            qspace.pixelPosition(vector3d, vector3d2);
            Assert.assertEquals((String)"x is wrong", (double)n, (double)vector3d2.x, (double)1.0E-6);
            Assert.assertEquals((String)"y is wrong", (double)n2, (double)vector3d2.y, (double)1.0E-6);
            d4 += d3;
        }
    }

    @Test
    public void testScatteringAngles() {
        double d = Math.toRadians(11.5);
        double d2 = origin[2] * Math.tan(d);
        double d3 = 45.0;
        double d4 = 0.0;
        while (d4 < 360.0) {
            int n = (int)Math.floor((origin[0] + d2 * Math.cos(Math.toRadians(d4))) / pxdim[0]);
            int n2 = (int)Math.floor((origin[1] + d2 * Math.sin(Math.toRadians(d4))) / pxdim[1]);
            Vector3d vector3d = qspace.qFromPixelPosition(n, n2);
            double d5 = Math.max(pxdim[0], pxdim[1]) / origin[2];
            Assert.assertEquals((double)d, (double)qspace.scatteringAngle(vector3d), (double)d5);
            d4 += d3;
        }
    }
}

