/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class MapToPolar
implements DatasetToDatasetFunction {
    double cx;
    double cy;
    double srad;
    double sphi;
    double erad;
    double ephi;

    public MapToPolar(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, true);
    }

    public MapToPolar(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.cx = d;
        this.cy = d2;
        this.srad = d3;
        this.erad = d5;
        if (bl) {
            this.sphi = Math.toRadians(d4);
            this.ephi = Math.toRadians(d6);
        } else {
            this.sphi = d4;
            this.ephi = d6;
        }
        if (this.sphi > this.ephi) {
            double d7 = this.sphi;
            this.sphi = this.ephi;
            this.ephi = d7;
        }
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                throw new IllegalArgumentException("operating on 2d arrays only");
            }
            double d = 1.0 / this.erad;
            int n3 = (int)Math.ceil(this.erad - this.srad);
            int n4 = (int)Math.ceil((this.ephi - this.sphi) / d);
            if (n3 == 0) {
                n3 = 1;
            }
            if (n4 == 0) {
                n4 = 1;
            }
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n3, n4}, AbstractDataset.getBestFloatDType(iDataset.elementClass()));
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset);
            int n5 = 0;
            while (n5 < n3) {
                double d2 = this.srad + (double)n5;
                int n6 = 0;
                while (n6 < n4) {
                    abstractDataset2.set(d * d2, n5, n6);
                    double d3 = this.sphi + (double)n6 * d;
                    double d4 = this.cx + d2 * Math.cos(d3);
                    double d5 = this.cy + d2 * Math.sin(d3);
                    abstractDataset.set(d * d2 * Maths.getBilinear(iDataset, d5, d4), n5, n6++);
                }
                ++n5;
            }
            arrayList.add(abstractDataset);
            arrayList.add(abstractDataset2);
            ++n2;
        }
        return arrayList;
    }
}

