/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class ShortDataset
extends AbstractDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(ShortDataset.class);
    protected short[] data;

    @Override
    protected void setData() {
        this.data = (short[])this.odata;
    }

    private static short[] createArray(int n) {
        short[] sArray = null;
        try {
            sArray = new short[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return sArray;
    }

    @Override
    public int getDtype() {
        return 2;
    }

    public ShortDataset() {
    }

    public ShortDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = ShortDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                logger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = ShortDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = ShortDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public ShortDataset(short[] sArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{sArray.length};
        }
        this.size = ShortDataset.calcSize(nArray);
        if (this.size != sArray.length) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = sArray;
        this.odata = sArray;
    }

    public ShortDataset(ShortDataset shortDataset) {
        this(shortDataset, false);
    }

    public ShortDataset(ShortDataset shortDataset, boolean bl) {
        Object object;
        Object object2;
        this.size = shortDataset.size;
        if (bl) {
            this.shape = shortDataset.shape;
            this.dataSize = shortDataset.dataSize;
            this.dataShape = shortDataset.dataShape;
            this.name = shortDataset.name;
            this.metadata = shortDataset.metadata;
            this.data = shortDataset.data;
            this.odata = shortDataset.data;
            return;
        }
        this.shape = (int[])shortDataset.shape.clone();
        this.name = new String(shortDataset.name);
        if (shortDataset.metadata != null) {
            this.metadata = new HashMap();
            object2 = shortDataset.metadata.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.metadata.put(object, shortDataset.metadata.get(object));
            }
        }
        object = shortDataset.data;
        if (shortDataset.isContiguous()) {
            this.data = (short[])object.clone();
            this.odata = this.data;
        } else {
            this.data = ShortDataset.createArray(this.size);
            this.odata = this.data;
            object2 = shortDataset.getIterator();
            int n = 0;
            while (((IndexIterator)object2).hasNext()) {
                this.data[n] = object[((IndexIterator)object2).index];
                ++n;
            }
        }
    }

    public ShortDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.metadata = abstractDataset.metadata;
        this.data = ShortDataset.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            ++n;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ShortDataset shortDataset = (ShortDataset)object;
        return Arrays.equals(this.data, shortDataset.data);
    }

    public static ShortDataset createFromObject(Object object) {
        ShortDataset shortDataset = new ShortDataset();
        shortDataset.shape = ShortDataset.getShapeFromObject(object);
        shortDataset.size = ShortDataset.calcSize(shortDataset.shape);
        shortDataset.data = ShortDataset.createArray(shortDataset.size);
        shortDataset.odata = shortDataset.data;
        int[] nArray = new int[shortDataset.shape.length];
        shortDataset.fillData(object, 0, nArray);
        return shortDataset;
    }

    public static ShortDataset arange(double d) {
        return ShortDataset.arange(0.0, d, 1.0);
    }

    public static ShortDataset arange(double d, double d2, double d3) {
        int n = ShortDataset.calcSteps(d, d2, d3);
        ShortDataset shortDataset = new ShortDataset(n);
        int n2 = 0;
        while (n2 < n) {
            shortDataset.data[n2] = (short)(d + (double)n2 * d3);
            ++n2;
        }
        return shortDataset;
    }

    public static ShortDataset ones(int[] nArray) {
        return new ShortDataset(nArray).fill(1);
    }

    @Override
    public ShortDataset fill(Object object) {
        short s = (short)ShortDataset.toLong(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = s;
        }
        return this;
    }

    public short[] getData() {
        return this.data;
    }

    @Override
    public ShortDataset getView() {
        ShortDataset shortDataset = new ShortDataset();
        shortDataset.name = new String(this.name);
        shortDataset.size = ShortDataset.calcSize(this.shape);
        shortDataset.shape = (int[])this.shape.clone();
        shortDataset.data = this.data;
        shortDataset.odata = this.data;
        shortDataset.metadata = this.metadata;
        return shortDataset;
    }

    public short getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        short[] sArray = (short[])object;
        this.data[n] = sArray[n2];
    }

    public void setAbs(short s, int n) {
        this.data[n] = s;
        this.setDirty();
    }

    public short get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        if (n < 0 || n > this.data.length) {
            logger.error("Index given is outside dataset");
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs((short)ShortDataset.toLong(object), n);
    }

    public void setItem(short s, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            this.setAbs(s, this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Dimensionalities of requested position, {}, and dataset, {}, are incompatible", (Object)nArray.length, (Object)this.shape.length);
            throw new IllegalArgumentException("Dimensionalities of requested position, " + nArray.length + ", and dataset, " + this.shape.length + ", are incompatible");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Index out of bounds - need to make dataset extendible");
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem((short)ShortDataset.toLong(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            logger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = ShortDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = ShortDataset.calcSize(this.dataShape);
        short[] sArray = ShortDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = ShortDataset.calcSize(nArray);
        Arrays.fill(sArray, (short)Short.MIN_VALUE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            sArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = sArray;
        this.odata = sArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = ShortDataset.calcSize(nArray);
        short[] sArray = ShortDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            sArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = sArray;
        this.odata = sArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public Object getObject(int ... nArray) {
        return new Short(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0;
    }

    @Override
    public String getString(int ... nArray) {
        return String.format("%d", this.get(nArray));
    }

    @Override
    public ShortDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        ShortDataset shortDataset = new ShortDataset(sliceIterator.getSliceShape());
        short[] sArray = shortDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            sArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return shortDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        short[] sArray = ((ShortDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            sArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public ShortDataset setByBoolean(BooleanDataset booleanDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                logger.error("Number of true items in selection does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            short s = (short)ShortDataset.toLong(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = s;
            }
        }
        return this;
    }

    @Override
    public ShortDataset setByIndex(IntegerDataset integerDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                logger.error("Number of true items in index dataset does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            short s = (short)ShortDataset.toLong(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = s;
            }
        }
        return this;
    }

    @Override
    public ShortDataset setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = ShortDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            try {
                short s = (short)ShortDataset.toLong(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = s;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (short[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = ShortDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= ShortDataset.calcSize(var6_6)) ** GOTO lbl11
        ShortDataset.logger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl11:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl12:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        short[] sArray = (short[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (sArray.length < ShortDataset.calcSize(sliceIterator.getSliceShape())) {
            logger.error("destination array is not large enough");
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = sArray[n];
            ++n;
        }
        this.setDirty();
    }

    protected ArrayList<Integer> findPositions(double d) {
        short s = (short)d;
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != s) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMax());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMin());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public ShortDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((long)this.data[n] + abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ShortDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ShortDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((long)this.data[n] - abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ShortDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ShortDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((long)this.data[n] * abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = ShortDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (short)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ShortDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (short)((long)this.data[n] / abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = ShortDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (short)((double)this.data[n] / d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ShortDataset ifloor() {
        return this;
    }

    @Override
    public ShortDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (short)((long)this.data[n] % abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = ShortDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (short)((double)this.data[n] % d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ShortDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = Double.isInfinite(d) || Double.isNaN(d) ? (short)0 : (short)d;
            }
        } else {
            double d = ShortDataset.toReal(object);
            double d2 = ShortDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = Double.isInfinite(d3) || Double.isNaN(d3) ? (short)0 : (short)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = Double.isInfinite(d4) || Double.isNaN(d4) ? (short)0 : (short)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = ShortDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

