/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Random;

public class MathsTest {
    private static final int SSTEP = 15;
    private static final int SITER = 3;
    private static final double ABSERR = 1.0E-7;
    private static final double RELERR = 1.0E-5;
    private static final int ISIZE = 2;
    private Map<String, Integer> classes;

    @Before
    public void setUpClass() {
        this.classes = new LinkedHashMap<String, Integer>();
        this.classes.put("Byte", 1);
        this.classes.put("Short", 2);
        this.classes.put("Integer", 3);
        this.classes.put("Long", 4);
        this.classes.put("Float", 5);
        this.classes.put("Double", 6);
        this.classes.put("ComplexF", 7);
        this.classes.put("ComplexD", 8);
        this.classes.put("ArrayB", 100);
        this.classes.put("ArrayS", 200);
        this.classes.put("ArrayI", 300);
        this.classes.put("ArrayL", 400);
        this.classes.put("ArrayF", 500);
        this.classes.put("ArrayD", 600);
    }

    /*
     * Unable to fully structure code
     */
    private void checkDatasets(AbstractDataset var1_1, AbstractDataset var2_2) {
        block3: {
            Assert.assertNotNull((Object)var1_1);
            Assert.assertNotNull((Object)var2_2);
            Assert.assertEquals((String)"Dtype does not match", (long)var1_1.getDtype(), (long)var2_2.getDtype());
            Assert.assertEquals((String)"Size does not match", (long)var1_1.getSize(), (long)var2_2.getSize());
            Assert.assertEquals((String)"ISize does not match", (long)var1_1.getElementsPerItem(), (long)var2_2.getElementsPerItem());
            Assert.assertArrayEquals((String)"Shape does not match", (int[])var1_1.getShape(), (int[])var2_2.getShape());
            var3_3 = var1_1.getIterator(true);
            var4_4 = var2_2.getIterator();
            var5_5 = var1_1.getElementsPerItem();
            if (var5_5 != 1) ** GOTO lbl26
            while (var3_3.hasNext() && var4_4.hasNext()) {
                var6_6 = var1_1.getElementDoubleAbs(var3_3.index);
                var8_8 = var2_2.getElementDoubleAbs(var4_4.index);
                var10_9 = var6_6 == 0.0 ? 1.0E-7 : var6_6 * 1.0E-5;
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(var3_3.getPos()) + ": "), (double)var6_6, (double)var8_8, (double)var10_9);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var6_7 = 0;
                while (var6_7 < var5_5) {
                    var7_10 = var1_1.getElementDoubleAbs(var3_3.index + var6_7);
                    var9_11 = var2_2.getElementDoubleAbs(var4_4.index + var6_7);
                    var11_12 = var7_10 == 0.0 ? 1.0E-7 : var7_10 * 1.0E-5;
                    Assert.assertEquals((String)("Value does not match at " + Arrays.toString(var3_3.getPos()) + "; " + var6_7 + ": "), (double)var7_10, (double)var9_11, (double)var11_12);
                    ++var6_7;
                }
lbl26:
                // 2 sources

                ** while (var3_3.hasNext() && var4_4.hasNext())
            }
        }
    }

    @Test
    public void testAddition() {
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = null;
        Complex complex = new Complex(-3.5, 0.0);
        double d = complex.getReal();
        for (String string : this.classes.keySet()) {
            IndexIterator indexIterator;
            double d2;
            long l;
            AbstractDataset abstractDataset3;
            int n = this.classes.get(string);
            Random.seed(12735L);
            int n2 = 32;
            System.out.println("Adding " + string);
            int n3 = 0;
            while (n3 < 3) {
                AbstractDataset abstractDataset4;
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset4 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset4.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                    abstractDataset4 = abstractDataset4.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[2];
                    int n4 = 0;
                    while (n4 < 2) {
                        abstractDatasetArray[n4] = Random.randn(n2).imultiply(100);
                        abstractDatasetArray2[n4] = Random.randn(n2).imultiply(100);
                        ++n4;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                    abstractDataset4 = DatasetUtils.cast(abstractDatasetArray2, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.add(abstractDataset3, abstractDataset4);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                IndexIterator indexIterator2 = abstractDataset4.getIterator();
                int n5 = 0;
                if (n == 7 || n == 8) {
                    int n6 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).add((Complex)abstractDataset4.getObjectAbs(indexIterator2.index)), n5);
                        n5 += n6;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() + ((Number)abstractDataset4.getObjectAbs(indexIterator2.index)).doubleValue(), n5++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        int n7 = 0;
                        while (n7 < 2) {
                            dArray[n7] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n7) + abstractDataset4.getElementDoubleAbs(indexIterator2.index + n7);
                            ++n7;
                        }
                        abstractDataset2.setObjectAbs(dArray, n5);
                        n5 += 2;
                    }
                }
                double d3 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by add for %s: %s; %s (%.1f%%)\n", n2, d3, d2, 100.0 * (d3 - d2) / d3);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Adding constant to " + string);
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n8 = 0;
                    while (n8 < 2) {
                        abstractDatasetArray[n8] = Random.randn(n2).imultiply(100);
                        ++n8;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.add(abstractDataset3, d);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n9 = 0;
                if (n == 7 || n == 8) {
                    int n10 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).add(complex), n9);
                        n9 += n10;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() + d, n9++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n11 = 0;
                        while (n11 < 2) {
                            dArray[n11] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n11) + d;
                            ++n11;
                        }
                        abstractDataset2.setObjectAbs(dArray, n9);
                        n9 += 2;
                    }
                }
                double d4 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by add for %s: %s; %s (%.1f%%)\n", n2, d4, d2, 100.0 * (d4 - d2) / d4);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
        }
    }

    @Test
    public void testSubtraction() {
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = null;
        Complex complex = new Complex(-3.5, 0.0);
        double d = complex.getReal();
        for (String string : this.classes.keySet()) {
            IndexIterator indexIterator;
            double d2;
            long l;
            AbstractDataset abstractDataset3;
            int n = this.classes.get(string);
            Random.seed(12735L);
            int n2 = 32;
            System.out.println("Subtracting " + string);
            int n3 = 0;
            while (n3 < 3) {
                AbstractDataset abstractDataset4;
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset4 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset4.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                    abstractDataset4 = abstractDataset4.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[2];
                    int n4 = 0;
                    while (n4 < 2) {
                        abstractDatasetArray[n4] = Random.randn(n2).imultiply(100);
                        abstractDatasetArray2[n4] = Random.randn(n2).imultiply(100);
                        ++n4;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                    abstractDataset4 = DatasetUtils.cast(abstractDatasetArray2, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.subtract(abstractDataset3, abstractDataset4);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                IndexIterator indexIterator2 = abstractDataset4.getIterator();
                int n5 = 0;
                if (n == 7 || n == 8) {
                    int n6 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).subtract((Complex)abstractDataset4.getObjectAbs(indexIterator2.index)), n5);
                        n5 += n6;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() - ((Number)abstractDataset4.getObjectAbs(indexIterator2.index)).doubleValue(), n5++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        int n7 = 0;
                        while (n7 < 2) {
                            dArray[n7] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n7) - abstractDataset4.getElementDoubleAbs(indexIterator2.index + n7);
                            ++n7;
                        }
                        abstractDataset2.setObjectAbs(dArray, n5);
                        n5 += 2;
                    }
                }
                double d3 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by sub for %s: %s; %s (%.1f%%)\n", n2, d3, d2, 100.0 * (d3 - d2) / d3);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Subtracting constant from " + string);
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n8 = 0;
                    while (n8 < 2) {
                        abstractDatasetArray[n8] = Random.randn(n2).imultiply(100);
                        ++n8;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.subtract((Object)abstractDataset3, d);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n9 = 0;
                if (n == 7 || n == 8) {
                    int n10 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).subtract(complex), n9);
                        n9 += n10;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() - d, n9++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n11 = 0;
                        while (n11 < 2) {
                            dArray[n11] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n11) - d;
                            ++n11;
                        }
                        abstractDataset2.setObjectAbs(dArray, n9);
                        n9 += 2;
                    }
                }
                double d4 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by sub for %s: %s; %s (%.1f%%)\n", n2, d4, d2, 100.0 * (d4 - d2) / d4);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Subtracting " + string + " from constant");
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n12 = 0;
                    while (n12 < 2) {
                        abstractDatasetArray[n12] = Random.randn(n2).imultiply(100);
                        ++n12;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.subtract(d, (Object)abstractDataset3);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n13 = 0;
                if (n == 7 || n == 8) {
                    int n14 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(complex.subtract((Complex)abstractDataset3.getObjectAbs(indexIterator.index)), n13);
                        n13 += n14;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(d - ((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue(), n13++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n15 = 0;
                        while (n15 < 2) {
                            dArray[n15] = d - abstractDataset3.getElementDoubleAbs(indexIterator.index + n15);
                            ++n15;
                        }
                        abstractDataset2.setObjectAbs(dArray, n13);
                        n13 += 2;
                    }
                }
                double d5 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by sub for %s: %s; %s (%.1f%%)\n", n2, d5, d2, 100.0 * (d5 - d2) / d5);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
        }
    }

    @Test
    public void testMultiplication() {
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = null;
        Complex complex = new Complex(-3.5, 0.0);
        double d = complex.getReal();
        for (String string : this.classes.keySet()) {
            IndexIterator indexIterator;
            double d2;
            long l;
            AbstractDataset abstractDataset3;
            int n = this.classes.get(string);
            Random.seed(12735L);
            int n2 = 32;
            System.out.println("Multiplying " + string);
            int n3 = 0;
            while (n3 < 3) {
                AbstractDataset abstractDataset4;
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset4 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset4.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                    abstractDataset4 = abstractDataset4.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[2];
                    int n4 = 0;
                    while (n4 < 2) {
                        abstractDatasetArray[n4] = Random.randn(n2).imultiply(100);
                        abstractDatasetArray2[n4] = Random.randn(n2).imultiply(100);
                        ++n4;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                    abstractDataset4 = DatasetUtils.cast(abstractDatasetArray2, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.multiply(abstractDataset3, abstractDataset4);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                IndexIterator indexIterator2 = abstractDataset4.getIterator();
                int n5 = 0;
                if (n == 7 || n == 8) {
                    int n6 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).multiply((Complex)abstractDataset4.getObjectAbs(indexIterator2.index)), n5);
                        n5 += n6;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() * ((Number)abstractDataset4.getObjectAbs(indexIterator2.index)).doubleValue(), n5++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        int n7 = 0;
                        while (n7 < 2) {
                            dArray[n7] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n7) * abstractDataset4.getElementDoubleAbs(indexIterator2.index + n7);
                            ++n7;
                        }
                        abstractDataset2.setObjectAbs(dArray, n5);
                        n5 += 2;
                    }
                }
                double d3 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by mul for %s: %s; %s (%.1f%%)\n", n2, d3, d2, 100.0 * (d3 - d2) / d3);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Multiplying constant with " + string);
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n8 = 0;
                    while (n8 < 2) {
                        abstractDatasetArray[n8] = Random.randn(n2).imultiply(100);
                        ++n8;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.multiply(abstractDataset3, d);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n9 = 0;
                if (n == 7 || n == 8) {
                    int n10 = abstractDataset2.getElementsPerItem();
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Complex)abstractDataset3.getObjectAbs(indexIterator.index)).multiply(complex), n9);
                        n9 += n10;
                    }
                } else if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() * d, n9++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n11 = 0;
                        while (n11 < 2) {
                            dArray[n11] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n11) * d;
                            ++n11;
                        }
                        abstractDataset2.setObjectAbs(dArray, n9);
                        n9 += 2;
                    }
                }
                double d4 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by mul for %s: %s; %s (%.1f%%)\n", n2, d4, d2, 100.0 * (d4 - d2) / d4);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testDivision() {
        var3_1 = null;
        var4_2 = null;
        var5_3 = new Complex(-3.5, 0.0);
        var6_4 = var5_3.getReal();
        for (String var11_10 : this.classes.keySet()) {
            var13_11 = this.classes.get(var11_10);
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Dividing " + var11_10);
            var14_12 = 0;
            while (var14_12 < 3) {
                block36: {
                    block37: {
                        block35: {
                            if (var13_11 < 100) {
                                var1_6 = Random.randn(new int[]{var10_9});
                                var2_7 = Random.randn(new int[]{var10_9});
                                var1_6.imultiply(30);
                                var2_7.imultiply(30);
                                var1_6 = var1_6.cast(var13_11);
                                var2_7 = var2_7.cast(var13_11);
                            } else {
                                var15_14 = new AbstractDataset[2];
                                var16_17 = new AbstractDataset[2];
                                var17_21 = 0;
                                while (var17_21 < 2) {
                                    var15_14[var17_21] = Random.randn(new int[]{var10_9}).imultiply(30);
                                    var16_17[var17_21] = Random.randn(new int[]{var10_9}).imultiply(30);
                                    ++var17_21;
                                }
                                var1_6 = DatasetUtils.cast(var15_14, var13_11);
                                var2_7 = DatasetUtils.cast(var16_17, var13_11);
                            }
                            var8_8 = -System.nanoTime();
                            var3_1 = Maths.divide(var1_6, var2_7);
                            var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                            var4_2 = AbstractDataset.zeros(var3_1);
                            var8_8 = -System.nanoTime();
                            var17_20 = var1_6.getIterator();
                            var18_22 = var2_7.getIterator();
                            var19_25 = 0;
                            if (var13_11 != 7 && var13_11 != 8) break block35;
                            var20_32 = var4_2.getElementsPerItem();
                            while (var17_20.hasNext() && var18_22.hasNext()) {
                                var4_2.setObjectAbs(((Complex)var1_6.getObjectAbs(var17_20.index)).divide((Complex)var2_7.getObjectAbs(var18_22.index)), var19_25);
                                var19_25 += var20_32;
                            }
                            break block36;
                        }
                        if (var13_11 >= 100) break block37;
                        while (var17_20.hasNext() && var18_22.hasNext()) {
                            var4_2.setObjectAbs(((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue() / ((Number)var2_7.getObjectAbs(var18_22.index)).doubleValue(), var19_25++);
                        }
                        break block36;
                    }
                    var20_33 = new double[2];
                    if (var13_11 >= 500) ** GOTO lbl74
                    while (var17_20.hasNext() && var18_22.hasNext()) {
                        var21_37 = 0;
                        while (var21_37 < 2) {
                            var22_38 = var1_6.getElementDoubleAbs(var17_20.index + var21_37) / var2_7.getElementDoubleAbs(var18_22.index + var21_37);
                            var20_33[var21_37] = Double.isInfinite(var22_38) != false || Double.isNaN(var22_38) != false ? 0.0 : var22_38;
                            ++var21_37;
                        }
                        var4_2.setObjectAbs(var20_33, var19_25);
                        var19_25 += 2;
                    }
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        var21_37 = 0;
                        while (var21_37 < 2) {
                            var20_33[var21_37] = var1_6.getElementDoubleAbs(var17_20.index + var21_37) / var2_7.getElementDoubleAbs(var18_22.index + var21_37);
                            ++var21_37;
                        }
                        var4_2.setObjectAbs(var20_33, var19_25);
                        var19_25 += 2;
lbl74:
                        // 2 sources

                        ** while (var17_20.hasNext() && var18_22.hasNext())
                    }
                }
                var20_34 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by div for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var20_34, var15_13, 100.0 * (var20_34 - var15_13) / var20_34});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Dividing " + var11_10 + " by constant");
            var14_12 = 0;
            while (var14_12 < 3) {
                if (var13_11 < 100) {
                    var1_6 = Random.randn(new int[]{var10_9});
                    var1_6.imultiply(100);
                    var1_6 = var1_6.cast(var13_11);
                } else {
                    var15_15 = new AbstractDataset[2];
                    var16_18 = 0;
                    while (var16_18 < 2) {
                        var15_15[var16_18] = Random.randn(new int[]{var10_9}).imultiply(100);
                        ++var16_18;
                    }
                    var1_6 = DatasetUtils.cast(var15_15, var13_11);
                }
                var8_8 = -System.nanoTime();
                var3_1 = Maths.divide((Object)var1_6, var6_4);
                var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                var4_2 = AbstractDataset.zeros(var3_1);
                var8_8 = -System.nanoTime();
                var17_20 = var1_6.getIterator();
                var18_23 = 0;
                if (var13_11 == 7 || var13_11 == 8) {
                    var19_26 = var4_2.getElementsPerItem();
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(((Complex)var1_6.getObjectAbs(var17_20.index)).divide(var5_3), var18_23);
                        var18_23 += var19_26;
                    }
                } else if (var13_11 < 100) {
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue() / var6_4, var18_23++);
                    }
                } else {
                    var19_27 = new double[2];
                    while (var17_20.hasNext()) {
                        var20_35 = 0;
                        while (var20_35 < 2) {
                            var19_27[var20_35] = var1_6.getElementDoubleAbs(var17_20.index + var20_35) / var6_4;
                            ++var20_35;
                        }
                        var4_2.setObjectAbs(var19_27, var18_23);
                        var18_23 += 2;
                    }
                }
                var19_28 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by div for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var19_28, var15_13, 100.0 * (var19_28 - var15_13) / var19_28});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Dividing constant by " + var11_10);
            var14_12 = 0;
            while (var14_12 < 3) {
                if (var13_11 < 100) {
                    var1_6 = Random.randn(new int[]{var10_9});
                    var1_6.imultiply(100);
                    var1_6 = var1_6.cast(var13_11);
                } else {
                    var15_16 = new AbstractDataset[2];
                    var16_19 = 0;
                    while (var16_19 < 2) {
                        var15_16[var16_19] = Random.randn(new int[]{var10_9}).imultiply(100);
                        ++var16_19;
                    }
                    var1_6 = DatasetUtils.cast(var15_16, var13_11);
                }
                var8_8 = -System.nanoTime();
                var3_1 = Maths.divide(var6_4, (Object)var1_6);
                var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                var4_2 = AbstractDataset.zeros(var3_1);
                var8_8 = -System.nanoTime();
                var17_20 = var1_6.getIterator();
                var18_24 = 0;
                if (var13_11 == 7 || var13_11 == 8) {
                    var19_29 = var4_2.getElementsPerItem();
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(var5_3.divide((Complex)var1_6.getObjectAbs(var17_20.index)), var18_24);
                        var18_24 += var19_29;
                    }
                } else if (var13_11 < 100) {
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(var6_4 / ((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue(), var18_24++);
                    }
                } else {
                    var19_30 = new double[2];
                    while (var17_20.hasNext()) {
                        var20_36 = 0;
                        while (var20_36 < 2) {
                            var19_30[var20_36] = var6_4 / var1_6.getElementDoubleAbs(var17_20.index + var20_36);
                            ++var20_36;
                        }
                        var4_2.setObjectAbs(var19_30, var18_24);
                        var18_24 += 2;
                    }
                }
                var19_31 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by div for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var19_31, var15_13, 100.0 * (var19_31 - var15_13) / var19_31});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
        }
    }

    @Test
    public void testRemainder() {
        AbstractDataset abstractDataset = null;
        AbstractDataset abstractDataset2 = null;
        Complex complex = new Complex(-3.5, 0.0);
        double d = complex.getReal();
        for (String string : this.classes.keySet()) {
            IndexIterator indexIterator;
            double d2;
            long l;
            AbstractDataset abstractDataset3;
            int n = this.classes.get(string);
            if (n == 7 || n == 8) continue;
            Random.seed(12735L);
            int n2 = 32;
            System.out.println("Remaindering " + string);
            int n3 = 0;
            while (n3 < 3) {
                AbstractDataset abstractDataset4;
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset4 = Random.randn(n2);
                    abstractDataset3.imultiply(30);
                    abstractDataset4.imultiply(30);
                    abstractDataset3 = abstractDataset3.cast(n);
                    abstractDataset4 = abstractDataset4.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    AbstractDataset[] abstractDatasetArray2 = new AbstractDataset[2];
                    int n4 = 0;
                    while (n4 < 2) {
                        abstractDatasetArray[n4] = Random.randn(n2).imultiply(30);
                        abstractDatasetArray2[n4] = Random.randn(n2).imultiply(30);
                        ++n4;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                    abstractDataset4 = DatasetUtils.cast(abstractDatasetArray2, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.remainder(abstractDataset3, abstractDataset4);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                IndexIterator indexIterator2 = abstractDataset4.getIterator();
                int n5 = 0;
                if (n < 100) {
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() % ((Number)abstractDataset4.getObjectAbs(indexIterator2.index)).doubleValue(), n5++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                        int n6 = 0;
                        while (n6 < 2) {
                            dArray[n6] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n6) % abstractDataset4.getElementDoubleAbs(indexIterator2.index + n6);
                            ++n6;
                        }
                        abstractDataset2.setObjectAbs(dArray, n5);
                        n5 += 2;
                    }
                }
                double d3 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by rem for %s: %s; %s (%.1f%%)\n", n2, d3, d2, 100.0 * (d3 - d2) / d3);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Remaindering " + string + " by constant");
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n7 = 0;
                    while (n7 < 2) {
                        abstractDatasetArray[n7] = Random.randn(n2).imultiply(100);
                        ++n7;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.remainder((Object)abstractDataset3, d);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n8 = 0;
                if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue() % d, n8++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n9 = 0;
                        while (n9 < 2) {
                            dArray[n9] = abstractDataset3.getElementDoubleAbs(indexIterator.index + n9) % d;
                            ++n9;
                        }
                        abstractDataset2.setObjectAbs(dArray, n8);
                        n8 += 2;
                    }
                }
                double d4 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by rem for %s: %s; %s (%.1f%%)\n", n2, d4, d2, 100.0 * (d4 - d2) / d4);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
            Random.seed(12735L);
            n2 = 32;
            System.out.println("Remaindering constant by " + string);
            n3 = 0;
            while (n3 < 3) {
                if (n < 100) {
                    abstractDataset3 = Random.randn(n2);
                    abstractDataset3.imultiply(100);
                    abstractDataset3 = abstractDataset3.cast(n);
                } else {
                    AbstractDataset[] abstractDatasetArray = new AbstractDataset[2];
                    int n10 = 0;
                    while (n10 < 2) {
                        abstractDatasetArray[n10] = Random.randn(n2).imultiply(100);
                        ++n10;
                    }
                    abstractDataset3 = DatasetUtils.cast(abstractDatasetArray, n);
                }
                l = -System.nanoTime();
                abstractDataset = Maths.remainder(d, (Object)abstractDataset3);
                d2 = (double)(l += System.nanoTime()) / (double)abstractDataset.getSize();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                l = -System.nanoTime();
                indexIterator = abstractDataset3.getIterator();
                int n11 = 0;
                if (n < 100) {
                    while (indexIterator.hasNext()) {
                        abstractDataset2.setObjectAbs(d % ((Number)abstractDataset3.getObjectAbs(indexIterator.index)).doubleValue(), n11++);
                    }
                } else {
                    double[] dArray = new double[2];
                    while (indexIterator.hasNext()) {
                        int n12 = 0;
                        while (n12 < 2) {
                            dArray[n12] = d % abstractDataset3.getElementDoubleAbs(indexIterator.index + n12);
                            ++n12;
                        }
                        abstractDataset2.setObjectAbs(dArray, n11);
                        n11 += 2;
                    }
                }
                double d5 = (double)(l += System.nanoTime()) / (double)abstractDataset2.getSize();
                System.out.printf("Time taken by rem for %s: %s; %s (%.1f%%)\n", n2, d5, d2, 100.0 * (d5 - d2) / d5);
                this.checkDatasets(abstractDataset, abstractDataset2);
                n2 *= 15;
                ++n3;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testPower() {
        var3_1 = null;
        var4_2 = null;
        var5_3 = new Complex(-3.5, 0.0);
        var6_4 = var5_3.getReal();
        for (String var11_10 : this.classes.keySet()) {
            var13_11 = this.classes.get(var11_10);
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Powering " + var11_10);
            var14_12 = 0;
            while (var14_12 < 3) {
                block36: {
                    block37: {
                        block35: {
                            if (var13_11 < 100) {
                                var1_6 = Random.randn(new int[]{var10_9});
                                var2_7 = Random.randn(new int[]{var10_9});
                                var1_6.imultiply(100);
                                var2_7.imultiply(100);
                                var1_6 = var1_6.cast(var13_11);
                                var2_7 = var2_7.cast(var13_11);
                            } else {
                                var15_14 = new AbstractDataset[2];
                                var16_17 = new AbstractDataset[2];
                                var17_21 = 0;
                                while (var17_21 < 2) {
                                    var15_14[var17_21] = Random.randn(new int[]{var10_9}).imultiply(100);
                                    var16_17[var17_21] = Random.randn(new int[]{var10_9}).imultiply(100);
                                    ++var17_21;
                                }
                                var1_6 = DatasetUtils.cast(var15_14, var13_11);
                                var2_7 = DatasetUtils.cast(var16_17, var13_11);
                            }
                            var8_8 = -System.nanoTime();
                            var3_1 = Maths.power(var1_6, var2_7);
                            var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                            var4_2 = AbstractDataset.zeros(var3_1);
                            var8_8 = -System.nanoTime();
                            var17_20 = var1_6.getIterator();
                            var18_22 = var2_7.getIterator();
                            var19_25 = 0;
                            if (var13_11 != 7 && var13_11 != 8) break block35;
                            var20_32 = var4_2.getElementsPerItem();
                            while (var17_20.hasNext() && var18_22.hasNext()) {
                                var4_2.setObjectAbs(((Complex)var1_6.getObjectAbs(var17_20.index)).pow((Complex)var2_7.getObjectAbs(var18_22.index)), var19_25);
                                var19_25 += var20_32;
                            }
                            break block36;
                        }
                        if (var13_11 >= 100) break block37;
                        while (var17_20.hasNext() && var18_22.hasNext()) {
                            var4_2.setObjectAbs(Math.pow(((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue(), ((Number)var2_7.getObjectAbs(var18_22.index)).doubleValue()), var19_25++);
                        }
                        break block36;
                    }
                    var20_33 = new double[2];
                    if (var13_11 >= 500) ** GOTO lbl74
                    while (var17_20.hasNext() && var18_22.hasNext()) {
                        var21_37 = 0;
                        while (var21_37 < 2) {
                            var22_38 = Math.pow(var1_6.getElementDoubleAbs(var17_20.index + var21_37), var2_7.getElementDoubleAbs(var18_22.index + var21_37));
                            var20_33[var21_37] = Double.isInfinite(var22_38) != false || Double.isNaN(var22_38) != false ? 0.0 : var22_38;
                            ++var21_37;
                        }
                        var4_2.setObjectAbs(var20_33, var19_25);
                        var19_25 += 2;
                    }
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        var21_37 = 0;
                        while (var21_37 < 2) {
                            var20_33[var21_37] = Math.pow(var1_6.getElementDoubleAbs(var17_20.index + var21_37), var2_7.getElementDoubleAbs(var18_22.index + var21_37));
                            ++var21_37;
                        }
                        var4_2.setObjectAbs(var20_33, var19_25);
                        var19_25 += 2;
lbl74:
                        // 2 sources

                        ** while (var17_20.hasNext() && var18_22.hasNext())
                    }
                }
                var20_34 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by pow for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var20_34, var15_13, 100.0 * (var20_34 - var15_13) / var20_34});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Powering " + var11_10 + " by constant");
            var14_12 = 0;
            while (var14_12 < 3) {
                if (var13_11 < 100) {
                    var1_6 = Random.randn(new int[]{var10_9});
                    var1_6.imultiply(100);
                    var1_6 = var1_6.cast(var13_11);
                } else {
                    var15_15 = new AbstractDataset[2];
                    var16_18 = 0;
                    while (var16_18 < 2) {
                        var15_15[var16_18] = Random.randn(new int[]{var10_9}).imultiply(100);
                        ++var16_18;
                    }
                    var1_6 = DatasetUtils.cast(var15_15, var13_11);
                }
                var8_8 = -System.nanoTime();
                var3_1 = Maths.power((Object)var1_6, var6_4);
                var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                var4_2 = AbstractDataset.zeros(var3_1);
                var8_8 = -System.nanoTime();
                var17_20 = var1_6.getIterator();
                var18_23 = 0;
                if (var13_11 == 7 || var13_11 == 8) {
                    var19_26 = var4_2.getElementsPerItem();
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(((Complex)var1_6.getObjectAbs(var17_20.index)).pow(var5_3), var18_23);
                        var18_23 += var19_26;
                    }
                } else if (var13_11 < 100) {
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(Math.pow(((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue(), var6_4), var18_23++);
                    }
                } else {
                    var19_27 = new double[2];
                    while (var17_20.hasNext()) {
                        var20_35 = 0;
                        while (var20_35 < 2) {
                            var19_27[var20_35] = Math.pow(var1_6.getElementDoubleAbs(var17_20.index + var20_35), var6_4);
                            ++var20_35;
                        }
                        var4_2.setObjectAbs(var19_27, var18_23);
                        var18_23 += 2;
                    }
                }
                var19_28 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by pow for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var19_28, var15_13, 100.0 * (var19_28 - var15_13) / var19_28});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
            Random.seed(12735L);
            var10_9 = 32;
            System.out.println("Powering constant by " + var11_10);
            var14_12 = 0;
            while (var14_12 < 3) {
                if (var13_11 < 100) {
                    var1_6 = Random.randn(new int[]{var10_9});
                    var1_6.imultiply(100);
                    var1_6 = var1_6.cast(var13_11);
                } else {
                    var15_16 = new AbstractDataset[2];
                    var16_19 = 0;
                    while (var16_19 < 2) {
                        var15_16[var16_19] = Random.randn(new int[]{var10_9}).imultiply(100);
                        ++var16_19;
                    }
                    var1_6 = DatasetUtils.cast(var15_16, var13_11);
                }
                var8_8 = -System.nanoTime();
                var3_1 = Maths.power(var6_4, (Object)var1_6);
                var15_13 = (double)(var8_8 += System.nanoTime()) / (double)var3_1.getSize();
                var4_2 = AbstractDataset.zeros(var3_1);
                var8_8 = -System.nanoTime();
                var17_20 = var1_6.getIterator();
                var18_24 = 0;
                if (var13_11 == 7 || var13_11 == 8) {
                    var19_29 = var4_2.getElementsPerItem();
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(var5_3.pow((Complex)var1_6.getObjectAbs(var17_20.index)), var18_24);
                        var18_24 += var19_29;
                    }
                } else if (var13_11 < 100) {
                    while (var17_20.hasNext()) {
                        var4_2.setObjectAbs(Math.pow(var6_4, ((Number)var1_6.getObjectAbs(var17_20.index)).doubleValue()), var18_24++);
                    }
                } else {
                    var19_30 = new double[2];
                    while (var17_20.hasNext()) {
                        var20_36 = 0;
                        while (var20_36 < 2) {
                            var19_30[var20_36] = Math.pow(var6_4, var1_6.getElementDoubleAbs(var17_20.index + var20_36));
                            ++var20_36;
                        }
                        var4_2.setObjectAbs(var19_30, var18_24);
                        var18_24 += 2;
                    }
                }
                var19_31 = (double)(var8_8 += System.nanoTime()) / (double)var4_2.getSize();
                System.out.printf("Time taken by pow for %s: %s; %s (%.1f%%)\n", new Object[]{var10_9, var19_31, var15_13, 100.0 * (var19_31 - var15_13) / var19_31});
                this.checkDatasets(var3_1, var4_2);
                var10_9 *= 15;
                ++var14_12;
            }
        }
    }

    @Test
    public void testDifference() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 9;
        nArray[4] = 5;
        nArray[5] = 10;
        int[] nArray2 = nArray;
        IntegerDataset integerDataset = new IntegerDataset(nArray2, null);
        AbstractDataset abstractDataset = Maths.difference((AbstractDataset)integerDataset, 1, -1);
        int[] nArray3 = new int[]{1, 2, 6, -4, 5};
        IntegerDataset integerDataset2 = new IntegerDataset(nArray3, null);
        this.checkDatasets(abstractDataset, integerDataset2);
    }
}

