/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Signal;
import uk.ac.diamond.scisoft.analysis.dataset.function.MapToRotatedCartesian;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class Image {
    protected static final transient Logger logger = LoggerFactory.getLogger(Image.class);

    public static double[] findTranslation2D(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, RectangularROI rectangularROI) {
        Object object;
        AbstractDataset abstractDataset3;
        AbstractDataset abstractDataset4;
        if (abstractDataset.getRank() != 2 || abstractDataset2.getRank() != 2) {
            logger.error("Both datasets should be two-dimensional");
            throw new IllegalArgumentException("Both datasets should be two-dimensional");
        }
        if (rectangularROI == null) {
            abstractDataset4 = abstractDataset;
            abstractDataset3 = abstractDataset2;
        } else {
            object = new MapToRotatedCartesian(rectangularROI);
            abstractDataset4 = ((MapToRotatedCartesian)object).value(abstractDataset).get(0);
            abstractDataset3 = ((MapToRotatedCartesian)object).value(abstractDataset2).get(0);
        }
        object = Signal.phaseCorrelate(abstractDataset4, abstractDataset3, null, true);
        AbstractDataset abstractDataset5 = (AbstractDataset)object.get(0);
        int[] nArray = abstractDataset5.maxPos();
        int[] nArray2 = abstractDataset5.shape;
        double d = abstractDataset5.max().doubleValue();
        logger.info("Max at {} is {}", (Object)nArray, (Object)d);
        double[] dArray = new double[2];
        AbstractDataset abstractDataset6 = (AbstractDataset)object.get(1);
        double d2 = abstractDataset6.getDouble(nArray);
        int n = 0;
        while (n < 2) {
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
            if (nArray[n] < nArray2[n]) {
                double d3 = abstractDataset6.getDouble(nArray);
                dArray[n] = d3 / (d3 - d2);
                if (Math.abs(dArray[n]) > 1.0) {
                    dArray[n] = d3 / (d3 + d2);
                }
            }
            int n3 = n++;
            nArray[n3] = nArray[n3] - 1;
        }
        logger.info("Partial shift is {}", (Object)dArray);
        n = 0;
        while (n < 2) {
            int n4 = n;
            dArray[n4] = dArray[n4] + (double)nArray[n];
            if (dArray[n] > (double)(nArray2[n] / 2)) {
                int n5 = n;
                dArray[n5] = dArray[n5] - (double)nArray2[n];
                logger.info("  Unwrapped position to {}", (Object)dArray[n]);
            }
            ++n;
        }
        logger.info("Shift is {}", (Object)dArray);
        return dArray;
    }
}

