/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class FloatDataset
extends AbstractDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(FloatDataset.class);
    protected float[] data;

    @Override
    protected void setData() {
        this.data = (float[])this.odata;
    }

    private static float[] createArray(int n) {
        float[] fArray = null;
        try {
            fArray = new float[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return fArray;
    }

    @Override
    public int getDtype() {
        return 5;
    }

    public FloatDataset() {
    }

    public FloatDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = FloatDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                logger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = FloatDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = FloatDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public FloatDataset(float[] fArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{fArray.length};
        }
        this.size = FloatDataset.calcSize(nArray);
        if (this.size != fArray.length) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = fArray;
        this.odata = fArray;
    }

    public FloatDataset(FloatDataset floatDataset) {
        this(floatDataset, false);
    }

    public FloatDataset(FloatDataset floatDataset, boolean bl) {
        Object object;
        Object object2;
        this.size = floatDataset.size;
        if (bl) {
            this.shape = floatDataset.shape;
            this.dataSize = floatDataset.dataSize;
            this.dataShape = floatDataset.dataShape;
            this.name = floatDataset.name;
            this.metadata = floatDataset.metadata;
            this.data = floatDataset.data;
            this.odata = floatDataset.data;
            return;
        }
        this.shape = (int[])floatDataset.shape.clone();
        this.name = new String(floatDataset.name);
        if (floatDataset.metadata != null) {
            this.metadata = new HashMap();
            object2 = floatDataset.metadata.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.metadata.put(object, floatDataset.metadata.get(object));
            }
        }
        object = floatDataset.data;
        if (floatDataset.isContiguous()) {
            this.data = (float[])object.clone();
            this.odata = this.data;
        } else {
            this.data = FloatDataset.createArray(this.size);
            this.odata = this.data;
            object2 = floatDataset.getIterator();
            int n = 0;
            while (((IndexIterator)object2).hasNext()) {
                this.data[n] = object[((IndexIterator)object2).index];
                ++n;
            }
        }
    }

    public FloatDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.metadata = abstractDataset.metadata;
        this.data = FloatDataset.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            ++n;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        FloatDataset floatDataset = (FloatDataset)object;
        return Arrays.equals(this.data, floatDataset.data);
    }

    public static FloatDataset createFromObject(Object object) {
        FloatDataset floatDataset = new FloatDataset();
        floatDataset.shape = FloatDataset.getShapeFromObject(object);
        floatDataset.size = FloatDataset.calcSize(floatDataset.shape);
        floatDataset.data = FloatDataset.createArray(floatDataset.size);
        floatDataset.odata = floatDataset.data;
        int[] nArray = new int[floatDataset.shape.length];
        floatDataset.fillData(object, 0, nArray);
        return floatDataset;
    }

    public static FloatDataset arange(double d) {
        return FloatDataset.arange(0.0, d, 1.0);
    }

    public static FloatDataset arange(double d, double d2, double d3) {
        int n = FloatDataset.calcSteps(d, d2, d3);
        FloatDataset floatDataset = new FloatDataset(n);
        int n2 = 0;
        while (n2 < n) {
            floatDataset.data[n2] = (float)(d + (double)n2 * d3);
            ++n2;
        }
        return floatDataset;
    }

    public static FloatDataset ones(int[] nArray) {
        return new FloatDataset(nArray).fill(1);
    }

    @Override
    public FloatDataset fill(Object object) {
        float f = (float)FloatDataset.toReal(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = f;
        }
        return this;
    }

    public float[] getData() {
        return this.data;
    }

    @Override
    public FloatDataset getView() {
        FloatDataset floatDataset = new FloatDataset();
        floatDataset.name = new String(this.name);
        floatDataset.size = FloatDataset.calcSize(this.shape);
        floatDataset.shape = (int[])this.shape.clone();
        floatDataset.data = this.data;
        floatDataset.odata = this.data;
        floatDataset.metadata = this.metadata;
        return floatDataset;
    }

    public float getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0.0f;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return (long)this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return Float.valueOf(this.data[n]);
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        float[] fArray = (float[])object;
        this.data[n] = fArray[n2];
    }

    public void setAbs(float f, int n) {
        this.data[n] = f;
        this.setDirty();
    }

    public float get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        if (n < 0 || n > this.data.length) {
            logger.error("Index given is outside dataset");
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs((float)FloatDataset.toReal(object), n);
    }

    public void setItem(float f, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            this.setAbs(f, this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Dimensionalities of requested position, {}, and dataset, {}, are incompatible", (Object)nArray.length, (Object)this.shape.length);
            throw new IllegalArgumentException("Dimensionalities of requested position, " + nArray.length + ", and dataset, " + this.shape.length + ", are incompatible");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Index out of bounds - need to make dataset extendible");
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem((float)FloatDataset.toReal(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            logger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = FloatDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = FloatDataset.calcSize(this.dataShape);
        float[] fArray = FloatDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = FloatDataset.calcSize(nArray);
        Arrays.fill(fArray, Float.NaN);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = fArray;
        this.odata = fArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = FloatDataset.calcSize(nArray);
        float[] fArray = FloatDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            fArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = fArray;
        this.odata = fArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public Object getObject(int ... nArray) {
        return new Float(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return (long)this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0.0f;
    }

    @Override
    public String getString(int ... nArray) {
        return String.format("%.8g", Float.valueOf(this.get(nArray)));
    }

    @Override
    public FloatDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        FloatDataset floatDataset = new FloatDataset(sliceIterator.getSliceShape());
        float[] fArray = floatDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            fArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return floatDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        float[] fArray = ((FloatDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public FloatDataset setByBoolean(BooleanDataset booleanDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                logger.error("Number of true items in selection does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            float f = (float)FloatDataset.toReal(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = f;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setByIndex(IntegerDataset integerDataset, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                logger.error("Number of true items in index dataset does not match number of items in dataset");
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            float f = (float)FloatDataset.toReal(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = f;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = FloatDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            try {
                float f = (float)FloatDataset.toReal(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = f;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (float[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = FloatDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= FloatDataset.calcSize(var6_6)) ** GOTO lbl11
        FloatDataset.logger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl11:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl12:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        float[] fArray = (float[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (fArray.length < FloatDataset.calcSize(sliceIterator.getSliceShape())) {
            logger.error("destination array is not large enough");
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = fArray[n];
            ++n;
        }
        this.setDirty();
    }

    protected ArrayList<Integer> findPositions(double d) {
        float f = (float)d;
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != f) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMax());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList<Integer> arrayList = null;
        if (v == null) {
            SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats");
            arrayList = this.findPositions(summaryStatistics.getMin());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList<Integer>)v;
        } else {
            logger.error("Inconsistent internal state of stored values for statistics calculation");
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition(arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Float.isNaN(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Float.isInfinite(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public FloatDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] + abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] - abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] * abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] / abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] / d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset ifloor() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = (float)Math.floor(this.data[indexIterator.index]);
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] % abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] % d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = (float)d;
            }
        } else {
            double d = FloatDataset.toReal(object);
            double d2 = FloatDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = (float)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = (float)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

