/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.DataSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;
import uk.ac.diamond.scisoft.analysis.dataset.function.Centroid;

public class DatasetUtils {
    protected static final transient Logger utilsLogger = LoggerFactory.getLogger(DatasetUtils.class);

    public static AbstractDataset put(AbstractDataset abstractDataset, int[] nArray, Object[] objectArray) {
        int n = nArray.length;
        int n2 = objectArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            if (n4 >= n2) {
                n4 -= n2;
            }
            abstractDataset.setObjectAbs(objectArray[n4], abstractDataset.to1DIndex(nArray[n3]));
            ++n3;
            ++n4;
        }
        return abstractDataset;
    }

    public static AbstractDataset take(AbstractDataset abstractDataset, int[] nArray, Integer n) {
        AbstractDataset abstractDataset2;
        if (nArray == null || nArray.length == 0) {
            utilsLogger.error("No indices given");
            throw new IllegalArgumentException("No indices given");
        }
        int[] nArray2 = abstractDataset.getShape();
        int n2 = nArray2.length;
        int n3 = abstractDataset.getDtype();
        int n4 = nArray.length;
        int n5 = abstractDataset.getElementsPerItem();
        if (n == null) {
            nArray2 = new int[]{n4};
            abstractDataset2 = AbstractDataset.zeros(n5, nArray2, n3);
            int n6 = 0;
            while (n6 < n4) {
                abstractDataset2.setItemDirect(n6, abstractDataset.to1DIndex(nArray[n6]), abstractDataset);
                ++n6;
            }
        } else {
            n = abstractDataset.checkAxis(n);
            nArray2[n.intValue()] = n4;
            abstractDataset2 = AbstractDataset.zeros(n5, nArray2, n3);
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[n2];
            boolean[] blArray = new boolean[n2];
            Arrays.fill(blArray, true);
            blArray[n.intValue()] = false;
            Object object = abstractDataset.getBuffer();
            int n7 = 0;
            while (n7 < n4) {
                nArray4[n.intValue()] = nArray[n7];
                nArray3[n.intValue()] = n7;
                SliceIterator sliceIterator = abstractDataset.getSliceIteratorFromAxes(nArray4, blArray);
                SliceIterator sliceIterator2 = abstractDataset2.getSliceIteratorFromAxes(nArray3, blArray);
                while (sliceIterator.hasNext() && sliceIterator2.hasNext()) {
                    abstractDataset2.setItemDirect(sliceIterator2.index, sliceIterator.index, object);
                }
                ++n7;
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset tile(AbstractDataset abstractDataset, int ... nArray) {
        int n;
        int n2;
        int[] nArray2;
        int[] nArray3 = abstractDataset.getShape();
        int[] nArray4 = null;
        int n3 = nArray3.length;
        int n4 = nArray.length;
        if (n3 < n4) {
            nArray2 = new int[n4];
            nArray4 = new int[n3];
            n2 = n4 - n3;
            n = 0;
            while (n < n2) {
                nArray2[n] = 1;
                ++n;
            }
            n = 0;
            while (n < n3) {
                nArray2[n + n2] = nArray3[n];
                nArray4[n] = nArray3[n];
                ++n;
            }
            nArray3 = nArray2;
            n3 = n4;
        } else if (n3 > n4) {
            nArray2 = new int[n3];
            n2 = n3 - n4;
            n = 0;
            while (n < n2) {
                nArray2[n] = 1;
                ++n;
            }
            n = 0;
            while (n < n4) {
                nArray2[n + n2] = nArray[n];
                ++n;
            }
            nArray = nArray2;
        }
        nArray2 = new int[n3];
        n2 = 0;
        while (n2 < n3) {
            nArray2[n2] = nArray3[n2] * nArray[n2];
            ++n2;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset.getElementsPerItem(), nArray2, abstractDataset.getDtype());
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray5[n5] = 0;
            nArray6[n5] = nArray3[n5];
            nArray7[n5] = 1;
            ++n5;
        }
        block6: do {
            abstractDataset2.setSlice(nArray5, nArray6, nArray7, abstractDataset);
            n5 = 0;
            while (n5 < n3) {
                int n6 = n5;
                nArray5[n6] = nArray5[n6] + nArray3[n5];
                int n7 = n5;
                nArray6[n7] = nArray6[n7] + nArray3[n5];
                if (nArray5[n5] < nArray2[n5]) continue block6;
                nArray5[n5] = 0;
                nArray6[n5] = nArray3[n5];
                ++n5;
            }
        } while (n5 != n3);
        if (nArray4 != null) {
            abstractDataset.setShape(nArray4);
        }
        return abstractDataset2;
    }

    public static AbstractDataset transpose(AbstractDataset abstractDataset, int ... nArray) {
        int n;
        int n2;
        int[] nArray2 = abstractDataset.getShape();
        int n3 = nArray2.length;
        if (n3 == 1) {
            return abstractDataset;
        }
        if (nArray.length == 0) {
            nArray = new int[n3];
            n2 = 0;
            while (n2 < n3) {
                nArray[n2] = n3 - 1 - n2;
                ++n2;
            }
        }
        if (nArray.length != n3) {
            utilsLogger.error("axis permutation has length {} that does not match dataset's rank {}", (Object)nArray.length, (Object)n3);
            throw new IllegalArgumentException("axis permutation does not match shape of dataset");
        }
        int[] nArray3 = nArray;
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray3[n5];
            if (n6 < 0 || n6 >= n3) {
                utilsLogger.error("axis permutation contains element {} outside rank of dataset", (Object)n6);
                throw new IllegalArgumentException("axis permutation contains element outside rank of dataset");
            }
            ++n5;
        }
        int[] nArray4 = (int[])nArray.clone();
        Arrays.sort(nArray4);
        n2 = 0;
        while (n2 < n3) {
            if (nArray4[n2] != n2) {
                utilsLogger.error("axis permutation is not valid: it does not contain complete set of axes");
                throw new IllegalArgumentException("axis permutation does not contain complete set of axes");
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n3) {
            if (nArray[n2] != n2) break;
            ++n2;
        }
        if (n2 == n3) {
            return abstractDataset.clone();
        }
        int[] nArray5 = new int[n3];
        n2 = 0;
        while (n2 < n3) {
            nArray5[n2] = nArray2[nArray[n2]];
            ++n2;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset.getElementsPerItem(), nArray5, abstractDataset.getDtype());
        nArray3 = new int[n3];
        int[] nArray6 = new int[n3];
        n2 = 0;
        while (n2 < n3) {
            nArray3[n2] = 0;
            nArray6[n2] = 0;
            ++n2;
        }
        block6: do {
            abstractDataset2.set(abstractDataset.getObject(nArray6), nArray3);
            n = n3 - 1;
            while (n >= 0) {
                int n7;
                int n8 = n;
                nArray3[n8] = nArray3[n8] + 1;
                int n9 = n7 = nArray[n];
                nArray6[n9] = nArray6[n9] + 1;
                if (nArray3[n] < nArray5[n]) continue block6;
                nArray3[n] = 0;
                nArray6[n7] = 0;
                --n;
            }
        } while (n != -1);
        return abstractDataset2;
    }

    public static AbstractDataset swapAxes(AbstractDataset abstractDataset, int n, int n2) {
        int[] nArray = abstractDataset.getShape();
        int n3 = nArray.length;
        if (n < 0) {
            n += n3;
        }
        if (n2 < 0) {
            n2 += n3;
        }
        if (n < 0 || n2 < 0 || n >= n3 || n2 >= n3) {
            utilsLogger.error("Axis value invalid - out of range");
            throw new IllegalArgumentException("Axis value invalid - out of range");
        }
        if (n3 == 1 || n == n2) {
            return abstractDataset;
        }
        int[] nArray2 = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n4] = n4;
            ++n4;
        }
        nArray2[n] = n2;
        nArray2[n2] = n;
        return DatasetUtils.transpose(abstractDataset, nArray2);
    }

    public static AbstractDataset sort(AbstractDataset abstractDataset, Integer n) {
        AbstractDataset abstractDataset2 = abstractDataset.clone();
        return abstractDataset2.sort(n);
    }

    public static AbstractDataset concatenate(AbstractDataset[] abstractDatasetArray, int n) {
        if (abstractDatasetArray == null || abstractDatasetArray.length == 0) {
            utilsLogger.error("No datasets given");
            throw new IllegalArgumentException("No datasets given");
        }
        AbstractDataset abstractDataset = abstractDatasetArray[0];
        if (abstractDatasetArray.length == 1) {
            return abstractDataset.clone();
        }
        int[] nArray = abstractDataset.getShape();
        int n2 = abstractDataset.getDtype();
        int n3 = abstractDatasetArray.length;
        int n4 = abstractDataset.getElementsPerItem();
        int n5 = 1;
        while (n5 < n3) {
            if (n2 != abstractDatasetArray[n5].getDtype()) {
                utilsLogger.error("Datasets are not of same type");
                break;
            }
            if (!AbstractDataset.areShapesCompatible(nArray, abstractDatasetArray[n5].shape, n)) {
                utilsLogger.error("Datasets' shapes are not equal");
                break;
            }
            int n6 = abstractDatasetArray[n5].getElementsPerItem();
            if (n4 < n6) {
                n4 = n6;
            }
            ++n5;
        }
        if (n5 < n3) {
            utilsLogger.error("Dataset are not compatible");
            throw new IllegalArgumentException("Datasets are not compatible");
        }
        n5 = 1;
        while (n5 < n3) {
            int n7 = n;
            nArray[n7] = nArray[n7] + abstractDatasetArray[n5].shape[n];
            ++n5;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(n4, nArray, n2);
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = nArray;
        nArray3[n] = 0;
        n5 = 0;
        while (n5 < n3) {
            AbstractDataset abstractDataset3 = abstractDatasetArray[n5];
            int n8 = n;
            nArray3[n8] = nArray3[n8] + abstractDataset3.shape[n];
            abstractDataset2.setSlice(nArray2, nArray3, null, abstractDataset3);
            int n9 = n;
            nArray2[n9] = nArray2[n9] + abstractDataset3.shape[n];
            ++n5;
        }
        return abstractDataset2;
    }

    public static List<AbstractDataset> split(AbstractDataset abstractDataset, int n, int n2, boolean bl) {
        int[] nArray = abstractDataset.shape;
        int n3 = nArray.length;
        if (n2 > n3) {
            utilsLogger.error("Axis exceeds rank of dataset");
            throw new IllegalArgumentException("Axis exceeds rank of dataset");
        }
        int n4 = nArray[n2];
        if (bl && n4 % n != 0) {
            utilsLogger.error("Number of sections does not divide axis into equal parts");
            throw new IllegalArgumentException("Number of sections does not divide axis into equal parts");
        }
        int n5 = (n4 + n - 1) / n;
        int[] nArray2 = new int[n - 1];
        int n6 = 1;
        while (n6 < n) {
            nArray2[n6 - 1] = n5 * n6;
            ++n6;
        }
        return DatasetUtils.split(abstractDataset, nArray2, n2);
    }

    public static List<AbstractDataset> split(AbstractDataset abstractDataset, int[] nArray, int n) {
        int[] nArray2 = abstractDataset.shape;
        int n2 = nArray2.length;
        if (n > n2) {
            utilsLogger.error("Axis exceeds rank of dataset");
            throw new IllegalArgumentException("Axis exceeds rank of dataset");
        }
        int n3 = nArray2[n];
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        int[] nArray3 = (int[])nArray2.clone();
        int n4 = abstractDataset.getElementsPerItem();
        int n5 = 0;
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            nArray4[n6] = 0;
            nArray5[n6] = nArray2[n6];
            nArray6[n6] = 1;
            ++n6;
        }
        int[] nArray7 = nArray;
        int n7 = nArray.length;
        int n8 = 0;
        while (n8 < n7) {
            n6 = nArray7[n8];
            if (n6 > n3) {
                arrayList.add(AbstractDataset.zeros(n4, new int[1], abstractDataset.getDtype()));
            } else {
                nArray3[n] = n6 - n5;
                nArray4[n] = n5;
                nArray5[n] = n6;
                AbstractDataset abstractDataset2 = AbstractDataset.zeros(n4, nArray3, abstractDataset.getDtype());
                IndexIterator indexIterator = abstractDataset.getSliceIterator(nArray4, nArray5, nArray6);
                abstractDataset.fillDataset(abstractDataset2, indexIterator);
                arrayList.add(abstractDataset2);
                n5 = n6;
            }
            ++n8;
        }
        if (n3 > n5) {
            nArray3[n] = n3 - n5;
            nArray4[n] = n5;
            nArray5[n] = n3;
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(n4, nArray3, abstractDataset.getDtype());
            IndexIterator indexIterator = abstractDataset.getSliceIterator(nArray4, nArray5, nArray6);
            abstractDataset.fillDataset(abstractDataset3, indexIterator);
            arrayList.add(abstractDataset3);
        }
        return arrayList;
    }

    public static AbstractDataset repeat(AbstractDataset abstractDataset, int[] nArray, int n) {
        int n2;
        Object object = abstractDataset.getBuffer();
        int[] nArray2 = abstractDataset.getShape();
        int n3 = nArray2.length;
        int n4 = abstractDataset.getElementsPerItem();
        if (n >= n3) {
            utilsLogger.warn("Axis value is out of bounds");
            throw new IllegalArgumentException("Axis value is out of bounds");
        }
        if (n < 0) {
            n2 = abstractDataset.size;
            n = 0;
            n3 = 1;
            nArray2[0] = n2;
        } else {
            n2 = nArray2[n];
        }
        int n5 = nArray.length;
        if (n5 != 1 && n5 != n2) {
            utilsLogger.warn("Repeats array should have length of 1 or match chosen axis");
            throw new IllegalArgumentException("Repeats array should have length of 1 or match chosen axis");
        }
        int n6 = 0;
        while (n6 < n5) {
            if (nArray[n6] < 0) {
                utilsLogger.warn("Negative repeat value is not allowed");
                throw new IllegalArgumentException("Negative repeat value is not allowed");
            }
            ++n6;
        }
        int[] nArray3 = new int[n3];
        int n7 = 0;
        while (n7 < n3) {
            nArray3[n7] = nArray2[n7];
            ++n7;
        }
        if (nArray.length == 1) {
            int n8 = n;
            nArray3[n8] = nArray3[n8] * nArray[0];
        } else {
            n7 = 0;
            int n9 = 0;
            while (n9 < n2) {
                n7 += nArray[n9];
                ++n9;
            }
            nArray3[n] = n7;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(n4, nArray3, abstractDataset.getDtype());
        Object object2 = abstractDataset2.getBuffer();
        int n10 = n4;
        int n11 = n + 1;
        while (n11 < n3) {
            n10 *= nArray3[n11];
            ++n11;
        }
        n11 = 1;
        int n12 = 0;
        while (n12 < n) {
            n11 *= nArray3[n12];
            ++n12;
        }
        if (abstractDataset.isContiguous()) {
            n12 = 0;
            int n13 = 0;
            if (n5 == 1) {
                int n14 = 0;
                while (n14 < n11) {
                    int n15 = 0;
                    while (n15 < nArray2[n]) {
                        int n16 = 0;
                        while (n16 < nArray[0]) {
                            System.arraycopy(object, n12, object2, n13, n10);
                            n13 += n10;
                            ++n16;
                        }
                        n12 += n10;
                        ++n15;
                    }
                    ++n14;
                }
            } else {
                int n17 = 0;
                while (n17 < n11) {
                    int n18 = 0;
                    while (n18 < nArray2[n]) {
                        int n19 = 0;
                        while (n19 < nArray[n18]) {
                            System.arraycopy(object, n12, object2, n13, n10);
                            n13 += n10;
                            ++n19;
                        }
                        n12 += n10;
                        ++n18;
                    }
                    ++n17;
                }
            }
        } else {
            n12 = 0;
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(n4, new int[]{n10 / n4}, abstractDataset.getDtype());
            Object object3 = abstractDataset3.getBuffer();
            IndexIterator indexIterator = abstractDataset.getIterator();
            if (n5 == 1) {
                int n20 = 0;
                while (n20 < n11) {
                    int n21 = 0;
                    while (n21 < nArray2[n]) {
                        abstractDataset.fillDataset(abstractDataset3, indexIterator);
                        int n22 = 0;
                        while (n22 < nArray[0]) {
                            System.arraycopy(object3, 0, object2, n12, n10);
                            n12 += n10;
                            ++n22;
                        }
                        ++n21;
                    }
                    ++n20;
                }
            } else {
                int n23 = 0;
                while (n23 < n11) {
                    int n24 = 0;
                    while (n24 < nArray2[n]) {
                        abstractDataset.fillDataset(abstractDataset3, indexIterator);
                        int n25 = 0;
                        while (n25 < nArray[n24]) {
                            System.arraycopy(object3, 0, object2, n12, n10);
                            n12 += n10;
                            ++n25;
                        }
                        ++n24;
                    }
                    ++n23;
                }
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset cast(AbstractDataset abstractDataset, int n) {
        if (abstractDataset.getDtype() == n) {
            return abstractDataset;
        }
        AbstractDataset abstractDataset2 = null;
        try {
            switch (n) {
                case 0: {
                    abstractDataset2 = new BooleanDataset(abstractDataset);
                    break;
                }
                case 1: {
                    abstractDataset2 = new ByteDataset(abstractDataset);
                    break;
                }
                case 2: {
                    abstractDataset2 = new ShortDataset(abstractDataset);
                    break;
                }
                case 3: {
                    abstractDataset2 = new IntegerDataset(abstractDataset);
                    break;
                }
                case 4: {
                    abstractDataset2 = new LongDataset(abstractDataset);
                    break;
                }
                case 100: {
                    abstractDataset2 = new CompoundByteDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 200: {
                    abstractDataset2 = new CompoundShortDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 300: {
                    abstractDataset2 = new CompoundIntegerDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 400: {
                    abstractDataset2 = new CompoundLongDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 5: {
                    abstractDataset2 = new FloatDataset(abstractDataset);
                    break;
                }
                case 6: {
                    abstractDataset2 = new DoubleDataset(abstractDataset);
                    break;
                }
                case 500: {
                    abstractDataset2 = new CompoundFloatDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 600: {
                    abstractDataset2 = new CompoundDoubleDataset(new AbstractDataset[]{abstractDataset});
                    break;
                }
                case 7: {
                    abstractDataset2 = new ComplexFloatDataset(abstractDataset);
                    break;
                }
                case 8: {
                    abstractDataset2 = new ComplexDoubleDataset(abstractDataset);
                    break;
                }
                default: {
                    utilsLogger.error("Dataset of unknown type!");
                    break;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            utilsLogger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        return abstractDataset2;
    }

    public static AbstractCompoundDataset cast(AbstractDataset[] abstractDatasetArray, int n) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        switch (n) {
            case 100: {
                abstractCompoundDataset = new CompoundByteDataset(abstractDatasetArray);
                break;
            }
            case 200: {
                abstractCompoundDataset = new CompoundShortDataset(abstractDatasetArray);
                break;
            }
            case 300: {
                abstractCompoundDataset = new CompoundIntegerDataset(abstractDatasetArray);
                break;
            }
            case 400: {
                abstractCompoundDataset = new CompoundLongDataset(abstractDatasetArray);
                break;
            }
            case 500: {
                abstractCompoundDataset = new CompoundFloatDataset(abstractDatasetArray);
                break;
            }
            case 600: {
                abstractCompoundDataset = new CompoundDoubleDataset(abstractDatasetArray);
                break;
            }
            case 7: {
                if (abstractDatasetArray.length != 2) {
                    throw new IllegalArgumentException("Need two datasets for complex dataset type");
                }
                abstractCompoundDataset = new ComplexFloatDataset(abstractDatasetArray[0], abstractDatasetArray[1]);
                break;
            }
            case 8: {
                if (abstractDatasetArray.length != 2) {
                    throw new IllegalArgumentException("Need two datasets for complex dataset type");
                }
                abstractCompoundDataset = new ComplexDoubleDataset(abstractDatasetArray[0], abstractDatasetArray[1]);
                break;
            }
            default: {
                utilsLogger.error("Dataset of unsupported type!");
            }
        }
        return abstractCompoundDataset;
    }

    public static void unwrapUnsigned(AbstractDataset abstractDataset, int n) {
        int n2 = abstractDataset.getDtype();
        long l = 1 << n;
        IndexIterator indexIterator = abstractDataset.getIterator();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ShortDataset shortDataset = (ShortDataset)abstractDataset;
                short s = (short)l;
                while (indexIterator.hasNext()) {
                    short s2 = shortDataset.getAbs(indexIterator.index);
                    if (s2 >= 0) continue;
                    shortDataset.setAbs((short)(s2 + s), indexIterator.index);
                }
                break;
            }
            case 3: {
                IntegerDataset integerDataset = (IntegerDataset)abstractDataset;
                int n3 = (int)l;
                while (indexIterator.hasNext()) {
                    int n4 = integerDataset.getAbs(indexIterator.index);
                    if (n4 >= 0) continue;
                    integerDataset.setAbs(n4 + n3, indexIterator.index);
                }
                break;
            }
            case 4: {
                LongDataset longDataset = (LongDataset)abstractDataset;
                while (indexIterator.hasNext()) {
                    long l2 = longDataset.getAbs(indexIterator.index);
                    if (l2 >= 0L) continue;
                    longDataset.setAbs(l2 + l, indexIterator.index);
                }
                break;
            }
            case 5: {
                FloatDataset floatDataset = (FloatDataset)abstractDataset;
                float f = l;
                while (indexIterator.hasNext()) {
                    float f2 = floatDataset.getAbs(indexIterator.index);
                    if (!(f2 < 0.0f)) continue;
                    floatDataset.setAbs(f2 + f, indexIterator.index);
                }
                break;
            }
            case 6: {
                DoubleDataset doubleDataset = (DoubleDataset)abstractDataset;
                double d = l;
                while (indexIterator.hasNext()) {
                    double d2 = doubleDataset.getAbs(indexIterator.index);
                    if (!(d2 < 0.0)) continue;
                    doubleDataset.setAbs(d2 + d, indexIterator.index);
                }
                break;
            }
            default: {
                utilsLogger.error("Dataset of unsupported type for this method");
            }
        }
    }

    public static AbstractDataset linSpace(double d, double d2, int n, int n2) {
        if (n < 1) {
            utilsLogger.error("Length is less than one");
            throw new IllegalArgumentException("Length is less than one");
        }
        if (n == 1) {
            return AbstractDataset.array(d, n2);
        }
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n}, n2);
        double d3 = (d2 - d) / (double)(n - 1);
        int n3 = 0;
        while (n3 < n) {
            double d4 = d + (double)n3 * d3;
            abstractDataset.setObjectAbs(d4, n3);
            ++n3;
        }
        return abstractDataset;
    }

    public static AbstractDataset logSpace(double d, double d2, int n, double d3, int n2) {
        if (n < 1) {
            utilsLogger.error("Length is less than one");
            throw new IllegalArgumentException("Length is less than one");
        }
        if (n == 1) {
            return AbstractDataset.array(Math.pow(d3, d), n2);
        }
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n}, n2);
        double d4 = (d2 - d) / (double)(n - 1);
        int n3 = 0;
        while (n3 < n) {
            double d5 = d + (double)n3 * d4;
            abstractDataset.setObjectAbs(Math.pow(d3, d5), n3);
            ++n3;
        }
        return abstractDataset;
    }

    public static AbstractDataset eye(int n, int n2, int n3, int n4) {
        int[] nArray = new int[]{n, n2};
        AbstractDataset abstractDataset = AbstractDataset.zeros(nArray, n4);
        int[] nArray2 = new int[2];
        nArray2[1] = n3;
        int[] nArray3 = nArray2;
        while (nArray3[1] < 0) {
            nArray3[0] = nArray3[0] + 1;
            nArray3[1] = nArray3[1] + 1;
        }
        while (nArray3[0] < n && nArray3[1] < n2) {
            abstractDataset.set(1, nArray3);
            nArray3[0] = nArray3[0] + 1;
            nArray3[1] = nArray3[1] + 1;
        }
        return abstractDataset;
    }

    public static AbstractDataset diag(AbstractDataset abstractDataset, int n) {
        AbstractDataset abstractDataset2;
        block7: {
            int n2;
            int n3;
            int n4;
            block6: {
                n4 = abstractDataset.getDtype();
                int n5 = abstractDataset.getRank();
                n3 = abstractDataset.getElementsPerItem();
                if (n5 == 0 || n5 > 2) {
                    utilsLogger.error("Rank of dataset should be one or two");
                    throw new IllegalArgumentException("Rank of dataset should be one or two");
                }
                if (n5 != 1) break block6;
                int n6 = abstractDataset.shape[0] + Math.abs(n);
                int[] nArray = new int[]{n6, n6};
                abstractDataset2 = AbstractDataset.zeros(n3, nArray, n4);
                nArray[0] = 0;
                nArray[1] = n;
                while (nArray[1] < 0) {
                    nArray[0] = nArray[0] + 1;
                    nArray[1] = nArray[1] + 1;
                }
                int n7 = 0;
                while (nArray[0] < n6 && nArray[1] < n6) {
                    abstractDataset2.set(abstractDataset.getObject(n7++), nArray);
                    nArray[0] = nArray[0] + 1;
                    nArray[1] = nArray[1] + 1;
                }
                break block7;
            }
            int n8 = n2 = n >= 0 ? Math.min(abstractDataset.shape[0], abstractDataset.shape[1] - n) : Math.min(abstractDataset.shape[0] + n, abstractDataset.shape[1]);
            if (n2 < 0) {
                n2 = 0;
            }
            abstractDataset2 = AbstractDataset.zeros(n3, new int[]{n2}, n4);
            if (n2 <= 0) break block7;
            int[] nArray = new int[2];
            nArray[1] = n;
            int[] nArray2 = nArray;
            while (nArray2[1] < 0) {
                nArray2[0] = nArray2[0] + 1;
                nArray2[1] = nArray2[1] + 1;
            }
            int n9 = 0;
            while (nArray2[0] < abstractDataset.shape[0] && nArray2[1] < abstractDataset.shape[1]) {
                abstractDataset2.set(abstractDataset.getObject(nArray2), n9++);
                nArray2[0] = nArray2[0] + 1;
                nArray2[1] = nArray2[1] + 1;
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset convertToAbstractDataset(IDataset iDataset) {
        if (iDataset instanceof AbstractDataset) {
            return (AbstractDataset)iDataset;
        }
        if (iDataset instanceof DataSet) {
            return AbstractDataset.toDoubleDataset((DataSet)iDataset);
        }
        int n = iDataset.getElementsPerItem();
        if (n <= 0) {
            throw new IllegalArgumentException("Datasets with " + n + " elements per item not supported");
        }
        Class<?> clazz = iDataset.elementClass();
        int n2 = AbstractDataset.getDTypeFromClass(clazz);
        AbstractDataset abstractDataset = AbstractDataset.zeros(n, iDataset.getShape(), n2);
        n2 = abstractDataset.getDtype();
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        int[] nArray = indexIterator.getPos();
        switch (n2) {
            case 0: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getBoolean(nArray), indexIterator.index);
                }
                break;
            }
            case 1: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getByte(nArray), indexIterator.index);
                }
                break;
            }
            case 2: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getShort(nArray), indexIterator.index);
                }
                break;
            }
            case 3: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getInt(nArray), indexIterator.index);
                }
                break;
            }
            case 4: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getLong(nArray), indexIterator.index);
                }
                break;
            }
            case 5: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(Float.valueOf(iDataset.getFloat(nArray)), indexIterator.index);
                }
                break;
            }
            case 6: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getDouble(nArray), indexIterator.index);
                }
                break;
            }
            default: {
                while (indexIterator.hasNext()) {
                    abstractDataset.setObjectAbs(iDataset.getObject(nArray), indexIterator.index);
                }
                break block0;
            }
        }
        return abstractDataset;
    }

    public static AbstractCompoundDataset createCompoundDatasetFromLastAxis(AbstractDataset abstractDataset, boolean bl) {
        int[] nArray;
        AbstractCompoundDataset abstractCompoundDataset;
        if (abstractDataset instanceof AbstractCompoundDataset) {
            utilsLogger.error("Need a single-element dataset");
            throw new IllegalArgumentException("Need a single-element dataset");
        }
        Object object = bl ? abstractDataset.getBuffer() : abstractDataset.clone().getBuffer();
        int[] nArray2 = abstractDataset.getShape();
        int n = nArray2.length - 1;
        int n2 = nArray2[n];
        switch (abstractDataset.getDtype()) {
            case 1: {
                abstractCompoundDataset = new CompoundByteDataset(n2);
                break;
            }
            case 2: {
                abstractCompoundDataset = new CompoundShortDataset(n2);
                break;
            }
            case 3: {
                abstractCompoundDataset = new CompoundIntegerDataset(n2);
                break;
            }
            case 4: {
                abstractCompoundDataset = new CompoundLongDataset(n2);
                break;
            }
            case 5: {
                abstractCompoundDataset = new CompoundFloatDataset(n2);
                break;
            }
            case 6: {
                abstractCompoundDataset = new CompoundDoubleDataset(n2);
                break;
            }
            default: {
                utilsLogger.error("Dataset type not supported for this operation");
                throw new UnsupportedOperationException("Dataset type not supported");
            }
        }
        if (n > 0) {
            nArray = Arrays.copyOf(nArray2, n);
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        abstractCompoundDataset.shape = nArray;
        abstractCompoundDataset.size = AbstractDataset.calcSize(abstractCompoundDataset.shape);
        if (bl && abstractDataset.dataShape != null) {
            int[] nArray4;
            if (n > 0) {
                nArray4 = Arrays.copyOf(abstractDataset.dataShape, n);
            } else {
                int[] nArray5 = new int[1];
                nArray4 = nArray5;
                nArray5[0] = 1;
            }
            abstractCompoundDataset.dataShape = nArray4;
            abstractCompoundDataset.dataSize = AbstractDataset.calcSize(abstractCompoundDataset.dataShape);
        }
        abstractCompoundDataset.odata = object;
        abstractCompoundDataset.setName(abstractDataset.getName());
        abstractCompoundDataset.setData();
        return abstractCompoundDataset;
    }

    public static AbstractDataset createDatasetFromCompoundDataset(AbstractCompoundDataset abstractCompoundDataset, boolean bl) {
        int n;
        AbstractDataset abstractDataset;
        Object object = bl ? abstractCompoundDataset.getBuffer() : abstractCompoundDataset.clone().getBuffer();
        switch (abstractCompoundDataset.getDtype()) {
            case 100: {
                abstractDataset = new ByteDataset();
                break;
            }
            case 200: {
                abstractDataset = new ShortDataset();
                break;
            }
            case 300: {
                abstractDataset = new IntegerDataset();
                break;
            }
            case 400: {
                abstractDataset = new LongDataset();
                break;
            }
            case 500: {
                abstractDataset = new FloatDataset();
                break;
            }
            case 600: {
                abstractDataset = new DoubleDataset();
                break;
            }
            default: {
                utilsLogger.error("Dataset type not supported for this operation");
                throw new UnsupportedOperationException("Dataset type not supported");
            }
        }
        int[] nArray = abstractCompoundDataset.getShape();
        int n2 = nArray.length + 1;
        int[] nArray2 = Arrays.copyOf(nArray, n2);
        nArray2[n2 - 1] = n = abstractCompoundDataset.getElementsPerItem();
        abstractDataset.shape = nArray2;
        abstractDataset.size = AbstractDataset.calcSize(nArray2);
        if (abstractCompoundDataset.dataShape != null) {
            abstractDataset.dataShape = Arrays.copyOf(abstractCompoundDataset.dataShape, n2);
            abstractDataset.dataShape[n2 - 1] = n;
            abstractDataset.dataSize = AbstractDataset.calcSize(abstractDataset.dataShape);
        }
        abstractDataset.odata = object;
        abstractDataset.setName(abstractCompoundDataset.getName());
        abstractDataset.setData();
        return abstractDataset;
    }

    public static AbstractDataset coerce(AbstractDataset abstractDataset, Object object) {
        int n = abstractDataset.getDtype();
        int n2 = AbstractDataset.getDTypeFromClass(object.getClass());
        return DatasetUtils.cast(abstractDataset, AbstractDataset.getBestDType(n, n2));
    }

    public static AbstractDataset maximum(AbstractDataset abstractDataset, Object object) {
        AbstractDataset abstractDataset2;
        block35: {
            block34: {
                AbstractDataset abstractDataset3;
                AbstractDataset abstractDataset4;
                int n;
                if (!(object instanceof AbstractDataset)) break block34;
                AbstractDataset abstractDataset5 = (AbstractDataset)object;
                abstractDataset.checkCompatibility(abstractDataset5);
                int n2 = abstractDataset.getDtype();
                int n3 = abstractDataset5.getDtype();
                if (n3 > n2) {
                    n = n3;
                    abstractDataset4 = abstractDataset5;
                    abstractDataset3 = abstractDataset;
                } else {
                    n = n2;
                    abstractDataset4 = abstractDataset;
                    abstractDataset3 = abstractDataset5;
                }
                IndexIterator indexIterator = abstractDataset4.getIterator();
                IndexIterator indexIterator2 = abstractDataset3.getIterator();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset4);
                switch (n) {
                    case 0: {
                        boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                        int n4 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            boolean bl = blArray[n4++] = abstractDataset4.getElementBooleanAbs(indexIterator.index) || abstractDataset3.getElementBooleanAbs(indexIterator2.index);
                        }
                        break block35;
                    }
                    case 1: {
                        byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                        int n5 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l2 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            byArray[n5++] = (byte)(l > l2 ? l : l2);
                        }
                        break block35;
                    }
                    case 2: {
                        short[] sArray = ((ShortDataset)abstractDataset2).getData();
                        int n6 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l3 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            sArray[n6++] = (short)(l > l3 ? l : l3);
                        }
                        break block35;
                    }
                    case 3: {
                        int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                        int n7 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l4 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            nArray[n7++] = (int)(l > l4 ? l : l4);
                        }
                        break block35;
                    }
                    case 4: {
                        long[] lArray = ((LongDataset)abstractDataset2).getData();
                        int n8 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l5 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            long l6 = lArray[n8++] = l > l5 ? l : l5;
                        }
                        break block35;
                    }
                    case 5: {
                        float[] fArray = ((FloatDataset)abstractDataset2).getData();
                        int n9 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            double d = abstractDataset4.getElementDoubleAbs(indexIterator.index);
                            double d2 = abstractDataset3.getElementDoubleAbs(indexIterator2.index);
                            fArray[n9++] = (float)(d > d2 ? d : d2);
                        }
                        break block35;
                    }
                    case 6: {
                        double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                        int n10 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            double d = abstractDataset4.getElementDoubleAbs(indexIterator.index);
                            double d3 = abstractDataset3.getElementDoubleAbs(indexIterator2.index);
                            double d4 = dArray[n10++] = d > d3 ? d : d3;
                        }
                        break block35;
                    }
                    default: {
                        throw new IllegalArgumentException("Multiple-element datasets not supported");
                    }
                }
            }
            int n = AbstractDataset.getBestDType(abstractDataset.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset2 = AbstractDataset.zeros(abstractDataset.shape, n);
            IndexIterator indexIterator = abstractDataset.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object);
                    boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                    int n11 = 0;
                    while (indexIterator.hasNext()) {
                        boolean bl2 = blArray[n11++] = abstractDataset.getElementBooleanAbs(indexIterator.index) || bl;
                    }
                    break;
                }
                case 1: {
                    byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n12 = 0;
                    while (indexIterator.hasNext()) {
                        long l7 = abstractDataset.getElementLongAbs(indexIterator.index);
                        byArray[n12++] = (byte)(l7 > l ? l7 : l);
                    }
                    break;
                }
                case 2: {
                    short[] sArray = ((ShortDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n13 = 0;
                    while (indexIterator.hasNext()) {
                        long l8 = abstractDataset.getElementLongAbs(indexIterator.index);
                        sArray[n13++] = (short)(l8 > l ? l8 : l);
                    }
                    break;
                }
                case 3: {
                    int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n14 = 0;
                    while (indexIterator.hasNext()) {
                        long l9 = abstractDataset.getElementLongAbs(indexIterator.index);
                        nArray[n14++] = (int)(l9 > l ? l9 : l);
                    }
                    break;
                }
                case 4: {
                    long[] lArray = ((LongDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n15 = 0;
                    while (indexIterator.hasNext()) {
                        long l10 = abstractDataset.getElementLongAbs(indexIterator.index);
                        long l11 = lArray[n15++] = l10 > l ? l10 : l;
                    }
                    break;
                }
                case 5: {
                    float[] fArray = ((FloatDataset)abstractDataset2).getData();
                    double d = AbstractDataset.toReal(object);
                    int n16 = 0;
                    while (indexIterator.hasNext()) {
                        double d5 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        fArray[n16++] = (float)(d5 > d ? d5 : d);
                    }
                    break;
                }
                case 6: {
                    double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                    double d = AbstractDataset.toReal(object);
                    int n17 = 0;
                    while (indexIterator.hasNext()) {
                        double d6 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d7 = dArray[n17++] = d6 > d ? d6 : d;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Multiple-element datasets not supported");
                }
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset minimum(AbstractDataset abstractDataset, Object object) {
        AbstractDataset abstractDataset2;
        block35: {
            block34: {
                AbstractDataset abstractDataset3;
                AbstractDataset abstractDataset4;
                int n;
                if (!(object instanceof AbstractDataset)) break block34;
                AbstractDataset abstractDataset5 = (AbstractDataset)object;
                abstractDataset.checkCompatibility(abstractDataset5);
                int n2 = abstractDataset.getDtype();
                int n3 = abstractDataset5.getDtype();
                if (n3 > n2) {
                    n = n3;
                    abstractDataset4 = abstractDataset5;
                    abstractDataset3 = abstractDataset;
                } else {
                    n = n2;
                    abstractDataset4 = abstractDataset;
                    abstractDataset3 = abstractDataset5;
                }
                IndexIterator indexIterator = abstractDataset4.getIterator();
                IndexIterator indexIterator2 = abstractDataset3.getIterator();
                abstractDataset2 = AbstractDataset.zeros(abstractDataset4);
                switch (n) {
                    case 0: {
                        boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                        int n4 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            boolean bl = blArray[n4++] = abstractDataset4.getElementBooleanAbs(indexIterator.index) && abstractDataset3.getElementBooleanAbs(indexIterator2.index);
                        }
                        break block35;
                    }
                    case 1: {
                        byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                        int n5 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l2 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            byArray[n5++] = (byte)(l < l2 ? l : l2);
                        }
                        break block35;
                    }
                    case 2: {
                        short[] sArray = ((ShortDataset)abstractDataset2).getData();
                        int n6 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l3 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            sArray[n6++] = (short)(l < l3 ? l : l3);
                        }
                        break block35;
                    }
                    case 3: {
                        int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                        int n7 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l4 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            nArray[n7++] = (int)(l < l4 ? l : l4);
                        }
                        break block35;
                    }
                    case 4: {
                        long[] lArray = ((LongDataset)abstractDataset2).getData();
                        int n8 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            long l = abstractDataset4.getElementLongAbs(indexIterator.index);
                            long l5 = abstractDataset3.getElementLongAbs(indexIterator2.index);
                            long l6 = lArray[n8++] = l < l5 ? l : l5;
                        }
                        break block35;
                    }
                    case 5: {
                        float[] fArray = ((FloatDataset)abstractDataset2).getData();
                        int n9 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            double d = abstractDataset4.getElementDoubleAbs(indexIterator.index);
                            double d2 = abstractDataset3.getElementDoubleAbs(indexIterator2.index);
                            fArray[n9++] = (float)(d < d2 ? d : d2);
                        }
                        break block35;
                    }
                    case 6: {
                        double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                        int n10 = 0;
                        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                            double d = abstractDataset4.getElementDoubleAbs(indexIterator.index);
                            double d3 = abstractDataset3.getElementDoubleAbs(indexIterator2.index);
                            double d4 = dArray[n10++] = d < d3 ? d : d3;
                        }
                        break block35;
                    }
                    default: {
                        throw new IllegalArgumentException("Multiple-element datasets not supported");
                    }
                }
            }
            int n = AbstractDataset.getBestDType(abstractDataset.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset2 = AbstractDataset.zeros(abstractDataset.shape, n);
            IndexIterator indexIterator = abstractDataset.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object);
                    boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                    int n11 = 0;
                    while (indexIterator.hasNext()) {
                        boolean bl2 = blArray[n11++] = abstractDataset.getElementBooleanAbs(indexIterator.index) && bl;
                    }
                    break;
                }
                case 1: {
                    byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n12 = 0;
                    while (indexIterator.hasNext()) {
                        long l7 = abstractDataset.getElementLongAbs(indexIterator.index);
                        byArray[n12++] = (byte)(l7 < l ? l7 : l);
                    }
                    break;
                }
                case 2: {
                    short[] sArray = ((ShortDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n13 = 0;
                    while (indexIterator.hasNext()) {
                        long l8 = abstractDataset.getElementLongAbs(indexIterator.index);
                        sArray[n13++] = (short)(l8 < l ? l8 : l);
                    }
                    break;
                }
                case 3: {
                    int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n14 = 0;
                    while (indexIterator.hasNext()) {
                        long l9 = abstractDataset.getElementLongAbs(indexIterator.index);
                        nArray[n14++] = (int)(l9 < l ? l9 : l);
                    }
                    break;
                }
                case 4: {
                    long[] lArray = ((LongDataset)abstractDataset2).getData();
                    long l = AbstractDataset.toLong(object);
                    int n15 = 0;
                    while (indexIterator.hasNext()) {
                        long l10 = abstractDataset.getElementLongAbs(indexIterator.index);
                        long l11 = lArray[n15++] = l10 < l ? l10 : l;
                    }
                    break;
                }
                case 5: {
                    float[] fArray = ((FloatDataset)abstractDataset2).getData();
                    double d = AbstractDataset.toReal(object);
                    int n16 = 0;
                    while (indexIterator.hasNext()) {
                        double d5 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        fArray[n16++] = (float)(d5 < d ? d5 : d);
                    }
                    break;
                }
                case 6: {
                    double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                    double d = AbstractDataset.toReal(object);
                    int n17 = 0;
                    while (indexIterator.hasNext()) {
                        double d6 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d7 = dArray[n17++] = d6 < d ? d6 : d;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Multiple-element datasets not supported");
                }
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset norm(AbstractDataset abstractDataset) {
        double d = abstractDataset.min().doubleValue();
        double d2 = abstractDataset.max().doubleValue() - d;
        AbstractDataset abstractDataset2 = Maths.subtract((Object)abstractDataset, d);
        abstractDataset2.idivide(d2);
        return abstractDataset2;
    }

    public static AbstractCompoundDataset norm(AbstractCompoundDataset abstractCompoundDataset, boolean bl) {
        AbstractDataset abstractDataset;
        double[] dArray = abstractCompoundDataset.minItem();
        double[] dArray2 = abstractCompoundDataset.maxItem();
        int n = abstractCompoundDataset.isize;
        if (bl) {
            Arrays.sort(dArray);
            Arrays.sort(dArray2);
            double d = dArray2[0] - dArray[0];
            abstractDataset = Maths.subtract((Object)abstractCompoundDataset, dArray[0]);
            abstractDataset.idivide(d);
        } else {
            double[] dArray3 = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray3[n2] = dArray2[n2] - dArray[n2];
                ++n2;
            }
            abstractDataset = Maths.subtract((Object)abstractCompoundDataset, dArray);
            abstractDataset.idivide(dArray3);
        }
        return (AbstractCompoundDataset)abstractDataset;
    }

    public static AbstractDataset lognorm(AbstractDataset abstractDataset) {
        double d = abstractDataset.min().doubleValue();
        double d2 = Math.log10(abstractDataset.max().doubleValue() - d + 1.0);
        AbstractDataset abstractDataset2 = Maths.subtract((Object)abstractDataset, d - 1.0);
        abstractDataset2 = Maths.log10(abstractDataset2);
        abstractDataset2 = Maths.divide((Object)abstractDataset2, d2);
        return abstractDataset2;
    }

    public static AbstractDataset lnnorm(AbstractDataset abstractDataset) {
        double d = abstractDataset.min().doubleValue();
        double d2 = Math.log(abstractDataset.max().doubleValue() - d + 1.0);
        AbstractDataset abstractDataset2 = Maths.subtract((Object)abstractDataset, d - 1.0);
        abstractDataset2 = Maths.log(abstractDataset2);
        abstractDataset2 = Maths.divide((Object)abstractDataset2, d2);
        return abstractDataset2;
    }

    public static List<AbstractDataset> meshGrid(AbstractDataset ... abstractDatasetArray) {
        AbstractDataset abstractDataset;
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        int n = abstractDatasetArray.length;
        if (n < 2) {
            utilsLogger.error("Two or more axes datasets are required");
            throw new IllegalArgumentException("Two or more axes datasets are required");
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            abstractDataset = abstractDatasetArray[n2];
            if (abstractDataset.getRank() != 1) {
                utilsLogger.error("Given axis is not 1D");
                throw new IllegalArgumentException("Given axis is not 1D");
            }
            nArray[n2] = abstractDatasetArray[n2].size;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            abstractDataset = abstractDatasetArray[n2];
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(nArray, abstractDataset.getDtype());
            arrayList.add(abstractDataset2);
            int n3 = abstractDataset.size;
            int n4 = 0;
            while (n4 < n3) {
                Object object = abstractDataset.getObjectAbs(n4);
                PositionIterator positionIterator = abstractDataset2.getPositionIterator(n2);
                int[] nArray2 = positionIterator.getPos();
                nArray2[n2] = n4;
                while (positionIterator.hasNext()) {
                    abstractDataset2.set(object, nArray2);
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList;
    }

    public static IntegerDataset indices(int ... nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n + 1];
        nArray2[0] = n;
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2 + 1] = nArray[n2];
            ++n2;
        }
        IntegerDataset integerDataset = new IntegerDataset(nArray2);
        if (n == 1) {
            int n3 = nArray[0];
            int[] nArray3 = new int[2];
            int n4 = 0;
            while (n4 < n3) {
                nArray3[1] = n4;
                integerDataset.set(n4, nArray3);
                ++n4;
            }
        } else {
            int n5 = 1;
            while (n5 <= n) {
                int n6 = nArray2[n5];
                int n7 = 0;
                while (n7 < n6) {
                    PositionIterator positionIterator = integerDataset.getPositionIterator(0, n5);
                    int[] nArray4 = positionIterator.getPos();
                    nArray4[0] = n5 - 1;
                    nArray4[n5] = n7;
                    while (positionIterator.hasNext()) {
                        integerDataset.set(n7, nArray4);
                    }
                    ++n7;
                }
                ++n5;
            }
        }
        return integerDataset;
    }

    public static double[] centroid(AbstractDataset abstractDataset, AbstractDataset ... abstractDatasetArray) {
        DoubleDataset doubleDataset = (DoubleDataset)new Centroid(abstractDatasetArray).value(abstractDataset).get(0);
        return doubleDataset.getData();
    }

    public static List<Double> crossings(AbstractDataset abstractDataset, double d) {
        if (abstractDataset.getRank() != 1) {
            utilsLogger.error("Only 1d datasets supported");
            throw new UnsupportedOperationException("Only 1d datasets supported");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d2 = abstractDataset.getElementDoubleAbs(0);
        int n = 1;
        int n2 = abstractDataset.getSize();
        while (n < n2) {
            double d3 = d2;
            d2 = abstractDataset.getElementDoubleAbs(n);
            if (d3 <= d && d2 > d || d3 > d && d2 <= d) {
                double d4 = (d - d2) / (d2 - d3);
                arrayList.add((double)n + d4);
            }
            ++n;
        }
        return arrayList;
    }

    public static List<Double> crossings(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, double d) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<Double> list = DatasetUtils.crossings(abstractDataset2, d);
        for (double d2 : list) {
            arrayList.add(Maths.getLinear(abstractDataset, d2));
        }
        return arrayList;
    }

    public static List<Double> crossings(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, double d, double d2) {
        List<Double> list = DatasetUtils.crossings(abstractDataset, abstractDataset2, d);
        double d3 = d2 * abstractDataset.peakToPeak().doubleValue();
        int n = 0;
        while (n < list.size() - 3) {
            double d4 = Math.abs(list.get(n) - list.get(n + 2));
            if (d4 < d3) {
                list.set(n + 2, (list.get(n) + list.get(n + 1) + list.get(n + 2)) / 3.0);
                list.remove(n);
                list.remove(n);
                continue;
            }
            ++n;
        }
        return list;
    }

    private static void setRow(Object object, AbstractDataset abstractDataset, int ... nArray) {
        int n = Array.getLength(object);
        int n2 = nArray.length;
        int[] nArray2 = Arrays.copyOf(nArray, n2 + 1);
        if (n2 + 1 < abstractDataset.getRank()) {
            int n3 = 0;
            while (n3 < n) {
                nArray2[n2] = n3;
                Object object2 = Array.get(object, n3);
                DatasetUtils.setRow(object2, abstractDataset, nArray2);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                nArray2[n2] = n4;
                Object object3 = abstractDataset.getObject(nArray2);
                Array.set(object, n4, object3);
                ++n4;
            }
        }
    }

    public static Object createJavaArray(AbstractDataset abstractDataset) {
        Object object;
        if (abstractDataset.getElementsPerItem() > 1) {
            abstractDataset = DatasetUtils.createDatasetFromCompoundDataset((AbstractCompoundDataset)abstractDataset, true);
        }
        switch (abstractDataset.getDtype()) {
            case 0: {
                object = Array.newInstance(Boolean.TYPE, abstractDataset.getShape());
                break;
            }
            case 1: {
                object = Array.newInstance(Byte.TYPE, abstractDataset.getShape());
                break;
            }
            case 2: {
                object = Array.newInstance(Short.TYPE, abstractDataset.getShape());
                break;
            }
            case 3: {
                object = Array.newInstance(Integer.TYPE, abstractDataset.getShape());
                break;
            }
            case 4: {
                object = Array.newInstance(Long.TYPE, abstractDataset.getShape());
                break;
            }
            case 5: {
                object = Array.newInstance(Float.TYPE, abstractDataset.getShape());
                break;
            }
            case 6: {
                object = Array.newInstance(Double.TYPE, abstractDataset.getShape());
                break;
            }
            default: {
                utilsLogger.error("Dataset type not supported");
                throw new IllegalArgumentException("Dataset type not supported");
            }
        }
        DatasetUtils.setRow(object, abstractDataset, new int[0]);
        return object;
    }
}

