/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class CompoundFloatDataset
extends AbstractCompoundDataset {
    private static final transient Logger compoundLogger = LoggerFactory.getLogger(CompoundFloatDataset.class);
    protected float[] data;

    @Override
    protected void setData() {
        this.data = (float[])this.odata;
    }

    protected float[] createArray(int n) {
        float[] fArray = null;
        try {
            fArray = new float[this.isize * n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            compoundLogger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return fArray;
    }

    @Override
    public int getDtype() {
        return 500;
    }

    public CompoundFloatDataset() {
    }

    public CompoundFloatDataset(int n) {
        this.isize = n;
    }

    public CompoundFloatDataset(int n, int[] nArray) {
        this.isize = n;
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = this.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                compoundLogger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = CompoundFloatDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
    }

    public CompoundFloatDataset(CompoundFloatDataset compoundFloatDataset) {
        this(compoundFloatDataset, false);
    }

    public CompoundFloatDataset(CompoundFloatDataset compoundFloatDataset, boolean bl) {
        this.isize = compoundFloatDataset.isize;
        this.size = compoundFloatDataset.size;
        if (bl) {
            this.shape = compoundFloatDataset.shape;
            this.name = compoundFloatDataset.name;
            this.data = compoundFloatDataset.data;
            this.odata = compoundFloatDataset.data;
            this.dataSize = compoundFloatDataset.dataSize;
            this.dataShape = compoundFloatDataset.dataShape;
            return;
        }
        this.shape = (int[])compoundFloatDataset.shape.clone();
        this.name = new String(compoundFloatDataset.name);
        float[] fArray = compoundFloatDataset.data;
        if (compoundFloatDataset.isContiguous()) {
            this.data = (float[])fArray.clone();
            this.odata = this.data;
        } else {
            this.data = this.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = compoundFloatDataset.getIterator();
            IndexIterator indexIterator2 = this.getIterator();
            while (indexIterator2.hasNext() && indexIterator.hasNext()) {
                this.data[indexIterator2.index] = fArray[indexIterator.index];
                this.data[indexIterator2.index + 1] = fArray[indexIterator.index + 1];
            }
        }
    }

    public CompoundFloatDataset(int n, float[] fArray, int ... nArray) {
        this.isize = n;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{fArray.length / this.isize};
        }
        this.size = CompoundFloatDataset.calcSize(nArray);
        if (this.size * this.isize != fArray.length) {
            compoundLogger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = fArray;
        this.odata = fArray;
    }

    public CompoundFloatDataset(AbstractDataset ... abstractDatasetArray) {
        if (abstractDatasetArray.length <= 1) {
            compoundLogger.error("Array must have length greater than one");
            throw new IllegalArgumentException("Array must have length greater than one");
        }
        int n = 1;
        while (n < abstractDatasetArray.length) {
            abstractDatasetArray[0].checkCompatibility(abstractDatasetArray[n]);
            ++n;
        }
        this.isize = abstractDatasetArray.length;
        this.size = CompoundFloatDataset.calcSize(abstractDatasetArray[0].shape);
        this.shape = (int[])abstractDatasetArray[0].shape.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator[] indexIteratorArray = new IndexIterator[this.isize];
        int n2 = 0;
        while (n2 < abstractDatasetArray.length) {
            indexIteratorArray[n2] = abstractDatasetArray[n2].getIterator();
            ++n2;
        }
        n2 = 0;
        while (indexIteratorArray[0].hasNext()) {
            this.data[n2++] = (float)abstractDatasetArray[0].getElementDoubleAbs(indexIteratorArray[0].index);
            int n3 = 1;
            while (n3 < abstractDatasetArray.length) {
                indexIteratorArray[n3].hasNext();
                this.data[n2++] = (float)abstractDatasetArray[n3].getElementDoubleAbs(indexIteratorArray[n3].index);
                ++n3;
            }
        }
    }

    public CompoundFloatDataset(int n, AbstractDataset abstractDataset) {
        this.isize = n;
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            this.data[n2] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            n2 += this.isize;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CompoundFloatDataset compoundFloatDataset = (CompoundFloatDataset)object;
        return Arrays.equals(this.data, compoundFloatDataset.data);
    }

    public static CompoundFloatDataset createFromObject(Object object) {
        FloatDataset floatDataset = FloatDataset.createFromObject(object);
        return (CompoundFloatDataset)DatasetUtils.createCompoundDatasetFromLastAxis(floatDataset, true);
    }

    public static CompoundFloatDataset arange(int n, double d) {
        return CompoundFloatDataset.arange(n, 0.0, d, 1.0);
    }

    public static CompoundFloatDataset arange(int n, double d, double d2, double d3) {
        int n2 = CompoundFloatDataset.calcSteps(d, d2, d3);
        CompoundFloatDataset compoundFloatDataset = new CompoundFloatDataset(n, new int[]{n2});
        int n3 = 0;
        while (n3 < n2) {
            compoundFloatDataset.data[n3 * compoundFloatDataset.isize] = (float)(d + (double)n3 * d3);
            ++n3;
        }
        return compoundFloatDataset;
    }

    public static CompoundFloatDataset ones(int n, int[] nArray) {
        return new CompoundFloatDataset(n, nArray).fill(1);
    }

    @Override
    public CompoundFloatDataset fill(Object object) {
        IndexIterator indexIterator = this.getIterator();
        float[] fArray = CompoundFloatDataset.toFloatArray(object, this.isize);
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                this.data[indexIterator.index + n] = fArray[n];
                ++n;
            }
        }
        return this;
    }

    public float[] getData() {
        return this.data;
    }

    @Override
    public CompoundFloatDataset getView() {
        CompoundFloatDataset compoundFloatDataset = new CompoundFloatDataset(this.isize);
        compoundFloatDataset.name = new String(this.name);
        compoundFloatDataset.size = CompoundFloatDataset.calcSize(this.shape);
        compoundFloatDataset.shape = (int[])this.shape.clone();
        compoundFloatDataset.data = this.data;
        compoundFloatDataset.odata = this.data;
        return compoundFloatDataset;
    }

    public float[] getAbs(int n) {
        float[] fArray = new float[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            fArray[n2] = this.data[n + n2];
            ++n2;
        }
        return fArray;
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        int n2 = 0;
        while (n2 < this.isize) {
            if (this.data[n + n2] == 0.0f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return (long)this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        float[] fArray = (float[])object;
        int n3 = 0;
        while (n3 < this.isize) {
            this.data[n + n3] = fArray[n2 + n3];
            ++n3;
        }
    }

    public void setAbs(float[] fArray, int n) {
        int n2 = 0;
        while (n2 < this.isize) {
            this.data[n + n2] = fArray[n2];
            ++n2;
        }
        this.setDirty();
    }

    public void setAbs(float f, int n) {
        this.data[n] = f;
        this.setDirty();
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.getFloatArray(nArray);
    }

    public float[] getFloatArray(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return (float[])this.getObjectAbs(n);
    }

    @Override
    public void getDoubleArray(double[] dArray, int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        int n2 = 0;
        while (n2 < this.isize) {
            dArray[n2] = this.data[n + n2];
            ++n2;
        }
    }

    @Override
    public String getString(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(String.format("%.8g", Float.valueOf(this.data[n])));
        int n2 = 1;
        while (n2 < this.isize) {
            stringBuilder.append(' ');
            stringBuilder.append(String.format("%.8g", Float.valueOf(this.data[n + n2])));
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    protected double getFirstValue(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        float[] fArray = new float[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            fArray[n2] = this.data[n + n2];
            ++n2;
        }
        return fArray;
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        float[] fArray = CompoundFloatDataset.toFloatArray(object, this.isize);
        this.setAbs(fArray, n);
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(CompoundFloatDataset.toFloatArray(object, this.isize), nArray);
    }

    public void setItem(float[] fArray, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    compoundLogger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            if (fArray.length > this.isize) {
                compoundLogger.error("Array is larger than compound");
                throw new IllegalArgumentException("Array is larger than compound");
            }
            this.setAbs(fArray, this.isize * this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            compoundLogger.error("Cannot get value from dataset" + this + ". The number of indices is incorrect.");
            throw illegalArgumentException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            compoundLogger.error("Index out of bounds");
            throw arrayIndexOutOfBoundsException;
        }
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            compoundLogger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = CompoundFloatDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = CompoundFloatDataset.calcSize(this.dataShape);
        float[] fArray = this.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = CompoundFloatDataset.calcSize(nArray);
        Arrays.fill(fArray, Float.NaN);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                fArray[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
        this.data = fArray;
        this.odata = fArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = CompoundFloatDataset.calcSize(nArray);
        float[] fArray = this.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            int n3 = 0;
            while (n3 < this.isize) {
                fArray[n2++] = this.data[indexIterator.index + n3];
                ++n3;
            }
        }
        this.data = fArray;
        this.odata = fArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public FloatDataset real() {
        FloatDataset floatDataset = new FloatDataset(this.shape);
        IndexIterator indexIterator = this.getIterator();
        IndexIterator indexIterator2 = floatDataset.getIterator();
        float[] fArray = floatDataset.data;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        return floatDataset;
    }

    @Override
    public Object sum() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getSum();
            ++n;
        }
        return dArray;
    }

    @Override
    public Object mean() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getMean();
            ++n;
        }
        return dArray;
    }

    @Override
    public CompoundFloatDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        CompoundFloatDataset compoundFloatDataset = new CompoundFloatDataset(this.isize, sliceIterator.getSliceShape());
        float[] fArray = compoundFloatDataset.data;
        IndexIterator indexIterator = compoundFloatDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                fArray[indexIterator.index + n] = this.data[sliceIterator.index + n];
                ++n;
            }
        }
        return compoundFloatDataset;
    }

    @Override
    public AbstractDataset getElements(int n) {
        FloatDataset floatDataset = new FloatDataset(this.shape);
        this.copyElements(floatDataset, n);
        return floatDataset;
    }

    @Override
    public void copyElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            compoundLogger.error("Invalid choice of element: {}/{}", (Object)n, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + n + "/" + this.isize);
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            compoundLogger.error("Element class of destination does not match this dataset");
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        float[] fArray = ((FloatDataset)abstractDataset).data;
        int n2 = 0;
        while (indexIterator.hasNext()) {
            fArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
    }

    @Override
    public void setElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            compoundLogger.error("Invalid choice of element: {}/{}", (Object)n, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + n + "/" + this.isize);
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            compoundLogger.error("Element class of destination does not match this dataset");
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        float[] fArray = ((FloatDataset)abstractDataset).data;
        if (abstractDataset.isContiguous()) {
            int n2 = 0;
            while (indexIterator.hasNext()) {
                this.data[indexIterator.index] = fArray[n2];
                ++n2;
            }
        } else {
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                this.data[indexIterator.index] = fArray[indexIterator2.index];
            }
        }
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                fArray[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset setByBoolean(BooleanDataset var1_1, Object var2_2) {
        block10: {
            block9: {
                if (!(var2_2 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var2_2;
                var4_5 = ((Number)var1_1.sum()).intValue();
                if (var4_5 != var3_3.getSize()) {
                    CompoundFloatDataset.compoundLogger.error("Number of true items in selection does not match number of items in dataset");
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var5_7 = var3_3.getIterator();
                var6_9 = this.getBooleanIterator(var1_1);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl26
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl18
                CompoundFloatDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var7_10 = 0;
                    while (var7_10 < this.isize) {
                        this.data[var6_9.index + var7_10] = (float)var3_3.getElementDoubleAbs(var5_7.index + var7_10);
                        ++var7_10;
                    }
lbl18:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl19:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var6_9.index] = (float)var3_3.getElementDoubleAbs(var5_7.index);
                    var7_11 = 1;
                    while (var7_11 < this.isize) {
                        this.data[var6_9.index + var7_11] = 0.0f;
                        ++var7_11;
                    }
lbl26:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl27:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundFloatDataset.toFloatArray(var2_2, this.isize);
                var4_6 = this.getBooleanIterator(var1_1);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundFloatDataset.compoundLogger.error("Object for setting is not a dataset or number");
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset setByIndex(IntegerDataset var1_1, Object var2_2) {
        block10: {
            block9: {
                if (!(var2_2 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var2_2;
                if (var1_1.getSize() != var3_3.getSize()) {
                    CompoundFloatDataset.compoundLogger.error("Number of true items in selection does not match number of items in dataset");
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var4_5 = var3_3.getIterator();
                var5_7 = new IntegerIterator(var1_1, this.size, this.isize);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl17
                CompoundFloatDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var6_9 = 0;
                    while (var6_9 < this.isize) {
                        this.data[var5_7.index + var6_9] = (float)var3_3.getElementDoubleAbs(var4_5.index + var6_9);
                        ++var6_9;
                    }
lbl17:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl18:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var5_7.index] = (float)var3_3.getElementDoubleAbs(var4_5.index);
                    var6_10 = 1;
                    while (var6_10 < this.isize) {
                        this.data[var5_7.index + var6_10] = 0.0f;
                        ++var6_10;
                    }
lbl25:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl26:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundFloatDataset.toFloatArray(var2_2, this.isize);
                var4_6 = new IntegerIterator(var1_1, this.size, this.isize);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundFloatDataset.compoundLogger.error("Object for setting is not a dataset or number");
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset setSlice(int[] var1_1, int[] var2_2, int[] var3_3, Object var4_4) {
        block11: {
            block10: {
                if (!(var4_4 instanceof AbstractDataset)) break block10;
                var5_5 = (SliceIterator)this.getSliceIterator(var1_1, var2_2, var3_3);
                var6_7 = (AbstractDataset)var4_4;
                var7_9 = CompoundFloatDataset.squeezeShape(var5_5.getSliceShape(), false);
                if (var7_9 == null) {
                    var7_9 = var5_5.getSliceShape();
                }
                var8_11 = var6_7.getIterator();
                if (!Arrays.equals(var7_9, var6_7.shape)) {
                    CompoundFloatDataset.compoundLogger.error("Input dataset is not compatible with slice");
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                if (!(var6_7 instanceof AbstractCompoundDataset)) ** GOTO lbl28
                if (this.isize == var6_7.getElementsPerItem()) ** GOTO lbl20
                CompoundFloatDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var9_12 = 0;
                    while (var9_12 < this.isize) {
                        this.data[var5_5.index + var9_12] = (float)var6_7.getElementDoubleAbs(var8_11.index + var9_12);
                        ++var9_12;
                    }
lbl20:
                    // 2 sources

                    ** while (var5_5.hasNext() && var8_11.hasNext())
                }
lbl21:
                // 1 sources

                break block11;
lbl-1000:
                // 1 sources

                {
                    this.data[var5_5.index] = (float)var6_7.getElementDoubleAbs(var8_11.index);
                    var9_13 = 1;
                    while (var9_13 < this.isize) {
                        this.data[var5_5.index + var9_13] = 0.0f;
                        ++var9_13;
                    }
lbl28:
                    // 2 sources

                    ** while (var5_5.hasNext() && var8_11.hasNext())
                }
lbl29:
                // 1 sources

                break block11;
            }
            try {
                var6_8 = CompoundFloatDataset.toFloatArray(var4_4, this.isize);
                var5_6 = (SliceIterator)this.getSliceIterator(var1_1, var2_2, var3_3);
                while (var5_6.hasNext()) {
                    var7_10 = 0;
                    while (var7_10 < this.isize) {
                        this.data[var5_6.index + var7_10] = var6_8[var7_10];
                        ++var7_10;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundFloatDataset.compoundLogger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (float[])var3_3.odata;
        if (var3_3.getElementsPerItem() != this.isize) {
            CompoundFloatDataset.compoundLogger.error("Destination dataset is incompatible as it has {} elements per item not {}", (Object)var3_3.getElementsPerItem(), (Object)this.isize);
            throw new IllegalArgumentException("Destination dataset is incompatible as it has different number of elements per item");
        }
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = CompoundFloatDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= CompoundFloatDataset.calcSize(var6_6)) ** GOTO lbl18
        CompoundFloatDataset.compoundLogger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var8_8 = 0;
            while (var8_8 < this.isize) {
                var4_4[var7_7.index + var8_8] = this.data[var5_5.index + var8_8];
                ++var8_8;
            }
lbl18:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl19:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        float[] fArray = (float[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (fArray.length < CompoundFloatDataset.calcSize(sliceIterator.getSliceShape())) {
            compoundLogger.error("source array is not large enough");
            throw new IllegalArgumentException("source array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            int n2 = 0;
            while (n2 < this.isize) {
                this.data[sliceIterator.index + n2] = fArray[this.isize * n + n2];
                ++n2;
            }
            ++n;
        }
        this.setDirty();
    }

    @Override
    public boolean containsNans() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                if (Float.isNaN(this.data[indexIterator.index + n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                if (Float.isInfinite(this.data[indexIterator.index + n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset iadd(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    v0 = var3_4.index;
                    this.data[v0] = (float)((double)this.data[v0] + var2_2.getElementDoubleAbs(var4_6.index));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        v1 = var3_4.index + var5_8;
                        this.data[v1] = (float)((double)this.data[v1] + var2_2.getElementDoubleAbs(var4_6.index + var5_8));
                        ++var5_8;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundFloatDataset.toFloatArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = this.data[v2] + var2_3[var4_7];
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset isubtract(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    v0 = var3_4.index;
                    this.data[v0] = (float)((double)this.data[v0] - var2_2.getElementDoubleAbs(var4_6.index));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        v1 = var3_4.index + var5_8;
                        this.data[v1] = (float)((double)this.data[v1] - var2_2.getElementDoubleAbs(var4_6.index + var5_8));
                        ++var5_8;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundFloatDataset.toFloatArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = this.data[v2] - var2_3[var4_7];
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset imultiply(Object var1_1) {
        block7: {
            block6: {
                if (!(var1_1 instanceof AbstractDataset)) break block6;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl23
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (float)var2_2.getElementDoubleAbs(var4_6.index);
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = this.data[v0] * var5_8;
                        ++var6_10;
                    }
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        v1 = var3_4.index + var5_9;
                        this.data[v1] = (float)((double)this.data[v1] * var2_2.getElementDoubleAbs(var4_6.index + var5_9));
                        ++var5_9;
                    }
lbl23:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl24:
                // 1 sources

                break block7;
            }
            var2_3 = CompoundFloatDataset.toFloatArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = this.data[v2] * var2_3[var4_7];
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset idivide(Object var1_1) {
        block7: {
            block6: {
                if (!(var1_1 instanceof AbstractDataset)) break block6;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl23
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (float)var2_2.getElementDoubleAbs(var4_6.index);
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = this.data[v0] / var5_8;
                        ++var6_10;
                    }
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        v1 = var3_4.index + var5_9;
                        this.data[v1] = (float)((double)this.data[v1] / var2_2.getElementDoubleAbs(var4_6.index + var5_9));
                        ++var5_9;
                    }
lbl23:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl24:
                // 1 sources

                break block7;
            }
            var2_3 = CompoundFloatDataset.toDoubleArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = (float)((double)this.data[v2] / var2_3[var4_7]);
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public CompoundFloatDataset ifloor() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                this.data[indexIterator.index + n] = (float)Math.floor(this.data[indexIterator.index] + (float)n);
                ++n;
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset iremainder(Object var1_1) {
        block7: {
            block6: {
                if (!(var1_1 instanceof AbstractDataset)) break block6;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl23
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (float)var2_2.getElementDoubleAbs(var4_6.index);
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = this.data[v0] % var5_8;
                        ++var6_10;
                    }
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        v1 = var3_4.index + var5_9;
                        this.data[v1] = (float)((double)this.data[v1] % var2_2.getElementDoubleAbs(var4_6.index + var5_9));
                        ++var5_9;
                    }
lbl23:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl24:
                // 1 sources

                break block7;
            }
            var2_3 = CompoundFloatDataset.toDoubleArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = (float)((double)this.data[v2] % var2_3[var4_7]);
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundFloatDataset ipower(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = Math.pow(this.data[var3_4.index], var2_2.getElementDoubleAbs(var4_6.index));
                    this.data[var3_4.index] = (float)var5_8;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        var6_11 = Math.pow(this.data[var3_4.index + var5_9], var2_2.getElementDoubleAbs(var4_6.index + var5_9));
                        this.data[var3_4.index + var5_9] = (float)var6_11;
                        ++var5_9;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundFloatDataset.toFloatArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    var5_10 = Math.pow(this.data[var3_5.index + var4_7], var2_3[var4_7]);
                    this.data[var3_5.index + var4_7] = (float)var5_10;
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            if (abstractDataset.getElementsPerItem() != this.isize) {
                double d2 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                    double d4 = d3 * d3 - d2;
                    double d5 = d + d4;
                    d2 = d5 - d - d4;
                    d = d5;
                }
            } else {
                double d6 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n = 0;
                    while (n < this.isize) {
                        double d7 = (double)this.data[indexIterator.index + n] - abstractDataset.getElementDoubleAbs(indexIterator2.index + n);
                        double d8 = d7 * d7 - d6;
                        double d9 = d + d8;
                        d6 = d9 - d - d8;
                        d = d9;
                        ++n;
                    }
                }
            }
        } else {
            double[] dArray = CompoundFloatDataset.toDoubleArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            double d10 = 0.0;
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    double d11 = (double)this.data[indexIterator.index + n] - dArray[n];
                    double d12 = d11 * d11 - d10;
                    double d13 = d + d12;
                    d10 = d13 - d - d12;
                    d = d13;
                    ++n;
                }
            }
        }
        return d;
    }
}

