/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.python.core.PyComplex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class ComplexFloatDataset
extends CompoundFloatDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(ComplexFloatDataset.class);
    private static final int ISIZE = 2;

    @Override
    public int getDtype() {
        return 7;
    }

    public ComplexFloatDataset() {
        super(2);
    }

    public ComplexFloatDataset(int ... nArray) {
        super(2, nArray);
    }

    public ComplexFloatDataset(float[] fArray, int ... nArray) {
        super(2, fArray, nArray);
    }

    public ComplexFloatDataset(ComplexFloatDataset complexFloatDataset) {
        super(complexFloatDataset);
    }

    public ComplexFloatDataset(ComplexFloatDataset complexFloatDataset, boolean bl) {
        super(complexFloatDataset, bl);
    }

    public ComplexFloatDataset(float[] fArray, float[] fArray2, int ... nArray) {
        int n;
        int n2 = n = fArray.length > fArray2.length ? fArray2.length : fArray.length;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{n};
        }
        this.isize = 2;
        this.size = ComplexFloatDataset.calcSize(nArray);
        if (this.size * this.isize != n) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            this.data[n4++] = fArray[n3];
            this.data[n4++] = fArray2[n3];
            ++n3;
        }
    }

    public ComplexFloatDataset(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        super(2, abstractDataset.shape);
        abstractDataset.checkCompatibility(abstractDataset2);
        IndexIterator indexIterator = abstractDataset.getIterator();
        IndexIterator indexIterator2 = abstractDataset2.getIterator();
        int n = 0;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            this.data[n++] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            this.data[n++] = (float)abstractDataset2.getElementDoubleAbs(indexIterator2.index);
        }
    }

    public ComplexFloatDataset(AbstractDataset abstractDataset) {
        super(2, abstractDataset.shape);
        this.name = new String(abstractDataset.name);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            n += this.isize;
        }
    }

    public static ComplexFloatDataset createFromObject(Object object) {
        ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset();
        complexFloatDataset.shape = ComplexFloatDataset.getShapeFromObject(object);
        complexFloatDataset.size = ComplexFloatDataset.calcSize(complexFloatDataset.shape);
        complexFloatDataset.data = complexFloatDataset.createArray(complexFloatDataset.size);
        complexFloatDataset.odata = complexFloatDataset.data;
        int[] nArray = new int[complexFloatDataset.shape.length];
        complexFloatDataset.fillData(object, 0, nArray);
        return complexFloatDataset;
    }

    public static ComplexFloatDataset arange(double d) {
        return ComplexFloatDataset.arange(0.0, d, 1.0);
    }

    public static ComplexFloatDataset arange(double d, double d2, double d3) {
        int n = ComplexFloatDataset.calcSteps(d, d2, d3);
        ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset(new int[]{n});
        int n2 = 0;
        while (n2 < n) {
            complexFloatDataset.data[n2 * 2] = (float)(d + (double)n2 * d3);
            ++n2;
        }
        return complexFloatDataset;
    }

    public static ComplexFloatDataset ones(int[] nArray) {
        return new ComplexFloatDataset(nArray).fill(1);
    }

    @Override
    public ComplexFloatDataset fill(Object object) {
        IndexIterator indexIterator = this.getIterator();
        float f = (float)ComplexFloatDataset.toReal(object);
        float f2 = (float)ComplexFloatDataset.toImag(object);
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = f;
            this.data[indexIterator.index + 1] = f2;
        }
        return this;
    }

    public Complex getComplexAbs(int n) {
        return new Complex((double)this.data[n], (double)this.data[n + 1]);
    }

    @Override
    public Object getObjectAbs(int n) {
        return new Complex((double)this.data[n], (double)this.data[n + 1]);
    }

    public void setAbs(PyComplex pyComplex, int n) {
        this.setAbs((float)pyComplex.real, (float)pyComplex.imag, n);
        this.setDirty();
    }

    public void setAbs(Complex complex, int n) {
        this.setAbs((float)complex.getReal(), (float)complex.getImaginary(), n);
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        this.setAbs((float)ComplexFloatDataset.toReal(object), (float)ComplexFloatDataset.toImag(object), n);
    }

    public void setAbs(float f, float f2, int n) {
        this.data[n] = f;
        this.data[n + 1] = f2;
        this.setDirty();
    }

    public Complex get(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        Complex complex = new Complex((double)this.data[n], (double)this.data[n + 1]);
        return complex;
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.getPyComplex(nArray);
    }

    public float getReal(int ... nArray) {
        return (float)this.getFirstValue(nArray);
    }

    public float getImag(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n + 1];
    }

    public Complex getComplex(int ... nArray) {
        return this.get(nArray);
    }

    public PyComplex getPyComplex(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        PyComplex pyComplex = new PyComplex((double)this.data[n], (double)this.data[n + 1]);
        return pyComplex;
    }

    @Override
    public String getString(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n + 1] >= 0.0f ? String.format("%.8g + %.8gj", Float.valueOf(this.data[n]), Float.valueOf(this.data[n + 1])) : String.format("%.8g - %.8gj", Float.valueOf(this.data[n]), Float.valueOf(-this.data[n + 1]));
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(new float[]{(float)ComplexFloatDataset.toReal(object), (float)ComplexFloatDataset.toImag(object)}, nArray);
    }

    public void set(float f, float f2, int ... nArray) {
        this.setItem(new float[]{f, f2}, nArray);
    }

    public FloatDataset imag() {
        FloatDataset floatDataset = new FloatDataset(this.shape);
        IndexIterator indexIterator = this.getIterator();
        IndexIterator indexIterator2 = floatDataset.getIterator();
        float[] fArray = floatDataset.data;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index + 1];
        }
        return floatDataset;
    }

    @Override
    public Number max() {
        logger.error("Cannot compare complex numbers");
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Number min() {
        logger.error("Cannot compare complex numbers");
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Object sum() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats-0");
        SummaryStatistics summaryStatistics2 = (SummaryStatistics)this.storedValues.get("stats-1");
        return new Complex(summaryStatistics.getSum(), summaryStatistics2.getSum());
    }

    @Override
    public Object mean() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats-0");
        SummaryStatistics summaryStatistics2 = (SummaryStatistics)this.storedValues.get("stats-1");
        return new Complex(summaryStatistics.getMean(), summaryStatistics2.getMean());
    }

    @Override
    public int[] maxPos() {
        logger.error("Cannot compare complex numbers");
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public int[] minPos() {
        logger.error("Cannot compare complex numbers");
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public ComplexFloatDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset(sliceIterator.getSliceShape());
        float[] fArray = complexFloatDataset.data;
        IndexIterator indexIterator = complexFloatDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            fArray[indexIterator.index] = this.data[sliceIterator.index];
            fArray[indexIterator.index + 1] = this.data[sliceIterator.index + 1];
        }
        return complexFloatDataset;
    }

    @Override
    public ComplexFloatDataset setSlice(int[] nArray, int[] nArray2, int[] nArray3, Object object) {
        if (object instanceof ComplexFloatDataset) {
            ComplexFloatDataset complexFloatDataset = (ComplexFloatDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray4 = ComplexFloatDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray4 == null) {
                nArray4 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray4, complexFloatDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = complexFloatDataset.getIterator();
            float[] fArray = complexFloatDataset.data;
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = fArray[indexIterator.index];
                this.data[sliceIterator.index + 1] = fArray[indexIterator.index + 1];
            }
        } else if (object instanceof ComplexDoubleDataset) {
            ComplexDoubleDataset complexDoubleDataset = (ComplexDoubleDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            int[] nArray5 = ComplexFloatDataset.squeezeShape(sliceIterator.getSliceShape(), false);
            if (nArray5 == null) {
                nArray5 = sliceIterator.getSliceShape();
            }
            if (!Arrays.equals(nArray5, complexDoubleDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = complexDoubleDataset.getIterator();
            double[] dArray = complexDoubleDataset.data;
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = (float)dArray[indexIterator.index];
                this.data[sliceIterator.index + 1] = (float)dArray[indexIterator.index + 1];
            }
        } else if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
            if (!Arrays.equals(sliceIterator.getSliceShape(), abstractDataset.shape)) {
                logger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
                this.data[sliceIterator.index + 1] = 0.0f;
            }
        } else {
            try {
                float f = (float)ComplexFloatDataset.toReal(object);
                float f2 = (float)ComplexFloatDataset.toImag(object);
                SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = f;
                    this.data[sliceIterator.index + 1] = f2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexFloatDataset iadd(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                v0 = var3_4.index;
                                this.data[v0] = (float)((double)this.data[v0] + var2_2.getElementDoubleAbs(var4_6.index));
                                v1 = var3_4.index + 1;
                                this.data[v1] = (float)((double)this.data[v1] + var2_2.getElementDoubleAbs(var4_6.index + 1));
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                v2 = var3_4.index;
                                this.data[v2] = (float)((double)this.data[v2] + var2_2.getElementDoubleAbs(var4_6.index));
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = (float)ComplexFloatDataset.toReal(var1_1);
            var3_5 = (float)ComplexFloatDataset.toImag(var1_1);
            var4_7 = this.getIterator();
            if (var3_5 != 0.0f) ** GOTO lbl39
            while (var4_7.hasNext()) {
                v3 = var4_7.index;
                this.data[v3] = this.data[v3] + var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                v4 = var4_7.index;
                this.data[v4] = this.data[v4] + var2_3;
                v5 = var4_7.index + 1;
                this.data[v5] = this.data[v5] + var3_5;
lbl39:
                // 2 sources

                ** while (var4_7.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexFloatDataset isubtract(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                v0 = var3_4.index;
                                this.data[v0] = (float)((double)this.data[v0] - var2_2.getElementDoubleAbs(var4_6.index));
                                v1 = var3_4.index + 1;
                                this.data[v1] = (float)((double)this.data[v1] - var2_2.getElementDoubleAbs(var4_6.index + 1));
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                v2 = var3_4.index;
                                this.data[v2] = (float)((double)this.data[v2] - var2_2.getElementDoubleAbs(var4_6.index));
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = (float)ComplexFloatDataset.toReal(var1_1);
            var3_5 = (float)ComplexFloatDataset.toImag(var1_1);
            var4_7 = this.getIterator();
            if (var3_5 != 0.0f) ** GOTO lbl39
            while (var4_7.hasNext()) {
                v3 = var4_7.index;
                this.data[v3] = this.data[v3] - var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                v4 = var4_7.index;
                this.data[v4] = this.data[v4] - var2_3;
                v5 = var4_7.index + 1;
                this.data[v5] = this.data[v5] - var3_5;
lbl39:
                // 2 sources

                ** while (var4_7.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexFloatDataset imultiply(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                var5_8 = this.data[var3_4.index];
                                var7_11 = var2_2.getElementDoubleAbs(var4_6.index);
                                var9_12 = this.data[var3_4.index + 1];
                                var11_13 = var2_2.getElementDoubleAbs(var4_6.index + 1);
                                this.data[var3_4.index] = (float)(var5_8 * var7_11 - var9_12 * var11_13);
                                this.data[var3_4.index + 1] = (float)(var5_8 * var11_13 + var9_12 * var7_11);
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_6.hasNext()) {
                                var5_9 = (float)var2_2.getElementDoubleAbs(var4_6.index);
                                v0 = var3_4.index;
                                this.data[v0] = this.data[v0] * var5_9;
                                v1 = var3_4.index + 1;
                                this.data[v1] = this.data[v1] * var5_9;
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = (float)ComplexFloatDataset.toReal(var1_1);
            var3_5 = (float)ComplexFloatDataset.toImag(var1_1);
            var4_7 = this.getIterator();
            if (var3_5 != 0.0f) ** GOTO lbl46
            while (var4_7.hasNext()) {
                v2 = var4_7.index;
                this.data[v2] = this.data[v2] * var2_3;
                v3 = var4_7.index + 1;
                this.data[v3] = this.data[v3] * var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var5_10 = this.data[var4_7.index];
                var6_14 = this.data[var4_7.index + 1];
                this.data[var4_7.index] = var5_10 * var2_3 - var6_14 * var3_5;
                this.data[var4_7.index + 1] = var5_10 * var3_5 + var6_14 * var2_3;
lbl46:
                // 2 sources

                ** while (var4_7.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexFloatDataset idivide(Object var1_1) {
        block9: {
            block11: {
                block10: {
                    if (!(var1_1 instanceof AbstractDataset)) break block10;
                    var2_2 = (AbstractDataset)var1_1;
                    this.checkCompatibility(var2_2);
                    var3_4 = this.getIterator();
                    var4_6 = var2_2.getIterator();
                    block0 : switch (var2_2.getDtype()) {
                        case 7: 
                        case 8: {
                            while (var3_4.hasNext()) {
                                if (!var4_6.hasNext()) break block0;
                                var5_8 = this.data[var3_4.index];
                                var7_12 = var2_2.getElementDoubleAbs(var4_6.index);
                                var9_15 = this.data[var3_4.index + 1];
                                var11_18 = var2_2.getElementDoubleAbs(var4_6.index + 1);
                                if (Math.abs(var7_12) < Math.abs(var11_18)) {
                                    var13_21 = var7_12 / var11_18;
                                    var15_22 = var7_12 * var13_21 + var11_18;
                                    this.data[var3_4.index] = (float)((var5_8 * var13_21 + var9_15) / var15_22);
                                    this.data[var3_4.index + 1] = (float)((var9_15 * var13_21 - var5_8) / var15_22);
                                    continue;
                                }
                                var13_21 = var11_18 / var7_12;
                                var15_22 = var11_18 * var13_21 + var7_12;
                                this.data[var3_4.index] = (float)((var9_15 * var13_21 + var5_8) / var15_22);
                                this.data[var3_4.index + 1] = (float)((var9_15 - var5_8 * var13_21) / var15_22);
                            }
                            break block9;
                        }
                        default: {
                            while (var3_4.hasNext()) {
                                if (!var4_6.hasNext()) break block0;
                                var5_9 = (float)var2_2.getElementDoubleAbs(var4_6.index);
                                v0 = var3_4.index;
                                this.data[v0] = this.data[v0] / var5_9;
                                v1 = var3_4.index + 1;
                                this.data[v1] = this.data[v1] / var5_9;
                            }
                            break block9;
                        }
                    }
                    {
                        break block9;
                        break;
                    }
                }
                var2_3 = (float)ComplexFloatDataset.toReal(var1_1);
                var3_5 = (float)ComplexFloatDataset.toImag(var1_1);
                var4_7 = this.getIterator();
                if (var3_5 == 0.0f) ** GOTO lbl55
                if (!(Math.abs(var2_3) < Math.abs(var3_5))) break block11;
                var5_10 = var2_3 / var3_5;
                var7_13 = (double)var2_3 * var5_10 + (double)var3_5;
                if (true) ** GOTO lbl62
            }
            var5_11 = var3_5 / var2_3;
            var7_14 = (double)var3_5 * var5_11 + (double)var2_3;
            if (true) ** GOTO lbl69
lbl-1000:
            // 1 sources

            {
                v2 = var4_7.index;
                this.data[v2] = this.data[v2] / var2_3;
                v3 = var4_7.index + 1;
                this.data[v3] = this.data[v3] / var2_3;
lbl55:
                // 2 sources

                ** while (var4_7.hasNext())
            }
lbl56:
            // 1 sources

            break block9;
            do {
                var9_16 = this.data[var4_7.index];
                var11_19 = this.data[var4_7.index + 1];
                this.data[var4_7.index] = (float)((var9_16 * var5_10 + var11_19) / var7_13);
                this.data[var4_7.index + 1] = (float)((var11_19 * var5_10 - var9_16) / var7_13);
lbl62:
                // 2 sources

            } while (var4_7.hasNext());
            break block9;
            do {
                var9_17 = this.data[var4_7.index];
                var11_20 = this.data[var4_7.index + 1];
                this.data[var4_7.index] = (float)((var11_20 * var5_11 + var9_17) / var7_14);
                this.data[var4_7.index + 1] = (float)((var11_20 - var9_17 * var5_11) / var7_14);
lbl69:
                // 2 sources

            } while (var4_7.hasNext());
        }
        this.setDirty();
        return this;
    }

    @Override
    public ComplexFloatDataset iremainder(Object object) {
        logger.error("Unsupported method for class");
        throw new UnsupportedOperationException("Unsupported method for class");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexFloatDataset ipower(Object object) {
        block8: {
            block9: {
                if (!(object instanceof AbstractDataset)) break block9;
                AbstractDataset abstractDataset = (AbstractDataset)object;
                this.checkCompatibility(abstractDataset);
                IndexIterator indexIterator = this.getIterator();
                IndexIterator indexIterator2 = abstractDataset.getIterator();
                switch (abstractDataset.getDtype()) {
                    case 7: 
                    case 8: {
                        while (indexIterator.hasNext()) {
                            if (indexIterator2.hasNext()) {
                                Complex complex = new Complex(abstractDataset.getElementDoubleAbs(indexIterator2.index), abstractDataset.getElementDoubleAbs(indexIterator2.index + 1));
                                Complex complex2 = new Complex((double)this.data[indexIterator.index], (double)this.data[indexIterator.index + 1]).pow(complex);
                                this.data[indexIterator.index] = (float)complex2.getReal();
                                this.data[indexIterator.index + 1] = (float)complex2.getImaginary();
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                    default: {
                        while (indexIterator.hasNext()) {
                            if (indexIterator2.hasNext()) {
                                Complex complex = new Complex(abstractDataset.getElementDoubleAbs(indexIterator2.index), 0.0);
                                Complex complex3 = new Complex((double)this.data[indexIterator.index], (double)this.data[indexIterator.index + 1]).pow(complex);
                                this.data[indexIterator.index] = (float)complex3.getReal();
                                this.data[indexIterator.index + 1] = (float)complex3.getImaginary();
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                }
            }
            Complex complex = new Complex(ComplexFloatDataset.toReal(object), ComplexFloatDataset.toImag(object));
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                Complex complex4 = new Complex((double)this.data[indexIterator.index], (double)this.data[indexIterator.index + 1]).pow(complex);
                this.data[indexIterator.index] = (float)complex4.getReal();
                this.data[indexIterator.index + 1] = (float)complex4.getImaginary();
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            switch (abstractDataset.getDtype()) {
                case 7: 
                case 8: {
                    while (indexIterator.hasNext()) {
                        if (!indexIterator2.hasNext()) {
                            return d;
                        }
                        double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                        double d4 = d3 * d3 - d2;
                        double d5 = d + d4;
                        d2 = d5 - d - d4;
                        d = d5;
                        d3 = (double)this.data[indexIterator.index + 1] - abstractDataset.getElementDoubleAbs(indexIterator2.index + 1);
                        d4 = d3 * d3 - d2;
                        d5 = d + d4;
                        d2 = d5 - d - d4;
                        d = d5;
                    }
                    return d;
                }
            }
            while (indexIterator.hasNext()) {
                if (!indexIterator2.hasNext()) {
                    return d;
                }
                double d6 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d7 = d6 * d6 - d2;
                double d8 = d + d7;
                d2 = d8 - d - d7;
                d = d8;
            }
            return d;
        }
        Complex complex = new Complex(ComplexFloatDataset.toReal(object), ComplexFloatDataset.toImag(object));
        IndexIterator indexIterator = this.getIterator();
        double d9 = 0.0;
        while (indexIterator.hasNext()) {
            double d10 = (double)this.data[indexIterator.index] - complex.getReal();
            double d11 = d10 * d10 - d9;
            double d12 = d + d11;
            d9 = d12 - d - d11;
            d = d12;
            d10 = (double)this.data[indexIterator.index + 1] - complex.getImaginary();
            d11 = d10 * d10 - d9;
            d12 = d + d11;
            d9 = d12 - d - d11;
            d = d12;
        }
        return d;
    }

    public static /* bridge */ /* synthetic */ CompoundFloatDataset createFromObject(Object object) {
        return ComplexFloatDataset.createFromObject(object);
    }
}

