/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.apache.commons.math.complex.Complex;
import org.junit.Assert;
import org.junit.Test;
import org.python.core.PyComplex;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class ComplexDoubleDatasetTest {
    @Test
    public void testConstructor() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset(dArray, new int[0]);
        Assert.assertEquals((long)8L, (long)complexDoubleDataset.getDtype());
        Assert.assertEquals((long)2L, (long)complexDoubleDataset.getElementsPerItem());
        Assert.assertEquals((long)16L, (long)complexDoubleDataset.getItemsize());
        IndexIterator indexIterator = complexDoubleDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)(n * 2), (double)complexDoubleDataset.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n));
            ++n;
        }
        ComplexDoubleDataset complexDoubleDataset2 = new ComplexDoubleDataset(dArray, 3, 2);
        indexIterator = complexDoubleDataset2.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)(n2 * 2), (double)complexDoubleDataset2.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
        PyComplex pyComplex = new PyComplex(0.5, 1.0);
        ComplexDoubleDataset complexDoubleDataset3 = ComplexDoubleDataset.createFromObject(new PyTuple(new PyObject[]{pyComplex}));
        Assert.assertEquals((double)0.5, (double)complexDoubleDataset3.getComplex(0).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)complexDoubleDataset3.getComplex(0).getImaginary(), (double)1.0E-6);
    }

    @Test
    public void testTake() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 8);
        System.out.println(abstractDataset);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        AbstractDataset abstractDataset2 = abstractDataset.take(nArray, 0);
        System.out.println(abstractDataset2);
        abstractDataset.setShape(3, 4);
        System.out.println(abstractDataset);
        abstractDataset2 = abstractDataset.take(new int[1], 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[1], 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{3}, 1);
        System.out.println(abstractDataset2);
    }

    @Test
    public void testStats() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 8);
        Assert.assertEquals((double)5.5, (double)((Complex)abstractDataset.mean()).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)((Complex)abstractDataset.mean()).getImaginary(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)abstractDataset.variance().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)abstractDataset.stdDeviation().doubleValue(), (double)1.0E-6);
        abstractDataset.iadd(new Complex(0.0, 0.5));
        Assert.assertEquals((double)5.5, (double)((Complex)abstractDataset.mean()).getReal(), (double)1.0E-6);
        Assert.assertEquals((double)0.5, (double)((Complex)abstractDataset.mean()).getImaginary(), (double)1.0E-6);
    }
}

