/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.DataSet;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class AbstractDatasetTest {
    @Test
    public void testMax() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        System.out.println(abstractDataset.max());
    }

    @Test
    public void testSort() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        abstractDataset.set(12, 0);
        System.out.println(abstractDataset.sort(null));
    }

    @Test
    public void testTake() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        AbstractDataset abstractDataset2 = abstractDataset.take(nArray, 0);
        System.out.println(abstractDataset2);
        abstractDataset.setShape(3, 4);
        System.out.println(abstractDataset);
        abstractDataset2 = abstractDataset.take(new int[1], 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[1], 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{3}, 1);
        System.out.println(abstractDataset2);
    }

    @Test
    public void testSqueeze() {
        AbstractDataset abstractDataset = AbstractDataset.arange(10.0, 6);
        abstractDataset.setShape(2, 1, 5);
        abstractDataset.squeeze();
        Assert.assertEquals((long)2L, (long)abstractDataset.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset.getShape()[0]);
        Assert.assertEquals((long)5L, (long)abstractDataset.getShape()[1]);
    }

    @Test
    public void testTile() {
        AbstractDataset abstractDataset = AbstractDataset.arange(3.0, 6);
        AbstractDataset abstractDataset2 = DatasetUtils.tile(abstractDataset, 2);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0};
        Assert.assertEquals((long)1L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)6L, (long)abstractDataset2.getShape()[0]);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((double)dArray[n], (double)((DoubleDataset)abstractDataset2).getData()[n], (double)1.0E-6);
            ++n;
        }
        AbstractDataset abstractDataset3 = DatasetUtils.tile(abstractDataset, 1, 2);
        Assert.assertEquals((long)2L, (long)abstractDataset3.getShape().length);
        Assert.assertEquals((long)1L, (long)abstractDataset3.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset3.getShape()[1]);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((double)dArray[n2], (double)((DoubleDataset)abstractDataset3).getData()[n2], (double)1.0E-6);
            ++n2;
        }
        AbstractDataset abstractDataset4 = DatasetUtils.tile(abstractDataset, 2, 1);
        Assert.assertEquals((long)2L, (long)abstractDataset4.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset4.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset4.getShape()[1]);
        int n3 = 0;
        while (n3 < dArray.length) {
            Assert.assertEquals((double)dArray[n3], (double)((DoubleDataset)abstractDataset4).getData()[n3], (double)1.0E-6);
            ++n3;
        }
        abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        AbstractDataset abstractDataset5 = DatasetUtils.tile(abstractDataset, 2);
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)abstractDataset5.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset5.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset5.getShape()[1]);
        int n4 = 0;
        while (n4 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n4], (double)((DoubleDataset)abstractDataset5).getData()[n4], (double)1.0E-6);
            ++n4;
        }
        AbstractDataset abstractDataset6 = DatasetUtils.tile(abstractDataset, 1, 2);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset6.getShape()[1]);
        int n5 = 0;
        while (n5 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n5], (double)((DoubleDataset)abstractDataset6).getData()[n5], (double)1.0E-6);
            ++n5;
        }
        AbstractDataset abstractDataset7 = DatasetUtils.tile(abstractDataset, 2, 1);
        double[] dArray3 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)abstractDataset7.getShape().length);
        Assert.assertEquals((long)4L, (long)abstractDataset7.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset7.getShape()[1]);
        int n6 = 0;
        while (n6 < dArray3.length) {
            Assert.assertEquals((double)dArray3[n6], (double)((DoubleDataset)abstractDataset7).getData()[n6], (double)1.0E-6);
            ++n6;
        }
    }

    @Test
    public void testTranspose() {
        int n;
        int n2;
        AbstractDataset abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        AbstractDataset abstractDataset2 = DatasetUtils.transpose(abstractDataset, 1, 0);
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        Assert.assertEquals((long)2L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset2.getShape()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 3) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)abstractDataset2.getDouble(n4, n3), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        abstractDataset = AbstractDataset.arange(24.0, 6);
        abstractDataset.setShape(2, 3, 4);
        double[][][] dArrayArray2 = new double[][][]{new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0, 7.0}, {8.0, 9.0, 10.0, 11.0}}, new double[][]{{12.0, 13.0, 14.0, 15.0}, {16.0, 17.0, 18.0, 19.0}, {20.0, 21.0, 22.0, 23.0}}};
        try {
            AbstractDataset abstractDataset3 = DatasetUtils.transpose(abstractDataset, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            AbstractDataset abstractDataset4 = DatasetUtils.transpose(abstractDataset, 0, -1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            AbstractDataset abstractDataset5 = DatasetUtils.transpose(abstractDataset, 0, 1, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        AbstractDataset abstractDataset6 = DatasetUtils.transpose(abstractDataset, 0, 1, 2);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[2]);
        int n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n5, n2, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        abstractDataset6 = DatasetUtils.transpose(abstractDataset, 1, 0, 2);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n2, n5, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        abstractDataset6 = DatasetUtils.transpose(abstractDataset, 2, 0, 1);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n, n5, n2), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
    }

    @Test
    public void testRepeat() {
        int n;
        AbstractDataset abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0};
        DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset.getShape().length);
        Assert.assertEquals((long)12L, (long)doubleDataset.getShape()[0]);
        int n2 = 0;
        while (n2 < 12) {
            Assert.assertEquals((double)dArray[n2], (double)doubleDataset.get(n2), (double)1.0E-6);
            ++n2;
        }
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 1.0, 1.0, 2.0, 2.0}, {3.0, 3.0, 4.0, 4.0, 5.0, 5.0}};
        DoubleDataset doubleDataset2 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset2.getShape().length);
        Assert.assertEquals((long)2L, (long)doubleDataset2.getShape()[0]);
        Assert.assertEquals((long)6L, (long)doubleDataset2.getShape()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 6) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)doubleDataset2.get(n3, n4), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}, {3.0, 4.0, 5.0}};
        DoubleDataset doubleDataset3 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset3.getShape().length);
        Assert.assertEquals((long)4L, (long)doubleDataset3.getShape()[0]);
        Assert.assertEquals((long)3L, (long)doubleDataset3.getShape()[1]);
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 3) {
                Assert.assertEquals((double)dArrayArray2[n5][n6], (double)doubleDataset3.get(n5, n6), (double)1.0E-6);
                ++n6;
            }
            ++n5;
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset doubleDataset4 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2, 1}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset4.getShape().length);
        Assert.assertEquals((long)3L, (long)doubleDataset4.getShape()[0]);
        Assert.assertEquals((long)3L, (long)doubleDataset4.getShape()[1]);
        int n7 = 0;
        while (n7 < 3) {
            int n8 = 0;
            while (n8 < 3) {
                Assert.assertEquals((double)dArrayArray3[n7][n8], (double)doubleDataset4.get(n7, n8), (double)1.0E-6);
                ++n8;
            }
            ++n7;
        }
        double[][] dArrayArray4 = new double[][]{{0.0, 1.0, 1.0, 2.0, 2.0, 2.0}, {3.0, 4.0, 4.0, 5.0, 5.0, 5.0}};
        DoubleDataset doubleDataset5 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{1, 2, 3}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset5.getShape().length);
        Assert.assertEquals((long)2L, (long)doubleDataset5.getShape()[0]);
        Assert.assertEquals((long)6L, (long)doubleDataset5.getShape()[1]);
        int n9 = 0;
        while (n9 < 2) {
            int n10 = 0;
            while (n10 < 6) {
                Assert.assertEquals((double)dArrayArray4[n9][n10], (double)doubleDataset5.get(n9, n10), (double)1.0E-6);
                ++n10;
            }
            ++n9;
        }
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 2.0, 5.0, 5.0, 5.0};
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[5] = 3;
        DoubleDataset doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, nArray, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset6.getShape().length);
        Assert.assertEquals((long)7L, (long)doubleDataset6.getShape()[0]);
        int n11 = 0;
        while (n11 < 7) {
            Assert.assertEquals((double)dArray2[n11], (double)doubleDataset6.get(n11), (double)1.0E-6);
            ++n11;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.arange(1024.0, 6);
        abstractDataset2.set(0, 1024);
        DoubleDataset doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)2050L, (long)doubleDataset7.getShape()[0]);
        int n12 = 0;
        while (n12 < 1024) {
            Assert.assertEquals((double)n12, (double)doubleDataset7.get(2 * n12), (double)1.0E-6);
            Assert.assertEquals((double)n12, (double)doubleDataset7.get(2 * n12 + 1), (double)1.0E-6);
            ++n12;
        }
        abstractDataset2 = AbstractDataset.arange(1024.0, 6);
        abstractDataset2.setShape(16, 64);
        abstractDataset2.set(0.0, 0, 64);
        doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)16L, (long)doubleDataset7.getShape()[0]);
        Assert.assertEquals((long)130L, (long)doubleDataset7.getShape()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(n12, 2 * n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(n12, 2 * n + 1), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)32L, (long)doubleDataset7.getShape()[0]);
        Assert.assertEquals((long)65L, (long)doubleDataset7.getShape()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(2 * n12, n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(2 * n12 + 1, n), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[1], 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2, 1}, -1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{-1}, -1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
    }

    @Test
    public void testContents() {
        double[] dArray = new double[]{0.0, 2.0, -12.3};
        double[] dArray2 = new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] dArray3 = new double[]{1.0E14, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        DataSet dataSet = new DataSet(dArray);
        Assert.assertEquals((Object)false, (Object)dataSet.containsNans());
        Assert.assertEquals((Object)false, (Object)dataSet.containsInfs());
        DataSet dataSet2 = new DataSet(dArray2);
        Assert.assertEquals((Object)true, (Object)dataSet2.containsNans());
        Assert.assertEquals((Object)true, (Object)dataSet2.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(dataSet2.min()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet2.min()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(dataSet2.max()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet2.max()));
        DataSet dataSet3 = new DataSet(dArray3);
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet3.min()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(dataSet3.max()));
        dataSet = DataSet.arange(1024.0);
        dataSet.set(3.0, 1024);
        Assert.assertEquals((Object)false, (Object)dataSet.containsNans());
        Assert.assertEquals((Object)false, (Object)dataSet.containsInfs());
    }

    @Test
    public void testAutoAllocation() {
        DataSet dataSet = new DataSet(1);
        int n = 0;
        while (n < 1000) {
            dataSet.set(n, n);
            ++n;
        }
        IndexIterator indexIterator = dataSet.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            if (n2 < 1000) assert ((double)n2 == dataSet.get(indexIterator.index));
            ++n2;
        }
        assert (n2 == 1000);
    }

    @Test
    public void testEquals() {
        AbstractDataset abstractDataset = AbstractDataset.arange(20.0, 6);
        AbstractDataset abstractDataset2 = AbstractDataset.arange(20.0, 6);
        AbstractDataset abstractDataset3 = abstractDataset.clone();
        AbstractDataset abstractDataset4 = Maths.add(abstractDataset, 0.5);
        AbstractDataset abstractDataset5 = AbstractDataset.arange(20.0, 5);
        Assert.assertEquals((Object)true, (Object)abstractDataset.equals(abstractDataset2));
        Assert.assertEquals((Object)true, (Object)abstractDataset.equals(abstractDataset3));
        Assert.assertEquals((Object)false, (Object)abstractDataset.equals(abstractDataset4));
        Assert.assertEquals((Object)false, (Object)abstractDataset.equals(abstractDataset5));
    }
}

