/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.DataSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBoolean;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIteratorWithPosition;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DiscontiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;

public abstract class AbstractDataset
implements Serializable,
IDataset {
    private static final long serialVersionUID = 1970L;
    protected static final transient Logger abstractLogger = LoggerFactory.getLogger(AbstractDataset.class);
    public static final int BOOL = 0;
    public static final int INT8 = 1;
    public static final int INT16 = 2;
    public static final int INT32 = 3;
    public static final int INT = 3;
    public static final int INT64 = 4;
    public static final int FLOAT32 = 5;
    public static final int FLOAT64 = 6;
    public static final int FLOAT = 6;
    public static final int COMPLEX64 = 7;
    public static final int COMPLEX128 = 8;
    public static final int COMPLEX = 8;
    public static final int ARRAYINT8 = 100;
    public static final int ARRAYINT16 = 200;
    public static final int ARRAYINT32 = 300;
    public static final int ARRAYINT64 = 400;
    public static final int ARRAYFLOAT32 = 500;
    public static final int ARRAYFLOAT64 = 600;
    protected static final int maxDisplayLength = 1024;
    private static final float ARRAY_ALLOCATION_EXTENSION = 0.5f;
    protected int[] shape;
    protected int size;
    protected int[] dataShape;
    protected int dataSize;
    protected Object odata = null;
    protected String name = "";
    protected transient HashMap<String, Object> storedValues = null;
    protected Map<String, ? extends Object> metadata;
    protected boolean extendible = true;
    private static final transient Map<Class<?>, Integer> dtypeMap = AbstractDataset.createDTypeMap();

    protected abstract void setData();

    public Map<String, ? extends Object> getMetadataMap() {
        return this.metadata;
    }

    public Object getMetadata(String string) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(string);
    }

    public void setMetadataMap(Map<String, ? extends Object> map) {
        this.metadata = map;
    }

    public void setMetadata(String string, Object object) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(string, object);
    }

    public boolean isExtendable() {
        return this.extendible;
    }

    public void setExtendible(boolean bl) {
        this.extendible = bl;
    }

    public AbstractDataset() {
    }

    public AbstractDataset(AbstractDataset abstractDataset) {
        if (abstractDataset == null) {
            abstractLogger.error("Input dataset to the dataset is null");
            throw new IllegalArgumentException("Input dataset to the dataset is null");
        }
        abstractDataset.clone();
    }

    public synchronized AbstractDataset synchronizedCopy() {
        return this.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractDataset abstractDataset = (AbstractDataset)object;
        if (!Arrays.equals(this.shape, abstractDataset.shape)) {
            return false;
        }
        if (this.dataShape != null) {
            if (abstractDataset.dataShape == null) {
                return false;
            }
            if (!Arrays.equals(this.dataShape, abstractDataset.dataShape)) {
                return false;
            }
        } else if (abstractDataset.dataShape != null) {
            return false;
        }
        return true;
    }

    public AbstractDataset clone() {
        AbstractDataset abstractDataset = null;
        try {
            switch (this.getDtype()) {
                case 0: {
                    abstractDataset = new BooleanDataset((BooleanDataset)this);
                    break;
                }
                case 1: {
                    abstractDataset = new ByteDataset((ByteDataset)this);
                    break;
                }
                case 2: {
                    abstractDataset = new ShortDataset((ShortDataset)this);
                    break;
                }
                case 3: {
                    abstractDataset = new IntegerDataset((IntegerDataset)this);
                    break;
                }
                case 4: {
                    abstractDataset = new LongDataset((LongDataset)this);
                    break;
                }
                case 100: {
                    abstractDataset = new CompoundByteDataset((CompoundByteDataset)this);
                    break;
                }
                case 200: {
                    abstractDataset = new CompoundShortDataset((CompoundShortDataset)this);
                    break;
                }
                case 300: {
                    abstractDataset = new CompoundIntegerDataset((CompoundIntegerDataset)this);
                    break;
                }
                case 400: {
                    abstractDataset = new CompoundLongDataset((CompoundLongDataset)this);
                    break;
                }
                case 5: {
                    abstractDataset = new FloatDataset((FloatDataset)this);
                    break;
                }
                case 6: {
                    abstractDataset = new DoubleDataset((DoubleDataset)this);
                    break;
                }
                case 500: {
                    abstractDataset = new CompoundFloatDataset((CompoundFloatDataset)this);
                    break;
                }
                case 600: {
                    abstractDataset = new CompoundDoubleDataset((CompoundDoubleDataset)this);
                    break;
                }
                case 7: {
                    abstractDataset = new ComplexFloatDataset((ComplexFloatDataset)this);
                    break;
                }
                case 8: {
                    abstractDataset = new ComplexDoubleDataset((ComplexDoubleDataset)this);
                    break;
                }
                default: {
                    abstractLogger.error("Dataset of unknown type!");
                    break;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            abstractLogger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        return abstractDataset;
    }

    public AbstractDataset cast(int n) {
        if (this.getDtype() == n) {
            return this;
        }
        return DatasetUtils.cast(this, n);
    }

    public static DoubleDataset toDoubleDataset(DataSet dataSet) {
        DoubleDataset doubleDataset = new DoubleDataset(dataSet.getBuffer(), dataSet.getDimensions());
        doubleDataset.setName(dataSet.getName());
        return doubleDataset;
    }

    public static DataSet toDataSet(IDataset iDataset) {
        if (iDataset instanceof DataSet) {
            return (DataSet)iDataset;
        }
        if (iDataset instanceof AbstractDataset) {
            DoubleDataset doubleDataset = (DoubleDataset)((AbstractDataset)iDataset).cast(6);
            DataSet dataSet = new DataSet(doubleDataset.getData(), doubleDataset.getShape());
            dataSet.setName(iDataset.getName());
            return dataSet;
        }
        return DataSet.convertToDataset(iDataset);
    }

    public abstract AbstractDataset getView();

    public IntegerDataset getIndices() {
        return DatasetUtils.indices(this.shape);
    }

    public AbstractDataset transpose(int ... nArray) {
        return DatasetUtils.transpose(this, nArray);
    }

    public AbstractDataset swapaxes(int n, int n2) {
        return DatasetUtils.swapAxes(this, n, n2);
    }

    public AbstractDataset append(AbstractDataset abstractDataset, int n) {
        int n2 = this.shape.length;
        int[] nArray = abstractDataset.getShape();
        if (n2 != nArray.length) {
            throw new IllegalArgumentException("Incompatible number of dimensions");
        }
        if (n >= n2) {
            throw new IllegalArgumentException("Axis specified exceeds array dimensions");
        }
        if (n == -1) {
            n = n2 - 1;
        } else if (n < -1) {
            throw new IllegalArgumentException("Axis specified is less than -1");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n && this.shape[n3] != nArray[n3]) {
                throw new IllegalArgumentException("Incompatible dimensions");
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = this.shape[n4];
            ++n4;
        }
        int n5 = n;
        nArray2[n5] = nArray2[n5] + nArray[n];
        n4 = abstractDataset.getDtype();
        int n6 = this.getDtype();
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(this.getElementsPerItem(), nArray2, n6 > n4 ? n6 : n4);
        int n7 = 0;
        int n8 = abstractDataset2.getSize();
        while (n7 < n8) {
            int[] nArray3 = abstractDataset2.getNDPosition(n7);
            boolean bl = true;
            int n9 = 0;
            while (n9 < nArray2.length) {
                if (nArray3[n9] >= this.shape[n9]) {
                    bl = false;
                    int n10 = n9;
                    nArray3[n10] = nArray3[n10] - this.shape[n9];
                    break;
                }
                ++n9;
            }
            if (bl) {
                abstractDataset2.setObjectAbs(this.getObject(nArray3), n7);
            } else {
                abstractDataset2.setObjectAbs(abstractDataset.getObject(nArray3), n7);
            }
            ++n7;
        }
        return abstractDataset2;
    }

    public AbstractDataset flatten() {
        AbstractDataset abstractDataset = this.shape.length <= 1 || this.dataShape == null ? this.getView() : this.clone();
        abstractDataset.shape = new int[]{abstractDataset.size};
        return abstractDataset;
    }

    protected static int calcSize(int[] nArray) {
        int n = 1;
        double d = 1.0;
        if (nArray.length == 1) {
            if (nArray[0] == 0) {
                return 0;
            }
            n *= nArray[0];
            d *= (double)nArray[0];
        } else {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] <= 0) {
                    abstractLogger.error("The {}-th axis is {} which is an illegal argument as it is zero or negative", (Object)n2, (Object)nArray[n2]);
                    throw new IllegalArgumentException("The " + n2 + "-th is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
                }
                n *= nArray[n2];
                d *= (double)nArray[n2];
                ++n2;
            }
        }
        if (d > 2.147483647E9) {
            abstractLogger.error("The size of the dataset that is being created is too large to allocate memory for.");
            throw new IllegalArgumentException("Size of the dataset is too large to allocate");
        }
        return n;
    }

    protected static int[] getShapeFromObject(Object object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        AbstractDataset.getShapeFromObj(arrayList, object, 0);
        int n = arrayList.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = arrayList.get(n2);
            ++n2;
        }
        return nArray;
    }

    public static int getBestDType(int n, int n2) {
        int n3;
        if (n >= 100 && n2 < 100) {
            switch (n2) {
                case 1: {
                    n2 = 100;
                    break;
                }
                case 2: {
                    n2 = 200;
                    break;
                }
                case 3: {
                    n2 = 300;
                    break;
                }
                case 4: {
                    n2 = 400;
                    break;
                }
                case 5: {
                    n2 = 500;
                    break;
                }
                case 6: {
                    n2 = 600;
                    break;
                }
                default: {
                    abstractLogger.error("Complex type cannot be promoted to compound type");
                    throw new IllegalArgumentException("Complex type cannot be promoted to compound type");
                }
            }
        }
        if (n2 > n) {
            if (n2 == 7 || n2 == 8) {
                switch (n) {
                    case 5: 
                    case 7: {
                        n3 = 7;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: {
                        n3 = 8;
                        break;
                    }
                    default: {
                        n3 = n;
                        break;
                    }
                }
            } else {
                n3 = n2;
            }
        } else {
            n3 = n;
        }
        return n3;
    }

    public static int getLargestDType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 3;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 5: 
            case 6: {
                return 6;
            }
            case 7: 
            case 8: {
                return 8;
            }
            case 100: 
            case 200: {
                return 300;
            }
            case 300: 
            case 400: {
                return 400;
            }
            case 500: 
            case 600: {
                return 600;
            }
        }
        abstractLogger.error("Unsupported dataset type");
        throw new IllegalArgumentException("Unsupported dataset type");
    }

    public static int getBestFloatDType(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 100: 
            case 200: 
            case 500: {
                n2 = 5;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 300: 
            case 400: 
            case 600: {
                n2 = 6;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    public static int getBestFloatDType(Class<? extends Object> clazz) {
        return AbstractDataset.getBestFloatDType(AbstractDataset.getDTypeFromClass(clazz));
    }

    private static Map<Class<?>, Integer> createDTypeMap() {
        HashMap hashMap = new HashMap();
        hashMap.put(Boolean.class, 0);
        hashMap.put(Byte.class, 1);
        hashMap.put(Short.class, 2);
        hashMap.put(Integer.class, 3);
        hashMap.put(Long.class, 4);
        hashMap.put(Float.class, 5);
        hashMap.put(Double.class, 6);
        hashMap.put(Complex.class, 8);
        hashMap.put(PyComplex.class, 8);
        return hashMap;
    }

    public static int getDTypeFromClass(Class<? extends Object> clazz) {
        Integer n = dtypeMap.get(clazz);
        if (n == null) {
            abstractLogger.error("Class of object not supported");
            throw new IllegalArgumentException("Class of object not supported");
        }
        return n;
    }

    public static int getDTypeFromObject(Object object) {
        int n = 0;
        if (object instanceof PySequenceList) {
            PySequenceList pySequenceList = (PySequenceList)object;
            int n2 = pySequenceList.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                Object object2 = pySequenceList.get(n3);
                if (object2 instanceof PySequence || object2 instanceof PyArray || object2.getClass().isArray()) {
                    n4 = AbstractDataset.getDTypeFromObject(object2);
                } else {
                    Class<?> clazz = object2.getClass();
                    n4 = AbstractDataset.getDTypeFromClass(clazz);
                }
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
        } else {
            if (object instanceof PyArray) {
                object = ((PyArray)object).getArray();
            }
            n = object.getClass().isArray() ? AbstractDataset.getDTypeFromArray(object) : AbstractDataset.getDTypeFromClass(object.getClass());
        }
        return n;
    }

    private static int getDTypeFromArray(Object object) {
        int n = 0;
        int n2 = Array.getLength(object);
        Object object2 = Array.get(object, 0);
        Class<?> clazz = object2.getClass();
        if (clazz.isArray()) {
            int n3 = 0;
            while (n3 < n2) {
                object2 = Array.get(object, n3);
                int n4 = AbstractDataset.getDTypeFromArray(object2);
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                object2 = Array.get(object, n5);
                int n6 = AbstractDataset.getDTypeFromClass(object2.getClass());
                if (n6 > n) {
                    n = n6;
                }
                ++n5;
            }
        }
        return n;
    }

    private static void getShapeFromObj(ArrayList<Integer> arrayList, Object object, int n) {
        if (object instanceof PySequenceList) {
            PySequenceList pySequenceList = (PySequenceList)object;
            int n2 = pySequenceList.size();
            AbstractDataset.updateShape(arrayList, n, n2);
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = pySequenceList.get(n3);
                if (object2 instanceof PySequence || object2 instanceof PyArray || object2.getClass().isArray()) {
                    AbstractDataset.getShapeFromObj(arrayList, object2, n + 1);
                }
                ++n3;
            }
        } else {
            Class<?> clazz;
            if (object instanceof PyArray) {
                object = ((PyArray)object).getArray();
            }
            if ((clazz = object.getClass()).isArray()) {
                int n4 = Array.getLength(object);
                AbstractDataset.updateShape(arrayList, n, n4);
                int n5 = 0;
                while (n5 < n4) {
                    Object object3 = Array.get(object, n5);
                    if (object3 instanceof PySequence || object3 instanceof PyArray || object3.getClass().isArray()) {
                        AbstractDataset.getShapeFromObj(arrayList, object3, n + 1);
                    }
                    ++n5;
                }
            } else {
                AbstractDataset.updateShape(arrayList, n, 1);
                return;
            }
        }
    }

    private static void updateShape(ArrayList<Integer> arrayList, int n, int n2) {
        if (n >= arrayList.size()) {
            arrayList.add(n2);
        } else if (n2 > arrayList.get(n)) {
            arrayList.set(n, n2);
        }
    }

    protected static boolean toBoolean(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue() != 0L;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getReal() != 0.0;
        }
        if (object instanceof PyBoolean) {
            return ((PyBoolean)object).getValue() != 0;
        }
        if (object instanceof PyFloat) {
            return ((PyFloat)object).asDouble() != 0.0;
        }
        if (object instanceof PyComplex) {
            return (long)((PyComplex)object).real != 0L;
        }
        abstractLogger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static long toLong(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return 0L;
            }
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Complex) {
            return (long)((Complex)object).getReal();
        }
        if (object instanceof PyBoolean) {
            return ((PyBoolean)object).getValue();
        }
        if (object instanceof PyFloat) {
            return (long)((PyFloat)object).asDouble();
        }
        if (object instanceof PyComplex) {
            return (long)((PyComplex)object).real;
        }
        abstractLogger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static double toReal(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getReal();
        }
        if (object instanceof PyBoolean) {
            return ((PyBoolean)object).getValue() != 0 ? 1.0 : 0.0;
        }
        if (object instanceof PyFloat) {
            return ((PyFloat)object).asDouble();
        }
        if (object instanceof PyComplex) {
            return ((PyComplex)object).real;
        }
        abstractLogger.error("Argument is of unsupported class");
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static double toImag(Object object) {
        if (object instanceof Number) {
            return 0.0;
        }
        if (object instanceof Boolean) {
            return 0.0;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getImaginary();
        }
        if (object instanceof PyBoolean) {
            return 0.0;
        }
        if (object instanceof PyFloat) {
            return 0.0;
        }
        if (object instanceof PyComplex) {
            return ((PyComplex)object).imag;
        }
        throw new IllegalArgumentException("Argument is not a number");
    }

    protected void fillData(Object object, int n, int[] nArray) {
        if (object instanceof PySequenceList) {
            PySequenceList pySequenceList = (PySequenceList)object;
            int n2 = pySequenceList.size();
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = pySequenceList.get(n3);
                if (object2 instanceof PySequence || object2 instanceof PyArray || object2.getClass().isArray()) {
                    this.fillData(object2, n + 1, nArray);
                    nArray[n + 1] = 0;
                } else {
                    this.set(object2, nArray);
                }
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
                ++n3;
            }
        } else {
            if (object instanceof PyArray) {
                object = ((PyArray)object).getArray();
            }
            if (object.getClass().isArray()) {
                this.fillDataFromArray(object, n, nArray);
            } else {
                this.set(object, nArray);
            }
        }
    }

    private void fillDataFromArray(Object object, int n, int[] nArray) {
        int n2 = Array.getLength(object);
        Object object2 = Array.get(object, 0);
        Class<?> clazz = object2.getClass();
        if (clazz.isArray()) {
            int n3 = 0;
            while (n3 < n2) {
                object2 = Array.get(object, n3);
                this.fillDataFromArray(object2, n + 1, nArray);
                nArray[n + 1] = 0;
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                object2 = Array.get(object, n5);
                this.set(object2, nArray);
                int n6 = n;
                nArray[n6] = nArray[n6] + 1;
                ++n5;
            }
        }
    }

    protected void expandDataShape(int[] nArray) {
        int n = this.dataShape.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.dataShape[n2] > 0) {
                double d = nArray[n2] - this.dataShape[n2];
                if ((d /= (double)this.dataShape[n2]) >= 0.0) {
                    if (d < 0.1) {
                        d = 0.5;
                    }
                    int n3 = n2;
                    this.dataShape[n3] = (int)((double)this.dataShape[n3] * (1.0 + d));
                }
            }
            ++n2;
        }
    }

    private boolean isAllZeros(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IndexIterator getIterator(boolean bl) {
        if (this.shape.length <= 1 || this.dataShape == null || this.isAllZeros(this.dataShape)) {
            return bl ? new ContiguousIteratorWithPosition(this.shape, this.size) : new ContiguousIterator(this.size);
        }
        return new DiscontiguousIterator(this.shape, this.dataShape, this.dataSize);
    }

    public IndexIterator getIterator() {
        return this.getIterator(false);
    }

    public PositionIterator getPositionIterator(int ... nArray) {
        try {
            return new PositionIterator(this.shape, nArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            abstractLogger.error(illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
    }

    public IndexIterator getSliceIterator(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4;
        int n = this.shape.length;
        int[] nArray5 = new int[n];
        if (nArray3 == null) {
            nArray4 = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray4[n2] = 1;
                ++n2;
            }
        } else {
            nArray4 = nArray3;
        }
        int[] nArray6 = nArray == null ? new int[n] : nArray;
        int[] nArray7 = nArray2 == null ? new int[n] : nArray2;
        if (n > 1 || this.shape[0] > 0) {
            this.checkSlice(nArray, nArray2, nArray6, nArray7, nArray4, nArray5);
        }
        if (n <= 1 || this.dataShape == null) {
            return new SliceIterator(this.shape, this.size, nArray6, nArray4, nArray5);
        }
        return new SliceIterator(this.dataShape, this.dataSize, nArray6, nArray4, nArray5);
    }

    protected SliceIterator getSliceIteratorFromAxes(int[] nArray, boolean[] blArray) {
        int[] nArray2;
        int n = this.shape.length;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        if (nArray == null) {
            nArray2 = new int[n];
        } else if (nArray.length == n) {
            nArray2 = (int[])nArray.clone();
        } else {
            abstractLogger.error("pos array length is not equal to rank of dataset");
            throw new IllegalArgumentException("pos array length is not equal to rank of dataset");
        }
        if (blArray == null) {
            blArray = new boolean[n];
            Arrays.fill(blArray, true);
        } else if (blArray.length != n) {
            abstractLogger.error("axes array length is not equal to rank of dataset");
            throw new IllegalArgumentException("axes array length is not equal to rank of dataset");
        }
        int n2 = 0;
        while (n2 < n) {
            if (blArray[n2]) {
                nArray2[n2] = 0;
                nArray3[n2] = this.shape[n2];
            } else {
                nArray3[n2] = nArray2[n2] + 1;
            }
            nArray4[n2] = 1;
            ++n2;
        }
        return (SliceIterator)this.getSliceIterator(nArray, nArray3, nArray4);
    }

    public abstract void copyItemsFromAxes(int[] var1, boolean[] var2, AbstractDataset var3);

    public abstract void setItemsOnAxes(int[] var1, boolean[] var2, Object var3);

    protected void checkSlice(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int n = this.shape.length;
        if (nArray3.length != n || nArray4.length != n || nArray5.length != n) {
            abstractLogger.error("Wrong number of indexes, you passed it start={}, stop={}, step={}, and it needs {}", (Object)new int[]{nArray3.length, nArray4.length, nArray5.length, n});
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + nArray3.length + ", stop=" + nArray4.length + ", step=" + nArray5.length + ", and it needs " + n);
        }
        int n2 = 0;
        while (n2 < n) {
            if (nArray5[n2] == 0) {
                abstractLogger.error("Array of steps should be all non-zero");
                throw new IllegalArgumentException("The step array is not allowed any zero entries: " + n2 + "-th entry is zero");
            }
            if (nArray != null) {
                if (nArray[n2] < 0) {
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + this.shape[n2];
                }
                if (nArray[n2] < 0) {
                    int n4 = nArray[n2] = nArray5[n2] > 0 ? 0 : -1;
                }
                if (nArray[n2] > this.shape[n2]) {
                    nArray[n2] = nArray5[n2] > 0 ? this.shape[n2] : this.shape[n2] - 1;
                }
            } else {
                int n5 = nArray3[n2] = nArray5[n2] > 0 ? 0 : this.shape[n2] - 1;
            }
            if (nArray2 != null) {
                if (nArray2[n2] < 0) {
                    int n6 = n2;
                    nArray2[n6] = nArray2[n6] + this.shape[n2];
                }
                if (nArray2[n2] < 0) {
                    nArray2[n2] = -1;
                }
                if (nArray2[n2] > this.shape[n2]) {
                    nArray2[n2] = this.shape[n2];
                }
            } else {
                int n7 = nArray4[n2] = nArray5[n2] > 0 ? this.shape[n2] : -1;
            }
            if (nArray3[n2] == nArray4[n2]) {
                abstractLogger.error("Same start=stop={} indices has been passed", (Object)nArray3[n2]);
                throw new IllegalArgumentException("Same indices in start and stop");
            }
            if (nArray5[n2] > 0 != nArray3[n2] < nArray4[n2]) {
                abstractLogger.error("Passed values of start={} and stop={} indices that are incompatible with step={}", (Object)new int[]{nArray3[n2], nArray4[n2], nArray5[n2]});
                throw new IllegalArgumentException("Start=" + nArray3[n2] + " and stop=" + nArray4[n2] + " indices are incompatible with step=" + nArray5[n2]);
            }
            nArray6[n2] = nArray5[n2] > 0 ? (nArray4[n2] - nArray3[n2] - 1) / nArray5[n2] + 1 : (nArray4[n2] - nArray3[n2] + 1) / nArray5[n2] + 1;
            ++n2;
        }
    }

    public abstract AbstractDataset setSlice(int[] var1, int[] var2, int[] var3, Object var4);

    public BooleanIterator getBooleanIterator(BooleanDataset booleanDataset) {
        return new BooleanIterator(this.getIterator(), booleanDataset);
    }

    public AbstractDataset getByBoolean(BooleanDataset booleanDataset) {
        this.checkCompatibility(booleanDataset);
        int n = ((Number)booleanDataset.sum()).intValue();
        int n2 = this.getElementsPerItem();
        AbstractDataset abstractDataset = AbstractDataset.zeros(n2, new int[]{n}, this.getDtype());
        BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
        int n3 = 0;
        while (booleanIterator.hasNext()) {
            abstractDataset.setObjectAbs(this.getObjectAbs(booleanIterator.index), n3);
            n3 += n2;
        }
        return abstractDataset;
    }

    public abstract AbstractDataset setByBoolean(BooleanDataset var1, Object var2);

    public AbstractDataset getByIndex(IntegerDataset integerDataset) {
        int n = this.getElementsPerItem();
        AbstractDataset abstractDataset = AbstractDataset.zeros(n, integerDataset.getShape(), this.getDtype());
        IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size, n);
        int n2 = 0;
        while (integerIterator.hasNext()) {
            abstractDataset.setObjectAbs(this.getObjectAbs(integerIterator.index), n2);
            n2 += n;
        }
        return abstractDataset;
    }

    public abstract AbstractDataset setByIndex(IntegerDataset var1, Object var2);

    protected static Class<?> elementClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 100: {
                return Byte.class;
            }
            case 2: 
            case 200: {
                return Short.class;
            }
            case 3: 
            case 300: {
                return Integer.class;
            }
            case 4: 
            case 400: {
                return Long.class;
            }
            case 5: 
            case 500: {
                return Float.class;
            }
            case 6: 
            case 600: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
        }
        return Object.class;
    }

    public abstract int getDtype();

    @Override
    public Class<?> elementClass() {
        return AbstractDataset.elementClass(this.getDtype());
    }

    @Override
    public int getElementsPerItem() {
        return AbstractDataset.getElementsPerItem(this.getDtype());
    }

    @Override
    public int getItemsize() {
        return AbstractDataset.getItemsize(this.getDtype(), this.getElementsPerItem());
    }

    public static int getElementsPerItem(int n) {
        switch (n) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                abstractLogger.error("Multi-element type unsupported");
                throw new UnsupportedOperationException("Multi-element type unsupported");
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 1;
    }

    public static int getItemsize(int n) {
        return AbstractDataset.getItemsize(n, AbstractDataset.getElementsPerItem(n));
    }

    public static int getItemsize(int n, int n2) {
        int n3;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: 
            case 100: {
                n3 = 1;
                break;
            }
            case 2: 
            case 200: {
                n3 = 2;
                break;
            }
            case 3: 
            case 300: {
                n3 = 4;
                break;
            }
            case 4: 
            case 400: {
                n3 = 8;
                break;
            }
            case 5: 
            case 7: 
            case 500: {
                n3 = 4;
                break;
            }
            case 6: 
            case 8: 
            case 600: {
                n3 = 8;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3 * n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getSize() {
        if (this.odata == null) {
            abstractLogger.error("The data object inside the dataset has not been allocated, this suggests a failed or absent construction of the dataset");
            throw new NullPointerException("The data object inside the dataset has not been allocated, this suggests a failed or absent construction of the dataset");
        }
        return this.size;
    }

    public boolean isContiguous() {
        return this.shape.length <= 1 || this.dataShape == null;
    }

    @Override
    public int[] getShape() {
        if (this.shape == null) {
            return new int[0];
        }
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    public int getNdim() {
        return this.getRank();
    }

    public int getNbytes() {
        return this.getSize() * this.getItemsize();
    }

    @Override
    public void setShape(int ... nArray) {
        int n = 1;
        if (this.dataShape != null) {
            abstractLogger.error("Cannot set a new shape to a discontiguous or fragmented dataset: copy dataset first");
            throw new UnsupportedOperationException("Cannot set a new shape to discontiguous dataset");
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] <= 0) {
                abstractLogger.error("Argument {} is {} which is an illegal argument as it is zero or negative", (Object)n2, (Object)nArray[n2]);
                throw new IllegalArgumentException("Argument " + n2 + " is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
            }
            n *= nArray[n2];
            ++n2;
        }
        if (n != this.size) {
            abstractLogger.error("New shape ({}) is not compatible with old shape ({})", (Object)nArray, (Object)this.shape);
            throw new IllegalArgumentException("New shape (" + Arrays.toString(nArray) + ") is not compatible with old shape (" + Arrays.toString(this.shape) + ")");
        }
        this.shape = (int[])nArray.clone();
    }

    public Object getBuffer() {
        return this.odata;
    }

    protected int get1DIndex(int ... nArray) {
        int n = nArray.length;
        int n2 = this.shape.length;
        if (n == 0) {
            if (n2 == 1 && this.shape[0] == 0) {
                return 0;
            }
            abstractLogger.error("One or more index parameters must be supplied");
            throw new IllegalArgumentException("One or more index parameters must be supplied");
        }
        if (n > n2) {
            abstractLogger.error("No of index parameters is different to the shape of data: {} given, {} required", (Object)n, (Object)n2);
            throw new IllegalArgumentException("No of index parameters is different to the shape of data: " + n + " given " + n2 + "required");
        }
        int n3 = nArray[0];
        int n4 = this.shape[0];
        if (n3 < -n4 || n3 >= n4) {
            abstractLogger.error("Index ({}) out of range [-{},{}) in dimension 0", new Object[]{n3, n4, n4});
            throw new ArrayIndexOutOfBoundsException("Index (" + n3 + ") out of range [-" + n4 + "," + n4 + ") in dimension 0");
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == 1) {
            return n3;
        }
        int[] nArray2 = this.dataShape == null ? this.shape : this.dataShape;
        int n5 = 1;
        while (n5 < n) {
            int n6 = nArray[n5];
            int n7 = this.shape[n5];
            if (n6 < -n7 || n6 >= n7) {
                abstractLogger.error("Index ({}) out of range [-{},{}) in dimension {}", new Object[]{n6, n7, n7, n5});
                throw new ArrayIndexOutOfBoundsException("Index (" + n6 + ") out of range [-" + n7 + "," + n7 + ") in dimension " + n5);
            }
            n3 = n3 * nArray2[n5] + n6;
            if (n6 < 0) {
                n3 += n7;
            }
            ++n5;
        }
        while (n5 < nArray2.length) {
            n3 *= nArray2[n5];
            ++n5;
        }
        return n3;
    }

    protected int[] getNDPosition(int n) {
        if (n >= this.size && this.dataShape != null && n >= this.dataSize) {
            abstractLogger.error("Index provided {} is larger then the size of the containing array {}", (Object)n, (Object)this.dataSize);
            throw new IllegalArgumentException("Index provided " + n + "is larger then the size of the containing array " + this.dataSize);
        }
        if (this.shape.length == 1) {
            return new int[]{n};
        }
        int[] nArray = this.dataShape == null ? this.shape : this.dataShape;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = n;
        --n2;
        while (n2 > 0) {
            nArray2[n2] = n3 % nArray[n2];
            n3 /= nArray[n2];
            --n2;
        }
        nArray2[0] = n3;
        return nArray2;
    }

    protected int to1DIndex(int n) {
        if (this.shape.length > 1 && this.dataShape != null) {
            return this.get1DIndex(this.getNDPosition(n));
        }
        if (n < 0 || n >= this.size) {
            abstractLogger.error("Index out of bounds: {} cf {}", (Object)n, (Object)this.size);
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " cf " + this.size);
        }
        return n;
    }

    public int checkAxis(int n) {
        int n2 = this.shape.length;
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            abstractLogger.error("Axis {} given is out of range [0, {})", (Object)n, (Object)n2);
            throw new IndexOutOfBoundsException("Axis " + n + " given is out of range [0, " + n2 + ")");
        }
        return n;
    }

    protected StringBuilder sanitizeLine(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 1023) {
            int n = stringBuilder.length() - 1024 + 6;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.subSequence(0, (stringBuilder.length() - n) / 2));
            stringBuilder2.append("\t...\t");
            stringBuilder2.append(stringBuilder.subSequence((stringBuilder.length() + n) / 2, stringBuilder.length()));
            stringBuilder2.append('\n');
            return stringBuilder2;
        }
        return stringBuilder.append("\n");
    }

    public abstract String getString(int ... var1);

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            stringBuilder.append("Dataset '");
            stringBuilder.append(this.name);
            stringBuilder.append("' has shape [");
        } else {
            stringBuilder.append("Dataset shape is [");
        }
        int n2 = n = this.shape == null ? 0 : this.shape.length;
        if (n > 0 && this.shape[0] > 0) {
            stringBuilder.append(this.shape[0]);
        }
        int n3 = 1;
        while (n3 < n) {
            stringBuilder.append(", " + this.shape[n3]);
            ++n3;
        }
        stringBuilder.append("]\n");
        if (this.size == 0) {
            return stringBuilder.toString();
        }
        if (n == 1) {
            stringBuilder2.append("[\t");
            stringBuilder2.append(this.getString(0));
            n3 = 1;
            while (n3 < this.shape[0]) {
                stringBuilder2.append(",\t");
                stringBuilder2.append(this.getString(n3++));
            }
            stringBuilder2.append("\t]");
            stringBuilder.append((CharSequence)this.sanitizeLine(stringBuilder2));
            stringBuilder2.delete(0, stringBuilder2.length());
        } else if (n == 2) {
            n3 = 0;
            while (n3 < this.shape[0]) {
                stringBuilder2.append("|\t");
                stringBuilder2.append(this.getString(n3, 0));
                int n4 = 1;
                while (n4 < this.shape[1]) {
                    stringBuilder2.append("|\t");
                    stringBuilder2.append(this.getString(n3, n4++));
                }
                stringBuilder2.append("\t|");
                stringBuilder.append((CharSequence)this.sanitizeLine(stringBuilder2));
                stringBuilder2.delete(0, stringBuilder2.length());
                ++n3;
            }
        } else if (n == 3) {
            n3 = 0;
            while (n3 < this.shape[2]) {
                stringBuilder.append("\t----------");
                ++n3;
            }
            stringBuilder.append('\n');
            n3 = 0;
            while (n3 < this.shape[0]) {
                int n5 = 0;
                while (n5 < this.shape[1]) {
                    stringBuilder2.append("|\t");
                    stringBuilder2.append(this.getString(n3, n5, 0));
                    int n6 = 1;
                    while (n6 < this.shape[2]) {
                        stringBuilder2.append(",\t");
                        stringBuilder2.append(this.getString(n3, n5, n6++));
                    }
                    stringBuilder2.append("\t|");
                    stringBuilder.append((CharSequence)this.sanitizeLine(stringBuilder2));
                    stringBuilder2.delete(0, stringBuilder2.length());
                    ++n5;
                }
                n5 = 0;
                while (n5 < this.shape[2]) {
                    stringBuilder.append("\t----------");
                    ++n5;
                }
                stringBuilder.append('\n');
                ++n3;
            }
        } else if (n > 3) {
            stringBuilder.append("<" + this.shape[0]);
            n3 = 1;
            while (n3 < n) {
                stringBuilder.append(String.valueOf(this.shape[n3]) + ",");
                ++n3;
            }
            stringBuilder.append(">\n");
            stringBuilder2.append("[" + this.getString(0));
            n3 = 1;
            while (n3 < this.size) {
                stringBuilder2.append("," + this.getString(n3++));
            }
            stringBuilder2.append("]");
            stringBuilder.append((CharSequence)this.sanitizeLine(stringBuilder2));
        }
        return stringBuilder.toString();
    }

    public void setDirty() {
        this.storedValues = null;
    }

    protected boolean isPositionInShape(int ... nArray) {
        int n = nArray.length;
        if (n > this.shape.length) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.shape[n2];
            if (nArray[n2] < 0) {
                int n4 = n2;
                nArray[n4] = nArray[n4] + n3;
            }
            if (nArray[n2] < 0) {
                abstractLogger.error("Index ({}) out of range [-{},{}) in dimension {}", new Object[]{nArray[n2], n3, n3, n2});
                throw new ArrayIndexOutOfBoundsException("Index (" + nArray[n2] + ") out of range [-" + n3 + "," + n3 + ") in dimension " + n2);
            }
            if (nArray[n2] >= n3) {
                if (this.extendible) {
                    return false;
                }
                abstractLogger.error("Index ({}) out of range [-{},{}) in dimension {}", new Object[]{nArray[n2], n3, n3, n2});
                throw new ArrayIndexOutOfBoundsException("Index (" + nArray[n2] + ") out of range [-" + n3 + "," + n3 + ") in dimension " + n2);
            }
            ++n2;
        }
        return true;
    }

    protected boolean isShapeInDataShape(int[] nArray) {
        int n = 0;
        while (n < this.dataShape.length) {
            if (nArray[n] >= this.dataShape[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public AbstractDataset squeeze() {
        return this.squeeze(false);
    }

    public AbstractDataset squeeze(boolean bl) {
        int[] nArray = AbstractDataset.squeezeShape(this.shape, bl);
        if (nArray != null) {
            this.shape = nArray;
        }
        return this;
    }

    protected static int[] squeezeShape(int[] nArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = nArray.length;
        if (bl) {
            n = n3 - 1;
            while (n >= 0) {
                if (nArray[n] == 1) {
                    ++n2;
                    --n;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < n3) {
                if (nArray[n] == 1) {
                    ++n2;
                }
                ++n;
            }
        }
        if (n2 == 0 || n3 == n2) {
            return null;
        }
        int[] nArray2 = new int[n3 - n2];
        if (bl) {
            n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                if (nArray[n6] > 1) {
                    nArray2[n5++] = nArray[n6];
                }
                ++n6;
            }
        }
        return nArray2;
    }

    public void checkCompatibility(AbstractDataset abstractDataset) throws IllegalArgumentException {
        AbstractDataset.checkCompatibility(this, abstractDataset);
    }

    public static void checkCompatibility(IDataset iDataset, IDataset iDataset2) throws IllegalArgumentException {
        if (iDataset.getRank() != iDataset2.getRank()) {
            abstractLogger.error("Incompatible ranks");
            throw new IllegalArgumentException("Incompatible ranks");
        }
        if (!Arrays.equals(iDataset.getShape(), iDataset2.getShape())) {
            abstractLogger.error("Shapes do not match");
            throw new IllegalArgumentException("Shapes do not match");
        }
    }

    public AbstractDataset reshape(int ... nArray) {
        AbstractDataset abstractDataset = this.getView();
        abstractDataset.setShape(nArray);
        return abstractDataset;
    }

    public abstract void resize(int ... var1);

    public static AbstractDataset array(Object object) {
        int n = AbstractDataset.getDTypeFromObject(object);
        return AbstractDataset.array(object, n);
    }

    public static AbstractDataset array(Object object, int n) {
        switch (n) {
            case 0: {
                return BooleanDataset.createFromObject(object);
            }
            case 1: {
                return ByteDataset.createFromObject(object);
            }
            case 2: {
                return ShortDataset.createFromObject(object);
            }
            case 3: {
                return IntegerDataset.createFromObject(object);
            }
            case 4: {
                return LongDataset.createFromObject(object);
            }
            case 100: {
                return CompoundByteDataset.createFromObject(object);
            }
            case 200: {
                return CompoundShortDataset.createFromObject(object);
            }
            case 300: {
                return CompoundIntegerDataset.createFromObject(object);
            }
            case 400: {
                return CompoundLongDataset.createFromObject(object);
            }
            case 5: {
                return FloatDataset.createFromObject(object);
            }
            case 6: {
                return DoubleDataset.createFromObject(object);
            }
            case 500: {
                return CompoundFloatDataset.createFromObject(object);
            }
            case 600: {
                return CompoundDoubleDataset.createFromObject(object);
            }
            case 7: {
                return ComplexFloatDataset.createFromObject(object);
            }
            case 8: {
                return ComplexDoubleDataset.createFromObject(object);
            }
        }
        return null;
    }

    public static AbstractDataset createFromList(List<?> list) {
        if (list == null || list.size() == 0) {
            abstractLogger.error("No list or zero-length list given");
            throw new IllegalArgumentException("No list or zero-length list given");
        }
        Object obj = list.get(0);
        if (obj instanceof Number || obj instanceof Complex) {
            int n = AbstractDataset.getDTypeFromClass(obj.getClass());
            int n2 = list.size();
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n2}, n);
            int n3 = 0;
            for (Object obj2 : list) {
                abstractDataset.setObjectAbs(obj2, n3++);
            }
            return abstractDataset;
        }
        abstractLogger.error("Class of list element not supported");
        throw new IllegalArgumentException("Class of list element not supported");
    }

    public static AbstractDataset zeros(int[] nArray, int n) {
        switch (n) {
            case 0: {
                return new BooleanDataset(nArray);
            }
            case 1: 
            case 100: {
                return new ByteDataset(nArray);
            }
            case 2: 
            case 200: {
                return new ShortDataset(nArray);
            }
            case 3: 
            case 300: {
                return new IntegerDataset(nArray);
            }
            case 4: 
            case 400: {
                return new LongDataset(nArray);
            }
            case 5: 
            case 500: {
                return new FloatDataset(nArray);
            }
            case 6: 
            case 600: {
                return new DoubleDataset(nArray);
            }
            case 7: {
                return new ComplexFloatDataset(nArray);
            }
            case 8: {
                return new ComplexDoubleDataset(nArray);
            }
        }
        abstractLogger.error("dtype not known or unsupported");
        throw new IllegalArgumentException("dtype not known or unsupported");
    }

    public static AbstractDataset zeros(int n, int[] nArray, int n2) {
        if (n == 1) {
            return AbstractDataset.zeros(nArray, n2);
        }
        switch (n2) {
            case 1: 
            case 100: {
                return new CompoundByteDataset(n, nArray);
            }
            case 2: 
            case 200: {
                return new CompoundShortDataset(n, nArray);
            }
            case 3: 
            case 300: {
                return new CompoundIntegerDataset(n, nArray);
            }
            case 4: 
            case 400: {
                return new CompoundLongDataset(n, nArray);
            }
            case 5: 
            case 500: {
                return new CompoundFloatDataset(n, nArray);
            }
            case 6: 
            case 600: {
                return new CompoundDoubleDataset(n, nArray);
            }
            case 7: {
                if (n != 2) {
                    abstractLogger.error("Number of elements not compatible with complex type");
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexFloatDataset(nArray);
            }
            case 8: {
                if (n != 2) {
                    abstractLogger.error("Number of elements not compatible with complex type");
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexDoubleDataset(nArray);
            }
        }
        abstractLogger.error("dtype not a known compound type");
        throw new IllegalArgumentException("dtype not a known compound type");
    }

    public static AbstractDataset zeros(AbstractDataset abstractDataset) {
        return AbstractDataset.zeros(abstractDataset, abstractDataset.getDtype());
    }

    public static AbstractDataset zeros(AbstractDataset abstractDataset, int n) {
        int[] nArray = abstractDataset.shape;
        int n2 = abstractDataset.getElementsPerItem();
        switch (n) {
            case 0: {
                return new BooleanDataset(nArray);
            }
            case 1: {
                return new ByteDataset(nArray);
            }
            case 2: {
                return new ShortDataset(nArray);
            }
            case 3: {
                return new IntegerDataset(nArray);
            }
            case 4: {
                return new LongDataset(nArray);
            }
            case 5: {
                return new FloatDataset(nArray);
            }
            case 6: {
                return new DoubleDataset(nArray);
            }
            case 7: {
                return new ComplexFloatDataset(nArray);
            }
            case 8: {
                return new ComplexDoubleDataset(nArray);
            }
            case 100: {
                return new CompoundByteDataset(n2, nArray);
            }
            case 200: {
                return new CompoundShortDataset(n2, nArray);
            }
            case 300: {
                return new CompoundIntegerDataset(n2, nArray);
            }
            case 400: {
                return new CompoundLongDataset(n2, nArray);
            }
            case 500: {
                return new CompoundFloatDataset(n2, nArray);
            }
            case 600: {
                return new CompoundDoubleDataset(n2, nArray);
            }
        }
        abstractLogger.error("dtype not known");
        throw new IllegalArgumentException("dtype not known");
    }

    public static AbstractDataset ones(AbstractDataset abstractDataset) {
        int n = abstractDataset.getDtype();
        int[] nArray = abstractDataset.shape;
        int n2 = abstractDataset.getElementsPerItem();
        switch (n) {
            case 0: {
                return BooleanDataset.ones(nArray);
            }
            case 1: {
                return ByteDataset.ones(nArray);
            }
            case 2: {
                return ShortDataset.ones(nArray);
            }
            case 3: {
                return IntegerDataset.ones(nArray);
            }
            case 4: {
                return LongDataset.ones(nArray);
            }
            case 100: {
                return CompoundByteDataset.ones(n2, nArray);
            }
            case 200: {
                return CompoundShortDataset.ones(n2, nArray);
            }
            case 300: {
                return CompoundIntegerDataset.ones(n2, nArray);
            }
            case 400: {
                return CompoundLongDataset.ones(n2, nArray);
            }
            case 5: {
                return FloatDataset.ones(nArray);
            }
            case 6: {
                return DoubleDataset.ones(nArray);
            }
            case 7: {
                return ComplexFloatDataset.ones(nArray);
            }
            case 8: {
                return ComplexDoubleDataset.ones(nArray);
            }
            case 500: {
                return CompoundFloatDataset.ones(n2, nArray);
            }
            case 600: {
                return CompoundDoubleDataset.ones(n2, nArray);
            }
        }
        abstractLogger.error("dtype not known");
        throw new IllegalArgumentException("dtype not known");
    }

    public static AbstractDataset ones(int[] nArray, int n) {
        switch (n) {
            case 0: {
                return BooleanDataset.ones(nArray);
            }
            case 1: {
                return ByteDataset.ones(nArray);
            }
            case 2: {
                return ShortDataset.ones(nArray);
            }
            case 3: {
                return IntegerDataset.ones(nArray);
            }
            case 4: {
                return LongDataset.ones(nArray);
            }
            case 5: {
                return FloatDataset.ones(nArray);
            }
            case 6: {
                return DoubleDataset.ones(nArray);
            }
            case 7: {
                return ComplexFloatDataset.ones(nArray);
            }
            case 8: {
                return ComplexDoubleDataset.ones(nArray);
            }
        }
        abstractLogger.error("dtype not known");
        throw new IllegalArgumentException("dtype not known");
    }

    public static AbstractDataset arange(double d, int n) {
        return AbstractDataset.arange(0.0, d, 1.0, n);
    }

    public static int calcSteps(double d, double d2, double d3) {
        if (d3 > 0.0) {
            return (int)Math.ceil((d2 - d) / d3);
        }
        return (int)Math.ceil((d2 - d) / d3);
    }

    public static AbstractDataset arange(double d, double d2, double d3, int n) {
        if (d3 > 0.0 != d <= d2) {
            return null;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                return ByteDataset.arange(d, d2, d3);
            }
            case 2: {
                return ShortDataset.arange(d, d2, d3);
            }
            case 3: {
                return IntegerDataset.arange(d, d2, d3);
            }
            case 4: {
                return LongDataset.arange(d, d2, d3);
            }
            case 5: {
                return FloatDataset.arange(d, d2, d3);
            }
            case 6: {
                return DoubleDataset.arange(d, d2, d3);
            }
            case 7: {
                return ComplexFloatDataset.arange(d, d2, d3);
            }
            case 8: {
                return ComplexDoubleDataset.arange(d, d2, d3);
            }
        }
        abstractLogger.error("dtype not known");
        throw new IllegalArgumentException("dtype not known");
    }

    public boolean isComplex() {
        int n = this.getDtype();
        return n == 7 || n == 8;
    }

    public AbstractDataset real() {
        return this;
    }

    public abstract AbstractDataset fill(Object var1);

    public abstract boolean getElementBooleanAbs(int var1);

    public abstract double getElementDoubleAbs(int var1);

    public abstract long getElementLongAbs(int var1);

    public abstract Object getObjectAbs(int var1);

    public abstract void setObjectAbs(Object var1, int var2);

    public AbstractDataset sort(Integer n) {
        int n2 = this.getDtype();
        if (n2 == 0 || n2 == 7 || n2 == 8 || this.getElementsPerItem() != 1) {
            throw new UnsupportedOperationException("Cannot sort dataset");
        }
        if (n == null) {
            if (this.dataShape != null) {
                AbstractDataset abstractDataset = this.clone();
                this.odata = abstractDataset.odata;
                this.setData();
                this.dataShape = null;
            }
            switch (n2) {
                case 1: {
                    Arrays.sort((byte[])this.odata);
                    break;
                }
                case 2: {
                    Arrays.sort((short[])this.odata);
                    break;
                }
                case 3: {
                    Arrays.sort((int[])this.odata);
                    break;
                }
                case 4: {
                    Arrays.sort((long[])this.odata);
                    break;
                }
                case 5: {
                    Arrays.sort((float[])this.odata);
                    break;
                }
                case 6: {
                    Arrays.sort((double[])this.odata);
                }
            }
        } else {
            n = this.checkAxis(n);
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{this.shape[n]}, n2);
            Object object = abstractDataset.getBuffer();
            PositionIterator positionIterator = this.getPositionIterator(n);
            int[] nArray = positionIterator.getPos();
            boolean[] blArray = positionIterator.getOmit();
            while (positionIterator.hasNext()) {
                this.copyItemsFromAxes(nArray, blArray, abstractDataset);
                switch (n2) {
                    case 1: {
                        Arrays.sort((byte[])object);
                        break;
                    }
                    case 2: {
                        Arrays.sort((short[])object);
                        break;
                    }
                    case 3: {
                        Arrays.sort((int[])object);
                        break;
                    }
                    case 4: {
                        Arrays.sort((long[])object);
                        break;
                    }
                    case 5: {
                        Arrays.sort((float[])object);
                        break;
                    }
                    case 6: {
                        Arrays.sort((double[])object);
                    }
                }
                this.setItemsOnAxes(nArray, blArray, abstractDataset.getBuffer());
            }
        }
        return this;
    }

    private static int createSliceParameters(PyObject pyObject, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, boolean[] blArray) {
        PyObject[] pyObjectArray;
        if (pyObject instanceof PyTuple) {
            pyObjectArray = ((PyTuple)pyObject).getArray();
        } else {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = pyObject;
        }
        PyObject[] pyObjectArray3 = pyObjectArray;
        int n = nArray.length;
        int n2 = pyObjectArray3.length > n ? n : pyObjectArray3.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (pyObjectArray3[n4] instanceof PyInteger) {
                blArray[n4] = true;
                nArray2[n4] = ((PyInteger)pyObjectArray3[n4]).asInt();
                if (nArray2[n4] < -nArray[n4] || nArray2[n4] >= nArray[n4]) {
                    abstractLogger.error("The value {} is not within the dataset's bounds", (Object)nArray2);
                    throw new PyException(Py.IndexError);
                }
                if (nArray2[n4] < 0) {
                    int n5 = n4;
                    nArray2[n5] = nArray2[n5] + nArray[n4];
                }
                nArray3[n4] = nArray2[n4] + 1;
                nArray4[n4] = 1;
            } else if (pyObjectArray3[n4] instanceof PySlice) {
                blArray[n4] = false;
                ++n3;
                PySlice pySlice = (PySlice)pyObjectArray3[n4];
                nArray4[n4] = pySlice.step instanceof PyNone ? 1 : ((PyInteger)pySlice.step).getValue();
                nArray2[n4] = pySlice.start instanceof PyNone ? (nArray4[n4] > 0 ? 0 : nArray[n4] - 1) : ((PyInteger)pySlice.start).getValue();
                nArray3[n4] = pySlice.stop instanceof PyNone ? (nArray4[n4] > 0 ? nArray[n4] : -1) : ((PyInteger)pySlice.stop).getValue();
            }
            ++n4;
        }
        while (n4 < n) {
            blArray[n4] = false;
            ++n3;
            nArray2[n4] = 0;
            nArray3[n4] = nArray[n4];
            nArray4[n4] = 1;
            ++n4;
        }
        return n3;
    }

    @Override
    public abstract AbstractDataset getSlice(int[] var1, int[] var2, int[] var3);

    public AbstractDataset getSlice(PyObject pyObject) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean[] blArray = new boolean[n];
        int n2 = AbstractDataset.createSliceParameters(pyObject, this.shape, nArray, nArray2, nArray3, blArray);
        AbstractDataset abstractDataset = this.getSlice(nArray, nArray2, nArray3);
        if (n2 < n) {
            int[] nArray4 = abstractDataset.shape;
            int[] nArray5 = new int[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                if (!blArray[n4]) {
                    nArray5[n3++] = nArray4[n4];
                }
                ++n4;
            }
            abstractDataset.setShape(nArray5);
        }
        return abstractDataset;
    }

    public void setSlice(PyObject pyObject, Object object) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean[] blArray = new boolean[n];
        AbstractDataset.createSliceParameters(pyObject, this.shape, nArray, nArray2, nArray3, blArray);
        if ((this.isComplex() || this.getElementsPerItem() == 1) && object instanceof PySequence) {
            object = AbstractDataset.array(object, this.getDtype());
        }
        this.setSlice(nArray, nArray2, nArray3, object);
    }

    public abstract void fillDataset(AbstractDataset var1, IndexIterator var2);

    public boolean all() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.getElementBooleanAbs(indexIterator.index)) continue;
            return false;
        }
        return true;
    }

    public BooleanDataset all(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        BooleanDataset booleanDataset = new BooleanDataset(nArray2);
        IndexIterator indexIterator = booleanDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            boolean bl = true;
            int n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5++;
                if (this.getDouble(nArray4) != 0.0) continue;
                bl = false;
                break;
            }
            booleanDataset.set(bl, nArray3);
        }
        return booleanDataset;
    }

    public boolean any() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!this.getElementBooleanAbs(indexIterator.index)) continue;
            return true;
        }
        return false;
    }

    public BooleanDataset any(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        BooleanDataset booleanDataset = new BooleanDataset(nArray2);
        IndexIterator indexIterator = booleanDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            boolean bl = false;
            int n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5++;
                if (this.getDouble(nArray4) == 0.0) continue;
                bl = true;
                break;
            }
            booleanDataset.set(bl, nArray3);
        }
        return booleanDataset;
    }

    public abstract AbstractDataset iadd(Object var1);

    public abstract AbstractDataset isubtract(Object var1);

    public abstract AbstractDataset imultiply(Object var1);

    public abstract AbstractDataset idivide(Object var1);

    public AbstractDataset ifloorDivide(Object object) {
        return this.idivide(object).ifloor();
    }

    public abstract AbstractDataset iremainder(Object var1);

    public abstract AbstractDataset ifloor();

    public abstract AbstractDataset ipower(Object var1);

    public abstract double residual(Object var1);

    protected Object getStoredValue(String string) {
        if (this.storedValues == null) {
            return null;
        }
        return this.storedValues.get(string);
    }

    protected void setStoredValue(String string, Object object) {
        if (this.storedValues == null) {
            this.storedValues = new HashMap();
        }
        this.storedValues.put(string, object);
    }

    protected void calculateSummaryStats() {
        IndexIterator indexIterator = this.getIterator();
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        while (indexIterator.hasNext()) {
            double d = this.getElementDoubleAbs(indexIterator.index);
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            summaryStatistics.addValue(d);
        }
        this.setStoredValue("stats", summaryStatistics);
    }

    protected void calculateSummaryStats(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        if (nArray2 == null) {
            nArray2 = nArray;
        }
        int n4 = this.getDtype();
        IntegerDataset integerDataset = new IntegerDataset(nArray2);
        AbstractDataset abstractDataset = AbstractDataset.zeros(nArray2, n4);
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(nArray2, n4);
        IntegerDataset integerDataset2 = new IntegerDataset(nArray2);
        IntegerDataset integerDataset3 = new IntegerDataset(nArray2);
        AbstractDataset abstractDataset3 = AbstractDataset.zeros(nArray2, AbstractDataset.getLargestDType(n4));
        DoubleDataset doubleDataset = new DoubleDataset(nArray2);
        DoubleDataset doubleDataset2 = new DoubleDataset(nArray2);
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n5 = 0;
            while (n5 < n) {
                nArray4[n5] = nArray3[n5];
                ++n5;
            }
            nArray4[n5++] = 0;
            while (n5 < n2) {
                nArray4[n5] = nArray3[n5 - 1];
                ++n5;
            }
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            int n6 = 0;
            while (n6 < n3) {
                nArray4[n] = n6;
                double d = this.getDouble(nArray4);
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    summaryStatistics.addValue(d);
                }
                ++n6;
            }
            integerDataset.setAbs((int)summaryStatistics.getN(), indexIterator.index);
            double d = summaryStatistics.getMax();
            abstractDataset.setObjectAbs(d, indexIterator.index);
            int n7 = 0;
            while (n7 < n3) {
                nArray4[n] = n7++;
                double d2 = this.getDouble(nArray4);
                if (d2 != d) continue;
                integerDataset2.setAbs(n7, indexIterator.index);
                break;
            }
            double d3 = summaryStatistics.getMin();
            abstractDataset2.setObjectAbs(d, indexIterator.index);
            int n8 = 0;
            while (n8 < n3) {
                nArray4[n] = n8++;
                double d4 = this.getDouble(nArray4);
                if (d4 != d3) continue;
                integerDataset3.setAbs(n8, indexIterator.index);
                break;
            }
            abstractDataset3.setObjectAbs(summaryStatistics.getSum(), indexIterator.index);
            doubleDataset.setAbs(summaryStatistics.getMean(), indexIterator.index);
            doubleDataset2.setAbs(summaryStatistics.getVariance(), indexIterator.index);
        }
        this.setStoredValue("count-" + n, integerDataset);
        this.storedValues.put("max-" + n, abstractDataset);
        this.storedValues.put("min-" + n, abstractDataset2);
        this.storedValues.put("sum-" + n, abstractDataset3);
        this.storedValues.put("mean-" + n, doubleDataset);
        this.storedValues.put("var-" + n, doubleDataset2);
        this.storedValues.put("maxIndex-" + n, integerDataset2);
        this.storedValues.put("minIndex-" + n, integerDataset3);
    }

    private Number fromDoubleToNumber(double d) {
        switch (this.getDtype()) {
            case 0: 
            case 3: {
                return new Integer((int)d);
            }
            case 1: {
                return new Byte((byte)d);
            }
            case 2: {
                return new Short((short)d);
            }
            case 4: {
                return new Long((long)d);
            }
            case 5: {
                return new Float((float)d);
            }
            case 6: {
                return new Double(d);
            }
        }
        return null;
    }

    private SummaryStatistics getStatistics() {
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.getStoredValue("stats");
        if (summaryStatistics == null) {
            this.calculateSummaryStats();
            summaryStatistics = (SummaryStatistics)this.getStoredValue("stats");
        }
        return summaryStatistics;
    }

    private Object getStatistics(int n, String string) {
        n = this.checkAxis(n);
        Object object = this.getStoredValue(string);
        if (object == null) {
            this.calculateSummaryStats(n);
            object = this.getStoredValue(string);
        }
        return object;
    }

    @Override
    public Number max() {
        return this.fromDoubleToNumber(this.getStatistics().getMax());
    }

    public AbstractDataset max(int n) {
        return (AbstractDataset)this.getStatistics(n, "max-" + n);
    }

    @Override
    public Number min() {
        return this.fromDoubleToNumber(this.getStatistics().getMin());
    }

    public AbstractDataset min(int n) {
        return (AbstractDataset)this.getStatistics(n, "min-" + n);
    }

    public int argMax() {
        return this.get1DIndex(this.maxPos());
    }

    public IntegerDataset argMax(int n) {
        return (IntegerDataset)this.getStatistics(n, "maxIndex-" + n);
    }

    public int argMin() {
        return this.get1DIndex(this.minPos());
    }

    public IntegerDataset argMin(int n) {
        return (IntegerDataset)this.getStatistics(n, "minIndex-" + n);
    }

    public abstract boolean containsInfs();

    public abstract boolean containsNans();

    public Number peakToPeak() {
        return this.fromDoubleToNumber(this.max().doubleValue() - this.min().doubleValue());
    }

    public AbstractDataset peakToPeak(int n) {
        return Maths.subtract(this.max(n), this.min(n));
    }

    public Object sum() {
        return this.fromDoubleToNumber(this.getStatistics().getSum());
    }

    public AbstractDataset sum(int n) {
        return (AbstractDataset)this.getStatistics(n, "sum-" + n);
    }

    public Object product() {
        return Stats.product(this);
    }

    public AbstractDataset product(int n) {
        return Stats.product(this, n);
    }

    public Object mean() {
        return this.getStatistics().getMean();
    }

    public AbstractDataset mean(int n) {
        return (AbstractDataset)this.getStatistics(n, "mean-" + n);
    }

    public Number variance() {
        return this.variance(false);
    }

    public Number variance(boolean bl) {
        SummaryStatistics summaryStatistics = this.getStatistics();
        if (bl) {
            StorelessUnivariateStatistic storelessUnivariateStatistic = summaryStatistics.getVarianceImpl();
            summaryStatistics.setVarianceImpl((StorelessUnivariateStatistic)new Variance(false));
            Double d = summaryStatistics.getVariance();
            summaryStatistics.setVarianceImpl(storelessUnivariateStatistic);
            return d;
        }
        return summaryStatistics.getVariance();
    }

    public AbstractDataset variance(int n) {
        return (AbstractDataset)this.getStatistics(n, "var-" + n);
    }

    public Number stdDeviation() {
        return Math.sqrt(this.variance().doubleValue());
    }

    public Number stdDeviation(boolean bl) {
        return Math.sqrt(this.variance(bl).doubleValue());
    }

    public AbstractDataset stdDeviation(int n) {
        AbstractDataset abstractDataset = (AbstractDataset)this.getStatistics(n, "var-" + n);
        return Maths.sqrt(abstractDataset);
    }

    public Number rootMeanSquare() {
        SummaryStatistics summaryStatistics = this.getStatistics();
        double d = summaryStatistics.getMean();
        return Math.sqrt(summaryStatistics.getVariance() + d * d);
    }

    public AbstractDataset rootMeanSquare(int n) {
        AbstractDataset abstractDataset = (AbstractDataset)this.getStatistics(n, "var-" + n);
        AbstractDataset abstractDataset2 = (AbstractDataset)this.getStatistics(n, "mean-" + n);
        AbstractDataset abstractDataset3 = Maths.power((Object)abstractDataset2, 2);
        return Maths.sqrt(abstractDataset3.iadd(abstractDataset));
    }

    protected static boolean areShapesCompatible(int[] nArray, int[] nArray2, int n) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n && nArray[n3] != nArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public AbstractDataset put(int[] nArray, Object[] objectArray) {
        return DatasetUtils.put(this, nArray, objectArray);
    }

    public AbstractDataset take(int[] nArray, Integer n) {
        return DatasetUtils.take(this, nArray, n);
    }

    protected abstract void setItemDirect(int var1, int var2, Object var3);
}

