/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImage;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;

public class AWTImageUtils {
    private AWTImageUtils() {
    }

    public static void createDatasets(Raster raster, AbstractDataset[] abstractDatasetArray, int n, boolean bl) {
        int n2 = abstractDatasetArray.length;
        int n3 = raster.getHeight();
        int n4 = raster.getWidth();
        int n5 = 0;
        while (n5 < n2) {
            switch (n) {
                case 0: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = bl ? new ByteDataset(integerDataset) : new ShortDataset(integerDataset);
                    break;
                }
                case 2: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = new ShortDataset(integerDataset);
                    break;
                }
                case 1: {
                    IntegerDataset integerDataset = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    abstractDatasetArray[n5] = bl ? new ShortDataset(integerDataset) : integerDataset;
                    break;
                }
                case 3: {
                    abstractDatasetArray[n5] = new IntegerDataset(raster.getSamples(0, 0, n4, n3, n5, (int[])null), new int[]{n3, n4});
                    break;
                }
                case 5: {
                    abstractDatasetArray[n5] = new DoubleDataset(raster.getSamples(0, 0, n4, n3, n5, (double[])null), n3, n4);
                    break;
                }
                case 4: {
                    abstractDatasetArray[n5] = new FloatDataset(raster.getSamples(0, 0, n4, n3, n5, (float[])null), n3, n4);
                }
            }
            ++n5;
        }
    }

    public static AbstractDataset[] makeDatasets(BufferedImage bufferedImage, boolean bl) {
        Raster raster = bufferedImage.getData();
        SampleModel sampleModel = raster.getSampleModel();
        int n = sampleModel.getNumBands();
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[n];
        AWTImageUtils.createDatasets(raster, abstractDatasetArray, sampleModel.getDataType(), bl);
        return abstractDatasetArray;
    }

    public static BufferedImage makeBufferedImage(AbstractDataset abstractDataset, int n) {
        Object object;
        int[] nArray = abstractDataset.getShape();
        int n2 = nArray[0];
        int n3 = nArray.length == 1 ? 1 : nArray[1];
        int n4 = abstractDataset.getSize();
        BufferedImage bufferedImage = null;
        DataBuffer dataBuffer = null;
        SampleModel sampleModel = null;
        if (abstractDataset instanceof RGBDataset) {
            object = (RGBDataset)abstractDataset;
            dataBuffer = new DataBufferInt(n4);
            sampleModel = new SinglePixelPackedSampleModel(3, n3, n2, new int[]{0xFF0000, 65280, 255});
            bufferedImage = new BufferedImage(n3, n2, 1);
            short s = ((RGBDataset)object).max().shortValue();
            IndexIterator indexIterator = ((AbstractCompoundDataset)object).getIterator(true);
            int[] nArray2 = indexIterator.getPos();
            short[] sArray = ((CompoundShortDataset)object).getData();
            if (s < 256) {
                while (indexIterator.hasNext()) {
                    int n5 = indexIterator.index;
                    int n6 = (sArray[n5] & 0xFF) << 16 & (sArray[n5 + 1] & 0xFF) << 8 & (sArray[n5 + 2] & 0xFF);
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n6, dataBuffer);
                }
            } else {
                int n7 = 0;
                while (s >= 256) {
                    ++n7;
                    s = (short)(s >> 2);
                }
                while (indexIterator.hasNext()) {
                    int n8 = indexIterator.index;
                    int n9 = (sArray[n8] >> n7 & 0xFF) << 16 & (sArray[n8 + 1] >> n7 & 0xFF) << 8 & (sArray[n8 + 2] >> n7 & 0xFF);
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n9, dataBuffer);
                }
            }
        } else {
            object = (IntegerDataset)DatasetUtils.cast(abstractDataset, 3);
            if (n <= 8) {
                dataBuffer = new DataBufferByte(n2 * n3);
                sampleModel = new PixelInterleavedSampleModel(0, n3, n2, 1, n3, new int[1]);
                bufferedImage = new BufferedImage(n3, n2, 10);
                sampleModel.setPixels(0, 0, n3, n2, ((IntegerDataset)object).getData(), dataBuffer);
            } else if (n <= 16) {
                dataBuffer = new DataBufferUShort(n2 * n3);
                sampleModel = new PixelInterleavedSampleModel(1, n3, n2, 1, n3, new int[1]);
                bufferedImage = new BufferedImage(n3, n2, 11);
                sampleModel.setPixels(0, 0, n3, n2, ((IntegerDataset)object).getData(), dataBuffer);
            }
        }
        object = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        bufferedImage.setData((Raster)object);
        return bufferedImage;
    }

    public static TiledImage makeTiledImage(AbstractDataset abstractDataset, int n) {
        IndexIterator indexIterator;
        SampleModel sampleModel;
        DataBufferInt dataBufferInt;
        Object object;
        int[] nArray = abstractDataset.getShape();
        int n2 = nArray[0];
        int n3 = nArray.length == 1 ? 1 : nArray[1];
        int n4 = abstractDataset.getSize();
        if (abstractDataset instanceof RGBDataset) {
            object = (RGBDataset)abstractDataset;
            dataBufferInt = new DataBufferInt(n4);
            sampleModel = new SinglePixelPackedSampleModel(3, n3, n2, new int[]{0xFF0000, 65280, 255});
            short s = ((RGBDataset)object).max().shortValue();
            indexIterator = ((AbstractCompoundDataset)object).getIterator(true);
            int[] nArray2 = indexIterator.getPos();
            short[] sArray = ((CompoundShortDataset)object).getData();
            if (s < 256) {
                while (indexIterator.hasNext()) {
                    int n5 = indexIterator.index;
                    int n6 = (sArray[n5] & 0xFF) << 16 & (sArray[n5 + 1] & 0xFF) << 8 & (sArray[n5 + 2] & 0xFF);
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n6, (DataBuffer)dataBufferInt);
                }
            } else {
                int n7 = 0;
                while (s >= 256) {
                    ++n7;
                    s = (short)(s >> 2);
                }
                while (indexIterator.hasNext()) {
                    int n8 = indexIterator.index;
                    int n9 = (sArray[n8] >> n7 & 0xFF) << 16 & (sArray[n8 + 1] >> n7 & 0xFF) << 8 & (sArray[n8 + 2] >> n7 & 0xFF);
                    sampleModel.setSample(nArray2[1], nArray2[0], 0, n9, (DataBuffer)dataBufferInt);
                }
            }
        } else {
            object = (IntegerDataset)DatasetUtils.cast(abstractDataset, 3);
            if (n <= 32) {
                dataBufferInt = new DataBufferInt(n4);
                sampleModel = RasterFactory.createBandedSampleModel((int)3, (int)n3, (int)n2, (int)1);
                sampleModel.setPixels(0, 0, n3, n2, ((IntegerDataset)object).getData(), (DataBuffer)dataBufferInt);
            } else {
                dataBufferInt = new DataBufferFloat(n4);
                sampleModel = RasterFactory.createBandedSampleModel((int)4, (int)n3, (int)n2, (int)1);
                FloatDataset floatDataset = new FloatDataset(abstractDataset);
                sampleModel.setPixels(0, 0, n3, n2, floatDataset.getData(), (DataBuffer)dataBufferInt);
            }
        }
        object = Raster.createWritableRaster(sampleModel, dataBufferInt, null);
        ColorModel colorModel = PlanarImage.createColorModel((SampleModel)sampleModel);
        indexIterator = new TiledImage(0, 0, n3, n2, 0, 0, sampleModel, colorModel);
        indexIterator.setData((Raster)object);
        return indexIterator;
    }
}

