/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.crystallography;

import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.crystallography.ReciprocalCell;
import uk.ac.diamond.scisoft.analysis.crystallography.UnitCell;

public class MillerSpace {
    private Matrix3d ub;
    private Matrix3d rotate;
    private Matrix3d toQ;
    private Matrix3d toMiller;
    private Matrix3d ta;
    private Matrix3d tb;

    public MillerSpace(Matrix3d matrix3d) {
        this.ub = matrix3d;
        this.rotate = new Matrix3d();
        this.toQ = new Matrix3d();
        this.toMiller = new Matrix3d();
        this.ta = new Matrix3d();
        this.tb = new Matrix3d();
        this.calcNetTransforms();
    }

    public MillerSpace(ReciprocalCell reciprocalCell, Matrix3d matrix3d) {
        Matrix3d matrix3d2;
        Matrix3d matrix3d3 = reciprocalCell.orthogonalization();
        if (matrix3d == null) {
            matrix3d2 = new Matrix3d();
            matrix3d2.setIdentity();
        } else {
            matrix3d2 = matrix3d;
        }
        this.ub = new Matrix3d();
        this.ub.mul(matrix3d2, matrix3d3);
        this.rotate = new Matrix3d();
        this.toQ = new Matrix3d();
        this.toMiller = new Matrix3d();
        this.calcNetTransforms();
    }

    public MillerSpace(UnitCell unitCell, Matrix3d matrix3d) {
        this(new ReciprocalCell(unitCell), matrix3d);
    }

    private void calcNetTransforms() {
        this.toQ.mul(this.rotate, this.ub);
        this.toQ.mul(Math.PI * 2);
        this.toMiller.invert(this.toQ);
    }

    public void setRotation(Matrix3d matrix3d) {
        this.rotate.set(matrix3d);
        this.calcNetTransforms();
    }

    public void setRotationEulerZXZ(double d, double d2, double d3) {
        this.ta.rotZ(d);
        this.tb.rotX(d2);
        this.tb.mul(this.ta);
        this.rotate.rotZ(d3);
        this.rotate.mul(this.tb);
        this.calcNetTransforms();
    }

    public void setRotationEulerZYZ(double d, double d2, double d3) {
        this.ta.rotZ(d);
        this.tb.rotY(d2);
        this.tb.mul(this.ta);
        this.rotate.rotZ(d3);
        this.rotate.mul(this.tb);
        this.calcNetTransforms();
    }

    public void setRotationYouConvention(double d, double d2, double d3, double d4) {
        this.ta.rotY(d);
        this.tb.rotX(-d2);
        this.tb.mul(this.ta);
        this.ta.rotZ(d3);
        this.tb.mul(this.ta);
        this.rotate.rotX(-d4);
        this.rotate.mul(this.tb);
        this.calcNetTransforms();
    }

    public void q(Vector3d vector3d, Vector3d vector3d2) {
        vector3d2.set((Tuple3d)vector3d);
        this.toQ.transform((Tuple3d)vector3d2);
    }

    public Vector3d q(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        this.toQ.transform((Tuple3d)vector3d);
        return vector3d;
    }

    public Vector3d q(int n, int n2, int n3) {
        return this.q((double)n, (double)n2, (double)n3);
    }

    public void h(Vector3d vector3d, Matrix3d matrix3d, Vector3d vector3d2) {
        vector3d2.set((Tuple3d)vector3d);
        vector3d2.scale(0.15915494309189535);
        if (matrix3d != null) {
            this.setRotation(matrix3d);
        }
        this.toMiller.transform((Tuple3d)vector3d2);
    }

    public void h(Vector3d vector3d, Matrix3d matrix3d, double[] dArray) {
        Vector3d vector3d2 = new Vector3d();
        this.h(vector3d, matrix3d, vector3d2);
        vector3d2.get(dArray);
    }

    public double[] h(Vector3d vector3d, Matrix3d matrix3d) {
        double[] dArray = new double[3];
        this.h(vector3d, matrix3d, dArray);
        return dArray;
    }

    public int[] integerh(Vector3d vector3d, Matrix3d matrix3d) {
        Vector3d vector3d2 = new Vector3d();
        this.h(vector3d, matrix3d, vector3d2);
        int[] nArray = new int[]{(int)Math.floor(vector3d2.x), (int)Math.floor(vector3d2.y), (int)Math.floor(vector3d2.z)};
        return nArray;
    }
}

