/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils.optimisation;

import gda.analysis.utils.optimisation.ProblemDefinition;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    static final double MUTANT_PROPORTION = 0.5;
    static final double MUTANT_SCALING = 0.5;
    static final int PARAMETER_SCALING = 10;
    static final int COMPETING_PARENTS = 2;
    static final int CROSSOVER_POINT = -1;
    static final int NUMBER_FOR_COMPETITION = 2;
    Random rand = new Random();
    private Member[] newEpoch;
    private Member[] oldEpoch;
    private int totalEpochs;
    private int epochPosition;
    private int epochSize;
    ProblemDefinition objectiveFunction;
    private BufferedReader br;
    private BufferedWriter bw;
    private int epochNumber;

    public void optimise(ProblemDefinition problemDefinition, int n, int n2, String string, double[] dArray) throws Exception {
        logger.debug("entering optimize");
        this.epochSize = n2;
        this.totalEpochs = n;
        this.objectiveFunction = problemDefinition;
        this.newEpoch = new Member[this.epochSize];
        this.bw = string != null ? new BufferedWriter(new FileWriter(string)) : null;
        if (this.bw != null) {
            this.bw.write("epoch Size = " + this.epochSize + "\n");
            this.bw.flush();
        }
        this.newEpoch[0] = new Member(dArray, this.objectiveFunction);
        this.epochNumber = 0;
        this.epochPosition = 1;
        try {
            if (this.bw != null) {
                this.writeMember(this.epochNumber, this.newEpoch[0]);
            }
            logger.debug("running epochs");
            this.runEpochs();
        }
        finally {
            if (this.bw != null) {
                this.bw.close();
            }
        }
    }

    public void optimise(ProblemDefinition problemDefinition, int n, String string) throws Exception {
        logger.debug("entering optimize");
        this.objectiveFunction = problemDefinition;
        this.br = new BufferedReader(new FileReader(string));
        this.epochSize = Integer.parseInt(this.br.readLine().split("=")[1].trim());
        this.totalEpochs = n;
        this.newEpoch = new Member[this.epochSize];
        this.epochNumber = 0;
        this.epochPosition = 0;
        logger.debug("loading epochs");
        this.readEpochs();
        this.br.close();
        this.bw = new BufferedWriter(new FileWriter(string, true));
        logger.debug("running epochs");
        try {
            if (this.epochPosition == 0) {
                this.newEpoch[0] = this.getBestMember(this.oldEpoch);
                this.writeMember(this.epochNumber, this.newEpoch[0]);
            }
            this.runEpochs();
        }
        finally {
            this.bw.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readEpochs() {
        ** GOTO lbl11
        {
            if (!this.readNextMember()) {
                return;
            }
            ++this.epochPosition;
            do {
                if (this.epochPosition < this.epochSize) continue block0;
                this.oldEpoch = this.newEpoch;
                this.newEpoch = new Member[this.oldEpoch.length];
                this.epochPosition = 0;
                ++this.epochNumber;
lbl11:
                // 2 sources

            } while (this.epochNumber < this.totalEpochs);
        }
    }

    private boolean readNextMember() {
        String string;
        try {
            string = this.br.readLine().split(":\t")[1];
        }
        catch (Exception exception) {
            return false;
        }
        this.newEpoch[this.epochPosition] = new Member(string);
        return true;
    }

    private void writeMember(int n, Member member) throws IOException {
        this.bw.append(String.valueOf(n) + ":\t" + member.saveToString() + "\n");
        this.bw.flush();
    }

    /*
     * Unable to fully structure code
     */
    private void runEpochs() throws Exception {
        ** GOTO lbl14
        {
            this.generateNextMember();
            if (this.bw != null) {
                this.writeMember(this.epochNumber, this.newEpoch[this.epochPosition - 1]);
            }
            do {
                if (this.epochPosition < this.epochSize) continue block0;
                this.oldEpoch = this.newEpoch;
                this.newEpoch = new Member[this.oldEpoch.length];
                ++this.epochNumber;
                this.newEpoch[0] = this.getBestMember(this.oldEpoch);
                if (this.bw != null) {
                    this.writeMember(this.epochNumber, this.newEpoch[0]);
                }
                this.epochPosition = 1;
lbl14:
                // 2 sources

            } while (this.epochNumber < this.totalEpochs);
        }
    }

    private Member getBestMember(Member[] memberArray) throws Exception {
        double d = memberArray[0].fitness;
        int n = 0;
        int n2 = 1;
        while (n2 < memberArray.length) {
            if (memberArray[n2] != null && memberArray[n2].fitness < d) {
                d = memberArray[n2].fitness;
                n = n2;
            }
            ++n2;
        }
        return new Member(memberArray[n].parameters, this.objectiveFunction);
    }

    private String status(Member[] memberArray) {
        double d = memberArray[0].fitness;
        double d2 = memberArray[0].fitness;
        double d3 = memberArray[0].fitness;
        int n = 1;
        int n2 = 1;
        while (n2 < memberArray.length) {
            if (memberArray[n2] != null) {
                if (memberArray[n2].fitness > d) {
                    d = memberArray[n2].fitness;
                } else if (memberArray[n2].fitness < d2) {
                    d2 = memberArray[n2].fitness;
                }
                d3 += memberArray[n2].fitness;
                ++n;
            }
            ++n2;
        }
        return "Max = " + d + " : Min = " + d2 + " : Mean = " + d3 / (double)n;
    }

    private void generateNextMember() throws Exception {
        if (this.oldEpoch == null) {
            this.newEpoch[this.epochPosition] = new Member(this.objectiveFunction);
        } else {
            int n = Math.abs(this.rand.nextInt()) % this.oldEpoch.length;
            int n2 = Math.abs(this.rand.nextInt()) % this.oldEpoch.length;
            this.newEpoch[this.epochPosition] = new Member(this.compete(this.oldEpoch), this.compete(this.oldEpoch), this.oldEpoch[n], this.oldEpoch[n2], this.objectiveFunction);
        }
        ++this.epochPosition;
    }

    private Member compete(Member[] memberArray) {
        int n = Math.abs(this.rand.nextInt()) % memberArray.length;
        int n2 = 0;
        while (n2 < 1) {
            int n3 = Math.abs(this.rand.nextInt()) % memberArray.length;
            if (memberArray[n3].fitness < memberArray[n].fitness) {
                n = n3;
            }
            ++n2;
        }
        return memberArray[n];
    }

    class Member {
        double[] parameters;
        double fitness;

        public double get(int n) {
            return this.parameters[n];
        }

        public Member(ProblemDefinition problemDefinition) throws Exception {
            this.parameters = new double[problemDefinition.getNumberOfParameters()];
            int n = 0;
            while (n < this.parameters.length) {
                this.parameters[n] = GeneticAlgorithm.this.rand.nextDouble();
                ++n;
            }
            this.fitness(problemDefinition);
        }

        public Member(double[] dArray, ProblemDefinition problemDefinition) throws Exception {
            this.parameters = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                this.parameters[n] = dArray[n];
                ++n;
            }
            this.fitness(problemDefinition);
        }

        public Member(Member member, Member member2, Member member3, Member member4, ProblemDefinition problemDefinition) throws Exception {
            this.parameters = new double[problemDefinition.getNumberOfParameters()];
            this.breed(member, member2);
            this.mutate(member3, member4);
            this.fitness(problemDefinition);
        }

        public Member(String string) {
            this.loadFromString(string);
        }

        private void fitness(ProblemDefinition problemDefinition) throws Exception {
            this.fitness = problemDefinition.eval(this.parameters);
        }

        private void breed(Member member, Member member2) {
            float f = GeneticAlgorithm.this.rand.nextFloat();
            int n = 0;
            while (n < this.parameters.length) {
                this.parameters[n] = GeneticAlgorithm.this.rand.nextFloat() > f ? member2.get(n) : member.get(n);
                ++n;
            }
        }

        private void mutate(Member member, Member member2) {
            if (GeneticAlgorithm.this.rand.nextDouble() > 0.5) {
                int n = 0;
                while (n < this.parameters.length) {
                    double d = this.parameters[n] + (member.get(n) - member2.get(n)) * 0.5;
                    d = Math.abs(d);
                    d -= Math.floor(d);
                    this.parameters[n] = d;
                    ++n;
                }
            }
        }

        public String saveToString() {
            String string = "";
            int n = 0;
            while (n < this.parameters.length) {
                string = String.valueOf(string) + this.parameters[n] + "\t";
                ++n;
            }
            string = String.valueOf(string) + this.fitness;
            return string;
        }

        public void loadFromString(String string) {
            String[] stringArray = string.split("\t");
            this.parameters = new double[stringArray.length - 1];
            int n = 0;
            while (n < stringArray.length - 1) {
                this.parameters[n] = Double.parseDouble(stringArray[n]);
                ++n;
            }
            this.fitness = Double.parseDouble(stringArray[stringArray.length - 1]);
        }

        public String toString() {
            return this.saveToString();
        }
    }
}

