/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;

public class Random {
    private static final MersenneTwister mtGenerator = new MersenneTwister();
    private static final RandomDataImpl prng = new RandomDataImpl((RandomGenerator)mtGenerator);

    public static void seed(int n) {
        mtGenerator.setSeed(n);
    }

    public static void seed(int[] nArray) {
        mtGenerator.setSeed(nArray);
    }

    public static void seed(long l) {
        mtGenerator.setSeed(l);
    }

    public static DataSet rand(int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextUniform(0.0, 1.0);
            ++n;
        }
        return dataSet;
    }

    public static DataSet randn(int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextGaussian(0.0, 1.0);
            ++n;
        }
        return dataSet;
    }

    @Deprecated
    public static DataSet randint(int n, int[] nArray) {
        return Random.random_integers(0, n - 1, nArray);
    }

    public static DataSet randint(int n, int n2, int[] nArray) {
        return Random.random_integers(n, n2 - 1, nArray);
    }

    @Deprecated
    public static DataSet random_integers(int n, int[] nArray) {
        return Random.random_integers(1, n, nArray);
    }

    public static DataSet random_integers(int n, int n2, int[] nArray) {
        DataSet dataSet = new DataSet(nArray);
        double[] dArray = dataSet.getBuffer();
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = prng.nextInt(n, n2);
            ++n3;
        }
        return dataSet;
    }

    public static DataSet exponential(double d, int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextExponential(d);
            ++n;
        }
        return dataSet;
    }

    public static DataSet poisson(double d, int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextPoisson(d);
            ++n;
        }
        return dataSet;
    }
}

