/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import Jama.Matrix;
import gda.analysis.DataSet;
import gda.analysis.functions.IFunction;
import gda.analysis.utils.DatasetMaths;
import gda.analysis.utils.IOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastSquares
implements IOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(LeastSquares.class);

    public LeastSquares(double d) {
    }

    private double chiSquared(double[] dArray, DataSet dataSet, DataSet dataSet2, DataSet dataSet3, IFunction iFunction) {
        double d = 0.0;
        double[] dArray2 = iFunction.getParameterValues();
        iFunction.setParameterValues(dArray);
        int n = 0;
        while (n < dataSet.getSize()) {
            d += Math.pow((dataSet2.get(n) - iFunction.val(dataSet.get(n))) / dataSet3.get(n++), 2.0);
        }
        iFunction.setParameterValues(dArray2);
        return d;
    }

    private double alpha(int n, int n2, DataSet dataSet, DataSet dataSet2, IFunction iFunction) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < dataSet.getDimensions()[0]) {
            double d2 = 1.0 / Math.pow(dataSet2.get(n3), 2.0);
            d2 *= iFunction.partialDeriv(n, dataSet.get(n3));
            d += (d2 *= iFunction.partialDeriv(n2, dataSet.get(n3++)));
        }
        return d;
    }

    private double alphaPrime(int n, int n2, DataSet dataSet, DataSet dataSet2, IFunction iFunction, double d) {
        if (n == n2) {
            return this.alpha(n, n2, dataSet, dataSet2, iFunction) * (1.0 + d);
        }
        return this.alpha(n, n2, dataSet, dataSet2, iFunction);
    }

    private Matrix evaluateMatrix(DataSet dataSet, DataSet dataSet2, IFunction iFunction, double d) {
        int n = iFunction.getNoOfParameters();
        Matrix matrix = new Matrix(n, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                matrix.set(n2, n3, this.alphaPrime(n2, n3, dataSet, dataSet2, iFunction, d));
                ++n3;
            }
            ++n2;
        }
        return matrix;
    }

    private double beta(int n, DataSet dataSet, DataSet dataSet2, DataSet dataSet3, IFunction iFunction) {
        double[] dArray = iFunction.getParameterValues();
        double d = 0.001;
        int n2 = n;
        dArray[n2] = dArray[n2] - d;
        double d2 = this.chiSquared(dArray, dataSet, dataSet2, dataSet3, iFunction);
        int n3 = n;
        dArray[n3] = dArray[n3] + 2.0 * d;
        double d3 = this.chiSquared(dArray, dataSet, dataSet2, dataSet3, iFunction);
        return -0.5 * (d3 - d2) / (2.0 * d);
    }

    private Matrix evaluateChiSquared(DataSet dataSet, DataSet dataSet2, DataSet dataSet3, IFunction iFunction) {
        int n = iFunction.getNoOfParameters();
        Matrix matrix = new Matrix(n, 1);
        int n2 = 0;
        while (n2 < n) {
            matrix.set(n2, 0, this.beta(n2, dataSet, dataSet2, dataSet3, iFunction));
            ++n2;
        }
        return matrix;
    }

    private double[] solveDa(DataSet dataSet, DataSet dataSet2, DataSet dataSet3, IFunction iFunction, double d) {
        Matrix matrix = this.evaluateMatrix(dataSet, dataSet3, iFunction, d);
        Matrix matrix2 = this.evaluateChiSquared(dataSet, dataSet2, dataSet3, iFunction);
        Matrix matrix3 = matrix.inverse();
        matrix3 = matrix3.times(matrix2);
        double[] dArray = new double[iFunction.getNoOfParameters()];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = matrix3.get(n, 0);
            ++n;
        }
        return dArray;
    }

    @Override
    public void Optimize(DataSet[] dataSetArray, DataSet dataSet, IFunction iFunction) {
        logger.debug("Start of Optimization");
        DataSet dataSet2 = new DataSet(dataSetArray[0].getDimensions()[0]);
        dataSet2 = DatasetMaths.add(dataSet2, 1.0);
        double[] dArray = iFunction.getParameterValues();
        double d = this.chiSquared(dArray, dataSetArray[0], dataSet, dataSet2, iFunction);
        double d2 = 0.001;
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < 1) {
            double[] dArray3 = this.solveDa(dataSetArray[0], dataSet, dataSet2, iFunction, d2);
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray2[n2] = dArray[n2] + dArray3[n2];
                ++n2;
            }
            double d3 = this.chiSquared(dArray2, dataSetArray[0], dataSet, dataSet2, iFunction);
            if (d3 >= d) {
                d2 *= 10.0;
            } else {
                d2 /= 10.0;
                d = d3;
                int n3 = 0;
                while (n3 < dArray.length) {
                    dArray[n3] = dArray2[n3];
                    ++n3;
                }
            }
            ++n;
        }
        iFunction.setParameterValues(dArray);
    }
}

