/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import gda.analysis.functions.IFunction;
import gda.analysis.utils.IOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradientDescent
implements IOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(GradientDescent.class);
    double qualityFactor = 0.0;

    public GradientDescent(double d) {
        this.qualityFactor = d;
    }

    @Override
    public void Optimize(DataSet[] dataSetArray, DataSet dataSet, IFunction iFunction) {
        double[] dArray = iFunction.getParameterValues();
        double d = iFunction.residual(true, dataSet, dataSetArray);
        double[] dArray2 = new double[dArray.length];
        double[] dArray3 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            dArray2[n] = dArray[n];
            ++n;
        }
        System.out.println(d);
        double d2 = 0.01;
        while (d2 > this.qualityFactor) {
            double d3;
            int n2 = 0;
            while (n2 < dArray2.length) {
                dArray2[n2] = iFunction.getParameterValue(n2);
                ++n2;
            }
            double d4 = 1.0E-7;
            int n3 = 0;
            while (n3 < dArray2.length) {
                dArray2[n3] = dArray2[n3] - d4;
                iFunction.setParameterValues(dArray2);
                d3 = iFunction.residual(true, dataSet, dataSetArray);
                dArray2[n3] = dArray2[n3] + 2.0 * d4;
                iFunction.setParameterValues(dArray2);
                double d5 = iFunction.residual(true, dataSet, dataSetArray);
                dArray2[n3] = dArray2[n3] - d4;
                dArray3[n3] = (d5 - d3) / (2.0 * d4);
                ++n3;
            }
            double[] dArray4 = new double[dArray.length];
            int n4 = 0;
            while (n4 < dArray2.length) {
                dArray4[n4] = dArray2[n4] - dArray3[n4] * d2;
                ++n4;
            }
            iFunction.setParameterValues(dArray4);
            d3 = iFunction.residual(true, dataSet, dataSetArray);
            if (d3 < d) {
                d2 *= 1.1;
                d = d3;
                continue;
            }
            d2 *= 0.5;
            iFunction.setParameterValues(dArray2);
        }
    }
}

