/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.CentroidND;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class DatasetMaths {
    private static final Logger logger = LoggerFactory.getLogger(DatasetMaths.class);

    private static void checkCompatibility(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        dataSet.checkCompatibility(dataSet2);
    }

    public static DataSet add(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = dataSet.getAbs(indexIterator.index) + dataSet2.getAbs(indexIterator2.index);
        }
        dataSet3.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "+" + DatasetMaths.bracketIfNecessary(dataSet2));
        return dataSet3;
    }

    public static DataSet add(DataSet dataSet, double d) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = dataSet.getAbs(indexIterator.index) + d;
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "+" + d);
        return dataSet2;
    }

    public static DataSet subtract(DataSet dataSet, DataSet dataSet2) {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = dataSet.getAbs(indexIterator.index) - dataSet2.getAbs(indexIterator2.index);
        }
        dataSet3.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "-" + DatasetMaths.bracketIfNecessary(dataSet2));
        return dataSet3;
    }

    public static DataSet subtract(DataSet dataSet, double d) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = dataSet.getAbs(indexIterator.index) - d;
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "-" + d);
        return dataSet2;
    }

    public static DataSet subtract(double d, DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = d - dataSet.getAbs(indexIterator.index);
        }
        dataSet2.setName(String.valueOf(d) + "-" + DatasetMaths.bracketIfNecessary(dataSet));
        return dataSet2;
    }

    public static DataSet multiply(DataSet dataSet, DataSet dataSet2) {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = dataSet.getAbs(indexIterator.index) * dataSet2.getAbs(indexIterator2.index);
        }
        dataSet3.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "*" + DatasetMaths.bracketIfNecessary(dataSet2));
        return dataSet3;
    }

    public static DataSet multiply(DataSet dataSet, double d) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = dataSet.getAbs(indexIterator.index) * d;
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "*" + d);
        return dataSet2;
    }

    public static DataSet divide(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = dataSet.getAbs(indexIterator.index) / dataSet2.getAbs(indexIterator2.index);
        }
        dataSet3.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "/" + DatasetMaths.bracketIfNecessary(dataSet2));
        return dataSet3;
    }

    public static DataSet divide(DataSet dataSet, double d) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = dataSet.getAbs(indexIterator.index) / d;
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "/" + d);
        return dataSet2;
    }

    public static DataSet divide(double d, DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = d / dataSet.getAbs(indexIterator.index);
        }
        dataSet2.setName(String.valueOf(d) + "/" + DatasetMaths.bracketIfNecessary(dataSet));
        return dataSet2;
    }

    public static DataSet dividez(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            double d = dataSet2.getAbs(indexIterator2.index);
            double d2 = dArray[n++] = d == 0.0 ? 0.0 : dataSet.getAbs(indexIterator.index) / d;
        }
        dataSet3.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "/" + DatasetMaths.bracketIfNecessary(dataSet2));
        return dataSet3;
    }

    public static DataSet dividez(double d, DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d2 = dataSet.getAbs(indexIterator.index);
            double d3 = dArray[n++] = d2 == 0.0 ? 0.0 : d / d2;
        }
        dataSet2.setName(String.valueOf(d) + "/" + DatasetMaths.bracketIfNecessary(dataSet));
        return dataSet2;
    }

    public static DataSet negative(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = -dataSet.getAbs(indexIterator.index);
        }
        dataSet2.setName(String.valueOf(dataSet.getName()) + "*-1");
        return dataSet2;
    }

    public static DataSet power(DataSet dataSet, double d) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.pow(dataSet.getAbs(indexIterator.index), d);
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "^" + d);
        return dataSet2;
    }

    public static DataSet absolute(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.abs(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("|" + dataSet.getName() + "|");
        return dataSet2;
    }

    public static DataSet rint(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.rint(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("rint(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet exp(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.exp(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("exp(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet exp2(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        double d = Math.log(2.0);
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.exp(d * dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("2^" + DatasetMaths.bracketIfNecessary(dataSet));
        return dataSet2;
    }

    public static DataSet log(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.log(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("log(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet log2(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        double d = 1.0 / Math.log(2.0);
        while (indexIterator.hasNext()) {
            dArray[n++] = d * Math.log(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("log2(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet log10(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.log10(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("log10(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet expm1(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.expm1(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("exp(" + dataSet.getName() + ") - 1");
        return dataSet2;
    }

    public static DataSet log1p(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.log1p(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("ln(1+" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet sqrt(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.sqrt(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("sqrt(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet cbrt(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.cbrt(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("cbrt(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet square(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = dataSet.getAbs(indexIterator.index);
            dArray[n++] = d * d;
        }
        dataSet2.setName(String.valueOf(DatasetMaths.bracketIfNecessary(dataSet)) + "^2");
        return dataSet2;
    }

    public static DataSet reciprocal(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = dataSet.getAbs(indexIterator.index);
            dArray[n++] = d * d;
        }
        dataSet2.setName("1/" + DatasetMaths.bracketIfNecessary(dataSet));
        return dataSet2;
    }

    public static DataSet cos(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.cos(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("cos(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet sin(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.sin(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("sin(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet tan(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.tan(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("tan(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arccos(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.acos(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("acos(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arcsin(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.asin(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("asin(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arctan(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.atan(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("atan(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arctan2(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = Math.atan2(dataSet.getAbs(indexIterator.index), dataSet2.getAbs(indexIterator2.index));
        }
        dataSet3.setName("atan(" + DatasetMaths.bracketIfNecessary(dataSet) + "/" + DatasetMaths.bracketIfNecessary(dataSet2) + ")");
        return dataSet3;
    }

    public static DataSet hypot(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        DatasetMaths.checkCompatibility(dataSet, dataSet2);
        DataSet dataSet3 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        IndexIterator indexIterator2 = dataSet2.getIterator();
        double[] dArray = dataSet3.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            indexIterator2.hasNext();
            dArray[n++] = Math.hypot(dataSet.getAbs(indexIterator.index), dataSet2.getAbs(indexIterator2.index));
        }
        dataSet3.setName("hypot(" + DatasetMaths.bracketIfNecessary(dataSet) + "," + DatasetMaths.bracketIfNecessary(dataSet2) + ")");
        return dataSet3;
    }

    public static DataSet cosh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.cosh(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("cosh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet sinh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.sinh(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("sinh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet tanh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.tanh(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("tanh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arccosh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = Math.cosh(dataSet.getAbs(indexIterator.index));
            dArray[n++] = Math.log(d + Math.sqrt(d * d - 1.0));
        }
        dataSet2.setName("arccosh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arcsinh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = Math.cosh(dataSet.getAbs(indexIterator.index));
            dArray[n++] = Math.log(d + Math.sqrt(d * d + 1.0));
        }
        dataSet2.setName("arcsinh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet arctanh(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = Math.cosh(dataSet.getAbs(indexIterator.index));
            dArray[n++] = 0.5 * Math.log((1.0 + d) / (1.0 - d));
        }
        dataSet2.setName("arctanh(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet deg2rad(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.toRadians(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("deg2rad(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet rad2deg(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.toDegrees(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("rad2deg(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet ceil(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.ceil(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("ceil(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static DataSet floor(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n++] = Math.floor(dataSet.getAbs(indexIterator.index));
        }
        dataSet2.setName("floor(" + dataSet.getName() + ")");
        return dataSet2;
    }

    public static double getAverageDeviation(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        double d = dataSet.mean();
        double d2 = 0.0;
        while (indexIterator.hasNext()) {
            d2 += Math.abs(dArray[indexIterator.index] - d);
        }
        return d2 / (double)dataSet.getSize();
    }

    public static double skew(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        double d = dataSet.mean();
        double d2 = dataSet.std();
        double d3 = 0.0;
        while (indexIterator.hasNext()) {
            double d4 = dArray[indexIterator.index] - d;
            d3 += d4 * d4 * d4;
        }
        return d3 / ((double)dataSet.getSize() * d2 * d2 * d2);
    }

    public static double kurtosis(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        double d = dataSet.mean();
        double d2 = dataSet.std();
        double d3 = 0.0;
        while (indexIterator.hasNext()) {
            double d4 = dArray[indexIterator.index] - d;
            d4 *= d4;
            d3 += d4 * d4;
        }
        d2 *= d2;
        return (d3 /= (double)dataSet.getSize()) / (d2 * d2) - 3.0;
    }

    public static double[] centroid(DataSet dataSet, DataSet ... dataSetArray) {
        DataSet dataSet2 = dataSet.exec(new CentroidND(dataSetArray)).get(0);
        return dataSet2.getBuffer();
    }

    @Deprecated
    public static double chiSquared(DataSet dataSet, DataSet dataSet2) {
        return DatasetMaths.residual(dataSet, dataSet2);
    }

    public static double residual(DataSet dataSet, DataSet dataSet2) {
        DataSet dataSet3 = DatasetMaths.subtract(dataSet, dataSet2);
        return DatasetMaths.square(dataSet3).sum();
    }

    private static double SelectedMean(DataSet dataSet, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        int n4 = dataSet.getSize();
        while (n3 <= n2) {
            int n5 = n3;
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 >= n4) {
                n5 = n4 - 1;
            }
            d += dataSet.get(n5);
            ++n3;
        }
        return d /= (double)(n2 - n + 1);
    }

    public static DataSet derivative(DataSet dataSet, DataSet dataSet2, int n) {
        DataSet dataSet3 = new DataSet(dataSet.getSize());
        int n2 = 0;
        int n3 = dataSet.getSize();
        while (n2 < n3) {
            double d = DatasetMaths.SelectedMean(dataSet2, n2 - n, n2 - 1);
            double d2 = DatasetMaths.SelectedMean(dataSet, n2 - n, n2 - 1);
            double d3 = DatasetMaths.SelectedMean(dataSet2, n2 + 1, n2 + n);
            double d4 = DatasetMaths.SelectedMean(dataSet, n2 + 1, n2 + n);
            dataSet3.set((d3 - d) / (d4 - d2), n2++);
        }
        dataSet3.setName(String.valueOf(dataSet2.getName()) + "'");
        return dataSet3;
    }

    public static DataSet norm(DataSet dataSet) {
        DataSet dataSet2 = DatasetMaths.subtract(dataSet, dataSet.min());
        dataSet2 = DatasetMaths.divide(dataSet2, dataSet2.max());
        return dataSet2;
    }

    public static DataSet lognorm(DataSet dataSet) {
        DataSet dataSet2 = DatasetMaths.subtract(dataSet, dataSet.min());
        dataSet2 = DatasetMaths.add(dataSet2, 1.0);
        dataSet2 = DatasetMaths.log10(dataSet2);
        dataSet2 = DatasetMaths.divide(dataSet2, dataSet2.max());
        return dataSet2;
    }

    public static DataSet lnnorm(DataSet dataSet) {
        DataSet dataSet2 = DatasetMaths.subtract(dataSet, dataSet.min());
        dataSet2 = DatasetMaths.add(dataSet2, 1.0);
        dataSet2 = DatasetMaths.log(dataSet2);
        dataSet2 = DatasetMaths.divide(dataSet2, dataSet2.max());
        return dataSet2;
    }

    public static DataSet clip(DataSet dataSet, double d, double d2) {
        DataSet dataSet2 = new DataSet(dataSet.getDimensions());
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet2.getBuffer();
        int n = 0;
        double d3 = (d + d2) / 2.0;
        while (indexIterator.hasNext()) {
            double d4 = dataSet.getAbs(indexIterator.index);
            if (Double.isNaN(d4)) {
                d4 = d3;
            } else if (d4 < d) {
                d4 = d;
            } else if (d4 > d2) {
                d4 = d2;
            }
            dArray[n++] = d4;
        }
        return dataSet2;
    }

    public static boolean all(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        while (indexIterator.hasNext()) {
            if (dArray[indexIterator.index] != 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean any(DataSet dataSet) {
        IndexIterator indexIterator = dataSet.getIterator();
        double[] dArray = dataSet.getBuffer();
        while (indexIterator.hasNext()) {
            if (dArray[indexIterator.index] == 0.0) continue;
            return false;
        }
        return true;
    }

    private static String bracketIfNecessary(DataSet dataSet) {
        String string = dataSet.getName();
        if (string.contains("+")) {
            return "(" + string + ")";
        }
        if (string.contains("-")) {
            return "(" + string + ")";
        }
        if (string.contains("*")) {
            return "(" + string + ")";
        }
        if (string.contains("/")) {
            return "(" + string + ")";
        }
        if (string.contains("^")) {
            return "(" + string + ")";
        }
        if (string.contains("'")) {
            return "(" + string + ")";
        }
        return string;
    }

    public static double getLinear(DataSet dataSet, double d) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 1) {
            logger.error("Only 1d datasets allowed");
            throw new IllegalArgumentException("Only 1d datasets allowed");
        }
        double d2 = 0.0;
        int n = (int)Math.floor(d);
        double d3 = d - (double)n;
        if (n < 0 || n >= nArray[0]) {
            return d2;
        }
        double d4 = dataSet.get(n);
        if (d3 > 0.0) {
            if (n == nArray[0] - 1) {
                return d2;
            }
            double d5 = dataSet.get(n + 1);
            d2 = (1.0 - d3) * d4 + d3 * d5;
        } else {
            d2 = d4;
        }
        return d2;
    }

    public static double getBilinear(DataSet dataSet, double d, double d2) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            logger.error("Only 2d datasets allowed");
            throw new IllegalArgumentException("Only 2d datasets allowed");
        }
        double d3 = 0.0;
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        if (n < 0 || n >= nArray[0] || n2 < 0 || n2 >= nArray[1]) {
            return d3;
        }
        double d6 = dataSet.get(n, n2);
        if (d5 > 0.0) {
            if (n2 == nArray[1] - 1) {
                return d3;
            }
            if (d4 > 0.0) {
                if (n == nArray[0] - 1) {
                    return d3;
                }
                double d7 = dataSet.get(n, n2 + 1);
                double d8 = dataSet.get(n + 1, n2 + 1);
                double d9 = dataSet.get(n + 1, n2);
                d3 = (1.0 - d5) * (1.0 - d4) * d6 + d5 * (1.0 - d4) * d7 + d5 * d4 * d8 + (1.0 - d5) * d4 * d9;
            } else {
                double d10 = dataSet.get(n, n2 + 1);
                d3 = (1.0 - d5) * d6 + d5 * d10;
            }
        } else if (d4 > 0.0) {
            if (n == nArray[0] - 1) {
                return d3;
            }
            double d11 = dataSet.get(n + 1, n2);
            d3 = (1.0 - d4) * d6 + d4 * d11;
        } else {
            d3 = d6;
        }
        return d3;
    }

    public static List<Double> crossings(DataSet dataSet, double d) {
        if (dataSet.getRank() != 1) {
            logger.error("Only 1d datasets supported");
            throw new UnsupportedOperationException("Only 1d datasets supported");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double d2 = dataSet.getAbs(0);
        int n = 1;
        int n2 = dataSet.getSize();
        while (n < n2) {
            double d3 = d2;
            d2 = dataSet.getAbs(n);
            if (d3 <= d && d2 > d || d3 > d && d2 <= d) {
                double d4 = (d - d2) / (d2 - d3);
                arrayList.add((double)n + d4);
            }
            ++n;
        }
        return arrayList;
    }

    public static List<Double> crossings(DataSet dataSet, DataSet dataSet2, double d) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        List<Double> list = DatasetMaths.crossings(dataSet2, d);
        for (double d2 : list) {
            arrayList.add(DatasetMaths.getLinear(dataSet, d2));
        }
        return arrayList;
    }

    public static List<Double> crossings(DataSet dataSet, DataSet dataSet2, double d, double d2) {
        List<Double> list = DatasetMaths.crossings(dataSet, dataSet2, d);
        double d3 = d2 * dataSet.range();
        int n = 0;
        while (n < list.size() - 3) {
            double d4 = Math.abs(list.get(n) - list.get(n + 2));
            if (d4 < d3) {
                list.set(n + 2, (list.get(n) + list.get(n + 1) + list.get(n + 2)) / 3.0);
                list.remove(n);
                list.remove(n);
                continue;
            }
            ++n;
        }
        return list;
    }
}

