/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.utils.DatasetMaths;
import java.util.ArrayList;
import java.util.List;

public class MapToRotatedCartesianAndIntegrate
implements IDataSetFunction {
    int ox;
    int oy;
    int h;
    int w;
    double phi;

    public MapToRotatedCartesianAndIntegrate(int n, int n2, int n3, int n4, double d) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = Math.toRadians(d);
    }

    public MapToRotatedCartesianAndIntegrate(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = bl ? Math.toRadians(d) : d;
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            return null;
        }
        double d = Math.cos(this.phi);
        double d2 = Math.sin(this.phi);
        DataSet dataSet2 = new DataSet(this.h);
        DataSet dataSet3 = new DataSet(this.w);
        int n = 0;
        while (n < this.h) {
            double d3 = 0.0;
            int n2 = 0;
            while (n2 < this.w) {
                double d4 = (double)this.ox + (double)n2 * d - (double)n * d2;
                double d5 = (double)this.oy + (double)n2 * d2 + (double)n * d;
                double d6 = DatasetMaths.getBilinear(dataSet, d5, d4);
                dataSet3.set(d6 + dataSet3.getDouble(n2), n2++);
                d3 += d6;
            }
            dataSet2.set(d3, n++);
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet2);
        arrayList.add(dataSet3);
        DataSet dataSet4 = new DataSet(this.h).fill(this.w);
        arrayList.add(dataSet4);
        DataSet dataSet5 = new DataSet(this.w).fill(this.h);
        arrayList.add(dataSet5);
        return arrayList;
    }
}

