/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.utils.DatasetMaths;
import java.util.ArrayList;
import java.util.List;

public class LineSample
implements IDataSetFunction {
    int sx;
    int sy;
    int ex;
    int ey;
    double step;

    public LineSample(int n, int n2, int n3, int n4, double d) {
        this.sx = n;
        this.sy = n2;
        this.ex = n3;
        this.ey = n4;
        this.step = d;
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            return null;
        }
        double d = Math.hypot(this.ex - this.sx, this.ey - this.sy);
        double d2 = Math.atan2(this.ey - this.sy, this.ex - this.sx);
        int n = (int)Math.floor(d / this.step) + 1;
        DataSet dataSet2 = new DataSet(n);
        int n2 = 0;
        while (n2 < n) {
            double d3 = (double)this.sx + this.step * (double)n2 * Math.cos(d2);
            double d4 = (double)this.sy + this.step * (double)n2 * Math.sin(d2);
            dataSet2.set(DatasetMaths.getBilinear(dataSet, d4, d3), n2++);
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet2);
        return arrayList;
    }
}

