/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.Histogram;
import junit.framework.TestCase;
import org.junit.Test;

public class HistogramTest
extends TestCase {
    DataSet d = null;

    public void setUp() {
        this.d = DataSet.arange(1.0, 2048.0, 1.0);
    }

    @Test
    public void testHistogram() {
        Histogram histogram = new Histogram(2048);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)2048.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(1), (double)0.0);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(512), (double)0.0);
    }

    @Test
    public void testHistogram2() {
        Histogram histogram = new Histogram(1024);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)1024.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)2.0, (double)dataSet.get(1), (double)0.0);
        HistogramTest.assertEquals((double)2.0, (double)dataSet.get(512), (double)0.0);
    }

    @Test
    public void testHistogram3() {
        Histogram histogram = new Histogram(256);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)256.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)8.0, (double)dataSet.get(1), (double)0.0);
        HistogramTest.assertEquals((double)8.0, (double)dataSet.get(128), (double)0.0);
    }

    @Test
    public void testHistogram4() {
        Histogram histogram = new Histogram(205);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)205.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)10.0, (double)dataSet.get(1), (double)0.0);
        HistogramTest.assertEquals((double)10.0, (double)dataSet.get(128), (double)0.0);
    }

    @Test
    public void testHistogram5() {
        Histogram histogram = new Histogram(1024, 1.0, 1024.0);
        histogram.setIgnoreOutliers(false);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)1024.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(1), (double)0.0);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(512), (double)0.0);
        HistogramTest.assertEquals((double)1024.0, (double)dataSet.get(1023), (double)0.0);
    }

    @Test
    public void testHistogram6() {
        Histogram histogram = new Histogram(1024, 2.0, 1024.0);
        histogram.setIgnoreOutliers(false);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)1024.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)2.0, (double)dataSet.get(0), (double)0.0);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(512), (double)0.0);
        HistogramTest.assertEquals((double)1024.0, (double)dataSet.get(1023), (double)0.0);
    }

    @Test
    public void testHistogram7() {
        Histogram histogram = new Histogram(1024, 2.0, 1024.0, true);
        DataSet dataSet = this.d.exec(histogram).get(0);
        HistogramTest.assertEquals((float)1024.0f, (float)dataSet.getSize(), (float)0.0f);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(0), (double)0.0);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(512), (double)0.0);
        HistogramTest.assertEquals((double)1.0, (double)dataSet.get(1023), (double)0.0);
    }
}

