/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.APeak;
import gda.analysis.functions.IdentifiedPeak;
import gda.analysis.functions.Parameter;

public class Lorentzian
extends APeak {
    private static String cname = "Lorentzian";
    double a;
    double top;
    double gsq;

    public Lorentzian(double ... dArray) {
        super(dArray);
        this.name = cname;
    }

    public Lorentzian(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public Lorentzian(IdentifiedPeak identifiedPeak) {
        super(3);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(identifiedPeak.getHeight() * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getHeight());
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d * 2.0);
        this.getParameter(2).setValue(identifiedPeak.getFWHM() / 4.0);
        this.name = cname;
    }

    public Lorentzian(double d, double d2, double d3, double d4) {
        super(3);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 2.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d4);
        this.getParameter(2).setValue(d4 / 10.0);
        this.name = cname;
    }

    public Lorentzian createPeakFunction(double d, double d2, double d3, double d4) {
        double d5 = d4 / 2.0;
        double d6 = 2.0 * d3 / d5;
        return new Lorentzian(d, d2, d6, d5);
    }

    private void calcCachedParameters() {
        this.a = this.getParameterValue(0);
        double d = this.getParameterValue(1);
        this.gsq = this.getParameterValue(2);
        this.gsq *= this.gsq;
        this.top = d * this.gsq;
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = d - this.a;
        return this.gsq / (this.gsq + d2 * d2);
    }

    @Override
    public void disp() {
        String string = String.format("Lorentzian position has value %f within the bounds [%f,%f]", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Lorentzian area     has value %f within the bounds [%f,%f]", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Lorentzian gamma    has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit());
        TerminalPrinter.print(string);
    }

    @Override
    public double getArea() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(2).getValue() * 2.0;
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

