/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussianND
extends AFunction {
    private static String cname = "GaussianND";
    private int rank;
    private double[] pos = null;
    private static final transient Logger logger = LoggerFactory.getLogger(GaussianND.class);
    private Array2DRowRealMatrix invcov;
    private double norm;

    public GaussianND(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public GaussianND(double ... dArray) {
        super(dArray);
        int n = dArray.length;
        int n2 = -1;
        this.rank = 0;
        while (n2 < n) {
            n2 = 1 + this.rank * (this.rank + 3) / 2;
        }
        if (n2 != n) {
            logger.error("Given number of parameters {} is not equal to {}", (Object)n, (Object)n2);
            throw new IllegalArgumentException("Given number of parameters " + n + " is not equal to" + n2);
        }
        int n3 = 2 * this.rank + 1;
        int n4 = 0;
        while (n4 < n) {
            double d = this.getParameter(n3).getValue();
            if (Math.abs(d) > 1.0) {
                logger.error("Parameter {} ({}) is outside valid range [-1,1]", (Object)n4, (Object)d);
                throw new IllegalArgumentException("Parameter " + n4 + " (" + d + ") is outside valid range [-1,1]");
            }
            ++n4;
        }
        this.pos = new double[this.rank];
    }

    public GaussianND(double d, double[] dArray, double[] dArray2, double d2) {
        super(1 + dArray.length * (dArray.length + 3) / 2);
        this.rank = dArray.length;
        if (dArray2.length != this.rank) {
            logger.error("Two vectors are not of same length");
            throw new IllegalArgumentException("Two vectors are not of same length");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.rank) {
            this.getParameter(n).setLowerLimit(dArray[n2]);
            this.getParameter(n).setUpperLimit(dArray2[n2]);
            this.getParameter(n).setValue((dArray[n2] + dArray2[n2]) / 2.0);
            ++n;
            ++n2;
        }
        this.getParameter(n).setLowerLimit(0.0);
        this.getParameter(n).setUpperLimit(d);
        this.getParameter(n).setValue(d / 2.0);
        ++n;
        double d3 = d2 * d2;
        int n3 = 0;
        while (n3 < this.rank) {
            this.getParameter(n).setLowerLimit(0.0);
            this.getParameter(n).setUpperLimit(d3);
            this.getParameter(n).setValue(d3 / 100.0);
            ++n;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.rank) {
            int n4 = n3 + 1;
            while (n4 < this.rank) {
                this.getParameter(n).setLowerLimit(-1.0);
                this.getParameter(n).setUpperLimit(1.0);
                this.getParameter(n).setValue(0.0);
                ++n;
                ++n4;
            }
            ++n3;
        }
        this.pos = new double[this.rank];
    }

    public void setPeakPosition(double[] dArray) {
        if (dArray.length != this.rank) {
            logger.error("Peak position vector has wrong length");
            throw new IllegalArgumentException("Peak position vector has wrong length");
        }
        int n = 0;
        while (n < this.rank) {
            this.getParameter(n).setValue(dArray[n]);
            ++n;
        }
    }

    public void setVolume(double d) {
        this.getParameter(this.rank).setValue(d);
    }

    public double getPeakValue() {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        return this.norm;
    }

    private void calcCachedParameters() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.rank) {
            this.pos[n2] = this.getParameterValue(n);
            ++n;
            ++n2;
        }
        this.norm = this.getParameterValue(n);
        ++n;
        Array2DRowRealMatrix array2DRowRealMatrix = (Array2DRowRealMatrix)MatrixUtils.createRealMatrix((int)this.rank, (int)this.rank);
        int n3 = 0;
        while (n3 < this.rank) {
            array2DRowRealMatrix.setEntry(n3, n3, this.getParameterValue(n));
            ++n;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.rank) {
            double d = Math.sqrt(array2DRowRealMatrix.getEntry(n3, n3));
            int n4 = n3 + 1;
            while (n4 < this.rank) {
                double d2 = Math.sqrt(array2DRowRealMatrix.getEntry(n4, n4)) * d;
                double d3 = d2 * this.getParameterValue(n);
                array2DRowRealMatrix.setEntry(n3, n4, d3);
                array2DRowRealMatrix.setEntry(n4, n3, d3);
                ++n;
                ++n4;
            }
            ++n3;
        }
        LUDecompositionImpl lUDecompositionImpl = null;
        try {
            lUDecompositionImpl = new LUDecompositionImpl((RealMatrix)array2DRowRealMatrix);
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            logger.error("Non-square covariance matrix");
            throw new IllegalArgumentException("Non-square covariance matrix");
        }
        this.invcov = (Array2DRowRealMatrix)lUDecompositionImpl.getSolver().getInverse();
        this.norm /= Math.sqrt(Math.pow(Math.PI * 2, this.rank) * lUDecompositionImpl.getDeterminant());
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double[] dArray2 = (double[])dArray.clone();
        int n = 0;
        while (n < dArray2.length) {
            int n2 = n;
            dArray2[n2] = dArray2[n2] - this.pos[n];
            ++n;
        }
        double[] dArray3 = this.invcov.operate(dArray2);
        double d = 0.0;
        int n3 = 0;
        while (n3 < dArray2.length) {
            d += dArray3[n3] * dArray2[n3];
            ++n3;
        }
        double d2 = Math.exp(-0.5 * d);
        return this.norm * d2;
    }
}

