/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.APeak;
import gda.analysis.functions.IPeak;
import gda.analysis.functions.IdentifiedPeak;
import gda.analysis.functions.Parameter;

public class Gaussian
extends APeak
implements IPeak {
    private static final double FWHM_TO_SIGMA = 1.0 / Math.sqrt(8.0 * Math.log(2.0));
    private static String cname = "Gaussian";
    double pos;
    double sigma;
    double norm;

    public Gaussian(double ... dArray) {
        super(dArray);
        this.name = cname;
    }

    public Gaussian(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public Gaussian(IdentifiedPeak identifiedPeak) {
        super(3);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(identifiedPeak.getHeight() * 2.0 * (d * 2.0));
        this.getParameter(2).setValue(identifiedPeak.getArea() / 2.0);
        this.name = cname;
    }

    public Gaussian(double d, double d2, double d3, double d4) {
        super(3);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 10.0);
        this.getParameter(2).setLowerLimit(0.0);
        this.getParameter(2).setUpperLimit(d4);
        this.getParameter(2).setValue(d4 / 2.0);
        this.name = cname;
    }

    public Gaussian createPeakFunction(double d, double d2, double d3, double d4) {
        return new Gaussian(d, d2, d3, d4);
    }

    private void calcCachedParameters() {
        this.pos = this.getParameterValue(0);
        this.sigma = this.getParameterValue(1) * FWHM_TO_SIGMA;
        double d = this.getParameterValue(2);
        this.norm = d / Math.sqrt(Math.PI * 2 * this.sigma * this.sigma);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        double d2 = (d - this.pos) / this.sigma;
        double d3 = Math.exp(-0.5 * d2 * d2);
        return this.norm * d3;
    }

    @Override
    public void disp() {
        String string = String.format("Gaussian position has value %f within the bounds [%f,%f]", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Gaussian FWHM     has value %f within the bounds [%f,%f]", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Gaussian area    has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit());
        TerminalPrinter.print(string);
    }

    @Override
    public double getArea() {
        return this.getParameter(2).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

