/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;

public class CubicSpline
extends AFunction {
    private static String cname = "CubicSpline";
    double[] a = null;
    double[] b = null;
    double[] c = null;
    double[] d = null;
    double[] x = null;
    double[] y = null;

    public CubicSpline(int n) {
        super(n);
        this.name = cname;
    }

    public CubicSpline(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public CubicSpline(double[] dArray, double[] dArray2, double d) {
        super(dArray2);
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n].setUpperLimit(this.parameters[n].getValue() + d);
            this.parameters[n].setLowerLimit(this.parameters[n].getValue() - d);
            ++n;
        }
        this.x = dArray;
    }

    public CubicSpline(double[] dArray, double[] dArray2) {
        super(dArray2);
        this.x = dArray;
    }

    protected void generateSpline(double[] dArray, double[] dArray2) throws IllegalArgumentException {
        this.x = dArray;
        this.y = dArray2;
        int n = 0;
        if (this.x.length != this.y.length) {
            throw new IllegalArgumentException("x and y arrays are not the same length");
        }
        n = this.x.length - 1;
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray3[n2] = this.x[n2 + 1] - this.x[n2];
            dArray4[n2] = (this.y[n2 + 1] - this.y[n2]) / dArray3[n2];
            ++n2;
        }
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        dArray5[1] = 2.0 * (dArray3[0] + dArray3[1]);
        dArray6[1] = 6.0 * (dArray4[1] - dArray4[0]);
        int n3 = 2;
        while (n3 < n) {
            dArray5[n3] = 2.0 * (dArray3[n3 - 1] + dArray3[n3]) - dArray3[n3 - 1] * dArray3[n3 - 1] / dArray5[n3 - 1];
            dArray6[n3] = 6.0 * (dArray4[n3] - dArray4[n3 - 1]) - dArray3[n3 - 1] * dArray6[n3 - 1] / dArray5[n3 - 1];
            ++n3;
        }
        double[] dArray7 = new double[n + 1];
        dArray7[n] = 0.0;
        int n4 = n - 1;
        while (n4 > 0) {
            dArray7[n4] = (dArray6[n4] - dArray3[n4] * dArray7[n4 + 1]) / dArray5[n4];
            --n4;
        }
        this.a = new double[n];
        this.b = new double[n];
        this.c = new double[n];
        this.d = new double[n];
        n4 = 0;
        while (n4 < n) {
            this.a[n4] = this.y[n4];
            this.b[n4] = -dArray3[n4] / 6.0 * dArray7[n4 + 1] - dArray3[n4] / 3.0 * dArray7[n4] + (this.y[n4 + 1] - this.y[n4]) / dArray3[n4];
            this.c[n4] = dArray7[n4] / 2.0;
            this.d[n4] = (dArray7[n4 + 1] - dArray7[n4]) / (6.0 * dArray3[n4]);
            ++n4;
        }
    }

    protected int getRegion(double d) {
        int n = 0;
        while (n < this.x.length - 1) {
            if (d < this.x[n + 1]) {
                return n;
            }
            ++n;
        }
        return this.x.length - 2;
    }

    protected double evaluateSpline(double d) {
        int n = this.getRegion(d);
        double d2 = d - this.x[n];
        double d3 = this.a[n] + d2 * (this.b[n] + d2 * (this.c[n] + d2 * this.d[n]));
        return d3;
    }

    protected boolean changed() {
        if (this.y == null) {
            return true;
        }
        int n = 0;
        while (n < this.y.length) {
            if (this.parameters[n].getValue() != this.y[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected double[] getParameterDoubleList() {
        double[] dArray = new double[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            dArray[n] = this.parameters[n].getValue();
            ++n;
        }
        return dArray;
    }

    @Override
    public double val(double ... dArray) {
        if (this.changed()) {
            this.generateSpline(this.x, this.getParameterDoubleList());
        }
        return this.evaluateSpline(dArray[0]);
    }
}

