/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import Jama.Matrix;
import gda.analysis.TerminalPrinter;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.utils.DatasetMaths;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIteratorWithPosition;
import uk.ac.diamond.scisoft.analysis.dataset.DiscontiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class DataSet
implements Serializable,
IDataset {
    private static transient String depMsg = "This is deprecated and will be removed in v8.";
    private static final long serialVersionUID = 1L;
    private static final transient Logger logger = LoggerFactory.getLogger(DataSet.class);
    private static final int maxDisplayLength = 1024;
    private static final float ARRAY_ALLOCATION_EXTENSION = 0.5f;
    private int[] dimensions;
    private int dataSize;
    private int[] dataDimensions;
    private double[] data = null;
    private String name = "";
    private HashMap<String, Object> storedValues = null;

    public IndexIterator getIterator(boolean bl) {
        if (this.dataDimensions == null) {
            return bl ? new ContiguousIteratorWithPosition(this.dimensions, this.data.length) : new ContiguousIterator(this.data.length);
        }
        return new DiscontiguousIterator(this.dimensions, this.dataDimensions, this.data.length);
    }

    public IndexIterator getIterator() {
        return this.getIterator(false);
    }

    public DataSet() {
    }

    public DataSet(String string) {
        this();
        this.name = string;
    }

    public DataSet(String string, int ... nArray) {
        this(nArray);
        this.name = string;
    }

    public DataSet(int ... nArray) {
        this((double[])null, nArray);
    }

    public DataSet(double[] dArray, int ... nArray) {
        if (nArray.length > 0) {
            this.dimensions = nArray;
            this.dataSize = 1;
            double d = 1.0;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                if (nArray[n] <= 0) {
                    logger.error("Argument " + n + " is " + nArray[n] + " which is an illegal argument as it is zero or negative");
                    throw new IllegalArgumentException("Argument " + n + " is " + nArray[n] + " which is an illegal argument as it is zero or negative");
                }
                this.dataSize *= nArray[n];
                d *= (double)nArray[n];
                ++n;
            }
            if (d > 2.147483647E9) {
                logger.error("The size of the dataset that is being created is too large to allocate memory for.");
                throw new IllegalArgumentException("Size of the dataset is too large to allocate");
            }
            try {
                if (dArray != null) {
                    if (dArray.length == this.dataSize) {
                        this.data = dArray;
                    }
                    this.data = Arrays.copyOf(dArray, this.dataSize);
                }
                this.data = new double[this.dataSize];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.error("The size of the dataset {} that is being created is too large and there is not enough memory to hold it.", (Object)this.dataSize);
                throw new OutOfMemoryError("The dimentions given are too large, and there is not enough memory available in the Java Virtual Machine");
            }
        } else {
            this.dimensions = new int[1];
            logger.warn("Dataset should be constructed with some indexes");
            logger.warn("Set is curently empty");
            this.dataSize = 0;
        }
    }

    public DataSet(String string, double[][] dArray) {
        this(dArray);
        this.name = string;
    }

    public DataSet(double[][] dArray) {
        this(dArray.length, dArray[0].length);
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            int n4 = 0;
            int n5 = dArray[0].length;
            while (n4 < n5) {
                this.data[n++] = dArray[n2][n4];
                ++n4;
            }
            ++n2;
        }
    }

    public DataSet(String string, double[] dArray) {
        this(dArray);
        this.name = string;
    }

    public DataSet(List<Double> list) {
        this.dataSize = list.size();
        this.dimensions = new int[]{this.dataSize};
        try {
            this.data = new double[this.dataSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        int n = 0;
        while (n < this.dataSize) {
            this.data[n] = list.get(n);
            ++n;
        }
    }

    public DataSet(double[] dArray) {
        this.dataSize = dArray.length;
        this.dimensions = new int[]{this.dataSize};
        try {
            this.data = new double[this.dataSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        int n = 0;
        while (n < this.dataSize) {
            this.data[n] = dArray[n];
            ++n;
        }
    }

    public DataSet(String string, int n, int n2, double[] dArray) {
        this(n, n2, dArray);
        this.name = string;
    }

    public DataSet(int n, int n2, double[] dArray) {
        if (n2 <= 0) {
            logger.error("width argument is " + n2 + " which is an illegal argument as it is zero or negative");
            throw new IllegalArgumentException("width argument is " + n2 + " which is an illegal argument as it is zero or negative");
        }
        if (n <= 0) {
            logger.error("height argument is " + n + " which is an illegal argument as it is zero or negative");
            throw new IllegalArgumentException("height argument is " + n + " which is an illegal argument as it is zero or negative");
        }
        if (n2 * n > dArray.length) {
            logger.error("Not enough data provided to dataset " + dArray.length + " provided but " + n2 * n + " needed");
            throw new IllegalArgumentException("Not enough data provided to dataset " + dArray.length + " provided but " + n2 * n + " needed");
        }
        if (n2 * n < dArray.length) {
            logger.warn("Not all the dataset given fits into the size specified");
        }
        this.dimensions = new int[]{n, n2};
        this.dataSize = n2 * n;
        try {
            this.data = new double[this.dataSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        int n3 = 0;
        while (n3 < this.dataSize) {
            this.data[n3] = dArray[n3];
            ++n3;
        }
    }

    public DataSet(String string, int n, int n2, int n3, double[] dArray) {
        this(n, n2, n3, dArray);
        this.name = string;
    }

    public DataSet(int n, int n2, int n3, double[] dArray) {
        if (n3 <= 0) {
            logger.error("width argument is " + n3 + " which is an illegal argument as it is zero or negative");
            throw new IllegalArgumentException("width argument is " + n3 + " which is an illegal argument as it is zero or negative");
        }
        if (n2 <= 0) {
            logger.error("height argument is " + n2 + " which is an illegal argument as it is zero or negative");
            throw new IllegalArgumentException("height argument is " + n2 + " which is an illegal argument as it is zero or negative");
        }
        if (n <= 0) {
            logger.error("depth argument is " + n + " which is an illegal argument as it is zero or negative");
            throw new IllegalArgumentException("depth argument is " + n + " which is an illegal argument as it is zero or negative");
        }
        if (n3 * n2 * n > dArray.length) {
            logger.error("Not enough data provided to dataset " + dArray.length + " provided but " + n3 * n2 * n + " needed");
            throw new IllegalArgumentException("Not enough data provided to dataset " + dArray.length + " provided but " + n3 * n2 * n + " needed");
        }
        this.dimensions = new int[]{n, n2, n3};
        this.dataSize = n3 * n2 * n;
        try {
            this.data = new double[this.dataSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        int n4 = 0;
        while (n4 < this.dataSize) {
            this.data[n4] = dArray[n4];
            ++n4;
        }
    }

    public DataSet(String string, Matrix matrix) {
        this(matrix);
        this.name = string;
    }

    public DataSet(Matrix matrix) {
        if (matrix == null) {
            logger.error("Input matrix to the dataset is null");
            throw new IllegalArgumentException("Input matrix to the dataset is null");
        }
        int[] nArray = new int[]{matrix.getRowDimension(), matrix.getColumnDimension()};
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            if (nArray[n] <= 0) {
                logger.error("Argument " + n + " is " + nArray[n] + " which is an illegal argument as it is zero or negative");
                throw new IllegalArgumentException("Argument " + n + " is " + nArray[n] + " which is an illegal argument as it is zero or negative");
            }
            ++n;
        }
        try {
            this.data = matrix.getRowPackedCopy();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        this.dataSize = this.data.length;
        this.dimensions = nArray;
    }

    public DataSet(DataSet dataSet) {
        if (dataSet == null) {
            logger.error("Input dataset to the dataset is null");
            throw new IllegalArgumentException("Input dataset to the dataset is null");
        }
        try {
            this.dimensions = dataSet.getDimensions();
            if (dataSet.isContiguous()) {
                this.data = (double[])dataSet.data.clone();
            } else {
                this.data = new double[dataSet.dataSize];
                IndexIterator indexIterator = dataSet.getIterator();
                int n = 0;
                while (indexIterator.hasNext()) {
                    this.data[n] = dataSet.data[indexIterator.index];
                    ++n;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("Not enough memory available to create dataset");
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        this.name = new String(dataSet.getName());
        this.dataSize = dataSet.dataSize;
    }

    public DataSet(PySequence pySequence) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        this.getDims(arrayList, pySequence, 0);
        int n = arrayList.size();
        this.dimensions = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.dimensions[n2] = arrayList.get(n2);
            ++n2;
        }
        this.dataSize = 1;
        double d = 1.0;
        int n3 = 0;
        while (n3 < n) {
            if (this.dimensions[n3] <= 0) {
                logger.error("Argument " + n3 + " is " + this.dimensions[n3] + " which is an illegal argument as it is zero or negative");
                throw new IllegalArgumentException("Argument " + n3 + " is " + this.dimensions[n3] + " which is an illegal argument as it is zero or negative");
            }
            this.dataSize *= this.dimensions[n3];
            d *= (double)this.dimensions[n3];
            ++n3;
        }
        if (d > 2.147483647E9) {
            logger.error("The size of the dataset that is being created is too large to allocate memory for.");
            throw new IllegalArgumentException("Size of the dataset is too large to allocate");
        }
        try {
            this.data = new double[this.dataSize];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimentions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        int[] nArray = new int[n];
        this.fillArray(pySequence, 0, nArray);
    }

    private void getDims(ArrayList<Integer> arrayList, Object object, int n) {
        block5: {
            Class<?> clazz;
            block4: {
                if (!(object instanceof PySequenceList)) break block4;
                PySequenceList pySequenceList = (PySequenceList)object;
                int n2 = pySequenceList.size();
                this.updateDims(arrayList, n, n2);
                int n3 = 0;
                while (n3 < n2) {
                    Object object2 = pySequenceList.get(n3);
                    if (object2 instanceof PySequence || object2 instanceof PyArray || object2.getClass().isArray()) {
                        this.getDims(arrayList, object2, n + 1);
                    }
                    ++n3;
                }
                break block5;
            }
            if (object instanceof PyArray) {
                object = ((PyArray)object).getArray();
            }
            if (!(clazz = object.getClass()).isArray()) break block5;
            Object object3 = object;
            while (clazz.isArray()) {
                this.updateDims(arrayList, n++, Array.getLength(object3));
                object3 = Array.get(object3, 0);
                clazz = object3.getClass();
            }
        }
    }

    private void updateDims(ArrayList<Integer> arrayList, int n, int n2) {
        if (n >= arrayList.size()) {
            arrayList.add(n2);
        } else if (n2 > arrayList.get(n)) {
            arrayList.set(n, n2);
        }
    }

    private void fillArray(Object object, int n, int[] nArray) {
        if (object instanceof PySequenceList) {
            PySequenceList pySequenceList = (PySequenceList)object;
            int n2 = pySequenceList.size();
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = pySequenceList.get(n3);
                if (object2 instanceof PySequence || object2 instanceof PyArray || object2.getClass().isArray()) {
                    this.fillArray(object2, n + 1, nArray);
                    nArray[n + 1] = 0;
                } else {
                    this.setArray(object2, nArray);
                }
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
                ++n3;
            }
        } else {
            if (object instanceof PyArray) {
                object = ((PyArray)object).getArray();
            }
            if (object.getClass().isArray()) {
                this.fillArrayFromArray(object, n, nArray);
            }
        }
    }

    private void fillArrayFromArray(Object object, int n, int[] nArray) {
        Object object2 = Array.get(object, 0);
        int n2 = Array.getLength(object);
        Class<?> clazz = object2.getClass();
        if (clazz.isArray()) {
            int n3 = 0;
            while (n3 < n2) {
                object2 = Array.get(object, n3);
                this.fillArrayFromArray(object2, n + 1, nArray);
                nArray[n + 1] = 0;
                int n4 = n;
                nArray[n4] = nArray[n4] + 1;
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                object2 = Array.get(object, n5);
                this.setArray(object2, nArray);
                int n6 = n;
                nArray[n6] = nArray[n6] + 1;
                ++n5;
            }
        }
    }

    private void setArray(Object object, int[] nArray) {
        if (object instanceof PyInteger || object instanceof Integer) {
            this.setItem(((Integer)object).doubleValue(), nArray);
        } else if (object instanceof PyFloat || object instanceof Double) {
            this.setItem((Double)object, nArray);
        } else {
            logger.error("Can't handle this data type in PySequenceList: " + ((PyObject)object).getType());
        }
    }

    public static DataSet convertToDataset(IDataset iDataset) {
        if (iDataset instanceof DataSet) {
            return (DataSet)iDataset;
        }
        if (iDataset instanceof AbstractDataset) {
            return AbstractDataset.toDataSet(iDataset);
        }
        DataSet dataSet = new DataSet(iDataset.getName(), iDataset.getShape());
        ContiguousIteratorWithPosition contiguousIteratorWithPosition = new ContiguousIteratorWithPosition(dataSet.getShape(), dataSet.getSize());
        int[] nArray = ((IndexIterator)contiguousIteratorWithPosition).getPos();
        while (((IndexIterator)contiguousIteratorWithPosition).hasNext()) {
            dataSet.setAbs(iDataset.getDouble(nArray), contiguousIteratorWithPosition.index);
        }
        return dataSet;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getSize() {
        if (this.data == null) {
            logger.error("The data object inside the dataset has not been allocated, this sugests a failed or absent construction of the Dataset");
            throw new NullPointerException("The data object inside the dataset has not been allocated, this sugests a failed or absent construction of the Dataset");
        }
        return this.dataSize;
    }

    public boolean isContiguous() {
        return this.dataDimensions == null;
    }

    public int[] getDimensions() {
        return this.getShape();
    }

    @Override
    public int[] getShape() {
        if (this.dimensions == null) {
            return new int[0];
        }
        return (int[])this.dimensions.clone();
    }

    @Override
    public void setShape(int ... nArray) {
        this.reshape(nArray);
    }

    protected int get1DIndex(int ... nArray) {
        int n = nArray.length;
        if (n > this.dimensions.length) {
            throw new IllegalArgumentException("No of index parameters is different to the dimensions of data\t" + n + " given " + this.dimensions.length + "required");
        }
        int n2 = nArray[0];
        if (this.dimensions.length == 1) {
            return n2;
        }
        if (this.dataDimensions == null) {
            int n3 = 1;
            while (n3 < n) {
                n2 = n2 * this.dimensions[n3] + nArray[n3];
                ++n3;
            }
        } else {
            int n4 = 1;
            while (n4 < n) {
                n2 = n2 * this.dataDimensions[n4] + nArray[n4];
                ++n4;
            }
        }
        return n2;
    }

    protected int[] getNDPosition(int n) {
        if (n >= this.data.length) {
            throw new IllegalArgumentException("Size of data provided " + n + "is larger then the size of the containing array" + this.data.length);
        }
        int n2 = this.dimensions.length;
        int[] nArray = new int[n2];
        if (n2 == 1) {
            nArray[0] = n;
            return nArray;
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n4 > 0) {
            nArray[n4] = n3 % this.dimensions[n4];
            n3 /= this.dimensions[n4];
            --n4;
        }
        nArray[0] = n3;
        return nArray;
    }

    private boolean checkValidPosition(int ... nArray) {
        int n = nArray.length;
        if (n > this.dimensions.length) {
            throw new IllegalArgumentException("Dimensionality of request and dataset are incompatible " + n + " requested and the internal " + "dimensions are " + this.dimensions.length);
        }
        if (n == this.dimensions.length) {
            int n2 = 0;
            while (n2 < n) {
                if (nArray[n2] < 0 || nArray[n2] >= this.dimensions[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public void checkCompatibility(DataSet dataSet) throws IllegalArgumentException {
        if (dataSet.getRank() != this.dimensions.length) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
        if (!Arrays.equals(dataSet.getDimensions(), this.dimensions)) {
            throw new IllegalArgumentException("Incompatible dimensions");
        }
    }

    public double getAbs(int n) {
        return this.data[n];
    }

    public void setAbs(double d, int n) {
        this.data[n] = d;
        this.setDirty();
    }

    public void put(int[] nArray, double[] dArray) {
        int n = nArray.length;
        int n2 = dArray.length;
        try {
            if (this.dataDimensions == null) {
                int n3 = 0;
                int n4 = 0;
                while (n3 < n) {
                    if (n4 >= n2) {
                        n4 -= n2;
                    }
                    this.data[nArray[n3]] = dArray[n4];
                    ++n3;
                    ++n4;
                }
            } else {
                int n5 = 0;
                int n6 = 0;
                while (n5 < n) {
                    if (n6 >= n2) {
                        n6 -= n2;
                    }
                    int[] nArray2 = this.getNDPosition(nArray[n5]);
                    this.data[this.get1DIndex((int[])nArray2)] = dArray[n6];
                    ++n5;
                    ++n6;
                }
            }
        }
        catch (Exception exception) {
            logger.error("An index was out of bounds");
            throw new IndexOutOfBoundsException("One of indices was out of bounds");
        }
    }

    public DataSet take(int[] nArray) {
        int n = nArray.length;
        DataSet dataSet = new DataSet(n);
        try {
            if (this.dataDimensions == null) {
                int n2 = 0;
                while (n2 < n) {
                    dataSet.data[n2] = this.data[nArray[n2]];
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    dataSet.data[n3] = this.data[this.get1DIndex(this.getNDPosition(nArray[n3]))];
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            logger.error("An index was out of bounds");
            throw new IndexOutOfBoundsException("One of indices was out of bounds");
        }
        return dataSet;
    }

    public double[] getBuffer() {
        return this.data;
    }

    public double[] getData() {
        return this.getBuffer();
    }

    @Override
    public int getItemsize() {
        return 8;
    }

    public int getNbytes() {
        return this.dataSize * this.getItemsize();
    }

    public double get(int ... nArray) {
        try {
            if (this.checkValidPosition(nArray)) {
                return this.data[this.get1DIndex(nArray)];
            }
            throw new IllegalArgumentException("Index not valid");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Cannot get value from dataset" + this + " The number of indexes is incorrect.");
            throw illegalArgumentException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.error("Cannot get value from dataset" + this + " The index is out of bounds.");
            throw arrayIndexOutOfBoundsException;
        }
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return (float)this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return (long)this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0.0;
    }

    @Override
    public Class<?> elementClass() {
        return Double.class;
    }

    @Override
    public int getElementsPerItem() {
        return 1;
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (object instanceof Number) {
            this.setItem(((Number)object).doubleValue(), nArray);
        } else if (object instanceof Complex) {
            this.setItem(((Complex)object).getReal(), nArray);
        } else if (object instanceof PyComplex) {
            this.setItem(((PyComplex)object).real, nArray);
        } else {
            logger.error("Cannot set with given object as its type is not supported");
            throw new IllegalArgumentException("Cannot set with given object as its type is not supported");
        }
    }

    public void setItem(double d, int ... nArray) {
        block7: {
            try {
                if (this.checkValidPosition(nArray)) {
                    this.data[this.get1DIndex((int[])nArray)] = d;
                    break block7;
                }
                try {
                    int n = nArray.length;
                    int[] nArray2 = new int[n];
                    int n2 = 0;
                    while (n2 < n) {
                        nArray2[n2] = nArray[n2] >= this.dimensions[n2] ? nArray[n2] + 1 : this.dimensions[n2];
                        ++n2;
                    }
                    this.allocateArray(nArray2);
                    this.data[this.get1DIndex((int[])nArray)] = d;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    logger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error("Cannot get value from dataset" + this + " The number of indices is incorect.");
                throw illegalArgumentException;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                logger.error("Index out of bounds");
                throw arrayIndexOutOfBoundsException;
            }
        }
        this.setDirty();
    }

    public Matrix getJamaMatrix() throws IllegalArgumentException {
        try {
            return new Matrix(this.doubleMatrix());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(this + " needs to be passed a 2-dimensional dataset, you passed it a dataset of rank " + this.dimensions.length);
            throw new IllegalArgumentException(this + " needs to be passed a 2-dimensional dataset, you passed it a " + this.dimensions.length + "-dimensional dataset");
        }
    }

    public synchronized double[] doubleArray() {
        IndexIterator indexIterator = this.getIterator();
        double[] dArray = new double[this.dataSize];
        int n = 0;
        while (indexIterator.hasNext()) {
            dArray[n] = this.data[indexIterator.index];
            ++n;
        }
        return dArray;
    }

    public synchronized double[][] doubleMatrix() throws IllegalArgumentException {
        if (this.dimensions.length != 2) {
            logger.error("doubleMatrix needs to be passed a 2-dimensional dataset, you passed it a {}-dimensional dataset", (Object)this.dimensions.length);
            throw new IllegalArgumentException(this + " needs to be passed a 2-dimensional dataset, you passed it a " + this.dimensions.length + "-dimensional dataset");
        }
        double[][] dArray = new double[this.dimensions[0]][this.dimensions[1]];
        int n = 0;
        while (n < this.dimensions[0]) {
            int n2 = 0;
            while (n2 < this.dimensions[1]) {
                dArray[n][n2] = this.get(n, n2);
                ++n2;
            }
            ++n;
        }
        return dArray;
    }

    @Deprecated
    public DataSet __add__(DataSet dataSet) {
        return DatasetMaths.add(this, dataSet);
    }

    @Deprecated
    public DataSet __add__(double d) {
        return DatasetMaths.add(this, d);
    }

    @Deprecated
    public DataSet __radd__(double d) {
        return DatasetMaths.add(this, d);
    }

    @Deprecated
    public DataSet __iadd__(Object object) {
        return this.iadd(object);
    }

    public DataSet iadd(Object object) {
        IndexIterator indexIterator = this.getIterator();
        if (object instanceof DataSet) {
            DataSet dataSet = (DataSet)object;
            this.checkCompatibility(dataSet);
            IndexIterator indexIterator2 = dataSet.getIterator();
            double[] dArray = dataSet.getBuffer();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] + dArray[indexIterator2.index];
            }
        } else {
            double d = ((Number)object).doubleValue();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] + d;
            }
        }
        this.setDirty();
        return this;
    }

    @Deprecated
    public DataSet __sub__(DataSet dataSet) {
        return DatasetMaths.subtract(this, dataSet);
    }

    @Deprecated
    public DataSet __sub__(double d) {
        return DatasetMaths.subtract(this, d);
    }

    @Deprecated
    public DataSet __rsub__(double d) {
        return DatasetMaths.subtract(d, this);
    }

    @Deprecated
    public DataSet __isub__(Object object) {
        return this.isubtract(object);
    }

    public DataSet isubtract(Object object) {
        IndexIterator indexIterator = this.getIterator();
        if (object instanceof DataSet) {
            DataSet dataSet = (DataSet)object;
            this.checkCompatibility(dataSet);
            IndexIterator indexIterator2 = dataSet.getIterator();
            double[] dArray = dataSet.getBuffer();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] - dArray[indexIterator2.index];
            }
        } else {
            double d = ((Number)object).doubleValue();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] - d;
            }
        }
        this.setDirty();
        return this;
    }

    @Deprecated
    public DataSet __div__(DataSet dataSet) {
        return DatasetMaths.divide(this, dataSet);
    }

    @Deprecated
    public DataSet __div__(double d) {
        return DatasetMaths.divide(this, d);
    }

    @Deprecated
    public DataSet __rdiv__(double d) {
        return DatasetMaths.divide(d, this);
    }

    @Deprecated
    public DataSet __idiv__(Object object) {
        return this.idivide(object);
    }

    public DataSet idivide(Object object) {
        IndexIterator indexIterator = this.getIterator();
        if (object instanceof DataSet) {
            DataSet dataSet = (DataSet)object;
            this.checkCompatibility(dataSet);
            IndexIterator indexIterator2 = dataSet.getIterator();
            double[] dArray = dataSet.getBuffer();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] / dArray[indexIterator2.index];
            }
        } else {
            double d = ((Number)object).doubleValue();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] / d;
            }
        }
        this.setDirty();
        return this;
    }

    @Deprecated
    public DataSet __mul__(DataSet dataSet) {
        return DatasetMaths.multiply(this, dataSet);
    }

    @Deprecated
    public DataSet __mul__(double d) {
        return DatasetMaths.multiply(this, d);
    }

    @Deprecated
    public DataSet __rmul__(double d) {
        return DatasetMaths.multiply(this, d);
    }

    @Deprecated
    public DataSet __imul__(Object object) {
        return this.imultiply(object);
    }

    public DataSet imultiply(Object object) {
        IndexIterator indexIterator = this.getIterator();
        if (object instanceof DataSet) {
            DataSet dataSet = (DataSet)object;
            this.checkCompatibility(dataSet);
            IndexIterator indexIterator2 = dataSet.getIterator();
            double[] dArray = dataSet.getBuffer();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] * dArray[indexIterator2.index];
            }
        } else {
            double d = ((Number)object).doubleValue();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] * d;
            }
        }
        this.setDirty();
        return this;
    }

    @Deprecated
    public DataSet __pow__(double d) {
        return DatasetMaths.power(this, d);
    }

    @Deprecated
    public DataSet __ipow__(Object object) {
        return this.ipower(object);
    }

    public DataSet ipower(Object object) {
        IndexIterator indexIterator = this.getIterator();
        try {
            if (object instanceof DataSet) {
                DataSet dataSet = (DataSet)object;
                this.checkCompatibility(dataSet);
                IndexIterator indexIterator2 = dataSet.getIterator();
                double[] dArray = dataSet.getBuffer();
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    this.data[indexIterator.index] = Math.pow(this.data[indexIterator.index], dArray[indexIterator2.index]);
                }
            } else {
                double d = ((Number)object).doubleValue();
                while (indexIterator.hasNext()) {
                    this.data[indexIterator.index] = Math.pow(this.data[indexIterator.index], d);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Cannot raise negative number to a fractional power");
            throw new IllegalArgumentException("Cannot raise negative number to a fractional power", exception);
        }
        this.setDirty();
        return this;
    }

    @Deprecated
    public DataSet __neg__() {
        return DatasetMaths.negative(this);
    }

    public Object __eq__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d == d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    public Object __ne__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d != d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    public Object __gt__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d > d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    public Object __lt__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d < d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    public Object __ge__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d >= d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    public Object __le__(DataSet dataSet) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < this.data.length) {
            d += this.data[n] * this.data[n];
            d2 += dataSet.data[n] * dataSet.data[n];
            ++n;
        }
        if (d <= d2) {
            PyInteger pyInteger = new PyInteger(1);
            return pyInteger;
        }
        PyInteger pyInteger = new PyInteger(0);
        return pyInteger;
    }

    @Deprecated
    public Object __contains__(Integer n) {
        logger.warn(String.valueOf(depMsg) + "8");
        return true;
    }

    public Object __getitem__(Integer n) {
        if (n < -this.dimensions[0] || n >= this.dimensions[0]) {
            logger.error("The value {} is not within the dataset's bounds", (Object)n);
            throw new PyException(Py.IndexError);
        }
        if (n < 0) {
            n = n + this.dimensions[0];
        }
        if (this.dimensions.length == 1) {
            return this.data[n];
        }
        Object[] objectArray = new Object[]{n};
        return this.__getitem__(objectArray);
    }

    public Object __getitem__(Integer[] integerArray) {
        int n;
        int[] nArray = new int[this.dimensions.length];
        if (integerArray.length > this.dimensions.length) {
            n = this.dimensions.length;
        } else if (integerArray.length == this.dimensions.length) {
            n = integerArray.length;
        } else {
            return this.__getitem__((Object[])integerArray);
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = integerArray[n2];
            if (n3 < -this.dimensions[n2] || n3 >= this.dimensions[n2]) {
                logger.error("The value {} is not within the dataset's bounds", (Object[])integerArray);
                throw new PyException(Py.IndexError);
            }
            if (n3 < 0) {
                n3 += this.dimensions[n2];
            }
            nArray[n2] = n3;
            ++n2;
        }
        while (n2 < this.dimensions.length) {
            nArray[n2] = 0;
            ++n2;
        }
        return this.get(nArray);
    }

    public DataSet __getitem__(PySlice pySlice) {
        int n = pySlice.step instanceof PyNone ? 1 : ((PyInteger)pySlice.step).getValue();
        int n2 = pySlice.start instanceof PyNone ? (n > 0 ? 0 : this.dimensions[0] - 1) : ((PyInteger)pySlice.start).getValue();
        int n3 = pySlice.stop instanceof PyNone ? (n > 0 ? this.dimensions[0] : -1) : ((PyInteger)pySlice.stop).getValue();
        return this.getSlice(n2, n3, n);
    }

    public DataSet __getitem__(Object[] objectArray) {
        DataSet dataSet;
        int n = this.dimensions.length;
        int n2 = objectArray.length > n ? n : objectArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean[] blArray = new boolean[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (objectArray[n4] instanceof Integer) {
                blArray[n4] = true;
                nArray[n4] = (Integer)objectArray[n4];
                if (nArray[n4] < -this.dimensions[n4] || nArray[n4] >= this.dimensions[n4]) {
                    logger.error("The value {} is not within the dataset's bounds", (Object)nArray);
                    throw new PyException(Py.IndexError);
                }
                if (nArray[n4] < 0) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + this.dimensions[n4];
                }
                nArray2[n4] = nArray[n4] + 1;
                nArray3[n4] = 1;
            } else if (objectArray[n4] instanceof PySlice) {
                blArray[n4] = false;
                ++n3;
                dataSet = (PySlice)objectArray[n4];
                nArray[n4] = ((PySlice)dataSet).start instanceof PyNone ? 0 : ((PyInteger)((PySlice)dataSet).start).getValue();
                nArray2[n4] = ((PySlice)dataSet).stop instanceof PyNone ? this.dimensions[n4] : ((PyInteger)((PySlice)dataSet).stop).getValue();
                nArray3[n4] = ((PySlice)dataSet).step instanceof PyNone ? 1 : ((PyInteger)((PySlice)dataSet).step).getValue();
            }
            ++n4;
        }
        while (n4 < n) {
            blArray[n4] = false;
            ++n3;
            nArray[n4] = 0;
            nArray2[n4] = this.dimensions[n4];
            nArray3[n4] = 1;
            ++n4;
        }
        dataSet = this.getSlice(nArray, nArray2, nArray3);
        if (n3 < n) {
            int[] nArray4 = dataSet.getDimensions();
            int[] nArray5 = new int[n3];
            int n6 = 0;
            n4 = 0;
            while (n4 < n) {
                if (!blArray[n4]) {
                    nArray5[n6++] = nArray4[n4];
                }
                ++n4;
            }
            dataSet.reshape(nArray5);
        }
        return dataSet;
    }

    public Object __delitem__(Integer n) {
        return null;
    }

    public void __setitem__(Integer n, Double d) {
        if (this.dimensions.length > 1) {
            logger.error("Cannot set an implicit slice to a single value");
            throw new PyException(Py.NotImplementedError);
        }
        if (n < -this.dataSize || n >= this.dataSize) {
            logger.error("The value {} is not within the dataset's bounds", (Object)n);
            throw new PyException(Py.IndexError);
        }
        if (n < 0) {
            n = n + this.dataSize;
        }
        this.data[n.intValue()] = d;
        this.setDirty();
    }

    public void __setitem__(Integer[] integerArray, Double d) {
        int n = this.dimensions.length;
        int[] nArray = new int[n];
        int n2 = integerArray.length > n ? n : integerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = integerArray[n3];
            if (nArray[n3] < -this.dimensions[n3] || nArray[n3] >= this.dimensions[n3]) {
                logger.error("The value {} is not within the dataset's bounds", (Object)nArray);
                throw new PyException(Py.IndexError);
            }
            if (nArray[n3] < 0) {
                int n4 = n3;
                nArray[n4] = nArray[n4] + this.dimensions[n3];
            }
            ++n3;
        }
        while (n3 < n) {
            nArray[n3] = 0;
            ++n3;
        }
        this.set(d, nArray);
    }

    public void __setitem__(PySlice pySlice, Double d) {
        int n = pySlice.start instanceof PyNone ? 0 : ((PyInteger)pySlice.start).getValue();
        int n2 = pySlice.stop instanceof PyNone ? this.dimensions[0] : ((PyInteger)pySlice.stop).getValue();
        int n3 = pySlice.step instanceof PyNone ? 1 : ((PyInteger)pySlice.step).getValue();
        this.setSlice(n, n2, n3, (double)d);
    }

    public void __setitem__(PySlice pySlice, DataSet dataSet) {
        int n = pySlice.start instanceof PyNone ? 0 : ((PyInteger)pySlice.start).getValue();
        int n2 = pySlice.stop instanceof PyNone ? this.dimensions[0] : ((PyInteger)pySlice.stop).getValue();
        int n3 = pySlice.step instanceof PyNone ? 1 : ((PyInteger)pySlice.step).getValue();
        this.setSlice(n, n2, n3, dataSet);
    }

    public void __setitem__(PySlice[] pySliceArray, Double d) {
        int n = this.dimensions.length;
        int n2 = pySliceArray.length > n ? n : pySliceArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = pySliceArray[n3].start instanceof PyNone ? 0 : ((PyInteger)pySliceArray[n3].start).getValue();
            nArray2[n3] = pySliceArray[n3].stop instanceof PyNone ? this.dimensions[n3] : ((PyInteger)pySliceArray[n3].stop).getValue();
            nArray3[n3] = pySliceArray[n3].step instanceof PyNone ? 1 : ((PyInteger)pySliceArray[n3].step).getValue();
            ++n3;
        }
        while (n3 < n) {
            nArray[n3] = 0;
            nArray2[n3] = this.dimensions[n3];
            nArray3[n3] = 1;
            ++n3;
        }
        this.setSlice(nArray, nArray2, nArray3, (double)d);
    }

    public void __setitem__(PySlice[] pySliceArray, DataSet dataSet) {
        int n = this.dimensions.length;
        int n2 = pySliceArray.length > n ? n : pySliceArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = pySliceArray[n3].start instanceof PyNone ? 0 : ((PyInteger)pySliceArray[n3].start).getValue();
            nArray2[n3] = pySliceArray[n3].stop instanceof PyNone ? this.dimensions[n3] : ((PyInteger)pySliceArray[n3].stop).getValue();
            nArray3[n3] = pySliceArray[n3].step instanceof PyNone ? 1 : ((PyInteger)pySliceArray[n3].step).getValue();
            ++n3;
        }
        while (n3 < n) {
            nArray[n3] = 0;
            nArray2[n3] = this.dimensions[n3];
            nArray3[n3] = 1;
            ++n3;
        }
        this.setSlice(nArray, nArray2, nArray3, dataSet);
    }

    @Deprecated
    public Object __len__() {
        return this.getSize();
    }

    @Deprecated
    public DataSetIterator __iter__() {
        return new DataSetIterator(this);
    }

    private String sanitizeLine(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 1024) {
            int n = stringBuilder.length() - 1024 + 5;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.subSequence(0, (stringBuilder.length() - n) / 2));
            stringBuilder2.append("\t...\t");
            stringBuilder2.append(stringBuilder.subSequence((stringBuilder.length() + n) / 2, stringBuilder.length()));
            return stringBuilder2.toString();
        }
        return stringBuilder.toString();
    }

    public void disp() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataSet Dimensions are [" + this.dimensions[0]);
        int n2 = this.dimensions.length;
        int n3 = 1;
        while (n3 < n2) {
            stringBuilder.append(", " + this.dimensions[n3]);
            ++n3;
        }
        stringBuilder.append("]");
        TerminalPrinter.print(stringBuilder.toString());
        stringBuilder.delete(0, stringBuilder.length());
        if (n2 == 1) {
            stringBuilder.append(String.format("[\t%.4e", this.get(0)));
            n3 = 1;
            while (n3 < this.dimensions[0]) {
                stringBuilder.append(String.format(",\t%.4e", this.get(n3++)));
            }
            stringBuilder.append("\t]");
            TerminalPrinter.print(this.sanitizeLine(stringBuilder));
        }
        if (n2 == 2) {
            n3 = 0;
            while (n3 < this.dimensions[0]) {
                stringBuilder.append(String.format("|\t%.4e", this.get(n3, 0)));
                n = 1;
                while (n < this.dimensions[1]) {
                    stringBuilder.append(String.format(",\t%.4e", this.get(n3, n++)));
                }
                stringBuilder.append("\t|");
                TerminalPrinter.print(this.sanitizeLine(stringBuilder));
                stringBuilder.delete(0, stringBuilder.length());
                ++n3;
            }
        }
        if (n2 == 3) {
            n3 = 0;
            while (n3 < this.dimensions[2]) {
                stringBuilder.append("\t----------");
                ++n3;
            }
            TerminalPrinter.print(stringBuilder.toString());
            stringBuilder.delete(0, stringBuilder.length());
            n3 = 0;
            while (n3 < this.dimensions[0]) {
                n = 0;
                while (n < this.dimensions[1]) {
                    stringBuilder.append(String.format("|\t%.4e", this.get(n3, n, 0)));
                    int n4 = 1;
                    while (n4 < this.dimensions[2]) {
                        stringBuilder.append(String.format(",\t%.4e", this.get(n3, n, n4++)));
                    }
                    stringBuilder.append("\t|");
                    TerminalPrinter.print(this.sanitizeLine(stringBuilder));
                    stringBuilder.delete(0, stringBuilder.length());
                    ++n;
                }
                n = 0;
                while (n < this.dimensions[2]) {
                    stringBuilder.append("\t----------");
                    ++n;
                }
                TerminalPrinter.print(stringBuilder.toString());
                stringBuilder.delete(0, stringBuilder.length());
                ++n3;
            }
        }
        if (n2 > 3) {
            stringBuilder.append("<" + this.dimensions[0]);
            n3 = 1;
            while (n3 < n2) {
                stringBuilder.append(String.valueOf(this.dimensions[n3]) + ",");
                ++n3;
            }
            stringBuilder.append(">");
            TerminalPrinter.print(stringBuilder.toString());
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append("[" + this.get(0));
            n3 = 1;
            while (n3 < this.dataSize) {
                stringBuilder.append("," + this.get(n3++));
            }
            stringBuilder.append("]");
            TerminalPrinter.print(this.sanitizeLine(stringBuilder));
        }
    }

    public DataSet append(DataSet dataSet, int n) {
        int n2 = this.dimensions.length;
        int[] nArray = dataSet.getDimensions();
        if (n2 != nArray.length) {
            throw new IllegalArgumentException("Incompatible number of dimensions");
        }
        if (n >= n2) {
            throw new IllegalArgumentException("Axis specified exceeds array dimensions");
        }
        if (n == -1) {
            n = n2 - 1;
        } else if (n < -1) {
            throw new IllegalArgumentException("Axis specified is less than -1");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n && this.dimensions[n3] != nArray[n3]) {
                throw new IllegalArgumentException("Incompatible dimensions");
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = this.dimensions[n4];
            ++n4;
        }
        int n5 = n;
        nArray2[n5] = nArray2[n5] + nArray[n];
        DataSet dataSet2 = new DataSet(nArray2);
        int n6 = 0;
        int n7 = dataSet2.getSize();
        while (n6 < n7) {
            int[] nArray3 = dataSet2.getNDPosition(n6);
            boolean bl = true;
            int n8 = 0;
            while (n8 < nArray2.length) {
                if (nArray3[n8] >= this.dimensions[n8]) {
                    bl = false;
                    int n9 = n8;
                    nArray3[n9] = nArray3[n9] - this.dimensions[n8];
                    break;
                }
                ++n8;
            }
            if (bl) {
                dataSet2.set(this.get(nArray3), n6);
            } else {
                dataSet2.set(dataSet.get(nArray3), n6);
            }
            ++n6;
        }
        return dataSet2;
    }

    public DataSet fill(double d) {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = d;
        }
        this.setDirty();
        return this;
    }

    public static DataSet arange(double d, double d2, double d3) {
        if (d >= d2) {
            throw new IllegalArgumentException("Start value greater than or equal stop value");
        }
        int n = (int)Math.ceil((d2 - d) / d3);
        DataSet dataSet = new DataSet(n);
        double d4 = d;
        int n2 = 0;
        while (n2 < n) {
            dataSet.set(d4, n2++);
            d4 += d3;
        }
        return dataSet;
    }

    public static DataSet arange(double d, double d2) {
        return DataSet.arange(d, d2, 1.0);
    }

    public static DataSet arange(double d) {
        return DataSet.arange(0.0, d, 1.0);
    }

    public static DataSet array(Matrix matrix) {
        return new DataSet(matrix);
    }

    public static DataSet array(PySequence pySequence) {
        return new DataSet(pySequence);
    }

    public static DataSet array(Number number) {
        return new DataSet(new double[]{number.doubleValue()});
    }

    public DataSet clone() {
        return new DataSet(this);
    }

    public DataSet copy() {
        return this.clone();
    }

    public void reshape(int ... nArray) {
        int n = 1;
        if (this.dataDimensions != null) {
            logger.error("Cannot set a new shape to a discontiguous or fragmented dataset: copy dataset first");
            throw new UnsupportedOperationException("Cannot set a new shape to discontiguous dataset");
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] <= 0) {
                logger.error("Argument " + n2 + " is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
                throw new IllegalArgumentException("Argument " + n2 + " is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
            }
            n *= nArray[n2];
            ++n2;
        }
        if (n != this.dataSize) {
            logger.error("New shape (" + nArray + ") is not compatible with old shape (" + this.dimensions + ")");
            throw new IllegalArgumentException("New shape (" + nArray + ") is not compatible with old shape (" + this.dimensions + ")");
        }
        this.dimensions = (int[])nArray.clone();
    }

    public void resize(int ... nArray) {
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] <= 0) {
                logger.error("Argument " + n2 + " is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
                throw new IllegalArgumentException("Argument " + n2 + " is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
            }
            n *= nArray[n2];
            ++n2;
        }
        double[] dArray = new double[n];
        IndexIterator indexIterator = this.getIterator();
        int n3 = 0;
        while (indexIterator.hasNext() && n3 < n) {
            dArray[n3++] = this.data[indexIterator.index];
        }
        this.data = dArray;
        this.dimensions = (int[])nArray.clone();
    }

    public static DataSet linspace(double d, double d2, int n) {
        if (n < 1 || d > d2) {
            throw new IllegalArgumentException("Length is less than one or start is greater than stop");
        }
        if (n == 1) {
            double[] dArray = new double[]{d};
            return new DataSet(dArray);
        }
        DataSet dataSet = new DataSet(n);
        double d3 = (d2 - d) / (double)(n - 1);
        int n2 = 0;
        while (n2 < n) {
            double d4 = d + (double)n2 * d3;
            dataSet.set(d4, n2++);
        }
        return dataSet;
    }

    public static DataSet ones(int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        dataSet.fill(1.0);
        return dataSet;
    }

    public static DataSet zeros(int ... nArray) {
        DataSet dataSet = new DataSet(nArray);
        dataSet.fill(0.0);
        return dataSet;
    }

    @Override
    public Double min() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Double)this.storedValues.get("min");
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return this.getNDPosition((Integer)this.storedValues.get("minpos"));
    }

    public int argmin() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Integer)this.storedValues.get("minpos");
    }

    @Override
    public Double max() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Double)this.storedValues.get("max");
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return this.getNDPosition((Integer)this.storedValues.get("maxpos"));
    }

    public int argmax() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Integer)this.storedValues.get("maxpos");
    }

    public double mean() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Double)this.storedValues.get("mean");
    }

    public double range() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Double)this.storedValues.get("max") - (Double)this.storedValues.get("min");
    }

    public Double sum() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return (Double)this.storedValues.get("sum");
    }

    public double rms() {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        double d = (Double)this.storedValues.get("mean");
        return Math.sqrt((Double)this.storedValues.get("centralmom2") + d * d);
    }

    public double std() {
        return this.std(false);
    }

    public double std(boolean bl) {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        return Math.sqrt(this.var(bl));
    }

    public double var() {
        return this.var(false);
    }

    public double var(boolean bl) {
        if (this.storedValues == null) {
            this.calculateMinMaxMeanSumDeviation();
        }
        if (bl && this.dataSize > 1) {
            double d = (double)this.dataSize / ((double)this.dataSize - 1.0);
            return (Double)this.storedValues.get("centralmom2") * d;
        }
        return (Double)this.storedValues.get("centralmom2");
    }

    public double prod() {
        IndexIterator indexIterator = this.getIterator();
        double d = 1.0;
        while (indexIterator.hasNext()) {
            d *= this.data[indexIterator.index];
        }
        return d;
    }

    @Deprecated
    public double averageDeviation() {
        logger.warn(String.valueOf(depMsg) + "8 - use DatasetMaths.getAverageDeviation()");
        return DatasetMaths.getAverageDeviation(this);
    }

    @Deprecated
    public DataSet diff() {
        logger.warn(String.valueOf(depMsg) + "8 - use getIndexDataSet and DatasetMaths.derivative()");
        return this.diff(1);
    }

    @Deprecated
    public DataSet diff(int n) {
        logger.warn(String.valueOf(depMsg) + "8 - use getIndexDataSet and DatasetMaths.derivative()");
        DataSet dataSet = this.getIndexDataSet();
        return DatasetMaths.derivative(dataSet, this, n);
    }

    @Deprecated
    public DataSet diff(DataSet dataSet) {
        logger.warn(String.valueOf(depMsg) + "8 - use DatasetMaths.derivative()");
        return DatasetMaths.derivative(dataSet, this, 1);
    }

    @Deprecated
    public DataSet diff(DataSet dataSet, int n) {
        logger.warn(String.valueOf(depMsg) + "8 - use DatasetMaths.derivative()");
        return DatasetMaths.derivative(dataSet, this, n);
    }

    public DataSet getSlice(int n) {
        return this.getSlice(null, new int[]{n}, null);
    }

    public DataSet getSlice(int n, int n2) {
        return this.getSlice(new int[]{n}, new int[]{n2}, null);
    }

    public DataSet getSlice(int n, int n2, int n3) {
        return this.getSlice(new int[]{n}, new int[]{n2}, new int[]{n3});
    }

    @Override
    public DataSet getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        DataSet dataSet = DataSet.zeros(sliceIterator.getSliceShape());
        double[] dArray = dataSet.getBuffer();
        int n = 0;
        while (sliceIterator.hasNext()) {
            dArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        return dataSet;
    }

    public IndexIterator getSliceIterator(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int[] nArray4;
        int n2 = this.dimensions.length;
        int[] nArray5 = new int[n2];
        if (nArray3 == null) {
            nArray4 = new int[n2];
            n = 0;
            while (n < n2) {
                nArray4[n] = 1;
                ++n;
            }
        } else {
            nArray4 = nArray3;
        }
        int[] nArray6 = nArray == null ? new int[n2] : nArray;
        int[] nArray7 = nArray2 == null ? new int[n2] : nArray2;
        if (n2 != this.dimensions.length || nArray7.length != this.dimensions.length || nArray4.length != this.dimensions.length) {
            logger.error("Wrong number of indexes, you passed it start={}, stop={}, step={}, and it needs {}", (Object)new int[]{n2, nArray7.length, nArray4.length, this.dimensions.length});
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + nArray6.length + ", stop=" + nArray7.length + ", step=" + nArray4.length + ", and it needs " + this.dimensions.length);
        }
        n = 0;
        while (n < n2) {
            if (nArray4[n] == 0) {
                logger.error("Array of steps should be all non-zero");
                throw new IllegalArgumentException("The step array is not allowed any zero entries: " + n + "-th entry is zero");
            }
            if (nArray != null) {
                if (nArray[n] < 0) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.dimensions[n];
                }
                if (nArray[n] < 0) {
                    int n4 = nArray[n] = nArray4[n] > 0 ? 0 : -1;
                }
                if (nArray[n] > this.dimensions[n]) {
                    nArray[n] = nArray4[n] > 0 ? this.dimensions[n] : this.dimensions[n] - 1;
                }
            } else {
                int n5 = nArray6[n] = nArray4[n] > 0 ? 0 : this.dimensions[n] - 1;
            }
            if (nArray2 != null) {
                if (nArray2[n] < 0) {
                    int n6 = n;
                    nArray2[n6] = nArray2[n6] + (nArray4[n] > 0 ? this.dimensions[n] : 0);
                }
                if (nArray2[n] < 0) {
                    nArray2[n] = -1;
                }
                if (nArray2[n] > this.dimensions[n]) {
                    nArray2[n] = this.dimensions[n];
                }
            } else {
                int n7 = nArray7[n] = nArray4[n] > 0 ? this.dimensions[n] : -1;
            }
            if (nArray6[n] == nArray7[n]) {
                logger.error("Same start=stop={} indices has been passed", (Object)nArray6[n]);
                throw new IllegalArgumentException("Same indices in start and stop");
            }
            if (nArray4[n] > 0 != nArray6[n] < nArray7[n]) {
                logger.error("Passed values of start={} and stop={} indices that are incompatible with step={}", (Object)new int[]{nArray6[n], nArray7[n], nArray4[n]});
                throw new IllegalArgumentException("Start=" + nArray6[n] + " and stop=" + nArray7[n] + " indices are incompatible with step=" + nArray4[n]);
            }
            nArray5[n] = nArray4[n] > 0 ? (nArray7[n] - nArray6[n] - 1) / nArray4[n] + 1 : (nArray7[n] - nArray6[n] + 1) / nArray4[n] + 1;
            ++n;
        }
        if (this.dataDimensions == null) {
            return new SliceIterator(this.dimensions, this.dataSize, nArray6, nArray4, nArray5);
        }
        return new SliceIterator(this.dataDimensions, this.dataSize, nArray6, nArray4, nArray5);
    }

    public void squeeze() {
        this.squeeze(false);
    }

    public void squeeze(boolean bl) {
        int[] nArray = DataSet.squeezeShape(this.dimensions, bl);
        if (nArray != null) {
            this.dimensions = nArray;
        }
    }

    protected static int[] squeezeShape(int[] nArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = nArray.length;
        if (bl) {
            n = n3 - 1;
            while (n >= 0) {
                if (nArray[n] == 1) {
                    ++n2;
                    --n;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < n3) {
                if (nArray[n] == 1) {
                    ++n2;
                }
                ++n;
            }
        }
        if (n2 == 0) {
            return null;
        }
        int[] nArray2 = new int[n3 - n2];
        if (bl) {
            n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                if (nArray[n6] > 1) {
                    nArray2[n5++] = nArray[n6];
                }
                ++n6;
            }
        }
        return nArray2;
    }

    @Deprecated
    public void setSlice(int n, double d) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, null, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(new int[]{n}, null, null, d);
    }

    @Deprecated
    public void setSlice(int n, int n2, double d) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(new int[]{n}, new int[]{n2}, null, d);
    }

    @Deprecated
    public void setSlice(int n, int n2, int n3, double d) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, step, values) instead or python slicing [start0:stop0:step0,start1:stop1:step1]");
        this.setSlice(new int[]{n}, new int[]{n2}, new int[]{n3}, d);
    }

    @Deprecated
    public void setSlice(int[] nArray, double d) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, null, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(nArray, null, null, d);
    }

    @Deprecated
    public void setSlice(int[] nArray, int[] nArray2, double d) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(nArray, nArray2, null, d);
    }

    public void setSlice(int[] nArray, int[] nArray2, int[] nArray3, double d) {
        int n;
        int n2 = nArray.length;
        if (nArray2 == null) {
            nArray2 = new int[n2];
            n = 0;
            while (n < n2) {
                nArray2[n] = this.dimensions[n];
                ++n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[n2];
            n = 0;
            while (n < n2) {
                nArray3[n] = 1;
                ++n;
            }
        }
        if (n2 != this.dimensions.length || nArray2.length != this.dimensions.length || nArray3.length != this.dimensions.length) {
            logger.error(this + " needs to be passed the correct number of indexes, you passed it start=" + n2 + ", stop=" + nArray2.length + ", step=" + nArray3.length + ", and it needs " + this.dimensions.length);
            throw new IllegalArgumentException("No of indexes does not match data dimensions you passed it start=" + nArray.length + ", stop=" + nArray2.length + ", step=" + nArray3.length + " pairs of bounds, and it needs " + this.dimensions.length + " pairs");
        }
        n = 0;
        while (n < n2) {
            if (nArray3[n] == 0) {
                logger.error(this + " needs to be passed an array of steps which are all non-zero");
                throw new IllegalArgumentException("The step array is not allowed any zero entries: " + n + "-th entry is zero");
            }
            if (nArray[n] < 0) {
                int n3 = n;
                nArray[n3] = nArray[n3] + this.dimensions[n];
            }
            if (nArray[n] > this.dimensions[n]) {
                nArray[n] = this.dimensions[n];
            }
            if (nArray[n] < 0) {
                logger.error(this + " has been passed start=" + nArray[n] + "that is outside valid range of [0, " + this.dimensions[n] + "]");
                throw new IllegalArgumentException("A start index, " + nArray[n] + ", is outside valid range of [0, " + this.dimensions[n] + "]");
            }
            if (nArray2[n] < 0) {
                int n4 = n;
                nArray2[n4] = nArray2[n4] + this.dimensions[n];
            }
            if (nArray2[n] > this.dimensions[n]) {
                nArray2[n] = this.dimensions[n];
            }
            if (nArray2[n] < 0) {
                logger.error(this + " has been passed stop=" + nArray2[n] + "that is outside valid range of [0, " + this.dimensions[n] + "]");
                throw new IllegalArgumentException("A stop index, " + nArray2[n] + ", is outside valid range of [0, " + this.dimensions[n] + "]");
            }
            if (nArray[n] == nArray2[n]) {
                logger.error(this + " has been passed the same start=stop=" + nArray[n] + " indexes");
                throw new IllegalArgumentException("Same indexes in start and stop");
            }
            if (nArray3[n] > 0 != nArray[n] < nArray2[n]) {
                logger.error(this + " has been passed start=" + nArray[n] + " and stop=" + nArray2[n] + " indexes that are incompatible with step=" + nArray3[n]);
                throw new IllegalArgumentException("Start=" + nArray[n] + " and stop=" + nArray2[n] + " indexes are incompatible with step=" + nArray3[n]);
            }
            ++n;
        }
        int[] nArray4 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray4[n5] = nArray[n5];
            ++n5;
        }
        block4: do {
            this.set(d, nArray4);
            n5 = 0;
            while (n5 < n2) {
                int n6 = n5;
                nArray4[n6] = nArray4[n6] + nArray3[n5];
                if (nArray3[n5] > 0) {
                    if (nArray4[n5] < nArray2[n5]) continue block4;
                    nArray4[n5] = nArray[n5];
                } else {
                    if (nArray4[n5] > nArray2[n5]) continue block4;
                    nArray4[n5] = nArray[n5];
                }
                ++n5;
            }
        } while (n5 != n2);
    }

    @Deprecated
    public void setSlice(int n, DataSet dataSet) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(new int[]{n}, null, null, dataSet);
    }

    @Deprecated
    public void setSlice(int n, int n2, DataSet dataSet) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(new int[]{n}, new int[]{n2}, null, dataSet);
    }

    @Deprecated
    public void setSlice(int n, int n2, int n3, DataSet dataSet) {
        logger.warn(String.valueOf(depMsg) + "8 - use setSlice(start, stop, null, values) instead or python slicing [start0:stop0,start1:stop1]");
        this.setSlice(new int[]{n}, new int[]{n2}, new int[]{n3}, dataSet);
    }

    public void setSlice(int[] nArray, int[] nArray2, int[] nArray3, DataSet dataSet) {
        int n;
        int n2;
        int n3;
        int n4 = nArray.length;
        if (nArray2 == null) {
            nArray2 = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                nArray2[n3] = this.dimensions[n3];
                ++n3;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                nArray3[n3] = 1;
                ++n3;
            }
        }
        if (n4 != this.dimensions.length || nArray2.length != this.dimensions.length || nArray3.length != this.dimensions.length) {
            logger.error(this + " needs to be passed the correct number of indexes, you passed it start=" + n4 + ", stop=" + nArray2.length + ", step=" + nArray3.length + ", and it needs " + this.dimensions.length);
            throw new IllegalArgumentException("No of indexes does not match data dimensions you passed it start=" + nArray.length + ", stop=" + nArray2.length + ", step=" + nArray3.length + " pairs of bounds, and it needs " + this.dimensions.length + " pairs");
        }
        int[] nArray4 = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            if (nArray3[n5] == 0) {
                logger.error(this + " needs to be passed an array of steps which are all non-zero");
                throw new IllegalArgumentException("The step array is not allowed any zero entries: " + n5 + "-th entry is zero");
            }
            if (nArray[n5] < 0) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + this.dimensions[n5];
            }
            if (nArray[n5] > this.dimensions[n5]) {
                nArray[n5] = this.dimensions[n5];
            }
            if (nArray[n5] < 0) {
                logger.error(this + " has been passed start=" + nArray[n5] + "that is outside valid range of [0, " + this.dimensions[n5] + "]");
                throw new IllegalArgumentException("A start index, " + nArray[n5] + ", is outside valid range of [0, " + this.dimensions[n5] + "]");
            }
            if (nArray2[n5] < 0) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + this.dimensions[n5];
            }
            if (nArray2[n5] > this.dimensions[n5]) {
                nArray2[n5] = this.dimensions[n5];
            }
            if (nArray2[n5] < 0) {
                logger.error(this + " has been passed stop=" + nArray2[n5] + "that is outside valid range of [0, " + this.dimensions[n5] + "]");
                throw new IllegalArgumentException("A stop index, " + nArray2[n5] + ", is outside valid range of [0, " + this.dimensions[n5] + "]");
            }
            if (nArray[n5] == nArray2[n5]) {
                logger.error(this + " has been passed the same start=stop=" + nArray[n5] + " indexes");
                throw new IllegalArgumentException("Same indexes in start and stop");
            }
            if (nArray3[n5] > 0 != nArray[n5] < nArray2[n5]) {
                logger.error(this + " has been passed start=" + nArray[n5] + " and stop=" + nArray2[n5] + " indexes that are incompatible with step=" + nArray3[n5]);
                throw new IllegalArgumentException("Start=" + nArray[n5] + " and stop=" + nArray2[n5] + " indexes are incompatible with step=" + nArray3[n5]);
            }
            nArray4[n5] = nArray3[n5] > 0 ? (nArray2[n5] - nArray[n5] + nArray3[n5] - 1) / nArray3[n5] : (nArray2[n5] - nArray[n5] + nArray3[n5] + 1) / nArray3[n5];
            ++n5;
        }
        int[] nArray5 = dataSet.getDimensions();
        int n8 = nArray5.length;
        boolean[] blArray = new boolean[n4];
        if (n8 != n4) {
            n2 = 0;
            int n9 = 0;
            while (n9 < n4) {
                if (nArray4[n9] == 1) {
                    ++n2;
                    blArray[n9] = true;
                } else {
                    blArray[n9] = false;
                }
                ++n9;
            }
            if (n8 != n4 - n2) {
                logger.error("Input dataset that has incompatible rank");
                throw new IllegalArgumentException("Incompatible rank for input dataset");
            }
            if (n2 > 0) {
                int[] nArray6 = DataSet.squeezeShape(nArray4, false);
                if (n8 != nArray6.length) {
                    logger.error("Input dataset that has incompatible rank");
                    throw new IllegalArgumentException("Incompatible rank for input dataset");
                }
                n = 0;
                while (n < n8) {
                    if (nArray5[n] < nArray6[n]) {
                        logger.error("Input dataset with a dimension that is too short: {}", (Object)nArray5[n]);
                        throw new IllegalArgumentException("Dimension of input dataset too short: " + nArray5[n]);
                    }
                    ++n;
                }
            }
        } else {
            n2 = 0;
            while (n2 < n8) {
                if (nArray5[n2] < nArray4[n2]) {
                    logger.error("Input dataset with a dimension that is too short: {}", (Object)nArray5[n2]);
                    throw new IllegalArgumentException("Dimension of input dataset too short: " + nArray5[n2]);
                }
                ++n2;
            }
        }
        int[] nArray7 = new int[n4];
        int[] nArray8 = new int[n8];
        n = 0;
        while (n < n4) {
            nArray7[n] = nArray[n];
            ++n;
        }
        n = 0;
        while (n < n8) {
            nArray8[n] = 0;
            ++n;
        }
        block8: do {
            this.set(dataSet.get(nArray8), nArray7);
            n = 0;
            int n10 = 0;
            while (n < n4) {
                if (!blArray[n]) {
                    int n11 = n;
                    nArray7[n11] = nArray7[n11] + nArray3[n];
                    int n12 = n10;
                    nArray8[n12] = nArray8[n12] + 1;
                    if (nArray8[n10] < nArray4[n]) continue block8;
                    nArray7[n] = nArray[n];
                    nArray8[n10] = 0;
                    ++n10;
                }
                ++n;
            }
        } while (n != n4);
    }

    public DataSet getIndexDataSet() {
        if (this.dimensions.length != 1) {
            logger.error("Input dataset has dimensionality greater than one: {}", (Object)this.dimensions.length);
            throw new IllegalArgumentException("Dimensionality of input dataset too large: " + this.dimensions.length);
        }
        DataSet dataSet = new DataSet(this);
        int n = 0;
        while (n < this.dataSize) {
            dataSet.data[n] = n;
            ++n;
        }
        return dataSet;
    }

    public static DataSet repeat(DataSet dataSet, int n) {
        return DataSet.repeat(dataSet, new int[]{n}, -1);
    }

    public static DataSet repeat(DataSet dataSet, int[] nArray) {
        return DataSet.repeat(dataSet, nArray, -1);
    }

    public static DataSet repeat(DataSet dataSet, int n, int n2) {
        return DataSet.repeat(dataSet, new int[]{n}, n2);
    }

    public static DataSet repeat(DataSet dataSet, int[] nArray, int n) {
        int n2;
        double[] dArray = dataSet.getBuffer();
        int[] nArray2 = dataSet.getDimensions();
        int n3 = nArray2.length;
        if (n >= n3) {
            logger.warn("Axis value is out of bounds");
            throw new IllegalArgumentException("Axis value is out of bounds");
        }
        if (n < 0) {
            n2 = dataSet.dataSize;
            n = 0;
            n3 = 1;
            nArray2[0] = n2;
        } else {
            n2 = nArray2[n];
        }
        int n4 = nArray.length;
        if (n4 != 1 && n4 != n2) {
            logger.warn("Repeats array should have length of 1 or match chosen axis");
            throw new IllegalArgumentException("Repeats array should have length of 1 or match chosen axis");
        }
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] < 0) {
                logger.warn("Negative repeat value is not allowed");
                throw new IllegalArgumentException("Negative repeat value is not allowed");
            }
            ++n5;
        }
        int[] nArray3 = new int[n3];
        int n6 = 0;
        while (n6 < n3) {
            nArray3[n6] = nArray2[n6];
            ++n6;
        }
        if (nArray.length == 1) {
            int n7 = n;
            nArray3[n7] = nArray3[n7] * nArray[0];
        } else {
            n6 = 0;
            int n8 = 0;
            while (n8 < n2) {
                n6 += nArray[n8];
                ++n8;
            }
            nArray3[n] = n6;
        }
        DataSet dataSet2 = new DataSet(nArray3);
        double[] dArray2 = dataSet2.getBuffer();
        int n9 = 1;
        int n10 = n + 1;
        while (n10 < n3) {
            n9 *= nArray3[n10];
            ++n10;
        }
        n10 = 1;
        int n11 = 0;
        while (n11 < n) {
            n10 *= nArray3[n11];
            ++n11;
        }
        if (dataSet.isContiguous()) {
            n11 = 0;
            int n12 = 0;
            if (n4 == 1) {
                int n13 = 0;
                while (n13 < n10) {
                    int n14 = 0;
                    while (n14 < nArray2[n]) {
                        int n15 = 0;
                        while (n15 < nArray[0]) {
                            System.arraycopy(dArray, n11, dArray2, n12, n9);
                            n12 += n9;
                            ++n15;
                        }
                        n11 += n9;
                        ++n14;
                    }
                    ++n13;
                }
            } else {
                int n16 = 0;
                while (n16 < n10) {
                    int n17 = 0;
                    while (n17 < nArray2[n]) {
                        int n18 = 0;
                        while (n18 < nArray[n17]) {
                            System.arraycopy(dArray, n11, dArray2, n12, n9);
                            n12 += n9;
                            ++n18;
                        }
                        n11 += n9;
                        ++n17;
                    }
                    ++n16;
                }
            }
        } else {
            n11 = 0;
            double[] dArray3 = new double[n9];
            IndexIterator indexIterator = dataSet.getIterator();
            if (n4 == 1) {
                int n19 = 0;
                while (n19 < n10) {
                    int n20 = 0;
                    while (n20 < nArray2[n]) {
                        DataSet.extractWholeSlice(dArray3, dArray, indexIterator);
                        int n21 = 0;
                        while (n21 < nArray[0]) {
                            System.arraycopy(dArray3, 0, dArray2, n11, n9);
                            n11 += n9;
                            ++n21;
                        }
                        ++n20;
                    }
                    ++n19;
                }
            } else {
                int n22 = 0;
                while (n22 < n10) {
                    int n23 = 0;
                    while (n23 < nArray2[n]) {
                        DataSet.extractWholeSlice(dArray3, dArray, indexIterator);
                        int n24 = 0;
                        while (n24 < nArray[n23]) {
                            System.arraycopy(dArray3, 0, dArray2, n11, n9);
                            n11 += n9;
                            ++n24;
                        }
                        ++n23;
                    }
                    ++n22;
                }
            }
        }
        return dataSet2;
    }

    private static void extractWholeSlice(double[] dArray, double[] dArray2, IndexIterator indexIterator) {
        int n = 0;
        while (n < dArray.length && indexIterator.hasNext()) {
            dArray[n] = dArray2[indexIterator.index];
            ++n;
        }
    }

    public static DataSet tile(DataSet dataSet, int ... nArray) {
        int n;
        int n2;
        int[] nArray2;
        int[] nArray3 = dataSet.getDimensions();
        int[] nArray4 = null;
        int n3 = nArray3.length;
        int n4 = nArray.length;
        if (n3 < n4) {
            nArray2 = new int[n4];
            nArray4 = new int[n3];
            n2 = n4 - n3;
            n = 0;
            while (n < n2) {
                nArray2[n] = 1;
                ++n;
            }
            n = 0;
            while (n < n3) {
                nArray2[n + n2] = nArray3[n];
                nArray4[n] = nArray3[n];
                ++n;
            }
            nArray3 = nArray2;
            n3 = n4;
            dataSet.reshape(nArray3);
        } else if (n3 > n4) {
            nArray2 = new int[n3];
            n2 = n3 - n4;
            n = 0;
            while (n < n2) {
                nArray2[n] = 1;
                ++n;
            }
            n = 0;
            while (n < n4) {
                nArray2[n + n2] = nArray[n];
                ++n;
            }
            nArray = nArray2;
        }
        nArray2 = new int[n3];
        n2 = 0;
        while (n2 < n3) {
            nArray2[n2] = nArray3[n2] * nArray[n2];
            ++n2;
        }
        DataSet dataSet2 = new DataSet(nArray2);
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int n5 = 0;
        while (n5 < n3) {
            nArray5[n5] = 0;
            nArray6[n5] = nArray3[n5];
            ++n5;
        }
        block6: do {
            dataSet2.setSlice(nArray5, nArray6, null, dataSet);
            n5 = 0;
            while (n5 < n3) {
                int n6 = n5;
                nArray5[n6] = nArray5[n6] + nArray3[n5];
                int n7 = n5;
                nArray6[n7] = nArray6[n7] + nArray3[n5];
                if (nArray5[n5] < nArray2[n5]) continue block6;
                nArray5[n5] = 0;
                nArray6[n5] = nArray3[n5];
                ++n5;
            }
        } while (n5 != n3);
        if (nArray4 != null) {
            dataSet.reshape(nArray4);
        }
        return dataSet2;
    }

    public static DataSet permuteAxes(DataSet dataSet, int ... nArray) {
        int n;
        DataSet dataSet2 = null;
        int[] nArray2 = dataSet.getDimensions();
        int n2 = nArray2.length;
        if (nArray.length != n2) {
            logger.error("axis permutation has length {} that does not match dataset's rank {}", (Object)nArray.length, (Object)n2);
            throw new IllegalArgumentException("axis permutation does not match dimensions of dataset");
        }
        int[] nArray3 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = nArray3[n4];
            if (n5 < 0 || n5 >= n2) {
                logger.error("axis permutation contains element {} outside rank of dataset", (Object)n5);
                throw new IllegalArgumentException("axis permutation contains element outside rank of dataset");
            }
            ++n4;
        }
        int[] nArray4 = (int[])nArray.clone();
        Arrays.sort(nArray4);
        int n6 = 0;
        while (n6 < n2) {
            if (nArray4[n6] != n6) {
                logger.error("axis permutation is not valid: it does not contain complete set of axes");
                throw new IllegalArgumentException("axis permutation does not contain complete set of axes");
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n2) {
            if (nArray[n6] != n6) break;
            ++n6;
        }
        if (n6 == n2) {
            return new DataSet(dataSet);
        }
        int[] nArray5 = new int[n2];
        n6 = 0;
        while (n6 < n2) {
            nArray5[n6] = nArray2[nArray[n6]];
            ++n6;
        }
        dataSet2 = new DataSet(nArray5);
        int[] nArray6 = new int[n2];
        nArray3 = new int[n2];
        n6 = 0;
        while (n6 < n2) {
            nArray6[n6] = 0;
            ++n6;
        }
        block5: do {
            n6 = 0;
            while (n6 < n2) {
                nArray3[nArray[n6]] = nArray6[n6];
                ++n6;
            }
            dataSet2.set(dataSet.get(nArray3), nArray6);
            n = n2 - 1;
            while (n >= 0) {
                int n7 = n;
                nArray6[n7] = nArray6[n7] + 1;
                if (nArray6[n] < nArray5[n]) continue block5;
                nArray6[n] = 0;
                --n;
            }
        } while (n != -1);
        return dataSet2;
    }

    public static DataSet transpose(DataSet dataSet) {
        int n = dataSet.getRank();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n - 1 - n2;
            ++n2;
        }
        return DataSet.permuteAxes(dataSet, nArray);
    }

    public static DataSet transpose(DataSet dataSet, int ... nArray) {
        return DataSet.permuteAxes(dataSet, nArray);
    }

    public static DataSet flatten(DataSet dataSet) {
        DataSet dataSet2 = new DataSet(dataSet);
        dataSet2.setShape(dataSet2.getSize());
        return dataSet2;
    }

    private void allocateArray(int ... nArray) {
        int n = nArray.length;
        if (this.data == null) {
            this.dataSize = 1;
            int n2 = 0;
            while (n2 < n) {
                this.dataSize *= nArray[n2];
                ++n2;
            }
            try {
                this.data = new double[this.dataSize];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.error("The size of the dataset {} that is being created is too large and there is not enough memory to hold it.", (Object)this.dataSize);
                throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
            }
            Arrays.fill(this.data, Double.NaN);
        } else {
            int n3;
            int n4;
            DataSet dataSet;
            if (this.dataDimensions == null) {
                dataSet = new DataSet(this);
                this.dataDimensions = new int[n];
            } else {
                n4 = 1;
                n3 = 0;
                while (n3 < n) {
                    if (nArray[n3] > this.dataDimensions[n3]) {
                        n4 = 0;
                        break;
                    }
                    ++n3;
                }
                if (n4 != 0) {
                    this.dataSize = 1;
                    n3 = 0;
                    while (n3 < n) {
                        this.dimensions[n3] = nArray[n3];
                        this.dataSize *= nArray[n3];
                        ++n3;
                    }
                    n4 = 1;
                    n3 = 0;
                    while (n3 < n) {
                        if (nArray[n3] < this.dataDimensions[n3]) {
                            n4 = 0;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 != 0) {
                        this.dataDimensions = null;
                    }
                    return;
                }
                dataSet = new DataSet(this);
            }
            n4 = 1;
            n3 = 0;
            while (n3 < n) {
                int n5 = nArray[n3] - this.dimensions[n3];
                if (n5 > 0 && n5 < (int)((double)this.dimensions[n3] * 0.1) + 1) {
                    n5 = (int)((float)this.dimensions[n3] * 0.5f) + 1;
                }
                this.dataDimensions[n3] = this.dimensions[n3] + n5;
                n4 *= this.dataDimensions[n3];
                ++n3;
            }
            try {
                this.data = new double[n4];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                logger.error("The size of the DataSet that is being created is too large and there is not enough memory to hold it.");
                throw new OutOfMemoryError("The dimentions given are too large, and there is not enough memory available in the Java Virtual Machine");
            }
            this.dataSize = 1;
            n3 = 0;
            while (n3 < n) {
                this.dimensions[n3] = nArray[n3];
                this.dataSize *= nArray[n3];
                ++n3;
            }
            Arrays.fill(this.data, Double.NaN);
            DiscontiguousIterator discontiguousIterator = new DiscontiguousIterator(dataSet.dimensions, this.dataDimensions, n4);
            double[] dArray = dataSet.data;
            int n6 = 0;
            while (((IndexIterator)discontiguousIterator).hasNext()) {
                this.data[discontiguousIterator.index] = dArray[n6];
                ++n6;
            }
            if (this.dataSize == n4) {
                this.dataDimensions = null;
            }
        }
    }

    public DataSet subSampleMean(int n) {
        int n2 = this.getSize();
        int n3 = n2 / n;
        DataSet dataSet = new DataSet(n3);
        int n4 = 0;
        while (n4 < n3) {
            double d = this.get(n4 * n);
            int n5 = 1;
            while (n5 < n) {
                d += this.get(n4 * n + n5);
                ++n5;
            }
            dataSet.set(d / (double)n, n4++);
        }
        return dataSet;
    }

    public DataSet subSampleMax(int n) {
        int n2 = this.getSize();
        int n3 = n2 / n;
        DataSet dataSet = new DataSet(n3);
        int n4 = 0;
        while (n4 < n3) {
            double d = this.get(n4 * n);
            int n5 = 1;
            while (n5 < n) {
                int[] nArray = new int[]{n4 * n + n5};
                double d2 = this.get(nArray);
                if (d2 > d) {
                    d = d2;
                }
                ++n5;
            }
            dataSet.set(d / (double)n, n4++);
        }
        return dataSet;
    }

    public List<DataSet> exec(IDataSetFunction iDataSetFunction) {
        return iDataSetFunction.execute(this);
    }

    public void setDirty() {
        this.storedValues = null;
    }

    private void calculateMinMaxMeanSumDeviation() {
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        int n2 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            double d7 = this.data[indexIterator.index];
            if (Double.isInfinite(d7) || Double.isNaN(d7)) continue;
            d3 += d7;
            double d8 = d7 - d4;
            d5 += d8 * (d7 - (d4 += d8 / (d6 += 1.0)));
            if (d7 > d) {
                d = d7;
                n = indexIterator.index;
            }
            if (!(d7 < d2)) continue;
            d2 = d7;
            n2 = indexIterator.index;
        }
        if (d6 == 0.0) {
            d2 = Double.NaN;
            d = Double.NaN;
        }
        this.storedValues = new HashMap();
        this.storedValues.put("min", d2);
        this.storedValues.put("max", d);
        this.storedValues.put("minpos", n2);
        this.storedValues.put("maxpos", n);
        this.storedValues.put("mean", d4);
        this.storedValues.put("sum", d3);
        this.storedValues.put("centralmom2", d5 / d6);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)object;
        if (!Arrays.equals(this.dimensions, dataSet.dimensions)) {
            return false;
        }
        if (!Arrays.equals(this.dataDimensions, dataSet.dataDimensions)) {
            return false;
        }
        return Arrays.equals(this.data, dataSet.data);
    }

    @Deprecated
    public double getFirstValue() {
        logger.warn(String.valueOf(depMsg) + "8 - use get(0)");
        return this.data[0];
    }

    @Deprecated
    public double getLastValue() {
        logger.warn(String.valueOf(depMsg) + "8 - use get()");
        return this.get(this.getNDPosition(this.dataSize - 1));
    }

    @Override
    public int getRank() {
        return this.dimensions.length;
    }

    public int getNdim() {
        return this.getRank();
    }

    public boolean containsNans() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Double.isNaN(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    public boolean containsInfs() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Double.isInfinite(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    public class DataSetIterator {
        private DataSet dataset;
        private IndexIterator iterator;

        public DataSetIterator(DataSet dataSet2) {
            this.dataset = dataSet2;
            this.iterator = dataSet2.getIterator();
        }

        public double __next__() {
            return this.next();
        }

        public double next() {
            if (this.iterator.hasNext()) {
                return this.dataset.getAbs(this.iterator.index);
            }
            throw new PyException(Py.StopIteration);
        }
    }
}

