/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media.protocol.j1394;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.VideoFormat;
import net.sf.jlibdc1394.J1394CameraInfo;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.JDC1394Helper;
import net.sf.jlibdc1394.JDC1394VideoModes;
import net.sf.jlibdc1394.media.protocol.j1394.FormatHelper;
import net.sf.jlibdc1394.media.protocol.j1394.J1394Format;

public class J1394Registry {
    public static JDC1394CamPort port = null;
    public static int numberOfCameras = 0;
    public static JDC1394Cam[] cameras = null;
    public static String[] cameraNames = null;
    public static J1394CameraInfo[][] cameraInfos = null;

    public static void updateRegistry() {
        try {
            port = JDC1394Helper.getJDC1394CamPort();
            if (port == null) {
                return;
            }
            port.checkLink();
            port.refreshCameraList();
            numberOfCameras = port.getNumberCameras();
            cameraNames = new String[numberOfCameras];
            cameras = new JDC1394Cam[numberOfCameras];
            cameraInfos = new J1394CameraInfo[numberOfCameras][];
            int node = 0;
            for (int i = 0; i < numberOfCameras; ++i) {
                JDC1394Cam camera = port.selectCamera(i);
                if (camera == null) continue;
                node = camera.getNode();
                J1394Registry.cameras[node] = camera;
                J1394Registry.cameraInfos[node] = J1394Registry.getI1394CameraInfos(camera, node);
                try {
                    J1394Registry.cameraNames[node] = new String(camera.getCameraModel());
                    int n = node;
                    cameraNames[n] = cameraNames[n] + " [" + camera.getCameraVendor() + "]";
                    String uid = cameraInfos[node][0].getUid();
                    if (uid == null) continue;
                    int n2 = node;
                    cameraNames[n2] = cameraNames[n2] + " [UID=" + uid + "]";
                    continue;
                }
                catch (Throwable npe) {
                    npe.printStackTrace();
                }
            }
        }
        catch (Throwable je) {
            je.printStackTrace();
        }
    }

    public static J1394CameraInfo[] getI1394CameraInfos(JDC1394Cam camera, int node) {
        if (camera == null) {
            return null;
        }
        JDC1394VideoModes videoModes = camera.getVideoModes();
        if (videoModes == null) {
            System.err.println("CaptureSourceDialog: Couldn't find any Video Modes for this camera!...");
            return null;
        }
        Vector<J1394CameraInfo> v = new Vector<J1394CameraInfo>(32);
        Format[] df = FormatHelper.getFormats(camera);
        if (df == null || df.length == 0) {
            return null;
        }
        for (int ifmt = 0; ifmt <= 2; ++ifmt) {
            block3: for (int imod = 0; imod <= 7; ++imod) {
                try {
                    if (!videoModes.checkCapability(ifmt, imod)) continue;
                    Dimension fSize = J1394Format.getSize(ifmt, imod);
                    Dimension dfSize = null;
                    for (int j = 0; j < df.length; ++j) {
                        dfSize = ((VideoFormat)df[j]).getSize();
                        if (dfSize.width != fSize.width || dfSize.height != fSize.height) continue;
                        J1394CameraInfo info = new J1394CameraInfo(node, ifmt, imod, -1, J1394CameraInfo.getUid(camera));
                        v.add(info);
                        continue block3;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (v.isEmpty()) {
            return null;
        }
        J1394CameraInfo[] infos = new J1394CameraInfo[v.size()];
        v.toArray(infos);
        return infos;
    }
}

