/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media.protocol.j1394;

import java.awt.Dimension;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.RGBFormat;
import net.sf.jlibdc1394.JDC1394Cam;

public class FormatHelper {
    private static final int formats = 2;
    private static final int modes = 7;
    private static final int frameRateCodes = 5;

    public static Format[] getFormats(JDC1394Cam cam) {
        Vector<Format> f = new Vector<Format>(32);
        int formatCount = 0;
        try {
            for (int i = 0; i <= 2; ++i) {
                for (int j = 0; j <= 7; ++j) {
                    for (int k = 0; k <= 5; ++k) {
                        boolean capability = cam.getVideoModes().checkCapability(i, j, k);
                        if (!capability) continue;
                        ++formatCount;
                        Format format = FormatHelper.getVideoFormat(i, j, k);
                        if (format == null) continue;
                        f.add(format);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (Format[])f.toArray((Object[])new Format[formatCount]);
    }

    public static Format getVideoFormat(int format, int mode) {
        return FormatHelper.getVideoFormat(format, mode, -1);
    }

    public static Format getVideoFormat(int format, int mode, int frameRateCode) {
        int vftype = 0;
        Object f = null;
        Dimension size = null;
        float frameRate = FormatHelper.getFrameRate(frameRateCode);
        block0 : switch (format) {
            case 0: {
                switch (mode) {
                    case 0: {
                        size = new Dimension(160, 120);
                        vftype = 1;
                        break;
                    }
                    case 1: {
                        size = new Dimension(320, 240);
                        vftype = 2;
                        break;
                    }
                    case 2: {
                        size = new Dimension(640, 480);
                        vftype = 4;
                        break;
                    }
                    case 3: {
                        size = new Dimension(640, 480);
                        vftype = 2;
                        break;
                    }
                    case 4: {
                        size = new Dimension(640, 480);
                        vftype = 0;
                        break;
                    }
                    case 5: {
                        size = new Dimension(640, 480);
                        vftype = 5;
                        break;
                    }
                    case 6: {
                        size = new Dimension(640, 480);
                        vftype = 6;
                    }
                }
                break;
            }
            case 1: {
                switch (mode) {
                    case 0: {
                        size = new Dimension(800, 600);
                        vftype = 2;
                        break;
                    }
                    case 1: {
                        size = new Dimension(800, 600);
                        vftype = 0;
                        break;
                    }
                    case 2: {
                        size = new Dimension(800, 600);
                        vftype = 5;
                        break;
                    }
                    case 3: {
                        size = new Dimension(1024, 768);
                        vftype = 2;
                        break;
                    }
                    case 4: {
                        size = new Dimension(1024, 768);
                        vftype = 0;
                        break;
                    }
                    case 5: {
                        size = new Dimension(1024, 768);
                        vftype = 5;
                        break;
                    }
                    case 6: {
                        size = new Dimension(800, 600);
                        vftype = 6;
                        break;
                    }
                    case 7: {
                        size = new Dimension(1024, 768);
                        vftype = 6;
                    }
                }
                break;
            }
            case 2: {
                switch (mode) {
                    case 0: {
                        size = new Dimension(1280, 960);
                        vftype = 2;
                        break block0;
                    }
                    case 1: {
                        size = new Dimension(1280, 960);
                        vftype = 0;
                        break block0;
                    }
                    case 2: {
                        size = new Dimension(1280, 960);
                        vftype = 5;
                        break block0;
                    }
                    case 3: {
                        size = new Dimension(1600, 1200);
                        vftype = 2;
                        break block0;
                    }
                    case 4: {
                        size = new Dimension(1600, 1200);
                        vftype = 0;
                        break block0;
                    }
                    case 5: {
                        size = new Dimension(1600, 1200);
                        vftype = 5;
                        break block0;
                    }
                    case 6: {
                        size = new Dimension(1280, 960);
                        vftype = 6;
                        break block0;
                    }
                    case 7: {
                        size = new Dimension(1600, 1200);
                        vftype = 6;
                    }
                }
            }
        }
        if (size != null) {
            switch (vftype) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return new RGBFormat(size, size.width * size.height * 3, Format.intArray, frameRate, 24, 0xFF0000, 65280, 255);
                }
            }
        }
        return null;
    }

    public static Dimension getSize(int format, int mode) {
        Dimension size = null;
        if (format == 0) {
            if (mode == 0) {
                size = new Dimension(160, 320);
            } else if (mode == 1) {
                size = new Dimension(320, 240);
            } else if (mode == 2 || mode == 3 || mode == 4 || mode == 5 || mode == 6) {
                size = new Dimension(640, 480);
            }
        } else if (format == 1) {
            if (mode == 0 || mode == 1 || mode == 2 || mode == 6) {
                size = new Dimension(800, 600);
            } else if (mode == 3 || mode == 4 || mode == 5 || mode == 7) {
                size = new Dimension(1024, 768);
            }
        } else if (format == 2) {
            if (mode == 0 || mode == 1 || mode == 2 || mode == 6) {
                size = new Dimension(1280, 960);
            } else if (mode == 3 || mode == 4 || mode == 5 || mode == 7) {
                size = new Dimension(1600, 1200);
            }
        }
        return size;
    }

    public static float getFrameRate(int frameRateCode) {
        switch (frameRateCode) {
            case 0: {
                return 1.875f;
            }
            case 1: {
                return 3.75f;
            }
            case 2: {
                return 7.5f;
            }
            case 3: {
                return 15.0f;
            }
            case 4: {
                return 30.0f;
            }
            case 5: {
                return 60.0f;
            }
        }
        return -1.0f;
    }

    public static int getFrameRateCode(float frameRate) {
        if (frameRate == 1.875f) {
            return 0;
        }
        if (frameRate == 3.75f) {
            return 1;
        }
        if (frameRate == 7.5f) {
            return 2;
        }
        if (frameRate == 15.0f) {
            return 3;
        }
        if (frameRate == 30.0f) {
            return 4;
        }
        if (frameRate == 60.0f) {
            return 5;
        }
        return -1;
    }
}

