/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media.protocol.j1394;

import java.io.IOException;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorEvent;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorListener;
import net.sf.jlibdc1394.media.protocol.j1394.DataSourceErrorListenerHandler;
import net.sf.jlibdc1394.media.protocol.j1394.J1394BufferStream;
import net.sf.jlibdc1394.media.protocol.j1394.J1394Format;
import net.sf.jlibdc1394.media.protocol.j1394.J1394FormatControl;

public class DataSource
extends PushBufferDataSource
implements CaptureDevice,
DataSourceErrorListener,
DataSourceErrorListenerHandler {
    public boolean debug = false;
    protected Object[] controls = new Object[0];
    protected boolean started = false;
    protected String contentType = "raw";
    protected boolean connected = false;
    protected Time duration = DURATION_UNKNOWN;
    protected J1394BufferStream[] streams = null;
    protected J1394BufferStream stream = null;
    private Vector<DataSourceErrorListener> errorListeners = new Vector(10, 10);

    public DataSource() {
        this.debug = Boolean.getBoolean("jlibdc1394.debug");
        MediaLocator ml = this.getLocator();
        if (this.debug) {
            System.out.println(this.getClass() + " constructor");
        }
    }

    public String getContentType() {
        if (!this.connected) {
            System.err.println("Error: DataSource not connected");
            return null;
        }
        return this.contentType;
    }

    public void connect() throws IOException {
        if (this.debug) {
            System.out.println(this.getClass() + " connect");
        }
        if (this.connected) {
            return;
        }
        if (this.streams == null) {
            MediaLocator locator = this.getLocator();
            if (locator == null) {
                throw new IOException("Null J1394 locator!...");
            }
            try {
                int cameraIndex = J1394Format.getCameraIndexFromLocator(locator);
                int format = J1394Format.getFormatFromLocator(locator);
                int mode = J1394Format.getModeFromLocator(locator);
                int frameRate = J1394Format.getFrameRateFromLocator(locator);
                this.stream = new J1394BufferStream(cameraIndex, format, mode, frameRate);
                this.stream.addDataSourceErrorListener(this);
                this.streams = new J1394BufferStream[1];
                this.streams[0] = this.stream;
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
        }
        this.connected = true;
    }

    public void disconnect() {
        if (this.debug) {
            System.out.println(this.getClass() + " disconnect");
        }
        if (this.stream != null) {
            this.stream.removeDataSourceErrorListener(this);
        }
        try {
            if (this.started) {
                this.stop();
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        this.connected = false;
    }

    public void start() throws IOException {
        if (this.debug) {
            System.out.println(this.getClass() + " start");
        }
        if (!this.connected) {
            throw new Error("DataSource must be connected before it can be started");
        }
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.stream != null) {
            this.stream.setEnabled(true);
        }
    }

    public void stop() throws IOException {
        if (this.debug) {
            System.out.println(this.getClass() + " stop");
        }
        if (!this.connected || !this.started) {
            return;
        }
        this.started = false;
        if (this.stream != null) {
            this.stream.setEnabled(false);
        }
    }

    public Object[] getControls() {
        if (this.debug) {
            System.out.println(this.getClass() + " get controls");
        }
        return this.controls;
    }

    public Object getControl(String controlType) {
        if (this.debug) {
            System.out.println(this.getClass() + " get control");
        }
        try {
            Class<?> cls = Class.forName(controlType);
            Object[] cs = this.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!cls.isInstance(cs[i])) continue;
                return cs[i];
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Time getDuration() {
        return this.duration;
    }

    public PushBufferStream[] getStreams() {
        if (this.debug) {
            System.out.println(this.getClass() + " get streams, medialoc: " + this.getLocator());
        }
        return this.streams;
    }

    public CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.debug) {
            System.out.println(this.getClass() + " get capture device info: " + this.getLocator());
        }
        Format[] formats = this.stream.getSupportedFormats();
        return new CaptureDeviceInfo("J1394", new MediaLocator("j1394://"), formats);
    }

    public FormatControl[] getFormatControls() {
        if (this.debug) {
            System.out.println(this.getClass() + " get format controls");
        }
        FormatControl[] ctrls = null;
        if (this.stream != null) {
            J1394FormatControl c = new J1394FormatControl(this.stream);
            if (this.debug) {
                System.out.println(this.getClass() + " adding format control");
            }
            ctrls = new FormatControl[]{c};
        } else {
            ctrls = new FormatControl[]{};
        }
        return ctrls;
    }

    public void addDataSourceErrorListener(DataSourceErrorListener listener) {
        if (listener != null) {
            this.errorListeners.add(listener);
        }
    }

    public void removeDataSourceErrorListener(DataSourceErrorListener listener) {
        if (listener != null) {
            this.errorListeners.remove(listener);
        }
    }

    private void removeAllDataSourceErrorListeners() {
        this.errorListeners.removeAllElements();
    }

    private void notifyErrorListeners(DataSourceErrorEvent event) {
        if (this.errorListeners.isEmpty()) {
            return;
        }
        for (DataSourceErrorListener l : this.errorListeners) {
            try {
                if (l == null) continue;
                l.errorOccured(event);
            }
            catch (Exception e) {}
        }
    }

    public void errorOccured(DataSourceErrorEvent event) {
        this.notifyErrorListeners(event);
    }

    public JDC1394Cam getCamera() {
        if (this.stream == null) {
            return null;
        }
        return this.stream.getCamera();
    }
}

