/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.media;

import com.jbit.awt.WrapperFrame;
import com.jbit.globals.Globals;
import com.jbit.globals.Utils;
import com.jbit.io.FFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.PackageManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sf.jlibdc1394.media.protocol.j1394.J1394Format;

public class InstallJ1394Cam
extends JPanel
implements ActionListener {
    private static final String deviceDescription = "CMU 1394 Digital Camera Device";
    private static final String deviceLocator = "j1394://";
    private String packagePrefix = "net.sf.jlibdc1394";
    String directory = System.getProperty("user.dir");
    JTextField fileField = new JTextField(48);
    JTextArea logField = new JTextArea(24, 48);
    JButton searchB = new JButton("Search...");
    JButton installB = new JButton("Set");
    JButton removeB = new JButton("Remove");

    public InstallJ1394Cam() {
        this.setLayout(new GridBagLayout());
        int xPos = 0;
        int yPos = 0;
        JLabel label = new JLabel("jmf.properties registry", 0);
        label.setBorder(BorderFactory.createEtchedBorder());
        Utils.constrain((Container)this, (Component)label, (int)xPos, (int)yPos, (int)2, (int)1, (double)1.0, (double)0.0, (int)2, (Insets)new Insets(2, 2, 2, 2));
        this.add(label);
        ++yPos;
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        Utils.constrain((Container)p, (Component)this.fileField, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (Insets)new Insets(2, 2, 2, 2));
        p.add(this.fileField);
        this.fileField.setToolTipText("Location of the jmf.properties file");
        Utils.constrain((Container)p, (Component)this.searchB, (int)1, (int)0, (int)1, (int)1, (double)0.0, (double)1.0, (int)3, (Insets)new Insets(2, 0, 2, 2));
        p.add(this.searchB);
        this.searchB.setToolTipText("Search...");
        this.searchB.addActionListener(this);
        Utils.constrain((Container)this, (Component)p, (int)xPos, (int)yPos, (int)2, (int)1, (double)1.0, (double)0.0, (int)2);
        this.add(p);
        xPos = 0;
        Utils.constrain((Container)this, (Component)this.installB, (int)xPos, (int)(++yPos), (int)1, (int)1, (double)1.0, (double)0.0, (int)2, (Insets)new Insets(2, 2, 2, 0));
        this.add(this.installB);
        this.installB.setToolTipText("Install DataSource");
        this.installB.addActionListener(this);
        Utils.constrain((Container)this, (Component)this.removeB, (int)(++xPos), (int)yPos, (int)1, (int)1, (double)1.0, (double)0.0, (int)2, (Insets)new Insets(2, 0, 2, 2));
        this.add(this.removeB);
        this.removeB.setToolTipText("Remove DataSource");
        this.removeB.addActionListener(this);
        xPos = 0;
        this.logField.setWrapStyleWord(true);
        this.logField.setEditable(true);
        this.logField.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(this.logField, 20, 30);
        Utils.constrain((Container)this, (Component)scroll, (int)xPos, (int)(++yPos), (int)2, (int)1, (double)1.0, (double)1.0, (int)1, (Insets)new Insets(0, 2, 2, 2));
        this.add(scroll);
        this.log("Current classpath is:\n\t" + System.getProperty("java.class.path") + "\n");
    }

    private void log(String text) {
        if (text == null) {
            return;
        }
        this.logField.append(text);
    }

    private String selectDirectory(String directory, String description, String extension) {
        if (directory == null) {
            directory = Globals.USERDIR;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(directory));
        FFileFilter filter = new FFileFilter();
        filter.addExtension(extension);
        filter.setDescription(description);
        chooser.setFileFilter((FileFilter)filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.directory = chooser.getCurrentDirectory().getAbsolutePath();
            return chooser.getCurrentDirectory().getAbsolutePath();
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.searchB) {
            String dir = this.selectDirectory(this.directory, "JMF registry file", "properties");
            if (dir != null) {
                this.directory = dir;
                this.fileField.setText(dir);
                System.setProperty("java.class.path", this.directory + InstallJ1394Cam.getLibraryPathSeparator() + System.getProperty("user.dir"));
                this.log("New classpath is:\n\t" + System.getProperty("java.class.path") + "\n");
            }
        } else if (src == this.installB) {
            this.fileField.setEnabled(false);
            this.searchB.setEnabled(false);
            if (this.installDevice()) {
                this.installB.setEnabled(false);
            }
        } else if (src == this.removeB) {
            this.fileField.setEnabled(false);
            this.searchB.setEnabled(false);
            if (this.removeDevice()) {
                this.removeB.setEnabled(false);
            }
        }
    }

    private boolean installDevice() {
        try {
            Vector<Format> v = new Vector<Format>(32, 16);
            v.add(J1394Format.getVideoFormat(0, 4, -1));
            v.add(J1394Format.getVideoFormat(1, 1, -1));
            v.add(J1394Format.getVideoFormat(1, 4, -1));
            v.add(J1394Format.getVideoFormat(2, 1, -1));
            v.add(J1394Format.getVideoFormat(2, 4, -1));
            Format[] fs = new Format[v.size()];
            v.toArray(fs);
            this.log("Install formats:\n");
            for (int i = 0; i < fs.length; ++i) {
                this.log("\t" + fs[i] + "\n");
            }
            CaptureDeviceInfo ci = new CaptureDeviceInfo(deviceDescription, new MediaLocator(deviceLocator), fs);
            if (CaptureDeviceManager.getDevice((String)deviceDescription) != null) {
                this.log("A device of type 'CMU 1394 Digital Camera Device' is already installed!...\n");
                return false;
            }
            this.log("Install new 'CMU 1394 Digital Camera Device' Please wait!...\n");
            CaptureDeviceManager.addDevice((CaptureDeviceInfo)ci);
            CaptureDeviceManager.commit();
            this.log("Device 'CMU 1394 Digital Camera Device' succesfully installed.\n");
            Vector list = PackageManager.getProtocolPrefixList();
            if (!list.contains(this.packagePrefix)) {
                list.add(this.packagePrefix);
                PackageManager.setProtocolPrefixList((Vector)list);
                PackageManager.commitProtocolPrefixList();
                this.log("Protocol prefix: '" + this.packagePrefix + "' succesfully added.\n");
            } else {
                this.log("Protocol prefix: '" + this.packagePrefix + "' is already installed.\n");
            }
            return true;
        }
        catch (Exception e) {
            this.log("Install exception: " + e.toString() + "\n");
            e.printStackTrace();
            return false;
        }
    }

    private boolean removeDevice() {
        try {
            Vector<Format> v = new Vector<Format>(32, 16);
            v.add(J1394Format.getVideoFormat(0, 4, -1));
            v.add(J1394Format.getVideoFormat(1, 1, -1));
            v.add(J1394Format.getVideoFormat(1, 4, -1));
            v.add(J1394Format.getVideoFormat(2, 1, -1));
            v.add(J1394Format.getVideoFormat(2, 4, -1));
            Format[] fs = new Format[v.size()];
            v.toArray(fs);
            this.log("Remove formats:\n");
            for (int i = 0; i < fs.length; ++i) {
                this.log("\t" + fs[i] + "\n");
            }
            CaptureDeviceInfo ci = CaptureDeviceManager.getDevice((String)deviceDescription);
            if (ci == null) {
                this.log("No device of type 'CMU 1394 Digital Camera Device' is installed!...\n");
                return false;
            }
            this.log("Remove 'CMU 1394 Digital Camera Device' Please wait!...\n");
            CaptureDeviceManager.removeDevice((CaptureDeviceInfo)ci);
            CaptureDeviceManager.commit();
            this.log("Device 'CMU 1394 Digital Camera Device' succesfully removed.\n");
            Vector list = PackageManager.getProtocolPrefixList();
            if (list.contains(this.packagePrefix)) {
                list.remove(this.packagePrefix);
                PackageManager.setProtocolPrefixList((Vector)list);
                PackageManager.commitProtocolPrefixList();
                this.log("Protocol prefix: '" + this.packagePrefix + "' removed succesfully.\n");
            }
            return true;
        }
        catch (Exception e) {
            this.log("Removal exception: " + e.toString() + "\n");
            return false;
        }
    }

    public static boolean isWindows() {
        String _OS_ = System.getProperty("os.name").toLowerCase();
        return _OS_.indexOf("windows") != -1 || _OS_.indexOf("nt") != -1;
    }

    public static String getLibraryPathSeparator() {
        if (InstallJ1394Cam.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static void main(String[] args) {
        String classpath = ".";
        String S = InstallJ1394Cam.getLibraryPathSeparator();
        if (args != null) {
            for (String arg : args) {
                classpath = classpath + S + arg;
            }
        }
        classpath = classpath + S + System.getProperty("java.class.path");
        System.setProperty("java.class.path", classpath);
        System.err.println("Update first 'jmf.properties' file found in:\n" + System.getProperty("java.class.path"));
        InstallJ1394Cam installer = new InstallJ1394Cam();
        WrapperFrame frame = new WrapperFrame((JComponent)installer, "J1394 JMF DataSource Registry add/remove...");
        frame.pack();
        frame.setLocation((Globals.screenWidth - installer.getWidth()) / 2, (Globals.screenHeight - installer.getHeight()) / 2);
        frame.setVisible(true);
    }
}

