/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import javax.swing.JTabbedPane;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394VideoSettings;
import net.sf.jlibdc1394.gui.JPanelCamSetting;

public class JTabbedPaneCamSettings
extends JTabbedPane {
    private JPanelCamSetting panelBrightness;
    private JPanelCamSetting panelAutoExposure;
    private JPanelCamSetting panelSharpness;
    private JPanelCamSetting panelWhiteBalance;
    private JPanelCamSetting panelHue;
    private JPanelCamSetting panelSaturation;
    private JPanelCamSetting panelGamma;
    private JPanelCamSetting panelShutter;
    private JPanelCamSetting panelGain;
    private JPanelCamSetting panelIris;
    private JPanelCamSetting panelFocus;
    private JPanelCamSetting panelZoom;
    private JDC1394Cam theCamera;
    private JDC1394VideoSettings videoSettings;
    private boolean doPreviewSync = true;

    public JTabbedPaneCamSettings(JDC1394Cam theCamera) {
        this.theCamera = theCamera;
        this.videoSettings = theCamera.getVideoSettings();
        this.panelBrightness = new JPanelCamSetting("Brightness", this.videoSettings.getBrightness(), this);
        this.addTab("Brightness", this.panelBrightness);
        this.panelSharpness = new JPanelCamSetting("Sharpness", this.videoSettings.getSharpness(), this);
        this.addTab("Sharpness", this.panelSharpness);
        this.panelGain = new JPanelCamSetting("Gain", this.videoSettings.getGain(), this);
        this.addTab("Gain", this.panelGain);
        this.panelShutter = new JPanelCamSetting("Shutter", this.videoSettings.getShutter(), this);
        this.addTab("Shutter", this.panelShutter);
        this.panelIris = new JPanelCamSetting("Iris", this.videoSettings.getIris(), this);
        this.addTab("Iris", this.panelIris);
        this.panelHue = new JPanelCamSetting("Hue", this.videoSettings.getHue(), this);
        this.addTab("Hue", this.panelHue);
        this.panelAutoExposure = new JPanelCamSetting("Auto exposure", this.videoSettings.getAutoExposure(), this);
        this.addTab("Auto exp.", this.panelAutoExposure);
        this.panelWhiteBalance = new JPanelCamSetting("White Balance", this.videoSettings.getWhiteBalance(), this);
        this.addTab("W. Bal.", this.panelWhiteBalance);
        this.panelSaturation = new JPanelCamSetting("Saturation", this.videoSettings.getSaturation(), this);
        this.addTab("Saturation", this.panelSaturation);
        this.panelGamma = new JPanelCamSetting("Gamma", this.videoSettings.getGamma(), this);
        this.addTab("Gamma", this.panelGamma);
        this.panelFocus = new JPanelCamSetting("Focus", this.videoSettings.getFocus(), this);
        this.addTab("Focus", this.panelFocus);
        this.panelZoom = new JPanelCamSetting("Zoom", this.videoSettings.getZoom(), this);
        this.addTab("Zoom", this.panelZoom);
    }

    public void previewSync() {
        if (!this.doPreviewSync) {
            return;
        }
        this.syncWithCam();
    }

    public void syncWithCam() {
        if (this.panelBrightness.getControl().isChanged()) {
            this.videoSettings.setBrightness(this.panelBrightness.getControl());
        }
        if (this.panelAutoExposure.getControl().isChanged()) {
            this.videoSettings.setAutoExposure(this.panelAutoExposure.getControl());
        }
        if (this.panelSharpness.getControl().isChanged()) {
            this.videoSettings.setSharpness(this.panelSharpness.getControl());
        }
        if (this.panelWhiteBalance.getControl().isChanged()) {
            this.videoSettings.setWhiteBalance(this.panelWhiteBalance.getControl());
        }
        if (this.panelHue.getControl().isChanged()) {
            this.videoSettings.setHue(this.panelHue.getControl());
        }
        if (this.panelSaturation.getControl().isChanged()) {
            this.videoSettings.setSaturation(this.panelSaturation.getControl());
        }
        if (this.panelGamma.getControl().isChanged()) {
            this.videoSettings.setGamma(this.panelGamma.getControl());
        }
        if (this.panelShutter.getControl().isChanged()) {
            this.videoSettings.setShutter(this.panelShutter.getControl());
        }
        if (this.panelGain.getControl().isChanged()) {
            this.videoSettings.setGain(this.panelGain.getControl());
        }
        if (this.panelIris.getControl().isChanged()) {
            this.videoSettings.setIris(this.panelIris.getControl());
        }
        if (this.panelFocus.getControl().isChanged()) {
            this.videoSettings.setFocus(this.panelFocus.getControl());
        }
        if (this.panelZoom.getControl().isChanged()) {
            this.videoSettings.setZoom(this.panelZoom.getControl());
        }
    }
}

