/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import net.sf.jlibdc1394.JDC1394Cam;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.gui.CameraListTableModel;
import net.sf.jlibdc1394.gui.JDC1394CamReceiver;

public class DialogChooseCamera
extends JDialog {
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JTable jTableCameras;
    private JDC1394CamPort port;
    private JDC1394CamReceiver receiver;

    public DialogChooseCamera(JDC1394CamPort port, JDC1394CamReceiver receiver) {
        this(null, port, receiver);
    }

    public DialogChooseCamera(Frame owner, JDC1394CamPort port, JDC1394CamReceiver receiver) {
        super(owner);
        this.port = port;
        this.receiver = receiver;
        try {
            this.jTableCameras = new JTable();
            this.jButtonOK = new JButton();
            this.jButtonCancel = new JButton();
            this.getContentPane().setLayout(null);
            this.setDefaultCloseOperation(2);
            this.setTitle("Select camera");
            this.setModal(true);
            this.setName("DialogChooseCamera");
            this.setSize(new Dimension(341, 224));
            this.jTableCameras.setAutoCreateColumnsFromModel(true);
            this.jTableCameras.setToolTipText("Cameras found on the ieee 1394bus");
            this.jTableCameras.setPreferredSize(new Dimension(175, 188));
            this.jTableCameras.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.jTableCameras.setVerifyInputWhenFocusTarget(false);
            this.jTableCameras.setBounds(new Rectangle(5, 4, 175, 188));
            this.getContentPane().add(this.jTableCameras);
            this.jButtonOK.setText("OK");
            this.jButtonOK.setPreferredSize(new Dimension(60, 26));
            this.jButtonOK.setBounds(new Rectangle(189, 8, 60, 26));
            this.getContentPane().add(this.jButtonOK);
            this.jButtonOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DialogChooseCamera.this.jButtonOKActionPerformed(evt);
                }
            });
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.setPreferredSize(new Dimension(73, 26));
            this.jButtonCancel.setBounds(new Rectangle(255, 8, 73, 26));
            this.getContentPane().add(this.jButtonCancel);
            this.jButtonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    DialogChooseCamera.this.jButtonCancelActionPerformed(evt);
                }
            });
            this.jTableCameras.setModel(new CameraListTableModel(port));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void showGUI(JDC1394CamPort port, JDC1394CamReceiver reciever, Component owner) {
        try {
            Dialog inst = null;
            if (owner != null) {
                inst = Frame.class.isAssignableFrom(owner.getClass()) ? new DialogChooseCamera((Frame)owner, port, reciever) : new DialogChooseCamera(port, reciever);
            }
            if (owner != null) {
                int newX = (int)((double)owner.getX() + Math.floor(owner.getWidth() / 2) - Math.floor(inst.getWidth() / 2));
                int newY = (int)((double)owner.getY() + Math.floor(owner.getHeight() / 2) - Math.floor(inst.getHeight() / 2));
                inst.setBounds(newX, newY, inst.getWidth(), inst.getHeight());
            }
            inst.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            if (this.jTableCameras.getSelectedRowCount() == 1) {
                JDC1394Cam cam = this.port.selectCamera(this.jTableCameras.getSelectedRow());
                System.err.println(">>> " + cam.getCameraDescription());
                if (this.receiver != null) {
                    this.receiver.receiveCam(cam);
                }
                System.out.println("imtek.camera.gui.DialogChooseCamera(jButtonOKActionPerformed): selected camera " + this.jTableCameras.getSelectedRow());
            }
            this.dispose();
        }
        catch (JDC1394CamException e) {
            e.printStackTrace();
        }
    }

    protected void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

