/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlibdc1394;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import net.sf.jlibdc1394.JDC1394CamException;
import net.sf.jlibdc1394.JDC1394CamPort;
import net.sf.jlibdc1394.impl.cmu.JDC1394CamPortCMU;

public class JDC1394Helper {
    private HashMap config = new HashMap();
    public static final String PORT_IMPL_PROPERTY_NAME = "net.sf.jlibdc1394.port.impl";
    public static final int IMPL_TYPE_UNSUPPORTED = 0;
    public static final int IMPL_TYPE_CMU = 1;
    private static JDC1394Helper sharedInstance;

    protected static int osToJLibDCImplType() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") >= 0) {
            return 1;
        }
        return 0;
    }

    protected JDC1394Helper() {
        String implClassName = System.getProperty(PORT_IMPL_PROPERTY_NAME);
        if (implClassName == null || "".equals(implClassName)) {
            throw new IllegalStateException("JDC1394Helper() called but system property net.sf.jlibdc1394.impl was not set !!!");
        }
        this.config.put(PORT_IMPL_PROPERTY_NAME, implClassName);
    }

    protected JDC1394Helper(URL configURL) {
        this.loadConfig(configURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig(URL configURL) {
        InputStream in;
        Properties props = new Properties();
        try {
            in = configURL.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("An exception occured while opening the configuration URL " + configURL + ". Can not initialize JDC1394Helper.");
        }
        try {
            try {
                props.load(configURL.openStream());
            }
            catch (IOException e) {
                throw new IllegalStateException("An exception occured while reading the configuration URL " + configURL + ".", e);
            }
            this.config.putAll(props);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static JDC1394Helper getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new JDC1394Helper();
        }
        return sharedInstance;
    }

    public static JDC1394Helper getSharedInstance(URL configURL) {
        if (sharedInstance == null) {
            sharedInstance = new JDC1394Helper(configURL);
        }
        return sharedInstance;
    }

    public JDC1394CamPort getPort() {
        Class<?> clazz;
        String className = (String)this.config.get(PORT_IMPL_PROPERTY_NAME);
        if (className == null || "".equals(className)) {
            throw new IllegalStateException("Property net.sf.jlibdc1394.port.impl was not set, or not included in configuration file, can not create JDC1394CamPort !!");
        }
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find the given class implementing JDC1394Cam: " + className);
        }
        try {
            return (JDC1394CamPort)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instatiate the given class implementing JDC1394Cam: " + className);
        }
    }

    protected static JDC1394CamPort getFallBackJDC1394CamPort() {
        switch (JDC1394Helper.osToJLibDCImplType()) {
            case 1: {
                return new JDC1394CamPortCMU();
            }
        }
        throw new UnsupportedOperationException(System.getProperty("os.name") + " is currently not supported by jlibdc1394!");
    }

    public static JDC1394CamPort getJDC1394CamPort() throws JDC1394CamException {
        try {
            return JDC1394Helper.getSharedInstance().getPort();
        }
        catch (IllegalStateException e) {
            return JDC1394Helper.getFallBackJDC1394CamPort();
        }
    }

    public static JDC1394CamPort getJDC1394CamPort(URL configURL) throws JDC1394CamException {
        try {
            return JDC1394Helper.getSharedInstance(configURL).getPort();
        }
        catch (IllegalStateException e) {
            return JDC1394Helper.getFallBackJDC1394CamPort();
        }
    }
}

