#!C:\Users\kieffer\AppData\Local\Enthought\Canopy\User\Scripts\python.exe
# -*- coding: utf-8 -*-
#
#    Project: Azimuthal integration
#             https://forge.epn-campus.eu/projects/azimuthal
#
#    File: "$Id$"
#
#    Copyright (C) European Synchrotron Radiation Facility, Grenoble, France
#
#    Principal author:       Jérôme Kieffer (Jerome.Kieffer@ESRF.eu)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
check_calib

this is a very simple tool that checks the calibratation

"""

__author__ = "Jerome Kieffer"
__contact__ = "Jerome.Kieffer@ESRF.eu"
__license__ = "GPLv3+"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"
__date__ = "06/02/2012"
__satus__ = "development"

import pyFAI, pyFAI.calibration
import pylab
import logging
logger = logging.getLogger("check_calib")

from pyFAI.calibration import  CheckCalib

cc = None
if __name__ == "__main__":

    cc = CheckCalib()
    cc.parse()
    cc.integrate()
    cc.rebuild()
    pylab.ion()

    pylab.imshow(cc.delta, aspect="auto", interpolation=None, origin="bottom")
#    pylab.show()
    raw_input("Delta image")
    pylab.imshow(cc.masked_image, aspect="auto", interpolation=None, origin="bottom")
    raw_input("raw image")
    pylab.imshow(cc.masked_resynth, aspect="auto", interpolation=None, origin="bottom")
    raw_input("rebuild image")
    pylab.clf()
    pylab.plot(cc.r, cc.I)
    raw_input("powder pattern")
