#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
#    Project: Azimuthal integration
#             https://forge.epn-campus.eu/projects/azimuthal
#
#    File: "$Id$"
#
#    Copyright (C) European Synchrotron Radiation Facility, Grenoble, France
#
#    Principal author:       Jérôme Kieffer (Jerome.Kieffer@ESRF.eu)
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

"""
pyFAI - recalib

A tool for refining the geometry of a detector using a reference sample and a previously known calibration file.


"""

__author__ = "Jerome Kieffer"
__contact__ = "Jerome.Kieffer@ESRF.eu"
__license__ = "GPLv3+"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"
__date__ = "06/11/2012"
__satus__ = "development"

import os, sys, gc, threading, time, logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger("pyFAI.recalib")
import pyFAI, pyFAI.calibration
from pyFAI.calibration import Recalibration
try:
    from rfoo.utils import rconsole
    rconsole.spawn_server()
except ImportError:
    logging.info("No socket opened for debugging -> install rfoo")


# This is for debugging with rconsole
c = None
if __name__ == "__main__":
    c = Recalibration()
    c.parse()
    c.preprocess()
#    time.sleep(2)
#    raw_input("resize and press enter")
    c.extract_cpt()
#    print c.peakPicker.points
#    c.gui_peakPicker()
    c.refine()
    c.postProcess()
    if c.interactive:
        raw_input("Press enter to quit")
